#include "zmult.h"

#define reg register double /* XXX: long double */

/* (u,v) <- (u + 2^(96k)v,u - 2^(96k)v); 0 <= k < 16 */
void zmult_32fft_butterfly(double u[32],double v[32],int k,double tmp[32])
{
  int i;
  double *vk;
  reg t0, t1, t2, t3, t4, t5, t6, t7;

  k *= 2;

  for (i = 32 - k;i < 32;i += 2) {
    tmp[i] = v[i];
    tmp[i + 1] = v[i + 1];
  }

  u += k;
  vk = v + k;
  for (i = 31 - k;i >= 0;--i) {
    t0 = u[i];
    t2 = v[i];
    t1 = t0;
    t1 -= t2;
    vk[i] = t1;
    t0 += t2;
    u[i] = t0;
  }
  for (i = -k;i < 0;++i) {
    t0 = u[i];
    t2 = tmp[32 + i];
    t1 = t0;
    t1 += t2;
    vk[i] = t1;
    t0 -= t2;
    u[i] = t0;
  }
}

/* (Z/(2^1536+1))[y]/(y^2-2^(192b)) */
static void zmult_32fft_2(double u[64],int b,double tmp[32])
{
  zmult_32fft_butterfly(u,u + 32,b,tmp);
}

/* (Z/(2^1536+1))[y]/(y^4-2^(384b)) */
static void zmult_32fft_4(double u[128],int b,double tmp[32])
{
  zmult_32fft_butterfly(u,u + 64,2 * b,tmp);
  zmult_32fft_butterfly(u + 32,u + 96,2 * b,tmp);
  zmult_32fft_2(u,b,tmp);
  zmult_32fft_2(u + 64,b + 8,tmp);
}

/* (Z/(2^1536+1))[y]/(y^8-2^(768b)) */
static void zmult_32fft_8(double u[256],int b,double tmp[32])
{
  zmult_32fft_butterfly(u + 0,u + 128,4 * b,tmp);
  zmult_32fft_butterfly(u + 32,u + 160,4 * b,tmp);
  zmult_32fft_butterfly(u + 64,u + 192,4 * b,tmp);
  zmult_32fft_butterfly(u + 96,u + 224,4 * b,tmp);
  zmult_32fft_4(u,b,tmp);
  zmult_32fft_4(u + 128,b + 4,tmp);
}

/* (Z/(2^1536+1))[y]/(y^16-2^(1536b)) */
static void zmult_32fft_16(double u[512],int b,double tmp[32])
{
  int i;
  for (i = 0;i < 256;i += 32)
    zmult_32fft_butterfly(u + i,u + 256 + i,8 * b,tmp);
  zmult_32fft_8(u,b,tmp);
  zmult_32fft_8(u + 256,b + 2,tmp);
}

/* (Z/(2^1536+1))[y]/(y^32-1) */
void zmult_32fft_32_0(double u[1024],double tmp[32])
{
  int i;
  for (i = 0;i < 512;i += 32)
    zmult_32fft_butterfly(u + i,u + 512 + i,0,tmp);
  zmult_32fft_16(u,0,tmp);
  zmult_32fft_16(u + 512,1,tmp);
}

/* (Z/(2^1536+1))[y]/(y^32-2^(96b)) */
static void zmult_32fft_32(double u[1024],int b,double tmp[32])
{
  int i;
  for (i = 0;i < 32;++i)
    zmult_32fft_twist(u + 32 * i,(i * b) & 1023,tmp);
  zmult_32fft_32_0(u,tmp);
}

/* (Z/(2^1536+1))[y]/(y^128-2^(384b)) */
static void zmult_32fft_128(double u[4096],int b,double tmp[32])
{
  int i;
  for (i = 0;i < 1024;i += 32) {
    zmult_32fft_butterfly(u + i,u + 2048 + i,2 * b,tmp);
    zmult_32fft_butterfly(u + 1024 + i,u + 3072 + i,2 * b,tmp);
    zmult_32fft_butterfly(u + i,u + 1024 + i,b,tmp);
    zmult_32fft_butterfly(u + 2048 + i,u + 3072 + i,b + 8,tmp);
  }
  zmult_32fft_32(u,b,tmp);
  zmult_32fft_32(u + 1024,b + 16,tmp);
  zmult_32fft_32(u + 2048,b + 8,tmp);
  zmult_32fft_32(u + 3072,b + 24,tmp);
}

/* (Z/(2^1536+1))[y]/(y^512-2^(1536b)) */
void zmult_32fft_512(double u[16384],int b,double tmp[32])
{
  int i;
  for (i = 0;i < 4096;i += 32) {
    zmult_32fft_butterfly(u + i,u + 8192 + i,8 * b,tmp);
    zmult_32fft_butterfly(u + 4096 + i,u + 12288 + i,8 * b,tmp);
    zmult_32fft_butterfly(u + i,u + 4096 + i,4 * b,tmp);
    zmult_32fft_butterfly(u + 8192 + i,u + 12288 + i,8 + 4 * b,tmp);
  }
  zmult_32fft_128(u,b,tmp);
  zmult_32fft_128(u + 4096,b + 4,tmp);
  zmult_32fft_128(u + 8192,b + 2,tmp);
  zmult_32fft_128(u + 12288,b + 6,tmp);
}
