#include "zmult.h"

#define two24 zmult_two24
#define twom24 zmult_twom24
#define twom48 zmult_twom48
#define minustwom48 zmult_minustwom48
#define alpha0 zmult_alpha0
#define alpha24 zmult_alpha24
#define alpha48 zmult_alpha48

#define reg register double /* XXX: long double */

#define a (tmp)
#define b (tmp + 8)

void zmult_48_4_plus(double out[4],double u[4],double v[4],double tmp[16])
{
  reg t0, t1, t2, t3, t4, t5, t6, t7;

  t4 = alpha24;
  t7 = t4;
  t5 = alpha24;
  t3 = t4;
  t0 = u[0]; t4 += t0;
  t6 = v[3]; t5 += t6;
  t2 = v[0]; t7 += t2;
  t4 -= alpha24;
  t1 = u[1]; t3 += t1;
  t5 -= alpha24;
  t0 -= t4; a[1] = t4; a[0] = t0;
  t7 -= alpha24;
  t6 -= t5; b[7] = t5; b[6] = t6;
  t3 -= alpha24;
  t4 = alpha24;
  t2 -= t7; b[1] = t7; b[0] = t2;
  t5 = alpha24;
  t7 = alpha24;
  t1 -= t3; a[3] = t3; a[2] = t1;
  t3 = alpha24;
  t0 = u[2]; t4 += t0;
  t6 = v[1]; t5 += t6;
  t2 = v[2]; t7 += t2;
  t4 -= alpha24;
  t1 = u[3]; t3 += t1;
  t5 -= alpha24;
  t0 -= t4; a[5] = t4; a[4] = t0;
  t7 -= alpha24;
  t0 = a[1]; t0 *= b[7];
  t3 -= alpha24;
  t4 = a[0]; t4 *= b[0];
  t6 -= t5; b[3] = t5; b[2] = t6;
  t5 = a[3]; t5 *= t7;
  t2 -= t7; b[5] = t7; b[4] = t2;
  t6 = a[2]; t6 *= b[6];
  t1 -= t3; a[7] = t3; a[6] = t1;

  t7 = a[5]; t7 *= b[3];
  t0 += t5;
  t5 = a[4]; t5 *= b[4];
  t4 -= t6;
  t6 = b[1]; t6 *= t3;
  t0 += t7;
  t7 = b[2]; t7 *= t1;
  t4 -= t5;
  t2 = a[1]; t2 *= b[0];
  t0 += t6;
  t5 = a[3]; t5 *= b[6];
  t4 -= t7;
  t0 *= minustwom48; t1 = alpha24;

  t6 = a[5]; t6 *= b[4];
  t2 -= t5;
  t7 = a[4]; t7 *= b[5];
  t0 += t4;
  t4 = a[0]; t4 *= b[1];
  t2 -= t6;
  t5 = b[2]; t5 *= t3;
  t1 += t0;
  t6 = a[2]; t6 *= b[7];
  t4 -= t7;
  t7 = a[6]; t7 *= b[3];
  t1 -= alpha24;
  t2 -= t5;
  t4 -= t6;
  t0 -= t1;
  t2 -= t7;
  t1 += t4;
  t4 = a[1]; t4 *= b[1];

  t1 += t2;
  t5 = a[3]; t5 *= b[7];
  t2 = alpha48;
  t2 += t1;
  t6 = a[5]; t6 *= b[5];

  t7 = b[3]; t7 *= t3;
  t2 -= alpha48;
  t4 -= t5;
  t5 = a[2]; t5 *= b[0];

  t1 -= t2;
  t2 *= twom48;
  t4 -= t6;
  t0 += t1;
  out[0] = t0; t0 = a[0]; t0 *= b[2];
  t4 -= t7;
  t6 = a[4]; t6 *= b[6];

  t7 = a[6]; t7 *= b[4];
  t0 += t5;
  t4 *= twom48;

  t0 += t2;
  t5 = a[2]; t5 *= b[1];
  t7 += t6;
  t0 += t4;
  t4 = a[0]; t4 *= b[3];

  t0 -= t7;
  t2 = a[1]; t2 *= b[2];
  t1 = alpha24;
  t1 += t0;
  t4 += t5;
  t6 = a[3]; t6 *= b[0];
  t1 -= alpha24;
  t7 = a[4]; t7 *= b[7];

  t5 = a[5]; t5 *= b[6];
  t2 += t6;
  t6 = a[6]; t6 *= b[5];
  t0 -= t1;
  t4 -= t7;
  t7 = b[4]; t7 *= t3;

  t2 -= t5;
  t5 = a[3]; t5 *= b[1];
  t4 -= t6;
  t2 -= t7;
  t6 = a[5]; t6 *= b[7];
  t4 += t2;
  t7 = b[5]; t7 *= t3;

  t1 += t4;
  t4 = a[1]; t4 *= b[3];
  t2 = alpha48;
  t2 += t1;
  t7 = t5 - t7;
  t5 = a[2]; t5 *= b[2];
  t2 -= alpha48;
  t4 -= t6;
  t6 = a[4]; t6 *= b[0];
  t1 -= t2;
  t2 *= twom48;
  t4 += t7;
  t7 = a[6]; t7 *= b[6];
  t0 += t1;
  out[1] = t0; t0 = a[0]; t0 *= b[4];
  t6 += t5;
  t5 = a[2]; t5 *= b[3];
  t2 -= t7;
  t4 *= twom48;
  t0 += t6;
  t6 = a[3]; t6 *= b[2];

  t0 += t4;
  t4 = a[0]; t4 *= b[5];

  t0 += t2;
  t2 = a[1]; t2 *= b[4];
  t1 = alpha24;
  t1 += t0;
  t7 = a[4]; t7 *= b[1];
  t4 += t5;
  t5 = a[5]; t5 *= b[0];
  t2 += t6;
  t6 = a[6]; t6 *= b[7];
  t4 += t7;
  t7 = b[6]; t7 *= t3;
  t2 += t5;
  t5 = a[3]; t5 *= b[3];
  t4 -= t6;
  t6 = a[5]; t6 *= b[1];
  t2 -= t7;
  t7 = b[7]; t7 *= t3;
  t1 -= alpha24;
  t2 += t4;
  t4 = a[1]; t4 *= b[5];
  t6 += t5;
  t5 = a[2]; t5 *= b[4];
  t0 -= t1;
  t4 += t6;
  t1 += t2;
  t6 = a[4]; t6 *= b[2];
  t4 -= t7;
  t7 = a[6]; t7 *= b[0];
  t2 = alpha48;
  t2 += t1;
  t5 += t6;
  t4 *= twom48;
  t2 -= alpha48;
  t7 += t5;
  t5 = a[2]; t5 *= b[5];
  t1 -= t2;
  t2 *= twom48;
  t4 += t7;
  t0 += t1;
  out[2] = t0; t0 = a[0]; t0 *= b[6];

  t2 += t4;
  t4 = a[0]; t4 *= b[7];

  t0 += t2;
  t2 = a[1]; t2 *= b[6];
  t1 = alpha24;
  t1 += t0;
  t6 = a[3]; t6 *= b[4];
  t4 += t5;
  t7 = a[4]; t7 *= b[3];
  t1 -= alpha24;
  t5 = a[5]; t5 *= b[2];
  t2 += t6;
  t6 = a[6]; t6 *= b[1];
  t4 += t7;
  t7 = a[7]; t7 *= b[0];
  t2 += t5;
  t0 -= t1;
  t4 += t6;

  t1 += t7;
  t4 += t2;


  t1 += t4;

  t2 = alpha48;
  t2 += t1;
  t3 = out[0];

  t2 -= alpha48;


  t1 -= t2;
  t2 *= twom48;

  t0 += t1;
  out[3] = t0;


  t3 -= t2;
  out[0] = t3;
}
