#include "ecrypt-config.h"
#include "ecrypt-machine.h"
#include "ecrypt-portable.h"

/* Remove tempering, FUBUKI encryption system use only 2005/04/14 */

/* 
   A C-program for MT19937, with initialization improved 2002/1/26.
   Coded by Takuji Nishimura and Makoto Matsumoto.

   Before using, initialize the state by using init_genrand(seed)  
   or init_by_array(init_key, key_length).

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.                          

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote 
        products derived from this software without specific prior written 
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


   Any feedback is very welcome.
   http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/emt.html
   email: m-mat @ math.sci.hiroshima-u.ac.jp (remove space)
*/

/* Period parameters */  
#define N 624
#define M 397
#define MATRIX_A U32C(0x9908B0DF)   /* constant vector a */
#define UPPER_MASK U32C(0x80000000) /* most significant w-r bits */
#define LOWER_MASK U32C(0x7FFFFFFF) /* least significant r bits */

/* initializes mt[N] with a seed */
void init_genrand(ECRYPT_ctx* ctx, u32 s)
{
    ctx->mt[0]= s & U32C(0xFFFFFFFF);
    for (ctx->mti=1; ctx->mti<N; ctx->mti++) {
        ctx->mt[ctx->mti] = 
	    (U32C(1812433253) * (ctx->mt[ctx->mti-1] ^ (ctx->mt[ctx->mti-1] >> 30)) + ctx->mti); 
        /* See Knuth TAOCP Vol2. 3rd Ed. P.106 for multiplier. */
        /* In the previous versions, MSBs of the seed affect   */
        /* only MSBs of the array mt[].                        */
        /* 2002/01/09 modified by Makoto Matsumoto             */
    }
}

/* initialize by an array with array-length */
/* init_key is the array for initializing keys */
/* key_length is its length */
/* slight change for C++, 2004/2/26 */
void init_by_array(ECRYPT_ctx* ctx, u32 init_key[], int key_length)
{
    int i, j, k;
    init_genrand(ctx, U32C(19650218));
    i=1; j=0;
    k = (N>key_length ? N : key_length);
    for (; k; k--) {
        ctx->mt[i] = (ctx->mt[i] ^ ((ctx->mt[i-1] ^ (ctx->mt[i-1] >> 30)) * 1664525UL))
          + init_key[j] + j; /* non linear */
        i++; j++;
        if (i>=N) { ctx->mt[0] = ctx->mt[N-1]; i=1; }
        if (j>=key_length) j=0;
    }
    for (k=N-1; k; k--) {
        ctx->mt[i] = (ctx->mt[i] ^ ((ctx->mt[i-1] ^ (ctx->mt[i-1] >> 30)) * 1566083941UL))
          - i; /* non linear */
        i++;
        if (i>=N) { ctx->mt[0] = ctx->mt[N-1]; i=1; }
    }

    ctx->mt[0] = U32C(0x80000000); /* MSB is 1; assuring non-zero initial array */ 
}


/* generate 32-bit random integer */
u32 genrand_int32(ECRYPT_ctx* ctx)
{
    u32 y;
    static u32 mag01[2]={U32C(0x0), MATRIX_A};
    /* mag01[x] = x * MATRIX_A  for x=0,1 */

    if (ctx->mti >= N) { /* generate N words at one time */
        int kk;

        if (ctx->mti == N+1)   /* if init_genrand() has not been called, */
            init_genrand(ctx, U32C(5489)); /* a default initial seed is used */

        for (kk=0;kk<N-M;kk++) {
            y = (ctx->mt[kk]&UPPER_MASK)|(ctx->mt[kk+1]&LOWER_MASK);
            ctx->mt[kk] = ctx->mt[kk+M] ^ (y >> 1) ^ mag01[y & 0x1UL];
        }
        for (;kk<N-1;kk++) {
            y = (ctx->mt[kk]&UPPER_MASK)|(ctx->mt[kk+1]&LOWER_MASK);
            ctx->mt[kk] = ctx->mt[kk+(M-N)] ^ (y >> 1) ^ mag01[y & 0x1UL];
        }
        y = (ctx->mt[N-1]&UPPER_MASK)|(ctx->mt[0]&LOWER_MASK);
        ctx->mt[N-1] = ctx->mt[M-1] ^ (y >> 1) ^ mag01[y & 0x1UL];

        ctx->mti = 0;
    }
  
    y = ctx->mt[ctx->mti++];  /* No Tempering */
    return y;
}

/* generates whole array of random numbers in [0,0xffffffff]-interval */
void genrand_whole_array(ECRYPT_ctx* ctx)
{
    u32 y;
    static u32 mag01[2]={U32C(0x0), MATRIX_A};
    /* mag01[x] = x * MATRIX_A  for x=0,1 */

    int kk;
    
    for (kk=0;kk<N-M;kk++) {
      y = (ctx->mt[kk]&UPPER_MASK)|(ctx->mt[kk+1]&LOWER_MASK);
      ctx->mt[kk] = ctx->mt[kk+M] ^ (y >> 1) ^ mag01[y & 0x1UL];
    }
    for (;kk<N-1;kk++) {
      y = (ctx->mt[kk]&UPPER_MASK)|(ctx->mt[kk+1]&LOWER_MASK);
      ctx->mt[kk] = ctx->mt[kk+(M-N)] ^ (y >> 1) ^ mag01[y & 0x1UL];
    }
    y = (ctx->mt[N-1]&UPPER_MASK)|(ctx->mt[0]&LOWER_MASK);
    ctx->mt[N-1] = ctx->mt[M-1] ^ (y >> 1) ^ mag01[y & 0x1UL];
    
    ctx->mti = 0;
    return ;
}

/* generates len (<624) random numbers on [0,0xffffffff]-interval */
/* rand_tuple[0]-[len-1] will be supplied with random numbers */
void genrand_tuple_int32(ECRYPT_ctx* ctx, u32 rand_tuple[], s32 len)
{
    s32 i;

    for (i=0; i<len; i++) {
      if (ctx->mti >= N) genrand_whole_array(ctx);
      rand_tuple[i] = ctx->mt[ctx->mti++];
    }
}




