/** ----------------------------------------------------------------------
*  hermes_core2.h    Core of the stream cipher algorithm
*
*  hermes Algorithm   (c) 2005  Dr. Ulrich Kaiser, Texas Instruments Germany
*
--------------------------------------------------------------------------
*/

/*  here different SBOXes can be chosen...  */
#define SBOXx  sboxAF
#define SBOXy  sbox130
#define SBOX   S
#define SBOXz  sboxBAD

#define KEY_STEP1  3
#define KEY_STEP2  5
#define KEY_STEP3  7


  for( j=1; j <= nx; j++ )   
  {
	accu = accu ^ state[p1] ^ k[p2]; /* linear operation       */
	accu = SBOX[ accu ];             /* NON-LINEAR OPERATION   */
	state[p1] = accu;                /* overwrite state byte ! */

	/* update the pointers */
	p1++;
	if( p1 >= nx ) p1 = 0;
	
	p2 += KEY_STEP1;
	if( p2 >= nk ) p2 = p2 - nk;
	
	src++; 
	if( src >= KEY_STEP3 ) /* update two key bytes */
	{
	    src = src - KEY_STEP3;
            p3 = p2 + 1; if( p3 >= nk ) p3 = p3 - nk;
            p4 = p3 + 1; if( p4 >= nk ) p4 = p4 - nk;
	    
	    tmp = k[p3] ^ k[p2] ;
	    k[p3] = SBOX[ tmp ];
	    tmp = k[p4] ^ k[p2] ;
	    k[p4] = SBOX[ tmp ];
	    
            /* fprintf(op,"CORE-K   k[%2d]= 0x%2x \n", p3, k[p3] );
            fprintf(op,"CORE-K   k[%2d]= 0x%2x \n", p4, k[p4] ); */
        }	    
	
	/* fprintf(op,"CORE!  accu=0x%2x p1=%d p2=%d src=%d  round=%d \n", 
                    accu, p1, p2, src, round ); */
	   
  } /* for j */

  /* key scheduling so that state[j] sees different k[] */
  if( round % KEY_STEP2 == 0 )
  {  p2++;
     if( p2 >= nk ) p2 = p2 - nk; 
  }/* if */


/*   fprintf(op,"CORE   accu=0x%2x p1=%d p2=%d  src=%d round=%d   nx=%d loops completed.\n", 
       accu, p1, p2, src, round, nx ); 

  dump_state_key( nx, nk );
 */ 
/* hermes_core2.h ----------------------------------------------------------------- */
