/*
 * REFERENCE IMPLEMENTATION OF STREAM CIPHER GRAIN
 *
 * Filename: grain.h
 *
 * Author:
 * Martin Hell
 * Dept. of Information Technology
 * P.O. Box 118
 * SE-221 00 Lund, Sweden,
 * email: martin@it.lth.se
 *
 * Synopsis:
 *  Header file for grain.c
 *
 */
#ifndef GRAIN_H
#define GRAIN_H

#include "ecrypt-sync.h"
#define INITCLOCKS 160
#define N(i) (ctx->NFSR[80-i])
#define L(i) (ctx->LFSR[80-i])
#define X0 (ctx->LFSR[3])
#define X1 (ctx->LFSR[25])
#define X2 (ctx->LFSR[46])
#define X3 (ctx->LFSR[64])
#define X4 (ctx->NFSR[63])


static const u8 NFTable[1024]={0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,0,
							   1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,0,
							   1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,
							   0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,
							   1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,
						       0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,
							   0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,0,
							   1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,1,
							   1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,
							   0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,
							   0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,0,
							   1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,0,
							   0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,0,
							   1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,
							   0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,0,
							   1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,0,
							   1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,
							   0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,
							   0,1,1,1,1,0,0,0,1,1,0,1,0,0,1,0,1,0,0,0,0,1,1,1,0,0,1,0,0,0,1,1,
							   1,0,0,0,0,1,1,1,0,0,1,0,1,1,0,1,1,0,0,0,0,1,1,1,0,0,1,0,0,0,1,1,
							   0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,0,
							   1,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,0,
							   1,0,0,0,0,1,1,1,0,0,1,0,1,1,0,1,0,1,1,1,1,0,0,0,1,1,0,1,1,1,0,0,
							   0,1,1,1,1,0,0,0,1,1,0,1,0,0,1,0,0,1,1,1,1,0,0,0,1,1,0,1,0,0,1,1,
							   1,0,0,0,0,1,0,0,0,1,1,1,1,0,1,1,0,1,1,1,1,0,1,1,1,0,0,0,1,0,1,0,
							   0,1,1,1,1,0,1,1,1,0,0,0,0,1,0,0,0,1,1,1,1,0,1,1,1,0,0,0,1,0,1,0,
							   0,1,1,1,1,0,1,1,1,1,0,1,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
							   1,0,0,0,0,1,0,0,0,0,1,0,1,1,1,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
							   0,1,1,1,1,0,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,1,1,1,0,1,0,1,
							   1,0,0,0,0,1,0,0,0,1,1,1,1,0,1,1,0,1,1,1,1,0,1,1,1,0,0,0,1,0,1,0,
							   0,1,1,1,1,0,1,1,1,1,0,1,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
							   0,1,1,1,1,0,1,1,1,1,0,1,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,1,1,1,1};



static const u8 boolTable[64] = {0,0,1,1,0,0,1,0,0,1,1,0,1,1,0,1,1,1,0,0,1,0,1,1,0,1,1,0,0,1,0,0,
								 1,1,0,0,1,1,0,1,1,0,0,1,0,0,1,0,0,0,1,1,0,1,0,0,1,0,0,1,1,0,1,1};

#endif
