/* abc-tables.h */

/*
 * ABC v.3 reference inmplementation
 *
 * Precomputed optimization tables for key setup
 */

#if defined(ABC_WINDOW_1)
static const u32 table[33] = {
  U32C(0x8bbc7b0a), U32C(0xe774a906), U32C(0x13040ec0), U32C(0xea149bd0), \
  U32C(0x32e3281d), U32C(0x38c15589), U32C(0xbdc92ea9), U32C(0x6b587ba0), \
  U32C(0xe1009816), U32C(0xeaa84751), U32C(0x77f1ce29), U32C(0xeb94ad46), \
  U32C(0xffd624d0), U32C(0x89581695), U32C(0xf0bbfbd3), U32C(0x83404b20), \
  U32C(0x9e66abea), U32C(0x798ce417), U32C(0x8d1adfb3), U32C(0xb8c6bf9f), \
  U32C(0x3bbad552), U32C(0x923ddd55), U32C(0xa6461e22), U32C(0xcbf825b8), \
  U32C(0x1139265e), U32C(0xb9cf4535), U32C(0xe7c87f14), U32C(0xf4f855d3), \
  U32C(0x7c77f154), U32C(0x46c0f13c), U32C(0x2d1229e6), U32C(0xcf390000), \
  U32C(0xa883b17d)
};

#elif defined(ABC_WINDOW_2)
static const u32 table[64] = {
  U32C(0xa883b17d), U32C(0x34402c87), U32C(0x8ff85a83), U32C(0x1bb4d58d), \
  U32C(0x00000000), U32C(0x13040ec0), U32C(0xea149bd0), U32C(0xfd18aa90), \
  U32C(0x00000000), U32C(0x32e3281d), U32C(0x38c15589), U32C(0x6ba47da6), \
  U32C(0x00000000), U32C(0xbdc92ea9), U32C(0x6b587ba0), U32C(0x2921aa49), \
  U32C(0x00000000), U32C(0xe1009816), U32C(0xeaa84751), U32C(0xcba8df67), \
  U32C(0x00000000), U32C(0x77f1ce29), U32C(0xeb94ad46), U32C(0x63867b6f), \
  U32C(0x00000000), U32C(0xffd624d0), U32C(0x89581695), U32C(0x892e3b65), \
  U32C(0x00000000), U32C(0xf0bbfbd3), U32C(0x83404b20), U32C(0x73fc46f3), \
  U32C(0x00000000), U32C(0x9e66abea), U32C(0x798ce417), U32C(0x17f39001), \
  U32C(0x00000000), U32C(0x8d1adfb3), U32C(0xb8c6bf9f), U32C(0x45e19f52), \
  U32C(0x00000000), U32C(0x3bbad552), U32C(0x923ddd55), U32C(0xcdf8b2a7), \
  U32C(0x00000000), U32C(0xa6461e22), U32C(0xcbf825b8), U32C(0x723e43da), \
  U32C(0x00000000), U32C(0x1139265e), U32C(0xb9cf4535), U32C(0xcb086b93), \
  U32C(0x00000000), U32C(0xe7c87f14), U32C(0xf4f855d3), U32C(0xdcc0d4e7), \
  U32C(0x00000000), U32C(0x7c77f154), U32C(0x46c0f13c), U32C(0xc338e290), \
  U32C(0x00000000), U32C(0x2d1229e6), U32C(0xcf390000), U32C(0xfc4b29e6)
};

#elif defined(ABC_WINDOW_4)
static const u32 table[128] = {
  U32C(0xa883b17d), U32C(0x34402c87), U32C(0x8ff85a83), U32C(0x1bb4d58d), \
  U32C(0xbb87c03d), U32C(0x47443b47), U32C(0xa2fc6943), U32C(0x2eb8e44d), \
  U32C(0x92984d4d), U32C(0x1e54c857), U32C(0x7a0cf653), U32C(0x05c9715d), \
  U32C(0xa59c5c0d), U32C(0x3158d717), U32C(0x8d110513), U32C(0x18cd801d), \
  U32C(0x00000000), U32C(0x32e3281d), U32C(0x38c15589), U32C(0x6ba47da6), \
  U32C(0xbdc92ea9), U32C(0xf0ac56c6), U32C(0xf68a8432), U32C(0x296dac4f), \
  U32C(0x6b587ba0), U32C(0x9e3ba3bd), U32C(0xa419d129), U32C(0xd6fcf946), \
  U32C(0x2921aa49), U32C(0x5c04d266), U32C(0x61e2ffd2), U32C(0x94c627ef), \
  U32C(0x00000000), U32C(0xe1009816), U32C(0xeaa84751), U32C(0xcba8df67), \
  U32C(0x77f1ce29), U32C(0x58f2663f), U32C(0x629a157a), U32C(0x439aad90), \
  U32C(0xeb94ad46), U32C(0xcc95455c), U32C(0xd63cf497), U32C(0xb73d8cad), \
  U32C(0x63867b6f), U32C(0x44871385), U32C(0x4e2ec2c0), U32C(0x2f2f5ad6), \
  U32C(0x00000000), U32C(0xffd624d0), U32C(0x89581695), U32C(0x892e3b65), \
  U32C(0xf0bbfbd3), U32C(0xf09220a3), U32C(0x7a141268), U32C(0x79ea3738), \
  U32C(0x83404b20), U32C(0x83166ff0), U32C(0x0c9861b5), U32C(0x0c6e8685), \
  U32C(0x73fc46f3), U32C(0x73d26bc3), U32C(0xfd545d88), U32C(0xfd2a8258), \
  U32C(0x00000000), U32C(0x9e66abea), U32C(0x798ce417), U32C(0x17f39001), \
  U32C(0x8d1adfb3), U32C(0x2b818b9d), U32C(0x06a7c3ca), U32C(0xa50e6fb4), \
  U32C(0xb8c6bf9f), U32C(0x572d6b89), U32C(0x3253a3b6), U32C(0xd0ba4fa0), \
  U32C(0x45e19f52), U32C(0xe4484b3c), U32C(0xbf6e8369), U32C(0x5dd52f53), \
  U32C(0x00000000), U32C(0x3bbad552), U32C(0x923ddd55), U32C(0xcdf8b2a7), \
  U32C(0xa6461e22), U32C(0xe200f374), U32C(0x3883fb77), U32C(0x743ed0c9), \
  U32C(0xcbf825b8), U32C(0x07b2fb0a), U32C(0x5e36030d), U32C(0x99f0d85f), \
  U32C(0x723e43da), U32C(0xadf9192c), U32C(0x047c212f), U32C(0x4036f681), \
  U32C(0x00000000), U32C(0x1139265e), U32C(0xb9cf4535), U32C(0xcb086b93), \
  U32C(0xe7c87f14), U32C(0xf901a572), U32C(0xa197c449), U32C(0xb2d0eaa7), \
  U32C(0xf4f855d3), U32C(0x06317c31), U32C(0xaec79b08), U32C(0xc000c166), \
  U32C(0xdcc0d4e7), U32C(0xedf9fb45), U32C(0x96901a1c), U32C(0xa7c9407a), \
  U32C(0x00000000), U32C(0x7c77f154), U32C(0x46c0f13c), U32C(0xc338e290), \
  U32C(0x2d1229e6), U32C(0xa98a1b3a), U32C(0x73d31b22), U32C(0xf04b0c76), \
  U32C(0xcf390000), U32C(0x4bb0f154), U32C(0x15f9f13c), U32C(0x9271e290), \
  U32C(0xfc4b29e6), U32C(0x78c31b3a), U32C(0x430c1b22), U32C(0xbf840c76)
};

#elif defined (ABC_WINDOW_8)
static const u32 table[1024] = {
  U32C(0xa883b17d), U32C(0x34402c87), U32C(0x8ff85a83), U32C(0x1bb4d58d), \
    U32C(0xbb87c03d), U32C(0x47443b47), U32C(0xa2fc6943), U32C(0x2eb8e44d), \
    U32C(0x92984d4d), U32C(0x1e54c857), U32C(0x7a0cf653), U32C(0x05c9715d), \
    U32C(0xa59c5c0d), U32C(0x3158d717), U32C(0x8d110513), U32C(0x18cd801d), \
    U32C(0xdb66d99a), U32C(0x672354a4), U32C(0xc2db82a0), U32C(0x4e97fdaa), \
    U32C(0xee6ae85a), U32C(0x7a276364), U32C(0xd5df9160), U32C(0x619c0c6a), \
    U32C(0xc57b756a), U32C(0x5137f074), U32C(0xacf01e70), U32C(0x38ac997a), \
    U32C(0xd87f842a), U32C(0x643bff34), U32C(0xbff42d30), U32C(0x4bb0a83a), \
    U32C(0xe1450706), U32C(0x6d018210), U32C(0xc8b9b00c), U32C(0x54762b16), \
    U32C(0xf44915c6), U32C(0x800590d0), U32C(0xdbbdbecc), U32C(0x677a39d6), \
    U32C(0xcb59a2d6), U32C(0x57161de0), U32C(0xb2ce4bdc), U32C(0x3e8ac6e6), \
    U32C(0xde5db196), U32C(0x6a1a2ca0), U32C(0xc5d25a9c), U32C(0x518ed5a6), \
    U32C(0x14282f23), U32C(0x9fe4aa2d), U32C(0xfb9cd829), U32C(0x87595333), \
    U32C(0x272c3de3), U32C(0xb2e8b8ed), U32C(0x0ea0e6e9), U32C(0x9a5d61f3), \
    U32C(0xfe3ccaf3), U32C(0x89f945fd), U32C(0xe5b173f9), U32C(0x716def03), \
    U32C(0x1140d9b3), U32C(0x9cfd54bd), U32C(0xf8b582b9), U32C(0x8471fdc3), \
    U32C(0x664ce026), U32C(0xf2095b30), U32C(0x4dc1892c), U32C(0xd97e0436), \
    U32C(0x7950eee6), U32C(0x050d69f0), U32C(0x60c597ec), U32C(0xec8212f6), \
    U32C(0x50617bf6), U32C(0xdc1df700), U32C(0x37d624fc), U32C(0xc392a006), \
    U32C(0x63658ab6), U32C(0xef2205c0), U32C(0x4ada33bc), U32C(0xd696aec6), \
    U32C(0x99300843), U32C(0x24ec834d), U32C(0x80a4b149), U32C(0x0c612c53), \
    U32C(0xac341703), U32C(0x37f0920d), U32C(0x93a8c009), U32C(0x1f653b13), \
    U32C(0x8344a413), U32C(0x0f011f1d), U32C(0x6ab94d19), U32C(0xf675c823), \
    U32C(0x9648b2d3), U32C(0x22052ddd), U32C(0x7dbd5bd9), U32C(0x0979d6e3), \
    U32C(0x9f0e35af), U32C(0x2acab0b9), U32C(0x8682deb5), U32C(0x123f59bf), \
    U32C(0xb212446f), U32C(0x3dcebf79), U32C(0x9986ed75), U32C(0x2543687f), \
    U32C(0x8922d17f), U32C(0x14df4c89), U32C(0x70977a85), U32C(0xfc53f58f), \
    U32C(0x9c26e03f), U32C(0x27e35b49), U32C(0x839b8945), U32C(0x0f58044f), \
    U32C(0xd1f15dcc), U32C(0x5dadd8d6), U32C(0xb96606d2), U32C(0x452281dc), \
    U32C(0xe4f56c8c), U32C(0x70b1e796), U32C(0xcc6a1592), U32C(0x5826909c), \
    U32C(0xbc05f99c), U32C(0x47c274a6), U32C(0xa37aa2a2), U32C(0x2f371dac), \
    U32C(0xcf0a085c), U32C(0x5ac68366), U32C(0xb67eb162), U32C(0x423b2c6c), \
    U32C(0x13dc2d1d), U32C(0x9f98a827), U32C(0xfb50d623), U32C(0x870d512d), \
    U32C(0x26e03bdd), U32C(0xb29cb6e7), U32C(0x0e54e4e3), U32C(0x9a115fed), \
    U32C(0xfdf0c8ed), U32C(0x89ad43f7), U32C(0xe56571f3), U32C(0x7121ecfd), \
    U32C(0x10f4d7ad), U32C(0x9cb152b7), U32C(0xf86980b3), U32C(0x8425fbbd), \
    U32C(0x46bf553a), U32C(0xd27bd044), U32C(0x2e33fe40), U32C(0xb9f0794a), \
    U32C(0x59c363fa), U32C(0xe57fdf04), U32C(0x41380d00), U32C(0xccf4880a), \
    U32C(0x30d3f10a), U32C(0xbc906c14), U32C(0x18489a10), U32C(0xa405151a), \
    U32C(0x43d7ffca), U32C(0xcf947ad4), U32C(0x2b4ca8d0), U32C(0xb70923da), \
    U32C(0x4c9d82a6), U32C(0xd859fdb0), U32C(0x34122bac), U32C(0xbfcea6b6), \
    U32C(0x5fa19166), U32C(0xeb5e0c70), U32C(0x47163a6c), U32C(0xd2d2b576), \
    U32C(0x36b21e76), U32C(0xc26e9980), U32C(0x1e26c77c), U32C(0xa9e34286), \
    U32C(0x49b62d36), U32C(0xd572a840), U32C(0x312ad63c), U32C(0xbce75146), \
    U32C(0x7f80aac3), U32C(0x0b3d25cd), U32C(0x66f553c9), U32C(0xf2b1ced3), \
    U32C(0x9284b983), U32C(0x1e41348d), U32C(0x79f96289), U32C(0x05b5dd93), \
    U32C(0x69954693), U32C(0xf551c19d), U32C(0x5109ef99), U32C(0xdcc66aa3), \
    U32C(0x7c995553), U32C(0x0855d05d), U32C(0x640dfe59), U32C(0xefca7963), \
    U32C(0xd1a55bc6), U32C(0x5d61d6d0), U32C(0xb91a04cc), U32C(0x44d67fd6), \
    U32C(0xe4a96a86), U32C(0x7065e590), U32C(0xcc1e138c), U32C(0x57da8e96), \
    U32C(0xbbb9f796), U32C(0x477672a0), U32C(0xa32ea09c), U32C(0x2eeb1ba6), \
    U32C(0xcebe0656), U32C(0x5a7a8160), U32C(0xb632af5c), U32C(0x41ef2a66), \
    U32C(0x048883e3), U32C(0x9044feed), U32C(0xebfd2ce9), U32C(0x77b9a7f3), \
    U32C(0x178c92a3), U32C(0xa3490dad), U32C(0xff013ba9), U32C(0x8abdb6b3), \
    U32C(0xee9d1fb3), U32C(0x7a599abd), U32C(0xd611c8b9), U32C(0x61ce43c3), \
    U32C(0x01a12e73), U32C(0x8d5da97d), U32C(0xe915d779), U32C(0x74d25283), \
    U32C(0x0a66b14f), U32C(0x96232c59), U32C(0xf1db5a55), U32C(0x7d97d55f), \
    U32C(0x1d6ac00f), U32C(0xa9273b19), U32C(0x04df6915), U32C(0x909be41f), \
    U32C(0xf47b4d1f), U32C(0x8037c829), U32C(0xdbeff625), U32C(0x67ac712f), \
    U32C(0x077f5bdf), U32C(0x933bd6e9), U32C(0xeef404e5), U32C(0x7ab07fef), \
    U32C(0x3d49d96c), U32C(0xc9065476), U32C(0x24be8272), U32C(0xb07afd7c), \
    U32C(0x504de82c), U32C(0xdc0a6336), U32C(0x37c29132), U32C(0xc37f0c3c), \
    U32C(0x275e753c), U32C(0xb31af046), U32C(0x0ed31e42), U32C(0x9a8f994c), \
    U32C(0x3a6283fc), U32C(0xc61eff06), U32C(0x21d72d02), U32C(0xad93a80c), \
    U32C(0x00000000), U32C(0xe1009816), U32C(0xeaa84751), U32C(0xcba8df67), \
    U32C(0x77f1ce29), U32C(0x58f2663f), U32C(0x629a157a), U32C(0x439aad90), \
    U32C(0xeb94ad46), U32C(0xcc95455c), U32C(0xd63cf497), U32C(0xb73d8cad), \
    U32C(0x63867b6f), U32C(0x44871385), U32C(0x4e2ec2c0), U32C(0x2f2f5ad6), \
    U32C(0xffd624d0), U32C(0xe0d6bce6), U32C(0xea7e6c21), U32C(0xcb7f0437), \
    U32C(0x77c7f2f9), U32C(0x58c88b0f), U32C(0x62703a4a), U32C(0x4370d260), \
    U32C(0xeb6ad216), U32C(0xcc6b6a2c), U32C(0xd6131967), U32C(0xb713b17d), \
    U32C(0x635ca03f), U32C(0x445d3855), U32C(0x4e04e790), U32C(0x2f057fa6), \
    U32C(0x89581695), U32C(0x6a58aeab), U32C(0x74005de6), U32C(0x5500f5fc), \
    U32C(0x0149e4be), U32C(0xe24a7cd4), U32C(0xebf22c0f), U32C(0xccf2c425), \
    U32C(0x74ecc3db), U32C(0x55ed5bf1), U32C(0x5f950b2c), U32C(0x4095a342), \
    U32C(0xecde9204), U32C(0xcddf2a1a), U32C(0xd786d955), U32C(0xb887716b), \
    U32C(0x892e3b65), U32C(0x6a2ed37b), U32C(0x73d682b6), U32C(0x54d71acc), \
    U32C(0x0120098e), U32C(0xe220a1a4), U32C(0xebc850df), U32C(0xccc8e8f5), \
    U32C(0x74c2e8ab), U32C(0x55c380c1), U32C(0x5f6b2ffc), U32C(0x406bc812), \
    U32C(0xecb4b6d4), U32C(0xcdb54eea), U32C(0xd75cfe25), U32C(0xb85d963b), \
    U32C(0xf0bbfbd3), U32C(0xd1bc93e9), U32C(0xdb644324), U32C(0xbc64db3a), \
    U32C(0x68adc9fc), U32C(0x49ae6212), U32C(0x5356114d), U32C(0x3456a963), \
    U32C(0xdc50a919), U32C(0xbd51412f), U32C(0xc6f8f06a), U32C(0xa7f98880), \
    U32C(0x54427742), U32C(0x35430f58), U32C(0x3eeabe93), U32C(0x1feb56a9), \
    U32C(0xf09220a3), U32C(0xd192b8b9), U32C(0xdb3a67f4), U32C(0xbc3b000a), \
    U32C(0x6883eecc), U32C(0x498486e2), U32C(0x532c361d), U32C(0x342cce33), \
    U32C(0xdc26cde9), U32C(0xbd2765ff), U32C(0xc6cf153a), U32C(0xa7cfad50), \
    U32C(0x54189c12), U32C(0x35193428), U32C(0x3ec0e363), U32C(0x1fc17b79), \
    U32C(0x7a141268), U32C(0x5b14aa7e), U32C(0x64bc59b9), U32C(0x45bcf1cf), \
    U32C(0xf205e091), U32C(0xd30678a7), U32C(0xdcae27e2), U32C(0xbdaebff8), \
    U32C(0x65a8bfae), U32C(0x46a957c4), U32C(0x505106ff), U32C(0x31519f15), \
    U32C(0xdd9a8dd7), U32C(0xbe9b25ed), U32C(0xc842d528), U32C(0xa9436d3e), \
    U32C(0x79ea3738), U32C(0x5aeacf4e), U32C(0x64927e89), U32C(0x4593169f), \
    U32C(0xf1dc0561), U32C(0xd2dc9d77), U32C(0xdc844cb2), U32C(0xbd84e4c8), \
    U32C(0x657ee47e), U32C(0x467f7c94), U32C(0x50272bcf), U32C(0x3127c3e5), \
    U32C(0xdd70b2a7), U32C(0xbe714abd), U32C(0xc818f9f8), U32C(0xa919920e), \
    U32C(0x83404b20), U32C(0x6440e336), U32C(0x6de89271), U32C(0x4ee92a87), \
    U32C(0xfb321949), U32C(0xdc32b15f), U32C(0xe5da609a), U32C(0xc6daf8b0), \
    U32C(0x6ed4f866), U32C(0x4fd5907c), U32C(0x597d3fb7), U32C(0x3a7dd7cd), \
    U32C(0xe6c6c68f), U32C(0xc7c75ea5), U32C(0xd16f0de0), U32C(0xb26fa5f6), \
    U32C(0x83166ff0), U32C(0x64170806), U32C(0x6dbeb741), U32C(0x4ebf4f57), \
    U32C(0xfb083e19), U32C(0xdc08d62f), U32C(0xe5b0856a), U32C(0xc6b11d80), \
    U32C(0x6eab1d36), U32C(0x4fabb54c), U32C(0x59536487), U32C(0x3a53fc9d), \
    U32C(0xe69ceb5f), U32C(0xc79d8375), U32C(0xd14532b0), U32C(0xb245cac6), \
    U32C(0x0c9861b5), U32C(0xed98f9cb), U32C(0xf740a906), U32C(0xd841411c), \
    U32C(0x848a2fde), U32C(0x658ac7f4), U32C(0x6f32772f), U32C(0x50330f45), \
    U32C(0xf82d0efb), U32C(0xd92da711), U32C(0xe2d5564c), U32C(0xc3d5ee62), \
    U32C(0x701edd24), U32C(0x511f753a), U32C(0x5ac72475), U32C(0x3bc7bc8b), \
    U32C(0x0c6e8685), U32C(0xed6f1e9b), U32C(0xf716cdd6), U32C(0xd81765ec), \
    U32C(0x846054ae), U32C(0x6560ecc4), U32C(0x6f089bff), U32C(0x50093415), \
    U32C(0xf80333cb), U32C(0xd903cbe1), U32C(0xe2ab7b1c), U32C(0xc3ac1332), \
    U32C(0x6ff501f4), U32C(0x50f59a0a), U32C(0x5a9d4945), U32C(0x3b9de15b), \
    U32C(0x73fc46f3), U32C(0x54fcdf09), U32C(0x5ea48e44), U32C(0x3fa5265a), \
    U32C(0xebee151c), U32C(0xcceead32), U32C(0xd6965c6d), U32C(0xb796f483), \
    U32C(0x5f90f439), U32C(0x40918c4f), U32C(0x4a393b8a), U32C(0x2b39d3a0), \
    U32C(0xd782c262), U32C(0xb8835a78), U32C(0xc22b09b3), U32C(0xa32ba1c9), \
    U32C(0x73d26bc3), U32C(0x54d303d9), U32C(0x5e7ab314), U32C(0x3f7b4b2a), \
    U32C(0xebc439ec), U32C(0xccc4d202), U32C(0xd66c813d), U32C(0xb76d1953), \
    U32C(0x5f671909), U32C(0x4067b11f), U32C(0x4a0f605a), U32C(0x2b0ff870), \
    U32C(0xd758e732), U32C(0xb8597f48), U32C(0xc2012e83), U32C(0xa301c699), \
    U32C(0xfd545d88), U32C(0xde54f59e), U32C(0xe7fca4d9), U32C(0xc8fd3cef), \
    U32C(0x75462bb1), U32C(0x5646c3c7), U32C(0x5fee7302), U32C(0x40ef0b18), \
    U32C(0xe8e90ace), U32C(0xc9e9a2e4), U32C(0xd391521f), U32C(0xb491ea35), \
    U32C(0x60dad8f7), U32C(0x41db710d), U32C(0x4b832048), U32C(0x2c83b85e), \
    U32C(0xfd2a8258), U32C(0xde2b1a6e), U32C(0xe7d2c9a9), U32C(0xc8d361bf), \
    U32C(0x751c5081), U32C(0x561ce897), U32C(0x5fc497d2), U32C(0x40c52fe8), \
    U32C(0xe8bf2f9e), U32C(0xc9bfc7b4), U32C(0xd36776ef), U32C(0xb4680f05), \
    U32C(0x60b0fdc7), U32C(0x41b195dd), U32C(0x4b594518), U32C(0x2c59dd2e), \
    U32C(0x00000000), U32C(0x9e66abea), U32C(0x798ce417), U32C(0x17f39001), \
    U32C(0x8d1adfb3), U32C(0x2b818b9d), U32C(0x06a7c3ca), U32C(0xa50e6fb4), \
    U32C(0xb8c6bf9f), U32C(0x572d6b89), U32C(0x3253a3b6), U32C(0xd0ba4fa0), \
    U32C(0x45e19f52), U32C(0xe4484b3c), U32C(0xbf6e8369), U32C(0x5dd52f53), \
    U32C(0x3bbad552), U32C(0xda21813c), U32C(0xb547b969), U32C(0x53ae6553), \
    U32C(0xc8d5b505), U32C(0x673c60ef), U32C(0x4262991c), U32C(0xe0c94506), \
    U32C(0xf48194f1), U32C(0x92e840db), U32C(0x6e0e7908), U32C(0x0c7524f2), \
    U32C(0x819c74a4), U32C(0x2003208e), U32C(0xfb2958bb), U32C(0x999004a5), \
    U32C(0x923ddd55), U32C(0x30a4893f), U32C(0x0bcac16c), U32C(0xaa316d56), \
    U32C(0x1f58bd08), U32C(0xbdbf68f2), U32C(0x98e5a11f), U32C(0x374c4d09), \
    U32C(0x4b049cf4), U32C(0xe96b48de), U32C(0xc491810b), U32C(0x62f82cf5), \
    U32C(0xd81f7ca7), U32C(0x76862891), U32C(0x51ac60be), U32C(0xf0130ca8), \
    U32C(0xcdf8b2a7), U32C(0x6c5f5e91), U32C(0x478596be), U32C(0xe5ec42a8), \
    U32C(0x5b13925a), U32C(0xf97a3e44), U32C(0xd4a07671), U32C(0x7307225b), \
    U32C(0x86bf7246), U32C(0x25261e30), U32C(0x004c565d), U32C(0x9eb30247), \
    U32C(0x13da51f9), U32C(0xb240fde3), U32C(0x8d673610), U32C(0x2bcde1fa), \
    U32C(0xa6461e22), U32C(0x44acca0c), U32C(0x1fd30239), U32C(0xbe39ae23), \
    U32C(0x3360fdd5), U32C(0xd1c7a9bf), U32C(0xacede1ec), U32C(0x4b548dd6), \
    U32C(0x5f0cddc1), U32C(0xfd7389ab), U32C(0xd899c1d8), U32C(0x77006dc2), \
    U32C(0xec27bd74), U32C(0x8a8e695e), U32C(0x65b4a18b), U32C(0x041b4d75), \
    U32C(0xe200f374), U32C(0x80679f5e), U32C(0x5b8dd78b), U32C(0xf9f48375), \
    U32C(0x6f1bd327), U32C(0x0d827f11), U32C(0xe8a8b73e), U32C(0x870f6328), \
    U32C(0x9ac7b313), U32C(0x392e5efd), U32C(0x1454972a), U32C(0xb2bb4314), \
    U32C(0x27e292c6), U32C(0xc6493eb0), U32C(0xa16f76dd), U32C(0x3fd622c7), \
    U32C(0x3883fb77), U32C(0xd6eaa761), U32C(0xb210df8e), U32C(0x50778b78), \
    U32C(0xc59edb2a), U32C(0x64058714), U32C(0x3f2bbf41), U32C(0xdd926b2b), \
    U32C(0xf14abb16), U32C(0x8fb16700), U32C(0x6ad79f2d), U32C(0x093e4b17), \
    U32C(0x7e659ac9), U32C(0x1ccc46b3), U32C(0xf7f27ee0), U32C(0x96592aca), \
    U32C(0x743ed0c9), U32C(0x12a57cb3), U32C(0xedcbb4e0), U32C(0x8c3260ca), \
    U32C(0x0159b07c), U32C(0x9fc05c66), U32C(0x7ae69493), U32C(0x194d407d), \
    U32C(0x2d059068), U32C(0xcb6c3c52), U32C(0xa692747f), U32C(0x44f92069), \
    U32C(0xba20701b), U32C(0x58871c05), U32C(0x33ad5432), U32C(0xd214001c), \
    U32C(0xcbf825b8), U32C(0x6a5ed1a2), U32C(0x458509cf), U32C(0xe3ebb5b9), \
    U32C(0x5913056b), U32C(0xf779b155), U32C(0xd29fe982), U32C(0x7106956c), \
    U32C(0x84bee557), U32C(0x23259141), U32C(0xfe4bc96e), U32C(0x9cb27558), \
    U32C(0x11d9c50a), U32C(0xb04070f4), U32C(0x8b66a921), U32C(0x29cd550b), \
    U32C(0x07b2fb0a), U32C(0xa619a6f4), U32C(0x813fdf21), U32C(0x1fa68b0b), \
    U32C(0x94cddabd), U32C(0x333486a7), U32C(0x0e5abed4), U32C(0xacc16abe), \
    U32C(0xc079baa9), U32C(0x5ee06693), U32C(0x3a069ec0), U32C(0xd86d4aaa), \
    U32C(0x4d949a5c), U32C(0xebfb4646), U32C(0xc7217e73), U32C(0x65882a5d), \
    U32C(0x5e36030d), U32C(0xfc9caef7), U32C(0xd7c2e724), U32C(0x7629930e), \
    U32C(0xeb50e2c0), U32C(0x89b78eaa), U32C(0x64ddc6d7), U32C(0x034472c1), \
    U32C(0x16fcc2ac), U32C(0xb5636e96), U32C(0x9089a6c3), U32C(0x2ef052ad), \
    U32C(0xa417a25f), U32C(0x427e4e49), U32C(0x1da48676), U32C(0xbc0b3260), \
    U32C(0x99f0d85f), U32C(0x38578449), U32C(0x137dbc76), U32C(0xb1e46860), \
    U32C(0x270bb812), U32C(0xc57263fc), U32C(0xa0989c29), U32C(0x3eff4813), \
    U32C(0x52b797fe), U32C(0xf11e43e8), U32C(0xcc447c15), U32C(0x6aab27ff), \
    U32C(0xdfd277b1), U32C(0x7e39239b), U32C(0x595f5bc8), U32C(0xf7c607b2), \
    U32C(0x723e43da), U32C(0x10a4efc4), U32C(0xebcb27f1), U32C(0x8a31d3db), \
    U32C(0xff59238d), U32C(0x9dbfcf77), U32C(0x78e607a4), U32C(0x174cb38e), \
    U32C(0x2b050379), U32C(0xc96baf63), U32C(0xa491e790), U32C(0x42f8937a), \
    U32C(0xb81fe32c), U32C(0x56868f16), U32C(0x31acc743), U32C(0xd013732d), \
    U32C(0xadf9192c), U32C(0x4c5fc516), U32C(0x2785fd43), U32C(0xc5eca92d), \
    U32C(0x3b13f8df), U32C(0xd97aa4c9), U32C(0xb4a0dcf6), U32C(0x530788e0), \
    U32C(0x66bfd8cb), U32C(0x052684b5), U32C(0xe04cbce2), U32C(0x7eb368cc), \
    U32C(0xf3dab87e), U32C(0x92416468), U32C(0x6d679c95), U32C(0x0bce487f), \
    U32C(0x047c212f), U32C(0xa2e2cd19), U32C(0x7e090546), U32C(0x1c6fb130), \
    U32C(0x919700e2), U32C(0x2ffdaccc), U32C(0x0b23e4f9), U32C(0xa98a90e3), \
    U32C(0xbd42e0ce), U32C(0x5ba98cb8), U32C(0x36cfc4e5), U32C(0xd53670cf), \
    U32C(0x4a5dc081), U32C(0xe8c46c6b), U32C(0xc3eaa498), U32C(0x62515082), \
    U32C(0x4036f681), U32C(0xde9da26b), U32C(0xb9c3da98), U32C(0x582a8682), \
    U32C(0xcd51d634), U32C(0x6bb8821e), U32C(0x46deba4b), U32C(0xe5456635), \
    U32C(0xf8fdb620), U32C(0x9764620a), U32C(0x728a9a37), U32C(0x10f14621), \
    U32C(0x861895d3), U32C(0x247f41bd), U32C(0xffa579ea), U32C(0x9e0c25d4), \
    U32C(0x00000000), U32C(0x1139265e), U32C(0xb9cf4535), U32C(0xcb086b93), \
    U32C(0xe7c87f14), U32C(0xf901a572), U32C(0xa197c449), U32C(0xb2d0eaa7), \
    U32C(0xf4f855d3), U32C(0x06317c31), U32C(0xaec79b08), U32C(0xc000c166), \
    U32C(0xdcc0d4e7), U32C(0xedf9fb45), U32C(0x96901a1c), U32C(0xa7c9407a), \
    U32C(0x7c77f154), U32C(0x8db117b2), U32C(0x36473689), U32C(0x47805ce7), \
    U32C(0x64407068), U32C(0x757996c6), U32C(0x1e0fb59d), U32C(0x2f48dbfb), \
    U32C(0x71704727), U32C(0x82a96d85), U32C(0x2b3f8c5c), U32C(0x3c78b2ba), \
    U32C(0x5938c63b), U32C(0x6a71ec99), U32C(0x13080b70), U32C(0x244131ce), \
    U32C(0x46c0f13c), U32C(0x57fa179a), U32C(0x00903671), U32C(0x11c95ccf), \
    U32C(0x2e897050), U32C(0x3fc296ae), U32C(0xe858b585), U32C(0xf991dbe3), \
    U32C(0x3bb9470f), U32C(0x4cf26d6d), U32C(0xf5888c44), U32C(0x06c1b2a2), \
    U32C(0x2381c623), U32C(0x34baec81), U32C(0xdd510b58), U32C(0xee8a31b6), \
    U32C(0xc338e290), U32C(0xd47208ee), U32C(0x7d0827c5), U32C(0x8e414e23), \
    U32C(0xab0161a4), U32C(0xbc3a8802), U32C(0x64d0a6d9), U32C(0x7609cd37), \
    U32C(0xb8313863), U32C(0xc96a5ec1), U32C(0x72007d98), U32C(0x8339a3f6), \
    U32C(0x9ff9b777), U32C(0xb132ddd5), U32C(0x59c8fcac), U32C(0x6b02230a), \
    U32C(0x2d1229e6), U32C(0x3e4b5044), U32C(0xe6e16f1b), U32C(0xf81a9579), \
    U32C(0x14daa8fa), U32C(0x2613cf58), U32C(0xcea9ee2f), U32C(0xdfe3148d), \
    U32C(0x220a7fb9), U32C(0x3343a617), U32C(0xdbd9c4ee), U32C(0xed12eb4c), \
    U32C(0x09d2fecd), U32C(0x1b0c252b), U32C(0xc3a24402), U32C(0xd4db6a60), \
    U32C(0xa98a1b3a), U32C(0xbac34198), U32C(0x6359606f), U32C(0x749286cd), \
    U32C(0x91529a4e), U32C(0xa28bc0ac), U32C(0x4b21df83), U32C(0x5c5b05e1), \
    U32C(0x9e82710d), U32C(0xafbb976b), U32C(0x5851b642), U32C(0x698adca0), \
    U32C(0x864af021), U32C(0x9784167f), U32C(0x401a3556), U32C(0x51535bb4), \
    U32C(0x73d31b22), U32C(0x850c4180), U32C(0x2da26057), U32C(0x3edb86b5), \
    U32C(0x5b9b9a36), U32C(0x6cd4c094), U32C(0x156adf6b), U32C(0x26a405c9), \
    U32C(0x68cb70f5), U32C(0x7a049753), U32C(0x229ab62a), U32C(0x33d3dc88), \
    U32C(0x5093f009), U32C(0x61cd1667), U32C(0x0a63353e), U32C(0x1b9c5b9c), \
    U32C(0xf04b0c76), U32C(0x018432d4), U32C(0xaa1a51ab), U32C(0xbb537809), \
    U32C(0xd8138b8a), U32C(0xe94cb1e8), U32C(0x91e2d0bf), U32C(0xa31bf71d), \
    U32C(0xe5436249), U32C(0xf67c88a7), U32C(0x9f12a77e), U32C(0xb04bcddc), \
    U32C(0xcd0be15d), U32C(0xde4507bb), U32C(0x86db2692), U32C(0x98144cf0), \
    U32C(0xcf390000), U32C(0xe072265e), U32C(0x89084535), U32C(0x9a416b93), \
    U32C(0xb7017f14), U32C(0xc83aa572), U32C(0x70d0c449), U32C(0x8209eaa7), \
    U32C(0xc43155d3), U32C(0xd56a7c31), U32C(0x7e009b08), U32C(0x8f39c166), \
    U32C(0xabf9d4e7), U32C(0xbd32fb45), U32C(0x65c91a1c), U32C(0x7702407a), \
    U32C(0x4bb0f154), U32C(0x5cea17b2), U32C(0x05803689), U32C(0x16b95ce7), \
    U32C(0x33797068), U32C(0x44b296c6), U32C(0xed48b59d), U32C(0xfe81dbfb), \
    U32C(0x40a94727), U32C(0x51e26d85), U32C(0xfa788c5c), U32C(0x0bb1b2ba), \
    U32C(0x2871c63b), U32C(0x39aaec99), U32C(0xe2410b70), U32C(0xf37a31ce), \
    U32C(0x15f9f13c), U32C(0x2733179a), U32C(0xcfc93671), U32C(0xe1025ccf), \
    U32C(0xfdc27050), U32C(0x0efb96ae), U32C(0xb791b585), U32C(0xc8cadbe3), \
    U32C(0x0af2470f), U32C(0x1c2b6d6d), U32C(0xc4c18c44), U32C(0xd5fab2a2), \
    U32C(0xf2bac623), U32C(0x03f3ec81), U32C(0xac8a0b58), U32C(0xbdc331b6), \
    U32C(0x9271e290), U32C(0xa3ab08ee), U32C(0x4c4127c5), U32C(0x5d7a4e23), \
    U32C(0x7a3a61a4), U32C(0x8b738802), U32C(0x3409a6d9), U32C(0x4542cd37), \
    U32C(0x876a3863), U32C(0x98a35ec1), U32C(0x41397d98), U32C(0x5272a3f6), \
    U32C(0x6f32b777), U32C(0x806bddd5), U32C(0x2901fcac), U32C(0x3a3b230a), \
    U32C(0xfc4b29e6), U32C(0x0d845044), U32C(0xb61a6f1b), U32C(0xc7539579), \
    U32C(0xe413a8fa), U32C(0xf54ccf58), U32C(0x9de2ee2f), U32C(0xaf1c148d), \
    U32C(0xf1437fb9), U32C(0x027ca617), U32C(0xab12c4ee), U32C(0xbc4beb4c), \
    U32C(0xd90bfecd), U32C(0xea45252b), U32C(0x92db4402), U32C(0xa4146a60), \
    U32C(0x78c31b3a), U32C(0x89fc4198), U32C(0x3292606f), U32C(0x43cb86cd), \
    U32C(0x608b9a4e), U32C(0x71c4c0ac), U32C(0x1a5adf83), U32C(0x2b9405e1), \
    U32C(0x6dbb710d), U32C(0x7ef4976b), U32C(0x278ab642), U32C(0x38c3dca0), \
    U32C(0x5583f021), U32C(0x66bd167f), U32C(0x0f533556), U32C(0x208c5bb4), \
    U32C(0x430c1b22), U32C(0x54454180), U32C(0xfcdb6057), U32C(0x0e1486b5), \
    U32C(0x2ad49a36), U32C(0x3c0dc094), U32C(0xe4a3df6b), U32C(0xf5dd05c9), \
    U32C(0x380470f5), U32C(0x493d9753), U32C(0xf1d3b62a), U32C(0x030cdc88), \
    U32C(0x1fccf009), U32C(0x31061667), U32C(0xd99c353e), U32C(0xead55b9c), \
    U32C(0xbf840c76), U32C(0xd0bd32d4), U32C(0x795351ab), U32C(0x8a8c7809), \
    U32C(0xa74c8b8a), U32C(0xb885b1e8), U32C(0x611bd0bf), U32C(0x7254f71d), \
    U32C(0xb47c6249), U32C(0xc5b588a7), U32C(0x6e4ba77e), U32C(0x7f84cddc), \
    U32C(0x9c44e15d), U32C(0xad7e07bb), U32C(0x56142692), U32C(0x674d4cf0)
};

#elif defined(ABC_WINDOW_12)
static const u32 table[8448] = {
  U32C(0xa883b17d), U32C(0x34402c87), U32C(0x8ff85a83), U32C(0x1bb4d58d), \
  U32C(0xbb87c03d), U32C(0x47443b47), U32C(0xa2fc6943), U32C(0x2eb8e44d), \
  U32C(0x92984d4d), U32C(0x1e54c857), U32C(0x7a0cf653), U32C(0x05c9715d), \
  U32C(0xa59c5c0d), U32C(0x3158d717), U32C(0x8d110513), U32C(0x18cd801d), \
  U32C(0xdb66d99a), U32C(0x672354a4), U32C(0xc2db82a0), U32C(0x4e97fdaa), \
  U32C(0xee6ae85a), U32C(0x7a276364), U32C(0xd5df9160), U32C(0x619c0c6a), \
  U32C(0xc57b756a), U32C(0x5137f074), U32C(0xacf01e70), U32C(0x38ac997a), \
  U32C(0xd87f842a), U32C(0x643bff34), U32C(0xbff42d30), U32C(0x4bb0a83a), \
  U32C(0xe1450706), U32C(0x6d018210), U32C(0xc8b9b00c), U32C(0x54762b16), \
  U32C(0xf44915c6), U32C(0x800590d0), U32C(0xdbbdbecc), U32C(0x677a39d6), \
  U32C(0xcb59a2d6), U32C(0x57161de0), U32C(0xb2ce4bdc), U32C(0x3e8ac6e6), \
  U32C(0xde5db196), U32C(0x6a1a2ca0), U32C(0xc5d25a9c), U32C(0x518ed5a6), \
  U32C(0x14282f23), U32C(0x9fe4aa2d), U32C(0xfb9cd829), U32C(0x87595333), \
  U32C(0x272c3de3), U32C(0xb2e8b8ed), U32C(0x0ea0e6e9), U32C(0x9a5d61f3), \
  U32C(0xfe3ccaf3), U32C(0x89f945fd), U32C(0xe5b173f9), U32C(0x716def03), \
  U32C(0x1140d9b3), U32C(0x9cfd54bd), U32C(0xf8b582b9), U32C(0x8471fdc3), \
  U32C(0x664ce026), U32C(0xf2095b30), U32C(0x4dc1892c), U32C(0xd97e0436), \
  U32C(0x7950eee6), U32C(0x050d69f0), U32C(0x60c597ec), U32C(0xec8212f6), \
  U32C(0x50617bf6), U32C(0xdc1df700), U32C(0x37d624fc), U32C(0xc392a006), \
  U32C(0x63658ab6), U32C(0xef2205c0), U32C(0x4ada33bc), U32C(0xd696aec6), \
  U32C(0x99300843), U32C(0x24ec834d), U32C(0x80a4b149), U32C(0x0c612c53), \
  U32C(0xac341703), U32C(0x37f0920d), U32C(0x93a8c009), U32C(0x1f653b13), \
  U32C(0x8344a413), U32C(0x0f011f1d), U32C(0x6ab94d19), U32C(0xf675c823), \
  U32C(0x9648b2d3), U32C(0x22052ddd), U32C(0x7dbd5bd9), U32C(0x0979d6e3), \
  U32C(0x9f0e35af), U32C(0x2acab0b9), U32C(0x8682deb5), U32C(0x123f59bf), \
  U32C(0xb212446f), U32C(0x3dcebf79), U32C(0x9986ed75), U32C(0x2543687f), \
  U32C(0x8922d17f), U32C(0x14df4c89), U32C(0x70977a85), U32C(0xfc53f58f), \
  U32C(0x9c26e03f), U32C(0x27e35b49), U32C(0x839b8945), U32C(0x0f58044f), \
  U32C(0xd1f15dcc), U32C(0x5dadd8d6), U32C(0xb96606d2), U32C(0x452281dc), \
  U32C(0xe4f56c8c), U32C(0x70b1e796), U32C(0xcc6a1592), U32C(0x5826909c), \
  U32C(0xbc05f99c), U32C(0x47c274a6), U32C(0xa37aa2a2), U32C(0x2f371dac), \
  U32C(0xcf0a085c), U32C(0x5ac68366), U32C(0xb67eb162), U32C(0x423b2c6c), \
  U32C(0x13dc2d1d), U32C(0x9f98a827), U32C(0xfb50d623), U32C(0x870d512d), \
  U32C(0x26e03bdd), U32C(0xb29cb6e7), U32C(0x0e54e4e3), U32C(0x9a115fed), \
  U32C(0xfdf0c8ed), U32C(0x89ad43f7), U32C(0xe56571f3), U32C(0x7121ecfd), \
  U32C(0x10f4d7ad), U32C(0x9cb152b7), U32C(0xf86980b3), U32C(0x8425fbbd), \
  U32C(0x46bf553a), U32C(0xd27bd044), U32C(0x2e33fe40), U32C(0xb9f0794a), \
  U32C(0x59c363fa), U32C(0xe57fdf04), U32C(0x41380d00), U32C(0xccf4880a), \
  U32C(0x30d3f10a), U32C(0xbc906c14), U32C(0x18489a10), U32C(0xa405151a), \
  U32C(0x43d7ffca), U32C(0xcf947ad4), U32C(0x2b4ca8d0), U32C(0xb70923da), \
  U32C(0x4c9d82a6), U32C(0xd859fdb0), U32C(0x34122bac), U32C(0xbfcea6b6), \
  U32C(0x5fa19166), U32C(0xeb5e0c70), U32C(0x47163a6c), U32C(0xd2d2b576), \
  U32C(0x36b21e76), U32C(0xc26e9980), U32C(0x1e26c77c), U32C(0xa9e34286), \
  U32C(0x49b62d36), U32C(0xd572a840), U32C(0x312ad63c), U32C(0xbce75146), \
  U32C(0x7f80aac3), U32C(0x0b3d25cd), U32C(0x66f553c9), U32C(0xf2b1ced3), \
  U32C(0x9284b983), U32C(0x1e41348d), U32C(0x79f96289), U32C(0x05b5dd93), \
  U32C(0x69954693), U32C(0xf551c19d), U32C(0x5109ef99), U32C(0xdcc66aa3), \
  U32C(0x7c995553), U32C(0x0855d05d), U32C(0x640dfe59), U32C(0xefca7963), \
  U32C(0xd1a55bc6), U32C(0x5d61d6d0), U32C(0xb91a04cc), U32C(0x44d67fd6), \
  U32C(0xe4a96a86), U32C(0x7065e590), U32C(0xcc1e138c), U32C(0x57da8e96), \
  U32C(0xbbb9f796), U32C(0x477672a0), U32C(0xa32ea09c), U32C(0x2eeb1ba6), \
  U32C(0xcebe0656), U32C(0x5a7a8160), U32C(0xb632af5c), U32C(0x41ef2a66), \
  U32C(0x048883e3), U32C(0x9044feed), U32C(0xebfd2ce9), U32C(0x77b9a7f3), \
  U32C(0x178c92a3), U32C(0xa3490dad), U32C(0xff013ba9), U32C(0x8abdb6b3), \
  U32C(0xee9d1fb3), U32C(0x7a599abd), U32C(0xd611c8b9), U32C(0x61ce43c3), \
  U32C(0x01a12e73), U32C(0x8d5da97d), U32C(0xe915d779), U32C(0x74d25283), \
  U32C(0x0a66b14f), U32C(0x96232c59), U32C(0xf1db5a55), U32C(0x7d97d55f), \
  U32C(0x1d6ac00f), U32C(0xa9273b19), U32C(0x04df6915), U32C(0x909be41f), \
  U32C(0xf47b4d1f), U32C(0x8037c829), U32C(0xdbeff625), U32C(0x67ac712f), \
  U32C(0x077f5bdf), U32C(0x933bd6e9), U32C(0xeef404e5), U32C(0x7ab07fef), \
  U32C(0x3d49d96c), U32C(0xc9065476), U32C(0x24be8272), U32C(0xb07afd7c), \
  U32C(0x504de82c), U32C(0xdc0a6336), U32C(0x37c29132), U32C(0xc37f0c3c), \
  U32C(0x275e753c), U32C(0xb31af046), U32C(0x0ed31e42), U32C(0x9a8f994c), \
  U32C(0x3a6283fc), U32C(0xc61eff06), U32C(0x21d72d02), U32C(0xad93a80c), \
  U32C(0x89844993), U32C(0x1540c49d), U32C(0x70f8f299), U32C(0xfcb56da3), \
  U32C(0x9c885853), U32C(0x2844d35d), U32C(0x83fd0159), U32C(0x0fb97c63), \
  U32C(0x7398e563), U32C(0xff55606d), U32C(0x5b0d8e69), U32C(0xe6ca0973), \
  U32C(0x869cf423), U32C(0x12596f2d), U32C(0x6e119d29), U32C(0xf9ce1833), \
  U32C(0xbc6771b0), U32C(0x4823ecba), U32C(0xa3dc1ab6), U32C(0x2f9895c0), \
  U32C(0xcf6b8070), U32C(0x5b27fb7a), U32C(0xb6e02976), U32C(0x429ca480), \
  U32C(0xa67c0d80), U32C(0x3238888a), U32C(0x8df0b686), U32C(0x19ad3190), \
  U32C(0xb9801c40), U32C(0x453c974a), U32C(0xa0f4c546), U32C(0x2cb14050), \
  U32C(0xc2459f1c), U32C(0x4e021a26), U32C(0xa9ba4822), U32C(0x3576c32c), \
  U32C(0xd549addc), U32C(0x610628e6), U32C(0xbcbe56e2), U32C(0x487ad1ec), \
  U32C(0xac5a3aec), U32C(0x3816b5f6), U32C(0x93cee3f2), U32C(0x1f8b5efc), \
  U32C(0xbf5e49ac), U32C(0x4b1ac4b6), U32C(0xa6d2f2b2), U32C(0x328f6dbc), \
  U32C(0xf528c739), U32C(0x80e54243), U32C(0xdc9d703f), U32C(0x6859eb49), \
  U32C(0x082cd5f9), U32C(0x93e95103), U32C(0xefa17eff), U32C(0x7b5dfa09), \
  U32C(0xdf3d6309), U32C(0x6af9de13), U32C(0xc6b20c0f), U32C(0x526e8719), \
  U32C(0xf24171c9), U32C(0x7dfdecd3), U32C(0xd9b61acf), U32C(0x657295d9), \
  U32C(0x474d783c), U32C(0xd309f346), U32C(0x2ec22142), U32C(0xba7e9c4c), \
  U32C(0x5a5186fc), U32C(0xe60e0206), U32C(0x41c63002), U32C(0xcd82ab0c), \
  U32C(0x3162140c), U32C(0xbd1e8f16), U32C(0x18d6bd12), U32C(0xa493381c), \
  U32C(0x446622cc), U32C(0xd0229dd6), U32C(0x2bdacbd2), U32C(0xb79746dc), \
  U32C(0x7a30a059), U32C(0x05ed1b63), U32C(0x61a5495f), U32C(0xed61c469), \
  U32C(0x8d34af19), U32C(0x18f12a23), U32C(0x74a9581f), U32C(0x0065d329), \
  U32C(0x64453c29), U32C(0xf001b733), U32C(0x4bb9e52f), U32C(0xd7766039), \
  U32C(0x77494ae9), U32C(0x0305c5f3), U32C(0x5ebdf3ef), U32C(0xea7a6ef9), \
  U32C(0x800ecdc5), U32C(0x0bcb48cf), U32C(0x678376cb), U32C(0xf33ff1d5), \
  U32C(0x9312dc85), U32C(0x1ecf578f), U32C(0x7a87858b), U32C(0x06440095), \
  U32C(0x6a236995), U32C(0xf5dfe49f), U32C(0x5198129b), U32C(0xdd548da5), \
  U32C(0x7d277855), U32C(0x08e3f35f), U32C(0x649c215b), U32C(0xf0589c65), \
  U32C(0xb2f1f5e2), U32C(0x3eae70ec), U32C(0x9a669ee8), U32C(0x262319f2), \
  U32C(0xc5f604a2), U32C(0x51b27fac), U32C(0xad6aada8), U32C(0x392728b2), \
  U32C(0x9d0691b2), U32C(0x28c30cbc), U32C(0x847b3ab8), U32C(0x1037b5c2), \
  U32C(0xb00aa072), U32C(0x3bc71b7c), U32C(0x977f4978), U32C(0x233bc482), \
  U32C(0xf4dcc533), U32C(0x8099403d), U32C(0xdc516e39), U32C(0x680de943), \
  U32C(0x07e0d3f3), U32C(0x939d4efd), U32C(0xef557cf9), U32C(0x7b11f803), \
  U32C(0xdef16103), U32C(0x6aaddc0d), U32C(0xc6660a09), U32C(0x52228513), \
  U32C(0xf1f56fc3), U32C(0x7db1eacd), U32C(0xd96a18c9), U32C(0x652693d3), \
  U32C(0x27bfed50), U32C(0xb37c685a), U32C(0x0f349656), U32C(0x9af11160), \
  U32C(0x3ac3fc10), U32C(0xc680771a), U32C(0x2238a516), U32C(0xadf52020), \
  U32C(0x11d48920), U32C(0x9d91042a), U32C(0xf9493226), U32C(0x8505ad30), \
  U32C(0x24d897e0), U32C(0xb09512ea), U32C(0x0c4d40e6), U32C(0x9809bbf0), \
  U32C(0x2d9e1abc), U32C(0xb95a95c6), U32C(0x1512c3c2), U32C(0xa0cf3ecc), \
  U32C(0x40a2297c), U32C(0xcc5ea486), U32C(0x2816d282), U32C(0xb3d34d8c), \
  U32C(0x17b2b68c), U32C(0xa36f3196), U32C(0xff275f92), U32C(0x8ae3da9c), \
  U32C(0x2ab6c54c), U32C(0xb6734056), U32C(0x122b6e52), U32C(0x9de7e95c), \
  U32C(0x608142d9), U32C(0xec3dbde3), U32C(0x47f5ebdf), U32C(0xd3b266e9), \
  U32C(0x73855199), U32C(0xff41cca3), U32C(0x5af9fa9f), U32C(0xe6b675a9), \
  U32C(0x4a95dea9), U32C(0xd65259b3), U32C(0x320a87af), U32C(0xbdc702b9), \
  U32C(0x5d99ed69), U32C(0xe9566873), U32C(0x450e966f), U32C(0xd0cb1179), \
  U32C(0xb2a5f3dc), U32C(0x3e626ee6), U32C(0x9a1a9ce2), U32C(0x25d717ec), \
  U32C(0xc5aa029c), U32C(0x51667da6), U32C(0xad1eaba2), U32C(0x38db26ac), \
  U32C(0x9cba8fac), U32C(0x28770ab6), U32C(0x842f38b2), U32C(0x0febb3bc), \
  U32C(0xafbe9e6c), U32C(0x3b7b1976), U32C(0x97334772), U32C(0x22efc27c), \
  U32C(0xe5891bf9), U32C(0x71459703), U32C(0xccfdc4ff), U32C(0x58ba4009), \
  U32C(0xf88d2ab9), U32C(0x8449a5c3), U32C(0xe001d3bf), U32C(0x6bbe4ec9), \
  U32C(0xcf9db7c9), U32C(0x5b5a32d3), U32C(0xb71260cf), U32C(0x42cedbd9), \
  U32C(0xe2a1c689), U32C(0x6e5e4193), U32C(0xca166f8f), U32C(0x55d2ea99), \
  U32C(0xeb674965), U32C(0x7723c46f), U32C(0xd2dbf26b), U32C(0x5e986d75), \
  U32C(0xfe6b5825), U32C(0x8a27d32f), U32C(0xe5e0012b), U32C(0x719c7c35), \
  U32C(0xd57be535), U32C(0x6138603f), U32C(0xbcf08e3b), U32C(0x48ad0945), \
  U32C(0xe87ff3f5), U32C(0x743c6eff), U32C(0xcff49cfb), U32C(0x5bb11805), \
  U32C(0x1e4a7182), U32C(0xaa06ec8c), U32C(0x05bf1a88), U32C(0x917b9592), \
  U32C(0x314e8042), U32C(0xbd0afb4c), U32C(0x18c32948), U32C(0xa47fa452), \
  U32C(0x085f0d52), U32C(0x941b885c), U32C(0xefd3b658), U32C(0x7b903162), \
  U32C(0x1b631c12), U32C(0xa71f971c), U32C(0x02d7c518), U32C(0x8e944022), \
  U32C(0x932bf8ce), U32C(0x1ee873d8), U32C(0x7aa0a1d4), U32C(0x065d1cde), \
  U32C(0xa630078e), U32C(0x31ec8298), U32C(0x8da4b094), U32C(0x19612b9e), \
  U32C(0x7d40949e), U32C(0x08fd0fa8), U32C(0x64b53da4), U32C(0xf071b8ae), \
  U32C(0x9044a35e), U32C(0x1c011e68), U32C(0x77b94c64), U32C(0x0375c76e), \
  U32C(0xc60f20eb), U32C(0x51cb9bf5), U32C(0xad83c9f1), U32C(0x394044fb), \
  U32C(0xd9132fab), U32C(0x64cfaab5), U32C(0xc087d8b1), U32C(0x4c4453bb), \
  U32C(0xb023bcbb), U32C(0x3be037c5), U32C(0x979865c1), U32C(0x2354e0cb), \
  U32C(0xc327cb7b), U32C(0x4ee44685), U32C(0xaa9c7481), U32C(0x3658ef8b), \
  U32C(0xcbed4e57), U32C(0x57a9c961), U32C(0xb361f75d), U32C(0x3f1e7267), \
  U32C(0xdef15d17), U32C(0x6aadd821), U32C(0xc666061d), U32C(0x52228127), \
  U32C(0xb601ea27), U32C(0x41be6531), U32C(0x9d76932d), U32C(0x29330e37), \
  U32C(0xc905f8e7), U32C(0x54c273f1), U32C(0xb07aa1ed), U32C(0x3c371cf7), \
  U32C(0xfed07674), U32C(0x8a8cf17e), U32C(0xe6451f7a), U32C(0x72019a84), \
  U32C(0x11d48534), U32C(0x9d91003e), U32C(0xf9492e3a), U32C(0x8505a944), \
  U32C(0xe8e51244), U32C(0x74a18d4e), U32C(0xd059bb4a), U32C(0x5c163654), \
  U32C(0xfbe92104), U32C(0x87a59c0e), U32C(0xe35dca0a), U32C(0x6f1a4514), \
  U32C(0x50f52777), U32C(0xdcb1a281), U32C(0x3869d07d), U32C(0xc4264b87), \
  U32C(0x63f93637), U32C(0xefb5b141), U32C(0x4b6ddf3d), U32C(0xd72a5a47), \
  U32C(0x3b09c347), U32C(0xc6c63e51), U32C(0x227e6c4d), U32C(0xae3ae757), \
  U32C(0x4e0dd207), U32C(0xd9ca4d11), U32C(0x35827b0d), U32C(0xc13ef617), \
  U32C(0x83d84f94), U32C(0x0f94ca9e), U32C(0x6b4cf89a), U32C(0xf70973a4), \
  U32C(0x96dc5e54), U32C(0x2298d95e), U32C(0x7e51075a), U32C(0x0a0d8264), \
  U32C(0x6deceb64), U32C(0xf9a9666e), U32C(0x5561946a), U32C(0xe11e0f74), \
  U32C(0x80f0fa24), U32C(0x0cad752e), U32C(0x6865a32a), U32C(0xf4221e34), \
  U32C(0x89b67d00), U32C(0x1572f80a), U32C(0x712b2606), U32C(0xfce7a110), \
  U32C(0x9cba8bc0), U32C(0x287706ca), U32C(0x842f34c6), U32C(0x0febafd0), \
  U32C(0x73cb18d0), U32C(0xff8793da), U32C(0x5b3fc1d6), U32C(0xe6fc3ce0), \
  U32C(0x86cf2790), U32C(0x128ba29a), U32C(0x6e43d096), U32C(0xfa004ba0), \
  U32C(0xbc99a51d), U32C(0x48562027), U32C(0xa40e4e23), U32C(0x2fcac92d), \
  U32C(0xcf9db3dd), U32C(0x5b5a2ee7), U32C(0xb7125ce3), U32C(0x42ced7ed), \
  U32C(0xa6ae40ed), U32C(0x326abbf7), U32C(0x8e22e9f3), U32C(0x19df64fd), \
  U32C(0xb9b24fad), U32C(0x456ecab7), U32C(0xa126f8b3), U32C(0x2ce373bd), \
  U32C(0xfe84746e), U32C(0x8a40ef78), U32C(0xe5f91d74), U32C(0x71b5987e), \
  U32C(0x1188832e), U32C(0x9d44fe38), U32C(0xf8fd2c34), U32C(0x84b9a73e), \
  U32C(0xe899103e), U32C(0x74558b48), U32C(0xd00db944), U32C(0x5bca344e), \
  U32C(0xfb9d1efe), U32C(0x87599a08), U32C(0xe311c804), U32C(0x6ece430e), \
  U32C(0x31679c8b), U32C(0xbd241795), U32C(0x18dc4591), U32C(0xa498c09b), \
  U32C(0x446bab4b), U32C(0xd0282655), U32C(0x2be05451), U32C(0xb79ccf5b), \
  U32C(0x1b7c385b), U32C(0xa738b365), U32C(0x02f0e161), U32C(0x8ead5c6b), \
  U32C(0x2e80471b), U32C(0xba3cc225), U32C(0x15f4f021), U32C(0xa1b16b2b), \
  U32C(0x3745c9f7), U32C(0xc3024501), U32C(0x1eba72fd), U32C(0xaa76ee07), \
  U32C(0x4a49d8b7), U32C(0xd60653c1), U32C(0x31be81bd), U32C(0xbd7afcc7), \
  U32C(0x215a65c7), U32C(0xad16e0d1), U32C(0x08cf0ecd), U32C(0x948b89d7), \
  U32C(0x345e7487), U32C(0xc01aef91), U32C(0x1bd31d8d), U32C(0xa78f9897), \
  U32C(0x6a28f214), U32C(0xf5e56d1e), U32C(0x519d9b1a), U32C(0xdd5a1624), \
  U32C(0x7d2d00d4), U32C(0x08e97bde), U32C(0x64a1a9da), U32C(0xf05e24e4), \
  U32C(0x543d8de4), U32C(0xdffa08ee), U32C(0x3bb236ea), U32C(0xc76eb1f4), \
  U32C(0x67419ca4), U32C(0xf2fe17ae), U32C(0x4eb645aa), U32C(0xda72c0b4), \
  U32C(0xbc4da317), U32C(0x480a1e21), U32C(0xa3c24c1d), U32C(0x2f7ec727), \
  U32C(0xcf51b1d7), U32C(0x5b0e2ce1), U32C(0xb6c65add), U32C(0x4282d5e7), \
  U32C(0xa6623ee7), U32C(0x321eb9f1), U32C(0x8dd6e7ed), U32C(0x199362f7), \
  U32C(0xb9664da7), U32C(0x4522c8b1), U32C(0xa0daf6ad), U32C(0x2c9771b7), \
  U32C(0xef30cb34), U32C(0x7aed463e), U32C(0xd6a5743a), U32C(0x6261ef44), \
  U32C(0x0234d9f4), U32C(0x8df154fe), U32C(0xe9a982fa), U32C(0x7565fe04), \
  U32C(0xd9456704), U32C(0x6501e20e), U32C(0xc0ba100a), U32C(0x4c768b14), \
  U32C(0xec4975c4), U32C(0x7805f0ce), U32C(0xd3be1eca), U32C(0x5f7a99d4), \
  U32C(0xf50ef8a0), U32C(0x80cb73aa), U32C(0xdc83a1a6), U32C(0x68401cb0), \
  U32C(0x08130760), U32C(0x93cf826a), U32C(0xef87b066), U32C(0x7b442b70), \
  U32C(0xdf239470), U32C(0x6ae00f7a), U32C(0xc6983d76), U32C(0x5254b880), \
  U32C(0xf227a330), U32C(0x7de41e3a), U32C(0xd99c4c36), U32C(0x6558c740), \
  U32C(0x27f220bd), U32C(0xb3ae9bc7), U32C(0x0f66c9c3), U32C(0x9b2344cd), \
  U32C(0x3af62f7d), U32C(0xc6b2aa87), U32C(0x226ad883), U32C(0xae27538d), \
  U32C(0x1206bc8d), U32C(0x9dc33797), U32C(0xf97b6593), U32C(0x8537e09d), \
  U32C(0x250acb4d), U32C(0xb0c74657), U32C(0x0c7f7453), U32C(0x983bef5d), \
  U32C(0x742c90e4), U32C(0xffe90bee), U32C(0x5ba139ea), U32C(0xe75db4f4), \
  U32C(0x87309fa4), U32C(0x12ed1aae), U32C(0x6ea548aa), U32C(0xfa61c3b4), \
  U32C(0x5e412cb4), U32C(0xe9fda7be), U32C(0x45b5d5ba), U32C(0xd17250c4), \
  U32C(0x71453b74), U32C(0xfd01b67e), U32C(0x58b9e47a), U32C(0xe4765f84), \
  U32C(0xa70fb901), U32C(0x32cc340b), U32C(0x8e846207), U32C(0x1a40dd11), \
  U32C(0xba13c7c1), U32C(0x45d042cb), U32C(0xa18870c7), U32C(0x2d44ebd1), \
  U32C(0x912454d1), U32C(0x1ce0cfdb), U32C(0x7898fdd7), U32C(0x045578e1), \
  U32C(0xa4286391), U32C(0x2fe4de9b), U32C(0x8b9d0c97), U32C(0x175987a1), \
  U32C(0xacede66d), U32C(0x38aa6177), U32C(0x94628f73), U32C(0x201f0a7d), \
  U32C(0xbff1f52d), U32C(0x4bae7037), U32C(0xa7669e33), U32C(0x3323193d), \
  U32C(0x9702823d), U32C(0x22befd47), U32C(0x7e772b43), U32C(0x0a33a64d), \
  U32C(0xaa0690fd), U32C(0x35c30c07), U32C(0x917b3a03), U32C(0x1d37b50d), \
  U32C(0xdfd10e8a), U32C(0x6b8d8994), U32C(0xc745b790), U32C(0x5302329a), \
  U32C(0xf2d51d4a), U32C(0x7e919854), U32C(0xda49c650), U32C(0x6606415a), \
  U32C(0xc9e5aa5a), U32C(0x55a22564), U32C(0xb15a5360), U32C(0x3d16ce6a), \
  U32C(0xdce9b91a), U32C(0x68a63424), U32C(0xc45e6220), U32C(0x501add2a), \
  U32C(0x31f5bf8d), U32C(0xbdb23a97), U32C(0x196a6893), U32C(0xa526e39d), \
  U32C(0x44f9ce4d), U32C(0xd0b64957), U32C(0x2c6e7753), U32C(0xb82af25d), \
  U32C(0x1c0a5b5d), U32C(0xa7c6d667), U32C(0x037f0463), U32C(0x8f3b7f6d), \
  U32C(0x2f0e6a1d), U32C(0xbacae527), U32C(0x16831323), U32C(0xa23f8e2d), \
  U32C(0x64d8e7aa), U32C(0xf09562b4), U32C(0x4c4d90b0), U32C(0xd80a0bba), \
  U32C(0x77dcf66a), U32C(0x03997174), U32C(0x5f519f70), U32C(0xeb0e1a7a), \
  U32C(0x4eed837a), U32C(0xdaa9fe84), U32C(0x36622c80), U32C(0xc21ea78a), \
  U32C(0x61f1923a), U32C(0xedae0d44), U32C(0x49663b40), U32C(0xd522b64a), \
  U32C(0x6ab71516), U32C(0xf6739020), U32C(0x522bbe1c), U32C(0xdde83926), \
  U32C(0x7dbb23d6), U32C(0x09779ee0), U32C(0x652fccdc), U32C(0xf0ec47e6), \
  U32C(0x54cbb0e6), U32C(0xe0882bf0), U32C(0x3c4059ec), U32C(0xc7fcd4f6), \
  U32C(0x67cfbfa6), U32C(0xf38c3ab0), U32C(0x4f4468ac), U32C(0xdb00e3b6), \
  U32C(0x9d9a3d33), U32C(0x2956b83d), U32C(0x850ee639), U32C(0x10cb6143), \
  U32C(0xb09e4bf3), U32C(0x3c5ac6fd), U32C(0x9812f4f9), U32C(0x23cf7003), \
  U32C(0x87aed903), U32C(0x136b540d), U32C(0x6f238209), U32C(0xfadffd13), \
  U32C(0x9ab2e7c3), U32C(0x266f62cd), U32C(0x822790c9), U32C(0x0de40bd3), \
  U32C(0xdf850c84), U32C(0x6b41878e), U32C(0xc6f9b58a), U32C(0x52b63094), \
  U32C(0xf2891b44), U32C(0x7e45964e), U32C(0xd9fdc44a), U32C(0x65ba3f54), \
  U32C(0xc999a854), U32C(0x5556235e), U32C(0xb10e515a), U32C(0x3ccacc64), \
  U32C(0xdc9db714), U32C(0x685a321e), U32C(0xc412601a), U32C(0x4fcedb24), \
  U32C(0x126834a1), U32C(0x9e24afab), U32C(0xf9dcdda7), U32C(0x859958b1), \
  U32C(0x256c4361), U32C(0xb128be6b), U32C(0x0ce0ec67), U32C(0x989d6771), \
  U32C(0xfc7cd071), U32C(0x88394b7b), U32C(0xe3f17977), U32C(0x6fadf481), \
  U32C(0x0f80df31), U32C(0x9b3d5a3b), U32C(0xf6f58837), U32C(0x82b20341), \
  U32C(0x1846620d), U32C(0xa402dd17), U32C(0xffbb0b13), U32C(0x8b77861d), \
  U32C(0x2b4a70cd), U32C(0xb706ebd7), U32C(0x12bf19d3), U32C(0x9e7b94dd), \
  U32C(0x025afddd), U32C(0x8e1778e7), U32C(0xe9cfa6e3), U32C(0x758c21ed), \
  U32C(0x155f0c9d), U32C(0xa11b87a7), U32C(0xfcd3b5a3), U32C(0x889030ad), \
  U32C(0x4b298a2a), U32C(0xd6e60534), U32C(0x329e3330), U32C(0xbe5aae3a), \
  U32C(0x5e2d98ea), U32C(0xe9ea13f4), U32C(0x45a241f0), U32C(0xd15ebcfa), \
  U32C(0x353e25fa), U32C(0xc0faa104), U32C(0x1cb2cf00), U32C(0xa86f4a0a), \
  U32C(0x484234ba), U32C(0xd3feafc4), U32C(0x2fb6ddc0), U32C(0xbb7358ca), \
  U32C(0x9d4e3b2d), U32C(0x290ab637), U32C(0x84c2e433), U32C(0x107f5f3d), \
  U32C(0xb05249ed), U32C(0x3c0ec4f7), U32C(0x97c6f2f3), U32C(0x23836dfd), \
  U32C(0x8762d6fd), U32C(0x131f5207), U32C(0x6ed78003), U32C(0xfa93fb0d), \
  U32C(0x9a66e5bd), U32C(0x262360c7), U32C(0x81db8ec3), U32C(0x0d9809cd), \
  U32C(0xd031634a), U32C(0x5bedde54), U32C(0xb7a60c50), U32C(0x4362875a), \
  U32C(0xe335720a), U32C(0x6ef1ed14), U32C(0xcaaa1b10), U32C(0x5666961a), \
  U32C(0xba45ff1a), U32C(0x46027a24), U32C(0xa1baa820), U32C(0x2d77232a), \
  U32C(0xcd4a0dda), U32C(0x590688e4), U32C(0xb4beb6e0), U32C(0x407b31ea), \
  U32C(0xd60f90b6), U32C(0x61cc0bc0), U32C(0xbd8439bc), U32C(0x4940b4c6), \
  U32C(0xe9139f76), U32C(0x74d01a80), U32C(0xd088487c), U32C(0x5c44c386), \
  U32C(0xc0242c86), U32C(0x4be0a790), U32C(0xa798d58c), U32C(0x33555096), \
  U32C(0xd3283b46), U32C(0x5ee4b650), U32C(0xba9ce44c), U32C(0x46595f56), \
  U32C(0x08f2b8d3), U32C(0x94af33dd), U32C(0xf06761d9), U32C(0x7c23dce3), \
  U32C(0x1bf6c793), U32C(0xa7b3429d), U32C(0x036b7099), U32C(0x8f27eba3), \
  U32C(0xf30754a3), U32C(0x7ec3cfad), U32C(0xda7bfda9), U32C(0x663878b3), \
  U32C(0x060b6363), U32C(0x91c7de6d), U32C(0xed800c69), U32C(0x793c8773), \
  U32C(0x20757fa6), U32C(0xac31fab0), U32C(0x07ea28ac), U32C(0x93a6a3b6), \
  U32C(0x33798e66), U32C(0xbf360970), U32C(0x1aee376c), U32C(0xa6aab276), \
  U32C(0x0a8a1b76), U32C(0x96469680), U32C(0xf1fec47c), U32C(0x7dbb3f86), \
  U32C(0x1d8e2a36), U32C(0xa94aa540), U32C(0x0502d33c), U32C(0x90bf4e46), \
  U32C(0x5358a7c3), U32C(0xdf1522cd), U32C(0x3acd50c9), U32C(0xc689cbd3), \
  U32C(0x665cb683), U32C(0xf219318d), U32C(0x4dd15f89), U32C(0xd98dda93), \
  U32C(0x3d6d4393), U32C(0xc929be9d), U32C(0x24e1ec99), U32C(0xb09e67a3), \
  U32C(0x50715253), U32C(0xdc2dcd5d), U32C(0x37e5fb59), U32C(0xc3a27663), \
  U32C(0x5936d52f), U32C(0xe4f35039), U32C(0x40ab7e35), U32C(0xcc67f93f), \
  U32C(0x6c3ae3ef), U32C(0xf7f75ef9), U32C(0x53af8cf5), U32C(0xdf6c07ff), \
  U32C(0x434b70ff), U32C(0xcf07ec09), U32C(0x2ac01a05), U32C(0xb67c950f), \
  U32C(0x564f7fbf), U32C(0xe20bfac9), U32C(0x3dc428c5), U32C(0xc980a3cf), \
  U32C(0x8c19fd4c), U32C(0x17d67856), U32C(0x738ea652), U32C(0xff4b215c), \
  U32C(0x9f1e0c0c), U32C(0x2ada8716), U32C(0x8692b512), U32C(0x124f301c), \
  U32C(0x762e991c), U32C(0x01eb1426), U32C(0x5da34222), U32C(0xe95fbd2c), \
  U32C(0x8932a7dc), U32C(0x14ef22e6), U32C(0x70a750e2), U32C(0xfc63cbec), \
  U32C(0xde3eae4f), U32C(0x69fb2959), U32C(0xc5b35755), U32C(0x516fd25f), \
  U32C(0xf142bd0f), U32C(0x7cff3819), U32C(0xd8b76615), U32C(0x6473e11f), \
  U32C(0xc8534a1f), U32C(0x540fc529), U32C(0xafc7f325), U32C(0x3b846e2f), \
  U32C(0xdb5758df), U32C(0x6713d3e9), U32C(0xc2cc01e5), U32C(0x4e887cef), \
  U32C(0x1121d66c), U32C(0x9cde5176), U32C(0xf8967f72), U32C(0x8452fa7c), \
  U32C(0x2425e52c), U32C(0xafe26036), U32C(0x0b9a8e32), U32C(0x9757093c), \
  U32C(0xfb36723c), U32C(0x86f2ed46), U32C(0xe2ab1b42), U32C(0x6e67964c), \
  U32C(0x0e3a80fc), U32C(0x99f6fc06), U32C(0xf5af2a02), U32C(0x816ba50c), \
  U32C(0x170003d8), U32C(0xa2bc7ee2), U32C(0xfe74acde), U32C(0x8a3127e8), \
  U32C(0x2a041298), U32C(0xb5c08da2), U32C(0x1178bb9e), U32C(0x9d3536a8), \
  U32C(0x01149fa8), U32C(0x8cd11ab2), U32C(0xe88948ae), U32C(0x7445c3b8), \
  U32C(0x1418ae68), U32C(0x9fd52972), U32C(0xfb8d576e), U32C(0x8749d278), \
  U32C(0x49e32bf5), U32C(0xd59fa6ff), U32C(0x3157d4fb), U32C(0xbd145005), \
  U32C(0x5ce73ab5), U32C(0xe8a3b5bf), U32C(0x445be3bb), U32C(0xd0185ec5), \
  U32C(0x33f7c7c5), U32C(0xbfb442cf), U32C(0x1b6c70cb), U32C(0xa728ebd5), \
  U32C(0x46fbd685), U32C(0xd2b8518f), U32C(0x2e707f8b), U32C(0xba2cfa95), \
  U32C(0x8bcdfb46), U32C(0x178a7650), U32C(0x7342a44c), U32C(0xfeff1f56), \
  U32C(0x9ed20a06), U32C(0x2a8e8510), U32C(0x8646b30c), U32C(0x12032e16), \
  U32C(0x75e29716), U32C(0x019f1220), U32C(0x5d57401c), U32C(0xe913bb26), \
  U32C(0x88e6a5d6), U32C(0x14a320e0), U32C(0x705b4edc), U32C(0xfc17c9e6), \
  U32C(0xbeb12363), U32C(0x4a6d9e6d), U32C(0xa625cc69), U32C(0x31e24773), \
  U32C(0xd1b53223), U32C(0x5d71ad2d), U32C(0xb929db29), U32C(0x44e65633), \
  U32C(0xa8c5bf33), U32C(0x34823a3d), U32C(0x903a6839), U32C(0x1bf6e343), \
  U32C(0xbbc9cdf3), U32C(0x478648fd), U32C(0xa33e76f9), U32C(0x2efaf203), \
  U32C(0xc48f50cf), U32C(0x504bcbd9), U32C(0xac03f9d5), U32C(0x37c074df), \
  U32C(0xd7935f8f), U32C(0x634fda99), U32C(0xbf080895), U32C(0x4ac4839f), \
  U32C(0xaea3ec9f), U32C(0x3a6067a9), U32C(0x961895a5), U32C(0x21d510af), \
  U32C(0xc1a7fb5f), U32C(0x4d647669), U32C(0xa91ca465), U32C(0x34d91f6f), \
  U32C(0xf77278ec), U32C(0x832ef3f6), U32C(0xdee721f2), U32C(0x6aa39cfc), \
  U32C(0x0a7687ac), U32C(0x963302b6), U32C(0xf1eb30b2), U32C(0x7da7abbc), \
  U32C(0xe18714bc), U32C(0x6d438fc6), U32C(0xc8fbbdc2), U32C(0x54b838cc), \
  U32C(0xf48b237c), U32C(0x80479e86), U32C(0xdbffcc82), U32C(0x67bc478c), \
  U32C(0x499729ef), U32C(0xd553a4f9), U32C(0x310bd2f5), U32C(0xbcc84dff), \
  U32C(0x5c9b38af), U32C(0xe857b3b9), U32C(0x440fe1b5), U32C(0xcfcc5cbf), \
  U32C(0x33abc5bf), U32C(0xbf6840c9), U32C(0x1b206ec5), U32C(0xa6dce9cf), \
  U32C(0x46afd47f), U32C(0xd26c4f89), U32C(0x2e247d85), U32C(0xb9e0f88f), \
  U32C(0x7c7a520c), U32C(0x0836cd16), U32C(0x63eefb12), U32C(0xefab761c), \
  U32C(0x8f7e60cc), U32C(0x1b3adbd6), U32C(0x76f309d2), U32C(0x02af84dc), \
  U32C(0x668eeddc), U32C(0xf24b68e6), U32C(0x4e0396e2), U32C(0xd9c011ec), \
  U32C(0x7992fc9c), U32C(0x054f77a6), U32C(0x6107a5a2), U32C(0xecc420ac), \
  U32C(0x82587f78), U32C(0x0e14fa82), U32C(0x69cd287e), U32C(0xf589a388), \
  U32C(0x955c8e38), U32C(0x21190942), U32C(0x7cd1373e), U32C(0x088db248), \
  U32C(0x6c6d1b48), U32C(0xf8299652), U32C(0x53e1c44e), U32C(0xdf9e3f58), \
  U32C(0x7f712a08), U32C(0x0b2da512), U32C(0x66e5d30e), U32C(0xf2a24e18), \
  U32C(0xb53ba795), U32C(0x40f8229f), U32C(0x9cb0509b), U32C(0x286ccba5), \
  U32C(0xc83fb655), U32C(0x53fc315f), U32C(0xafb45f5b), U32C(0x3b70da65), \
  U32C(0x9f504365), U32C(0x2b0cbe6f), U32C(0x86c4ec6b), U32C(0x12816775), \
  U32C(0xb2545225), U32C(0x3e10cd2f), U32C(0x99c8fb2b), U32C(0x25857635), \
  U32C(0x017617bc), U32C(0x8d3292c6), U32C(0xe8eac0c2), U32C(0x74a73bcc), \
  U32C(0x147a267c), U32C(0xa036a186), U32C(0xfbeecf82), U32C(0x87ab4a8c), \
  U32C(0xeb8ab38c), U32C(0x77472e96), U32C(0xd2ff5c92), U32C(0x5ebbd79c), \
  U32C(0xfe8ec24c), U32C(0x8a4b3d56), U32C(0xe6036b52), U32C(0x71bfe65c), \
  U32C(0x34593fd9), U32C(0xc015bae3), U32C(0x1bcde8df), U32C(0xa78a63e9), \
  U32C(0x475d4e99), U32C(0xd319c9a3), U32C(0x2ed1f79f), U32C(0xba8e72a9), \
  U32C(0x1e6ddba9), U32C(0xaa2a56b3), U32C(0x05e284af), U32C(0x919effb9), \
  U32C(0x3171ea69), U32C(0xbd2e6573), U32C(0x18e6936f), U32C(0xa4a30e79), \
  U32C(0x3a376d45), U32C(0xc5f3e84f), U32C(0x21ac164b), U32C(0xad689155), \
  U32C(0x4d3b7c05), U32C(0xd8f7f70f), U32C(0x34b0250b), U32C(0xc06ca015), \
  U32C(0x244c0915), U32C(0xb008841f), U32C(0x0bc0b21b), U32C(0x977d2d25), \
  U32C(0x375017d5), U32C(0xc30c92df), U32C(0x1ec4c0db), U32C(0xaa813be5), \
  U32C(0x6d1a9562), U32C(0xf8d7106c), U32C(0x548f3e68), U32C(0xe04bb972), \
  U32C(0x801ea422), U32C(0x0bdb1f2c), U32C(0x67934d28), U32C(0xf34fc832), \
  U32C(0x572f3132), U32C(0xe2ebac3c), U32C(0x3ea3da38), U32C(0xca605542), \
  U32C(0x6a333ff2), U32C(0xf5efbafc), U32C(0x51a7e8f8), U32C(0xdd646402), \
  U32C(0xbf3f4665), U32C(0x4afbc16f), U32C(0xa6b3ef6b), U32C(0x32706a75), \
  U32C(0xd2435525), U32C(0x5dffd02f), U32C(0xb9b7fe2b), U32C(0x45747935), \
  U32C(0xa953e235), U32C(0x35105d3f), U32C(0x90c88b3b), U32C(0x1c850645), \
  U32C(0xbc57f0f5), U32C(0x48146bff), U32C(0xa3cc99fb), U32C(0x2f891505), \
  U32C(0xf2226e82), U32C(0x7ddee98c), U32C(0xd9971788), U32C(0x65539292), \
  U32C(0x05267d42), U32C(0x90e2f84c), U32C(0xec9b2648), U32C(0x7857a152), \
  U32C(0xdc370a52), U32C(0x67f3855c), U32C(0xc3abb358), U32C(0x4f682e62), \
  U32C(0xef3b1912), U32C(0x7af7941c), U32C(0xd6afc218), U32C(0x626c3d22), \
  U32C(0xf8009bee), U32C(0x83bd16f8), U32C(0xdf7544f4), U32C(0x6b31bffe), \
  U32C(0x0b04aaae), U32C(0x96c125b8), U32C(0xf27953b4), U32C(0x7e35cebe), \
  U32C(0xe21537be), U32C(0x6dd1b2c8), U32C(0xc989e0c4), U32C(0x55465bce), \
  U32C(0xf519467e), U32C(0x80d5c188), U32C(0xdc8def84), U32C(0x684a6a8e), \
  U32C(0x2ae3c40b), U32C(0xb6a03f15), U32C(0x12586d11), U32C(0x9e14e81b), \
  U32C(0x3de7d2cb), U32C(0xc9a44dd5), U32C(0x255c7bd1), U32C(0xb118f6db), \
  U32C(0x14f85fdb), U32C(0xa0b4dae5), U32C(0xfc6d08e1), U32C(0x882983eb), \
  U32C(0x27fc6e9b), U32C(0xb3b8e9a5), U32C(0x0f7117a1), U32C(0x9b2d92ab), \
  U32C(0x6cce935c), U32C(0xf88b0e66), U32C(0x54433c62), U32C(0xdfffb76c), \
  U32C(0x7fd2a21c), U32C(0x0b8f1d26), U32C(0x67474b22), U32C(0xf303c62c), \
  U32C(0x56e32f2c), U32C(0xe29faa36), U32C(0x3e57d832), U32C(0xca14533c), \
  U32C(0x69e73dec), U32C(0xf5a3b8f6), U32C(0x515be6f2), U32C(0xdd1861fc), \
  U32C(0x9fb1bb79), U32C(0x2b6e3683), U32C(0x8726647f), U32C(0x12e2df89), \
  U32C(0xb2b5ca39), U32C(0x3e724543), U32C(0x9a2a733f), U32C(0x25e6ee49), \
  U32C(0x89c65749), U32C(0x1582d253), U32C(0x713b004f), U32C(0xfcf77b59), \
  U32C(0x9cca6609), U32C(0x2886e113), U32C(0x843f0f0f), U32C(0x0ffb8a19), \
  U32C(0xa58fe8e5), U32C(0x314c63ef), U32C(0x8d0491eb), U32C(0x18c10cf5), \
  U32C(0xb893f7a5), U32C(0x445072af), U32C(0xa008a0ab), U32C(0x2bc51bb5), \
  U32C(0x8fa484b5), U32C(0x1b60ffbf), U32C(0x77192dbb), U32C(0x02d5a8c5), \
  U32C(0xa2a89375), U32C(0x2e650e7f), U32C(0x8a1d3c7b), U32C(0x15d9b785), \
  U32C(0xd8731102), U32C(0x642f8c0c), U32C(0xbfe7ba08), U32C(0x4ba43512), \
  U32C(0xeb771fc2), U32C(0x77339acc), U32C(0xd2ebc8c8), U32C(0x5ea843d2), \
  U32C(0xc287acd2), U32C(0x4e4427dc), U32C(0xa9fc55d8), U32C(0x35b8d0e2), \
  U32C(0xd58bbb92), U32C(0x6148369c), U32C(0xbd006498), U32C(0x48bcdfa2), \
  U32C(0x2a97c205), U32C(0xb6543d0f), U32C(0x120c6b0b), U32C(0x9dc8e615), \
  U32C(0x3d9bd0c5), U32C(0xc9584bcf), U32C(0x251079cb), U32C(0xb0ccf4d5), \
  U32C(0x14ac5dd5), U32C(0xa068d8df), U32C(0xfc2106db), U32C(0x87dd81e5), \
  U32C(0x27b06c95), U32C(0xb36ce79f), U32C(0x0f25159b), U32C(0x9ae190a5), \
  U32C(0x5d7aea22), U32C(0xe937652c), U32C(0x44ef9328), U32C(0xd0ac0e32), \
  U32C(0x707ef8e2), U32C(0xfc3b73ec), U32C(0x57f3a1e8), U32C(0xe3b01cf2), \
  U32C(0x478f85f2), U32C(0xd34c00fc), U32C(0x2f042ef8), U32C(0xbac0aa02), \
  U32C(0x5a9394b2), U32C(0xe6500fbc), U32C(0x42083db8), U32C(0xcdc4b8c2), \
  U32C(0x6359178e), U32C(0xef159298), U32C(0x4acdc094), U32C(0xd68a3b9e), \
  U32C(0x765d264e), U32C(0x0219a158), U32C(0x5dd1cf54), U32C(0xe98e4a5e), \
  U32C(0x4d6db35e), U32C(0xd92a2e68), U32C(0x34e25c64), U32C(0xc09ed76e), \
  U32C(0x6071c21e), U32C(0xec2e3d28), U32C(0x47e66b24), U32C(0xd3a2e62e), \
  U32C(0x963c3fab), U32C(0x21f8bab5), U32C(0x7db0e8b1), U32C(0x096d63bb), \
  U32C(0xa9404e6b), U32C(0x34fcc975), U32C(0x90b4f771), U32C(0x1c71727b), \
  U32C(0x8050db7b), U32C(0x0c0d5685), U32C(0x67c58481), U32C(0xf381ff8b), \
  U32C(0x9354ea3b), U32C(0x1f116545), U32C(0x7ac99341), U32C(0x06860e4b), \
  U32C(0x0b1dc6f7), U32C(0x96da4201), U32C(0xf2926ffd), U32C(0x7e4eeb07), \
  U32C(0x1e21d5b7), U32C(0xa9de50c1), U32C(0x05967ebd), U32C(0x9152f9c7), \
  U32C(0xf53262c7), U32C(0x80eeddd1), U32C(0xdca70bcd), U32C(0x686386d7), \
  U32C(0x08367187), U32C(0x93f2ec91), U32C(0xefab1a8d), U32C(0x7b679597), \
  U32C(0x3e00ef14), U32C(0xc9bd6a1e), U32C(0x2575981a), U32C(0xb1321324), \
  U32C(0x5104fdd4), U32C(0xdcc178de), U32C(0x3879a6da), U32C(0xc43621e4), \
  U32C(0x28158ae4), U32C(0xb3d205ee), U32C(0x0f8a33ea), U32C(0x9b46aef4), \
  U32C(0x3b1999a4), U32C(0xc6d614ae), U32C(0x228e42aa), U32C(0xae4abdb4), \
  U32C(0x43df1c80), U32C(0xcf9b978a), U32C(0x2b53c586), U32C(0xb7104090), \
  U32C(0x56e32b40), U32C(0xe29fa64a), U32C(0x3e57d446), U32C(0xca144f50), \
  U32C(0x2df3b850), U32C(0xb9b0335a), U32C(0x15686156), U32C(0xa124dc60), \
  U32C(0x40f7c710), U32C(0xccb4421a), U32C(0x286c7016), U32C(0xb428eb20), \
  U32C(0x76c2449d), U32C(0x027ebfa7), U32C(0x5e36eda3), U32C(0xe9f368ad), \
  U32C(0x89c6535d), U32C(0x1582ce67), U32C(0x713afc63), U32C(0xfcf7776d), \
  U32C(0x60d6e06d), U32C(0xec935b77), U32C(0x484b8973), U32C(0xd408047d), \
  U32C(0x73daef2d), U32C(0xff976a37), U32C(0x5b4f9833), U32C(0xe70c133d), \
  U32C(0xc8e6f5a0), U32C(0x54a370aa), U32C(0xb05b9ea6), U32C(0x3c1819b0), \
  U32C(0xdbeb0460), U32C(0x67a77f6a), U32C(0xc35fad66), U32C(0x4f1c2870), \
  U32C(0xb2fb9170), U32C(0x3eb80c7a), U32C(0x9a703a76), U32C(0x262cb580), \
  U32C(0xc5ffa030), U32C(0x51bc1b3a), U32C(0xad744936), U32C(0x3930c440), \
  U32C(0xfbca1dbd), U32C(0x878698c7), U32C(0xe33ec6c3), U32C(0x6efb41cd), \
  U32C(0x0ece2c7d), U32C(0x9a8aa787), U32C(0xf642d583), U32C(0x81ff508d), \
  U32C(0xe5deb98d), U32C(0x719b3497), U32C(0xcd536293), U32C(0x590fdd9d), \
  U32C(0xf8e2c84d), U32C(0x849f4357), U32C(0xe0577153), U32C(0x6c13ec5d), \
  U32C(0x01a84b29), U32C(0x8d64c633), U32C(0xe91cf42f), U32C(0x74d96f39), \
  U32C(0x14ac59e9), U32C(0xa068d4f3), U32C(0xfc2102ef), U32C(0x87dd7df9), \
  U32C(0xebbce6f9), U32C(0x77796203), U32C(0xd3318fff), U32C(0x5eee0b09), \
  U32C(0xfec0f5b9), U32C(0x8a7d70c3), U32C(0xe6359ebf), U32C(0x71f219c9), \
  U32C(0x348b7346), U32C(0xc047ee50), U32C(0x1c001c4c), U32C(0xa7bc9756), \
  U32C(0x478f8206), U32C(0xd34bfd10), U32C(0x2f042b0c), U32C(0xbac0a616), \
  U32C(0x1ea00f16), U32C(0xaa5c8a20), U32C(0x0614b81c), U32C(0x91d13326), \
  U32C(0x31a41dd6), U32C(0xbd6098e0), U32C(0x1918c6dc), U32C(0xa4d541e6), \
  U32C(0x76764297), U32C(0x0232bda1), U32C(0x5deaeb9d), U32C(0xe9a766a7), \
  U32C(0x897a5157), U32C(0x1536cc61), U32C(0x70eefa5d), U32C(0xfcab7567), \
  U32C(0x608ade67), U32C(0xec475971), U32C(0x47ff876d), U32C(0xd3bc0277), \
  U32C(0x738eed27), U32C(0xff4b6831), U32C(0x5b03962d), U32C(0xe6c01137), \
  U32C(0xa9596ab4), U32C(0x3515e5be), U32C(0x90ce13ba), U32C(0x1c8a8ec4), \
  U32C(0xbc5d7974), U32C(0x4819f47e), U32C(0xa3d2227a), U32C(0x2f8e9d84), \
  U32C(0x936e0684), U32C(0x1f2a818e), U32C(0x7ae2af8a), U32C(0x069f2a94), \
  U32C(0xa6721544), U32C(0x322e904e), U32C(0x8de6be4a), U32C(0x19a33954), \
  U32C(0xaf379820), U32C(0x3af4132a), U32C(0x96ac4126), U32C(0x2268bc30), \
  U32C(0xc23ba6e0), U32C(0x4df821ea), U32C(0xa9b04fe6), U32C(0x356ccaf0), \
  U32C(0x994c33f0), U32C(0x2508aefa), U32C(0x80c0dcf6), U32C(0x0c7d5800), \
  U32C(0xac5042b0), U32C(0x380cbdba), U32C(0x93c4ebb6), U32C(0x1f8166c0), \
  U32C(0xe21ac03d), U32C(0x6dd73b47), U32C(0xc98f6943), U32C(0x554be44d), \
  U32C(0xf51ecefd), U32C(0x80db4a07), U32C(0xdc937803), U32C(0x684ff30d), \
  U32C(0xcc2f5c0d), U32C(0x57ebd717), U32C(0xb3a40513), U32C(0x3f60801d), \
  U32C(0xdf336acd), U32C(0x6aefe5d7), U32C(0xc6a813d3), U32C(0x52648edd), \
  U32C(0x343f7140), U32C(0xbffbec4a), U32C(0x1bb41a46), U32C(0xa7709550), \
  U32C(0x47438000), U32C(0xd2fffb0a), U32C(0x2eb82906), U32C(0xba74a410), \
  U32C(0x1e540d10), U32C(0xaa10881a), U32C(0x05c8b616), U32C(0x91853120), \
  U32C(0x31581bd0), U32C(0xbd1496da), U32C(0x18ccc4d6), U32C(0xa4893fe0), \
  U32C(0x6722995d), U32C(0xf2df1467), U32C(0x4e974263), U32C(0xda53bd6d), \
  U32C(0x7a26a81d), U32C(0x05e32327), U32C(0x619b5123), U32C(0xed57cc2d), \
  U32C(0x5137352d), U32C(0xdcf3b037), U32C(0x38abde33), U32C(0xc468593d), \
  U32C(0x643b43ed), U32C(0xeff7bef7), U32C(0x4bafecf3), U32C(0xd76c67fd), \
  U32C(0x6d00c6c9), U32C(0xf8bd41d3), U32C(0x54756fcf), U32C(0xe031ead9), \
  U32C(0x8004d589), U32C(0x0bc15093), U32C(0x67797e8f), U32C(0xf335f999), \
  U32C(0x57156299), U32C(0xe2d1dda3), U32C(0x3e8a0b9f), U32C(0xca4686a9), \
  U32C(0x6a197159), U32C(0xf5d5ec63), U32C(0x518e1a5f), U32C(0xdd4a9569), \
  U32C(0x9fe3eee6), U32C(0x2ba069f0), U32C(0x875897ec), U32C(0x131512f6), \
  U32C(0xb2e7fda6), U32C(0x3ea478b0), U32C(0x9a5ca6ac), U32C(0x261921b6), \
  U32C(0x89f88ab6), U32C(0x15b505c0), U32C(0x716d33bc), U32C(0xfd29aec6), \
  U32C(0x9cfc9976), U32C(0x28b91480), U32C(0x8471427c), U32C(0x102dbd86), \
  U32C(0xec1e5f0d), U32C(0x77dada17), U32C(0xd3930813), U32C(0x5f4f831d), \
  U32C(0xff226dcd), U32C(0x8adee8d7), U32C(0xe69716d3), U32C(0x725391dd), \
  U32C(0xd632fadd), U32C(0x61ef75e7), U32C(0xbda7a3e3), U32C(0x49641eed), \
  U32C(0xe937099d), U32C(0x74f384a7), U32C(0xd0abb2a3), U32C(0x5c682dad), \
  U32C(0x1f01872a), U32C(0xaabe0234), U32C(0x06763030), U32C(0x9232ab3a), \
  U32C(0x320595ea), U32C(0xbdc210f4), U32C(0x197a3ef0), U32C(0xa536b9fa), \
  U32C(0x091622fa), U32C(0x94d29e04), U32C(0xf08acc00), U32C(0x7c47470a), \
  U32C(0x1c1a31ba), U32C(0xa7d6acc4), U32C(0x038edac0), U32C(0x8f4b55ca), \
  U32C(0x24dfb496), U32C(0xb09c2fa0), U32C(0x0c545d9c), U32C(0x9810d8a6), \
  U32C(0x37e3c356), U32C(0xc3a03e60), U32C(0x1f586c5c), U32C(0xab14e766), \
  U32C(0x0ef45066), U32C(0x9ab0cb70), U32C(0xf668f96c), U32C(0x82257476), \
  U32C(0x21f85f26), U32C(0xadb4da30), U32C(0x096d082c), U32C(0x95298336), \
  U32C(0x57c2dcb3), U32C(0xe37f57bd), U32C(0x3f3785b9), U32C(0xcaf400c3), \
  U32C(0x6ac6eb73), U32C(0xf683667d), U32C(0x523b9479), U32C(0xddf80f83), \
  U32C(0x41d77883), U32C(0xcd93f38d), U32C(0x294c2189), U32C(0xb5089c93), \
  U32C(0x54db8743), U32C(0xe098024d), U32C(0x3c503049), U32C(0xc80cab53), \
  U32C(0xa9e78db6), U32C(0x35a408c0), U32C(0x915c36bc), U32C(0x1d18b1c6), \
  U32C(0xbceb9c76), U32C(0x48a81780), U32C(0xa460457c), U32C(0x301cc086), \
  U32C(0x93fc2986), U32C(0x1fb8a490), U32C(0x7b70d28c), U32C(0x072d4d96), \
  U32C(0xa7003846), U32C(0x32bcb350), U32C(0x8e74e14c), U32C(0x1a315c56), \
  U32C(0xdccab5d3), U32C(0x688730dd), U32C(0xc43f5ed9), U32C(0x4ffbd9e3), \
  U32C(0xefcec493), U32C(0x7b8b3f9d), U32C(0xd7436d99), U32C(0x62ffe8a3), \
  U32C(0xc6df51a3), U32C(0x529bccad), U32C(0xae53faa9), U32C(0x3a1075b3), \
  U32C(0xd9e36063), U32C(0x659fdb6d), U32C(0xc1580969), U32C(0x4d148473), \
  U32C(0xe2a8e33f), U32C(0x6e655e49), U32C(0xca1d8c45), U32C(0x55da074f), \
  U32C(0xf5acf1ff), U32C(0x81696d09), U32C(0xdd219b05), U32C(0x68de160f), \
  U32C(0xccbd7f0f), U32C(0x5879fa19), U32C(0xb4322815), U32C(0x3feea31f), \
  U32C(0xdfc18dcf), U32C(0x6b7e08d9), U32C(0xc73636d5), U32C(0x52f2b1df), \
  U32C(0x158c0b5c), U32C(0xa1488666), U32C(0xfd00b462), U32C(0x88bd2f6c), \
  U32C(0x28901a1c), U32C(0xb44c9526), U32C(0x1004c322), U32C(0x9bc13e2c), \
  U32C(0xffa0a72c), U32C(0x8b5d2236), U32C(0xe7155032), U32C(0x72d1cb3c), \
  U32C(0x12a4b5ec), U32C(0x9e6130f6), U32C(0xfa195ef2), U32C(0x85d5d9fc), \
  U32C(0x5776daad), U32C(0xe33355b7), U32C(0x3eeb83b3), U32C(0xcaa7febd), \
  U32C(0x6a7ae96d), U32C(0xf6376477), U32C(0x51ef9273), U32C(0xddac0d7d), \
  U32C(0x418b767d), U32C(0xcd47f187), U32C(0x29001f83), U32C(0xb4bc9a8d), \
  U32C(0x548f853d), U32C(0xe04c0047), U32C(0x3c042e43), U32C(0xc7c0a94d), \
  U32C(0x8a5a02ca), U32C(0x16167dd4), U32C(0x71ceabd0), U32C(0xfd8b26da), \
  U32C(0x9d5e118a), U32C(0x291a8c94), U32C(0x84d2ba90), U32C(0x108f359a), \
  U32C(0x746e9e9a), U32C(0x002b19a4), U32C(0x5be347a0), U32C(0xe79fc2aa), \
  U32C(0x8772ad5a), U32C(0x132f2864), U32C(0x6ee75660), U32C(0xfaa3d16a), \
  U32C(0x90383036), U32C(0x1bf4ab40), U32C(0x77acd93c), U32C(0x03695446), \
  U32C(0xa33c3ef6), U32C(0x2ef8ba00), U32C(0x8ab0e7fc), U32C(0x166d6306), \
  U32C(0x7a4ccc06), U32C(0x06094710), U32C(0x61c1750c), U32C(0xed7df016), \
  U32C(0x8d50dac6), U32C(0x190d55d0), U32C(0x74c583cc), U32C(0x0081fed6), \
  U32C(0xc31b5853), U32C(0x4ed7d35d), U32C(0xaa900159), U32C(0x364c7c63), \
  U32C(0xd61f6713), U32C(0x61dbe21d), U32C(0xbd941019), U32C(0x49508b23), \
  U32C(0xad2ff423), U32C(0x38ec6f2d), U32C(0x94a49d29), U32C(0x20611833), \
  U32C(0xc03402e3), U32C(0x4bf07ded), U32C(0xa7a8abe9), U32C(0x336526f3), \
  U32C(0x15400956), U32C(0xa0fc8460), U32C(0xfcb4b25c), U32C(0x88712d66), \
  U32C(0x28441816), U32C(0xb4009320), U32C(0x0fb8c11c), U32C(0x9b753c26), \
  U32C(0xff54a526), U32C(0x8b112030), U32C(0xe6c94e2c), U32C(0x7285c936), \
  U32C(0x1258b3e6), U32C(0x9e152ef0), U32C(0xf9cd5cec), U32C(0x8589d7f6), \
  U32C(0x48233173), U32C(0xd3dfac7d), U32C(0x2f97da79), U32C(0xbb545583), \
  U32C(0x5b274033), U32C(0xe6e3bb3d), U32C(0x429be939), U32C(0xce586443), \
  U32C(0x3237cd43), U32C(0xbdf4484d), U32C(0x19ac7649), U32C(0xa568f153), \
  U32C(0x453bdc03), U32C(0xd0f8570d), U32C(0x2cb08509), U32C(0xb86d0013), \
  U32C(0x4e015edf), U32C(0xd9bdd9e9), U32C(0x357607e5), U32C(0xc13282ef), \
  U32C(0x61056d9f), U32C(0xecc1e8a9), U32C(0x487a16a5), U32C(0xd43691af), \
  U32C(0x3815faaf), U32C(0xc3d275b9), U32C(0x1f8aa3b5), U32C(0xab471ebf), \
  U32C(0x4b1a096f), U32C(0xd6d68479), U32C(0x328eb275), U32C(0xbe4b2d7f), \
  U32C(0x80e486fc), U32C(0x0ca10206), U32C(0x68593002), U32C(0xf415ab0c), \
  U32C(0x93e895bc), U32C(0x1fa510c6), U32C(0x7b5d3ec2), U32C(0x0719b9cc), \
  U32C(0x6af922cc), U32C(0xf6b59dd6), U32C(0x526dcbd2), U32C(0xde2a46dc), \
  U32C(0x7dfd318c), U32C(0x09b9ac96), U32C(0x6571da92), U32C(0xf12e559c), \
  U32C(0x94185ec3), U32C(0x1fd4d9cd), U32C(0x7b8d07c9), U32C(0x074982d3), \
  U32C(0xa71c6d83), U32C(0x32d8e88d), U32C(0x8e911689), U32C(0x1a4d9193), \
  U32C(0x7e2cfa93), U32C(0x09e9759d), U32C(0x65a1a399), U32C(0xf15e1ea3), \
  U32C(0x91310953), U32C(0x1ced845d), U32C(0x78a5b259), U32C(0x04622d63), \
  U32C(0xc6fb86e0), U32C(0x52b801ea), U32C(0xae702fe6), U32C(0x3a2caaf0), \
  U32C(0xd9ff95a0), U32C(0x65bc10aa), U32C(0xc1743ea6), U32C(0x4d30b9b0), \
  U32C(0xb11022b0), U32C(0x3ccc9dba), U32C(0x9884cbb6), U32C(0x244146c0), \
  U32C(0xc4143170), U32C(0x4fd0ac7a), U32C(0xab88da76), U32C(0x37455580), \
  U32C(0xccd9b44c), U32C(0x58962f56), U32C(0xb44e5d52), U32C(0x400ad85c), \
  U32C(0xdfddc30c), U32C(0x6b9a3e16), U32C(0xc7526c12), U32C(0x530ee71c), \
  U32C(0xb6ee501c), U32C(0x42aacb26), U32C(0x9e62f922), U32C(0x2a1f742c), \
  U32C(0xc9f25edc), U32C(0x55aed9e6), U32C(0xb16707e2), U32C(0x3d2382ec), \
  U32C(0xffbcdc69), U32C(0x8b795773), U32C(0xe731856f), U32C(0x72ee0079), \
  U32C(0x12c0eb29), U32C(0x9e7d6633), U32C(0xfa35942f), U32C(0x85f20f39), \
  U32C(0xe9d17839), U32C(0x758df343), U32C(0xd146213f), U32C(0x5d029c49), \
  U32C(0xfcd586f9), U32C(0x88920203), U32C(0xe44a2fff), U32C(0x7006ab09), \
  U32C(0x51e18d6c), U32C(0xdd9e0876), U32C(0x39563672), U32C(0xc512b17c), \
  U32C(0x64e59c2c), U32C(0xf0a21736), U32C(0x4c5a4532), U32C(0xd816c03c), \
  U32C(0x3bf6293c), U32C(0xc7b2a446), U32C(0x236ad242), U32C(0xaf274d4c), \
  U32C(0x4efa37fc), U32C(0xdab6b306), U32C(0x366ee102), U32C(0xc22b5c0c), \
  U32C(0x84c4b589), U32C(0x10813093), U32C(0x6c395e8f), U32C(0xf7f5d999), \
  U32C(0x97c8c449), U32C(0x23853f53), U32C(0x7f3d6d4f), U32C(0x0af9e859), \
  U32C(0x6ed95159), U32C(0xfa95cc63), U32C(0x564dfa5f), U32C(0xe20a7569), \
  U32C(0x81dd6019), U32C(0x0d99db23), U32C(0x6952091f), U32C(0xf50e8429), \
  U32C(0x8aa2e2f5), U32C(0x165f5dff), U32C(0x72178bfb), U32C(0xfdd40705), \
  U32C(0x9da6f1b5), U32C(0x29636cbf), U32C(0x851b9abb), U32C(0x10d815c5), \
  U32C(0x74b77ec5), U32C(0x0073f9cf), U32C(0x5c2c27cb), U32C(0xe7e8a2d5), \
  U32C(0x87bb8d85), U32C(0x1378088f), U32C(0x6f30368b), U32C(0xfaecb195), \
  U32C(0xbd860b12), U32C(0x4942861c), U32C(0xa4fab418), U32C(0x30b72f22), \
  U32C(0xd08a19d2), U32C(0x5c4694dc), U32C(0xb7fec2d8), U32C(0x43bb3de2), \
  U32C(0xa79aa6e2), U32C(0x335721ec), U32C(0x8f0f4fe8), U32C(0x1acbcaf2), \
  U32C(0xba9eb5a2), U32C(0x465b30ac), U32C(0xa2135ea8), U32C(0x2dcfd9b2), \
  U32C(0xff70da63), U32C(0x8b2d556d), U32C(0xe6e58369), U32C(0x72a1fe73), \
  U32C(0x1274e923), U32C(0x9e31642d), U32C(0xf9e99229), U32C(0x85a60d33), \
  U32C(0xe9857633), U32C(0x7541f13d), U32C(0xd0fa1f39), U32C(0x5cb69a43), \
  U32C(0xfc8984f3), U32C(0x8845fffd), U32C(0xe3fe2df9), U32C(0x6fbaa903), \
  U32C(0x32540280), U32C(0xbe107d8a), U32C(0x19c8ab86), U32C(0xa5852690), \
  U32C(0x45581140), U32C(0xd1148c4a), U32C(0x2cccba46), U32C(0xb8893550), \
  U32C(0x1c689e50), U32C(0xa825195a), U32C(0x03dd4756), U32C(0x8f99c260), \
  U32C(0x2f6cad10), U32C(0xbb29281a), U32C(0x16e15616), U32C(0xa29dd120), \
  U32C(0x38322fec), U32C(0xc3eeaaf6), U32C(0x1fa6d8f2), U32C(0xab6353fc), \
  U32C(0x4b363eac), U32C(0xd6f2b9b6), U32C(0x32aae7b2), U32C(0xbe6762bc), \
  U32C(0x2246cbbc), U32C(0xae0346c6), U32C(0x09bb74c2), U32C(0x9577efcc), \
  U32C(0x354ada7c), U32C(0xc1075586), U32C(0x1cbf8382), U32C(0xa87bfe8c), \
  U32C(0x6b155809), U32C(0xf6d1d313), U32C(0x528a010f), U32C(0xde467c19), \
  U32C(0x7e1966c9), U32C(0x09d5e1d3), U32C(0x658e0fcf), U32C(0xf14a8ad9), \
  U32C(0x5529f3d9), U32C(0xe0e66ee3), U32C(0x3c9e9cdf), U32C(0xc85b17e9), \
  U32C(0x682e0299), U32C(0xf3ea7da3), U32C(0x4fa2ab9f), U32C(0xdb5f26a9), \
  U32C(0xbd3a090c), U32C(0x48f68416), U32C(0xa4aeb212), U32C(0x306b2d1c), \
  U32C(0xd03e17cc), U32C(0x5bfa92d6), U32C(0xb7b2c0d2), U32C(0x436f3bdc), \
  U32C(0xa74ea4dc), U32C(0x330b1fe6), U32C(0x8ec34de2), U32C(0x1a7fc8ec), \
  U32C(0xba52b39c), U32C(0x460f2ea6), U32C(0xa1c75ca2), U32C(0x2d83d7ac), \
  U32C(0xf01d3129), U32C(0x7bd9ac33), U32C(0xd791da2f), U32C(0x634e5539), \
  U32C(0x03213fe9), U32C(0x8eddbaf3), U32C(0xea95e8ef), U32C(0x765263f9), \
  U32C(0xda31ccf9), U32C(0x65ee4803), U32C(0xc1a675ff), U32C(0x4d62f109), \
  U32C(0xed35dbb9), U32C(0x78f256c3), U32C(0xd4aa84bf), U32C(0x6066ffc9), \
  U32C(0xf5fb5e95), U32C(0x81b7d99f), U32C(0xdd70079b), U32C(0x692c82a5), \
  U32C(0x08ff6d55), U32C(0x94bbe85f), U32C(0xf074165b), U32C(0x7c309165), \
  U32C(0xe00ffa65), U32C(0x6bcc756f), U32C(0xc784a36b), U32C(0x53411e75), \
  U32C(0xf3140925), U32C(0x7ed0842f), U32C(0xda88b22b), U32C(0x66452d35), \
  U32C(0x28de86b2), U32C(0xb49b01bc), U32C(0x10532fb8), U32C(0x9c0faac2), \
  U32C(0x3be29572), U32C(0xc79f107c), U32C(0x23573e78), U32C(0xaf13b982), \
  U32C(0x12f32282), U32C(0x9eaf9d8c), U32C(0xfa67cb88), U32C(0x86244692), \
  U32C(0x25f73142), U32C(0xb1b3ac4c), U32C(0x0d6bda48), U32C(0x99285552), \
  U32C(0x7518f6d9), U32C(0x00d571e3), U32C(0x5c8d9fdf), U32C(0xe84a1ae9), \
  U32C(0x881d0599), U32C(0x13d980a3), U32C(0x6f91ae9f), U32C(0xfb4e29a9), \
  U32C(0x5f2d92a9), U32C(0xeaea0db3), U32C(0x46a23baf), U32C(0xd25eb6b9), \
  U32C(0x7231a169), U32C(0xfdee1c73), U32C(0x59a64a6f), U32C(0xe562c579), \
  U32C(0xa7fc1ef6), U32C(0x33b89a00), U32C(0x8f70c7fc), U32C(0x1b2d4306), \
  U32C(0xbb002db6), U32C(0x46bca8c0), U32C(0xa274d6bc), U32C(0x2e3151c6), \
  U32C(0x9210bac6), U32C(0x1dcd35d0), U32C(0x798563cc), U32C(0x0541ded6), \
  U32C(0xa514c986), U32C(0x30d14490), U32C(0x8c89728c), U32C(0x1845ed96), \
  U32C(0xadda4c62), U32C(0x3996c76c), U32C(0x954ef568), U32C(0x210b7072), \
  U32C(0xc0de5b22), U32C(0x4c9ad62c), U32C(0xa8530428), U32C(0x340f7f32), \
  U32C(0x97eee832), U32C(0x23ab633c), U32C(0x7f639138), U32C(0x0b200c42), \
  U32C(0xaaf2f6f2), U32C(0x36af71fc), U32C(0x92679ff8), U32C(0x1e241b02), \
  U32C(0xe0bd747f), U32C(0x6c79ef89), U32C(0xc8321d85), U32C(0x53ee988f), \
  U32C(0xf3c1833f), U32C(0x7f7dfe49), U32C(0xdb362c45), U32C(0x66f2a74f), \
  U32C(0xcad2104f), U32C(0x568e8b59), U32C(0xb246b955), U32C(0x3e03345f), \
  U32C(0xddd61f0f), U32C(0x69929a19), U32C(0xc54ac815), U32C(0x5107431f), \
  U32C(0x32e22582), U32C(0xbe9ea08c), U32C(0x1a56ce88), U32C(0xa6134992), \
  U32C(0x45e63442), U32C(0xd1a2af4c), U32C(0x2d5add48), U32C(0xb9175852), \
  U32C(0x1cf6c152), U32C(0xa8b33c5c), U32C(0x046b6a58), U32C(0x9027e562), \
  U32C(0x2ffad012), U32C(0xbbb74b1c), U32C(0x176f7918), U32C(0xa32bf422), \
  U32C(0x65c54d9f), U32C(0xf181c8a9), U32C(0x4d39f6a5), U32C(0xd8f671af), \
  U32C(0x78c95c5f), U32C(0x0485d769), U32C(0x603e0565), U32C(0xebfa806f), \
  U32C(0x4fd9e96f), U32C(0xdb966479), U32C(0x374e9275), U32C(0xc30b0d7f), \
  U32C(0x62ddf82f), U32C(0xee9a7339), U32C(0x4a52a135), U32C(0xd60f1c3f), \
  U32C(0x6ba37b0b), U32C(0xf75ff615), U32C(0x53182411), U32C(0xded49f1b), \
  U32C(0x7ea789cb), U32C(0x0a6404d5), U32C(0x661c32d1), U32C(0xf1d8addb), \
  U32C(0x55b816db), U32C(0xe17491e5), U32C(0x3d2cbfe1), U32C(0xc8e93aeb), \
  U32C(0x68bc259b), U32C(0xf478a0a5), U32C(0x5030cea1), U32C(0xdbed49ab), \
  U32C(0x9e86a328), U32C(0x2a431e32), U32C(0x85fb4c2e), U32C(0x11b7c738), \
  U32C(0xb18ab1e8), U32C(0x3d472cf2), U32C(0x98ff5aee), U32C(0x24bbd5f8), \
  U32C(0x889b3ef8), U32C(0x1457ba02), U32C(0x700fe7fe), U32C(0xfbcc6308), \
  U32C(0x9b9f4db8), U32C(0x275bc8c2), U32C(0x8313f6be), U32C(0x0ed071c8), \
  U32C(0xe0717279), U32C(0x6c2ded83), U32C(0xc7e61b7f), U32C(0x53a29689), \
  U32C(0xf3758139), U32C(0x7f31fc43), U32C(0xdaea2a3f), U32C(0x66a6a549), \
  U32C(0xca860e49), U32C(0x56428953), U32C(0xb1fab74f), U32C(0x3db73259), \
  U32C(0xdd8a1d09), U32C(0x69469813), U32C(0xc4fec60f), U32C(0x50bb4119), \
  U32C(0x13549a96), U32C(0x9f1115a0), U32C(0xfac9439c), U32C(0x8685bea6), \
  U32C(0x2658a956), U32C(0xb2152460), U32C(0x0dcd525c), U32C(0x9989cd66), \
  U32C(0xfd693666), U32C(0x8925b170), U32C(0xe4dddf6c), U32C(0x709a5a76), \
  U32C(0x106d4526), U32C(0x9c29c030), U32C(0xf7e1ee2c), U32C(0x839e6936), \
  U32C(0x1932c802), U32C(0xa4ef430c), U32C(0x00a77108), U32C(0x8c63ec12), \
  U32C(0x2c36d6c2), U32C(0xb7f351cc), U32C(0x13ab7fc8), U32C(0x9f67fad2), \
  U32C(0x034763d2), U32C(0x8f03dedc), U32C(0xeabc0cd8), U32C(0x767887e2), \
  U32C(0x164b7292), U32C(0xa207ed9c), U32C(0xfdc01b98), U32C(0x897c96a2), \
  U32C(0x4c15f01f), U32C(0xd7d26b29), U32C(0x338a9925), U32C(0xbf47142f), \
  U32C(0x5f19fedf), U32C(0xead679e9), U32C(0x468ea7e5), U32C(0xd24b22ef), \
  U32C(0x362a8bef), U32C(0xc1e706f9), U32C(0x1d9f34f5), U32C(0xa95bafff), \
  U32C(0x492e9aaf), U32C(0xd4eb15b9), U32C(0x30a343b5), U32C(0xbc5fbebf), \
  U32C(0x9e3aa122), U32C(0x29f71c2c), U32C(0x85af4a28), U32C(0x116bc532), \
  U32C(0xb13eafe2), U32C(0x3cfb2aec), U32C(0x98b358e8), U32C(0x246fd3f2), \
  U32C(0x884f3cf2), U32C(0x140bb7fc), U32C(0x6fc3e5f8), U32C(0xfb806102), \
  U32C(0x9b534bb2), U32C(0x270fc6bc), U32C(0x82c7f4b8), U32C(0x0e846fc2), \
  U32C(0xd11dc93f), U32C(0x5cda4449), U32C(0xb8927245), U32C(0x444eed4f), \
  U32C(0xe421d7ff), U32C(0x6fde5309), U32C(0xcb968105), U32C(0x5752fc0f), \
  U32C(0xbb32650f), U32C(0x46eee019), U32C(0xa2a70e15), U32C(0x2e63891f), \
  U32C(0xce3673cf), U32C(0x59f2eed9), U32C(0xb5ab1cd5), U32C(0x416797df), \
  U32C(0xd6fbf6ab), U32C(0x62b871b5), U32C(0xbe709fb1), U32C(0x4a2d1abb), \
  U32C(0xea00056b), U32C(0x75bc8075), U32C(0xd174ae71), U32C(0x5d31297b), \
  U32C(0xc110927b), U32C(0x4ccd0d85), U32C(0xa8853b81), U32C(0x3441b68b), \
  U32C(0xd414a13b), U32C(0x5fd11c45), U32C(0xbb894a41), U32C(0x4745c54b), \
  U32C(0x09df1ec8), U32C(0x959b99d2), U32C(0xf153c7ce), U32C(0x7d1042d8), \
  U32C(0x1ce32d88), U32C(0xa89fa892), U32C(0x0457d68e), U32C(0x90145198), \
  U32C(0xf3f3ba98), U32C(0x7fb035a2), U32C(0xdb68639e), U32C(0x6724dea8), \
  U32C(0x06f7c958), U32C(0x92b44462), U32C(0xee6c725e), U32C(0x7a28ed68), \
  U32C(0x7ec0a614), U32C(0x0a7d211e), U32C(0x66354f1a), U32C(0xf1f1ca24), \
  U32C(0x91c4b4d4), U32C(0x1d812fde), U32C(0x79395dda), U32C(0x04f5d8e4), \
  U32C(0x68d541e4), U32C(0xf491bcee), U32C(0x5049eaea), U32C(0xdc0665f4), \
  U32C(0x7bd950a4), U32C(0x0795cbae), U32C(0x634df9aa), U32C(0xef0a74b4), \
  U32C(0xb1a3ce31), U32C(0x3d60493b), U32C(0x99187737), U32C(0x24d4f241), \
  U32C(0xc4a7dcf1), U32C(0x506457fb), U32C(0xac1c85f7), U32C(0x37d90101), \
  U32C(0x9bb86a01), U32C(0x2774e50b), U32C(0x832d1307), U32C(0x0ee98e11), \
  U32C(0xaebc78c1), U32C(0x3a78f3cb), U32C(0x963121c7), U32C(0x21ed9cd1), \
  U32C(0xb781fb9d), U32C(0x433e76a7), U32C(0x9ef6a4a3), U32C(0x2ab31fad), \
  U32C(0xca860a5d), U32C(0x56428567), U32C(0xb1fab363), U32C(0x3db72e6d), \
  U32C(0xa196976d), U32C(0x2d531277), U32C(0x890b4073), U32C(0x14c7bb7d), \
  U32C(0xb49aa62d), U32C(0x40572137), U32C(0x9c0f4f33), U32C(0x27cbca3d), \
  U32C(0xea6523ba), U32C(0x76219ec4), U32C(0xd1d9ccc0), U32C(0x5d9647ca), \
  U32C(0xfd69327a), U32C(0x8925ad84), U32C(0xe4dddb80), U32C(0x709a568a), \
  U32C(0xd479bf8a), U32C(0x60363a94), U32C(0xbbee6890), U32C(0x47aae39a), \
  U32C(0xe77dce4a), U32C(0x733a4954), U32C(0xcef27750), U32C(0x5aaef25a), \
  U32C(0x3c89d4bd), U32C(0xc8464fc7), U32C(0x23fe7dc3), U32C(0xafbaf8cd), \
  U32C(0x4f8de37d), U32C(0xdb4a5e87), U32C(0x37028c83), U32C(0xc2bf078d), \
  U32C(0x269e708d), U32C(0xb25aeb97), U32C(0x0e131993), U32C(0x99cf949d), \
  U32C(0x39a27f4d), U32C(0xc55efa57), U32C(0x21172853), U32C(0xacd3a35d), \
  U32C(0x6f6cfcda), U32C(0xfb2977e4), U32C(0x56e1a5e0), U32C(0xe29e20ea), \
  U32C(0x82710b9a), U32C(0x0e2d86a4), U32C(0x69e5b4a0), U32C(0xf5a22faa), \
  U32C(0x598198aa), U32C(0xe53e13b4), U32C(0x40f641b0), U32C(0xccb2bcba), \
  U32C(0x6c85a76a), U32C(0xf8422274), U32C(0x53fa5070), U32C(0xdfb6cb7a), \
  U32C(0x754b2a46), U32C(0x0107a550), U32C(0x5cbfd34c), U32C(0xe87c4e56), \
  U32C(0x884f3906), U32C(0x140bb410), U32C(0x6fc3e20c), U32C(0xfb805d16), \
  U32C(0x5f5fc616), U32C(0xeb1c4120), U32C(0x46d46f1c), U32C(0xd290ea26), \
  U32C(0x7263d4d6), U32C(0xfe204fe0), U32C(0x59d87ddc), U32C(0xe594f8e6), \
  U32C(0xa82e5263), U32C(0x33eacd6d), U32C(0x8fa2fb69), U32C(0x1b5f7673), \
  U32C(0xbb326123), U32C(0x46eedc2d), U32C(0xa2a70a29), U32C(0x2e638533), \
  U32C(0x9242ee33), U32C(0x1dff693d), U32C(0x79b79739), U32C(0x05741243), \
  U32C(0xa546fcf3), U32C(0x310377fd), U32C(0x8cbba5f9), U32C(0x18782103), \
  U32C(0xea1921b4), U32C(0x75d59cbe), U32C(0xd18dcaba), U32C(0x5d4a45c4), \
  U32C(0xfd1d3074), U32C(0x88d9ab7e), U32C(0xe491d97a), U32C(0x704e5484), \
  U32C(0xd42dbd84), U32C(0x5fea388e), U32C(0xbba2668a), U32C(0x475ee194), \
  U32C(0xe731cc44), U32C(0x72ee474e), U32C(0xcea6754a), U32C(0x5a62f054), \
  U32C(0x1cfc49d1), U32C(0xa8b8c4db), U32C(0x0470f2d7), U32C(0x902d6de1), \
  U32C(0x30005891), U32C(0xbbbcd39b), U32C(0x17750197), U32C(0xa3317ca1), \
  U32C(0x0710e5a1), U32C(0x92cd60ab), U32C(0xee858ea7), U32C(0x7a4209b1), \
  U32C(0x1a14f461), U32C(0xa5d16f6b), U32C(0x01899d67), U32C(0x8d461871), \
  U32C(0x22da773d), U32C(0xae96f247), U32C(0x0a4f2043), U32C(0x960b9b4d), \
  U32C(0x35de85fd), U32C(0xc19b0107), U32C(0x1d532f03), U32C(0xa90faa0d), \
  U32C(0x0cef130d), U32C(0x98ab8e17), U32C(0xf463bc13), U32C(0x8020371d), \
  U32C(0x1ff321cd), U32C(0xabaf9cd7), U32C(0x0767cad3), U32C(0x932445dd), \
  U32C(0x55bd9f5a), U32C(0xe17a1a64), U32C(0x3d324860), U32C(0xc8eec36a), \
  U32C(0x68c1ae1a), U32C(0xf47e2924), U32C(0x50365720), U32C(0xdbf2d22a), \
  U32C(0x3fd23b2a), U32C(0xcb8eb634), U32C(0x2746e430), U32C(0xb3035f3a), \
  U32C(0x52d649ea), U32C(0xde92c4f4), U32C(0x3a4af2f0), U32C(0xc6076dfa), \
  U32C(0xa7e2505d), U32C(0x339ecb67), U32C(0x8f56f963), U32C(0x1b13746d), \
  U32C(0xbae65f1d), U32C(0x46a2da27), U32C(0xa25b0823), U32C(0x2e17832d), \
  U32C(0x91f6ec2d), U32C(0x1db36737), U32C(0x796b9533), U32C(0x0528103d), \
  U32C(0xa4fafaed), U32C(0x30b775f7), U32C(0x8c6fa3f3), U32C(0x182c1efd), \
  U32C(0xdac5787a), U32C(0x6681f384), U32C(0xc23a2180), U32C(0x4df69c8a), \
  U32C(0xedc9873a), U32C(0x79860244), U32C(0xd53e3040), U32C(0x60faab4a), \
  U32C(0xc4da144a), U32C(0x50968f54), U32C(0xac4ebd50), U32C(0x380b385a), \
  U32C(0xd7de230a), U32C(0x639a9e14), U32C(0xbf52cc10), U32C(0x4b0f471a), \
  U32C(0xe0a3a5e6), U32C(0x6c6020f0), U32C(0xc8184eec), U32C(0x53d4c9f6), \
  U32C(0xf3a7b4a6), U32C(0x7f642fb0), U32C(0xdb1c5dac), U32C(0x66d8d8b6), \
  U32C(0xcab841b6), U32C(0x5674bcc0), U32C(0xb22ceabc), U32C(0x3de965c6), \
  U32C(0xddbc5076), U32C(0x6978cb80), U32C(0xc530f97c), U32C(0x50ed7486), \
  U32C(0x1386ce03), U32C(0x9f43490d), U32C(0xfafb7709), U32C(0x86b7f213), \
  U32C(0x268adcc3), U32C(0xb24757cd), U32C(0x0dff85c9), U32C(0x99bc00d3), \
  U32C(0xfd9b69d3), U32C(0x8957e4dd), U32C(0xe51012d9), U32C(0x70cc8de3), \
  U32C(0x109f7893), U32C(0x9c5bf39d), U32C(0xf8142199), U32C(0x83d09ca3), \
  U32C(0x5fc13e2a), U32C(0xeb7db934), U32C(0x4735e730), U32C(0xd2f2623a), \
  U32C(0x72c54cea), U32C(0xfe81c7f4), U32C(0x5a39f5f0), U32C(0xe5f670fa), \
  U32C(0x49d5d9fa), U32C(0xd5925504), U32C(0x314a8300), U32C(0xbd06fe0a), \
  U32C(0x5cd9e8ba), U32C(0xe89663c4), U32C(0x444e91c0), U32C(0xd00b0cca), \
  U32C(0x92a46647), U32C(0x1e60e151), U32C(0x7a190f4d), U32C(0x05d58a57), \
  U32C(0xa5a87507), U32C(0x3164f011), U32C(0x8d1d1e0d), U32C(0x18d99917), \
  U32C(0x7cb90217), U32C(0x08757d21), U32C(0x642dab1d), U32C(0xefea2627), \
  U32C(0x8fbd10d7), U32C(0x1b798be1), U32C(0x7731b9dd), U32C(0x02ee34e7), \
  U32C(0x988293b3), U32C(0x243f0ebd), U32C(0x7ff73cb9), U32C(0x0bb3b7c3), \
  U32C(0xab86a273), U32C(0x37431d7d), U32C(0x92fb4b79), U32C(0x1eb7c683), \
  U32C(0x82972f83), U32C(0x0e53aa8d), U32C(0x6a0bd889), U32C(0xf5c85393), \
  U32C(0x959b3e43), U32C(0x2157b94d), U32C(0x7d0fe749), U32C(0x08cc6253), \
  U32C(0xcb65bbd0), U32C(0x572236da), U32C(0xb2da64d6), U32C(0x3e96dfe0), \
  U32C(0xde69ca90), U32C(0x6a26459a), U32C(0xc5de7396), U32C(0x519aeea0), \
  U32C(0xb57a57a0), U32C(0x4136d2aa), U32C(0x9cef00a6), U32C(0x28ab7bb0), \
  U32C(0xc87e6660), U32C(0x543ae16a), U32C(0xaff30f66), U32C(0x3baf8a70), \
  U32C(0x1d8a6cd3), U32C(0xa946e7dd), U32C(0x04ff15d9), U32C(0x90bb90e3), \
  U32C(0x308e7b93), U32C(0xbc4af69d), U32C(0x18032499), U32C(0xa3bf9fa3), \
  U32C(0x079f08a3), U32C(0x935b83ad), U32C(0xef13b1a9), U32C(0x7ad02cb3), \
  U32C(0x1aa31763), U32C(0xa65f926d), U32C(0x0217c069), U32C(0x8dd43b73), \
  U32C(0x506d94f0), U32C(0xdc2a0ffa), U32C(0x37e23df6), U32C(0xc39eb900), \
  U32C(0x6371a3b0), U32C(0xef2e1eba), U32C(0x4ae64cb6), U32C(0xd6a2c7c0), \
  U32C(0x3a8230c0), U32C(0xc63eabca), U32C(0x21f6d9c6), U32C(0xadb354d0), \
  U32C(0x4d863f80), U32C(0xd942ba8a), U32C(0x34fae886), U32C(0xc0b76390), \
  U32C(0x564bc25c), U32C(0xe2083d66), U32C(0x3dc06b62), U32C(0xc97ce66c), \
  U32C(0x694fd11c), U32C(0xf50c4c26), U32C(0x50c47a22), U32C(0xdc80f52c), \
  U32C(0x40605e2c), U32C(0xcc1cd936), U32C(0x27d50732), U32C(0xb391823c), \
  U32C(0x53646cec), U32C(0xdf20e7f6), U32C(0x3ad915f2), U32C(0xc69590fc), \
  U32C(0x892eea79), U32C(0x14eb6583), U32C(0x70a3937f), U32C(0xfc600e89), \
  U32C(0x9c32f939), U32C(0x27ef7443), U32C(0x83a7a23f), U32C(0x0f641d49), \
  U32C(0x73438649), U32C(0xff000153), U32C(0x5ab82f4f), U32C(0xe674aa59), \
  U32C(0x86479509), U32C(0x12041013), U32C(0x6dbc3e0f), U32C(0xf978b919), \
  U32C(0xcb19b9ca), U32C(0x56d634d4), U32C(0xb28e62d0), U32C(0x3e4addda), \
  U32C(0xde1dc88a), U32C(0x69da4394), U32C(0xc5927190), U32C(0x514eec9a), \
  U32C(0xb52e559a), U32C(0x40ead0a4), U32C(0x9ca2fea0), U32C(0x285f79aa), \
  U32C(0xc832645a), U32C(0x53eedf64), U32C(0xafa70d60), U32C(0x3b63886a), \
  U32C(0xfdfce1e7), U32C(0x89b95cf1), U32C(0xe5718aed), U32C(0x712e05f7), \
  U32C(0x1100f0a7), U32C(0x9cbd6bb1), U32C(0xf87599ad), U32C(0x843214b7), \
  U32C(0xe8117db7), U32C(0x73cdf8c1), U32C(0xcf8626bd), U32C(0x5b42a1c7), \
  U32C(0xfb158c77), U32C(0x86d20781), U32C(0xe28a357d), U32C(0x6e46b087), \
  U32C(0x03db0f53), U32C(0x8f978a5d), U32C(0xeb4fb859), U32C(0x770c3363), \
  U32C(0x16df1e13), U32C(0xa29b991d), U32C(0xfe53c719), U32C(0x8a104223), \
  U32C(0xedefab23), U32C(0x79ac262d), U32C(0xd5645429), U32C(0x6120cf33), \
  U32C(0x00f3b9e3), U32C(0x8cb034ed), U32C(0xe86862e9), U32C(0x7424ddf3), \
  U32C(0x36be3770), U32C(0xc27ab27a), U32C(0x1e32e076), U32C(0xa9ef5b80), \
  U32C(0x49c24630), U32C(0xd57ec13a), U32C(0x3136ef36), U32C(0xbcf36a40), \
  U32C(0x20d2d340), U32C(0xac8f4e4a), U32C(0x08477c46), U32C(0x9403f750), \
  U32C(0x33d6e200), U32C(0xbf935d0a), U32C(0x1b4b8b06), U32C(0xa7080610), \
  U32C(0x88e2e873), U32C(0x149f637d), U32C(0x70579179), U32C(0xfc140c83), \
  U32C(0x9be6f733), U32C(0x27a3723d), U32C(0x835ba039), U32C(0x0f181b43), \
  U32C(0x72f78443), U32C(0xfeb3ff4d), U32C(0x5a6c2d49), U32C(0xe628a853), \
  U32C(0x85fb9303), U32C(0x11b80e0d), U32C(0x6d703c09), U32C(0xf92cb713), \
  U32C(0xbbc61090), U32C(0x47828b9a), U32C(0xa33ab996), U32C(0x2ef734a0), \
  U32C(0xceca1f50), U32C(0x5a869a5a), U32C(0xb63ec856), U32C(0x41fb4360), \
  U32C(0xa5daac60), U32C(0x3197276a), U32C(0x8d4f5566), U32C(0x190bd070), \
  U32C(0xb8debb20), U32C(0x449b362a), U32C(0xa0536426), U32C(0x2c0fdf30), \
  U32C(0xc1a43dfc), U32C(0x4d60b906), U32C(0xa918e702), U32C(0x34d5620c), \
  U32C(0xd4a84cbc), U32C(0x6064c7c6), U32C(0xbc1cf5c2), U32C(0x47d970cc), \
  U32C(0xabb8d9cc), U32C(0x377554d6), U32C(0x932d82d2), U32C(0x1ee9fddc), \
  U32C(0xbebce88c), U32C(0x4a796396), U32C(0xa6319192), U32C(0x31ee0c9c), \
  U32C(0xf4876619), U32C(0x8043e123), U32C(0xdbfc0f1f), U32C(0x67b88a29), \
  U32C(0x078b74d9), U32C(0x9347efe3), U32C(0xef001ddf), U32C(0x7abc98e9), \
  U32C(0xde9c01e9), U32C(0x6a587cf3), U32C(0xc610aaef), U32C(0x51cd25f9), \
  U32C(0xf1a010a9), U32C(0x7d5c8bb3), U32C(0xd914b9af), U32C(0x64d134b9), \
  U32C(0x0c0a2cec), U32C(0x97c6a7f6), U32C(0xf37ed5f2), U32C(0x7f3b50fc), \
  U32C(0x1f0e3bac), U32C(0xaacab6b6), U32C(0x0682e4b2), U32C(0x923f5fbc), \
  U32C(0xf61ec8bc), U32C(0x81db43c6), U32C(0xdd9371c2), U32C(0x694feccc), \
  U32C(0x0922d77c), U32C(0x94df5286), U32C(0xf0978082), U32C(0x7c53fb8c), \
  U32C(0x3eed5509), U32C(0xcaa9d013), U32C(0x2661fe0f), U32C(0xb21e7919), \
  U32C(0x51f163c9), U32C(0xddadded3), U32C(0x39660ccf), U32C(0xc52287d9), \
  U32C(0x2901f0d9), U32C(0xb4be6be3), U32C(0x107699df), U32C(0x9c3314e9), \
  U32C(0x3c05ff99), U32C(0xc7c27aa3), U32C(0x237aa89f), U32C(0xaf3723a9), \
  U32C(0x44cb8275), U32C(0xd087fd7f), U32C(0x2c402b7b), U32C(0xb7fca685), \
  U32C(0x57cf9135), U32C(0xe38c0c3f), U32C(0x3f443a3b), U32C(0xcb00b545), \
  U32C(0x2ee01e45), U32C(0xba9c994f), U32C(0x1654c74b), U32C(0xa2114255), \
  U32C(0x41e42d05), U32C(0xcda0a80f), U32C(0x2958d60b), U32C(0xb5155115), \
  U32C(0x77aeaa92), U32C(0x036b259c), U32C(0x5f235398), U32C(0xeadfcea2), \
  U32C(0x8ab2b952), U32C(0x166f345c), U32C(0x72276258), U32C(0xfde3dd62), \
  U32C(0x61c34662), U32C(0xed7fc16c), U32C(0x4937ef68), U32C(0xd4f46a72), \
  U32C(0x74c75522), U32C(0x0083d02c), U32C(0x5c3bfe28), U32C(0xe7f87932), \
  U32C(0xc9d35b95), U32C(0x558fd69f), U32C(0xb148049b), U32C(0x3d047fa5), \
  U32C(0xdcd76a55), U32C(0x6893e55f), U32C(0xc44c135b), U32C(0x50088e65), \
  U32C(0xb3e7f765), U32C(0x3fa4726f), U32C(0x9b5ca06b), U32C(0x27191b75), \
  U32C(0xc6ec0625), U32C(0x52a8812f), U32C(0xae60af2b), U32C(0x3a1d2a35), \
  U32C(0xfcb683b2), U32C(0x8872febc), U32C(0xe42b2cb8), U32C(0x6fe7a7c2), \
  U32C(0x0fba9272), U32C(0x9b770d7c), U32C(0xf72f3b78), U32C(0x82ebb682), \
  U32C(0xe6cb1f82), U32C(0x72879a8c), U32C(0xce3fc888), U32C(0x59fc4392), \
  U32C(0xf9cf2e42), U32C(0x858ba94c), U32C(0xe143d748), U32C(0x6d005252), \
  U32C(0x0294b11e), U32C(0x8e512c28), U32C(0xea095a24), U32C(0x75c5d52e), \
  U32C(0x1598bfde), U32C(0xa1553ae8), U32C(0xfd0d68e4), U32C(0x88c9e3ee), \
  U32C(0xeca94cee), U32C(0x7865c7f8), U32C(0xd41df5f4), U32C(0x5fda70fe), \
  U32C(0xffad5bae), U32C(0x8b69d6b8), U32C(0xe72204b4), U32C(0x72de7fbe), \
  U32C(0x3577d93b), U32C(0xc1345445), U32C(0x1cec8241), U32C(0xa8a8fd4b), \
  U32C(0x487be7fb), U32C(0xd4386305), U32C(0x2ff09101), U32C(0xbbad0c0b), \
  U32C(0x1f8c750b), U32C(0xab48f015), U32C(0x07011e11), U32C(0x92bd991b), \
  U32C(0x329083cb), U32C(0xbe4cfed5), U32C(0x1a052cd1), U32C(0xa5c1a7db), \
  U32C(0x7762a88c), U32C(0x031f2396), U32C(0x5ed75192), U32C(0xea93cc9c), \
  U32C(0x8a66b74c), U32C(0x16233256), U32C(0x71db6052), U32C(0xfd97db5c), \
  U32C(0x6177445c), U32C(0xed33bf66), U32C(0x48ebed62), U32C(0xd4a8686c), \
  U32C(0x747b531c), U32C(0x0037ce26), U32C(0x5beffc22), U32C(0xe7ac772c), \
  U32C(0xaa45d0a9), U32C(0x36024bb3), U32C(0x91ba79af), U32C(0x1d76f4b9), \
  U32C(0xbd49df69), U32C(0x49065a73), U32C(0xa4be886f), U32C(0x307b0379), \
  U32C(0x945a6c79), U32C(0x2016e783), U32C(0x7bcf157f), U32C(0x078b9089), \
  U32C(0xa75e7b39), U32C(0x331af643), U32C(0x8ed3243f), U32C(0x1a8f9f49), \
  U32C(0xb023fe15), U32C(0x3be0791f), U32C(0x9798a71b), U32C(0x23552225), \
  U32C(0xc3280cd5), U32C(0x4ee487df), U32C(0xaa9cb5db), U32C(0x365930e5), \
  U32C(0x9a3899e5), U32C(0x25f514ef), U32C(0x81ad42eb), U32C(0x0d69bdf5), \
  U32C(0xad3ca8a5), U32C(0x38f923af), U32C(0x94b151ab), U32C(0x206dccb5), \
  U32C(0xe3072632), U32C(0x6ec3a13c), U32C(0xca7bcf38), U32C(0x56384a42), \
  U32C(0xf60b34f2), U32C(0x81c7affc), U32C(0xdd7fddf8), U32C(0x693c5902), \
  U32C(0xcd1bc202), U32C(0x58d83d0c), U32C(0xb4906b08), U32C(0x404ce612), \
  U32C(0xe01fd0c2), U32C(0x6bdc4bcc), U32C(0xc79479c8), U32C(0x5350f4d2), \
  U32C(0x352bd735), U32C(0xc0e8523f), U32C(0x1ca0803b), U32C(0xa85cfb45), \
  U32C(0x482fe5f5), U32C(0xd3ec60ff), U32C(0x2fa48efb), U32C(0xbb610a05), \
  U32C(0x1f407305), U32C(0xaafcee0f), U32C(0x06b51c0b), U32C(0x92719715), \
  U32C(0x324481c5), U32C(0xbe00fccf), U32C(0x19b92acb), U32C(0xa575a5d5), \
  U32C(0x680eff52), U32C(0xf3cb7a5c), U32C(0x4f83a858), U32C(0xdb402362), \
  U32C(0x7b130e12), U32C(0x06cf891c), U32C(0x6287b718), U32C(0xee443222), \
  U32C(0x52239b22), U32C(0xdde0162c), U32C(0x39984428), U32C(0xc554bf32), \
  U32C(0x6527a9e2), U32C(0xf0e424ec), U32C(0x4c9c52e8), U32C(0xd858cdf2), \
  U32C(0x6ded2cbe), U32C(0xf9a9a7c8), U32C(0x5561d5c4), U32C(0xe11e50ce), \
  U32C(0x80f13b7e), U32C(0x0cadb688), U32C(0x6865e484), U32C(0xf4225f8e), \
  U32C(0x5801c88e), U32C(0xe3be4398), U32C(0x3f767194), U32C(0xcb32ec9e), \
  U32C(0x6b05d74e), U32C(0xf6c25258), U32C(0x527a8054), U32C(0xde36fb5e), \
  U32C(0xa0d054db), U32C(0x2c8ccfe5), U32C(0x8844fde1), U32C(0x140178eb), \
  U32C(0xb3d4639b), U32C(0x3f90dea5), U32C(0x9b490ca1), U32C(0x270587ab), \
  U32C(0x8ae4f0ab), U32C(0x16a16bb5), U32C(0x725999b1), U32C(0xfe1614bb), \
  U32C(0x9de8ff6b), U32C(0x29a57a75), U32C(0x855da871), U32C(0x111a237b), \
  U32C(0xed0ac502), U32C(0x78c7400c), U32C(0xd47f6e08), U32C(0x603be912), \
  U32C(0x000ed3c2), U32C(0x8bcb4ecc), U32C(0xe7837cc8), U32C(0x733ff7d2), \
  U32C(0xd71f60d2), U32C(0x62dbdbdc), U32C(0xbe9409d8), U32C(0x4a5084e2), \
  U32C(0xea236f92), U32C(0x75dfea9c), U32C(0xd1981898), U32C(0x5d5493a2), \
  U32C(0x1feded1f), U32C(0xabaa6829), U32C(0x07629625), U32C(0x931f112f), \
  U32C(0x32f1fbdf), U32C(0xbeae76e9), U32C(0x1a66a4e5), U32C(0xa6231fef), \
  U32C(0x0a0288ef), U32C(0x95bf03f9), U32C(0xf17731f5), U32C(0x7d33acff), \
  U32C(0x1d0697af), U32C(0xa8c312b9), U32C(0x047b40b5), U32C(0x9037bbbf), \
  U32C(0x25cc1a8b), U32C(0xb1889595), U32C(0x0d40c391), U32C(0x98fd3e9b), \
  U32C(0x38d0294b), U32C(0xc48ca455), U32C(0x2044d251), U32C(0xac014d5b), \
  U32C(0x0fe0b65b), U32C(0x9b9d3165), U32C(0xf7555f61), U32C(0x8311da6b), \
  U32C(0x22e4c51b), U32C(0xaea14025), U32C(0x0a596e21), U32C(0x9615e92b), \
  U32C(0x58af42a8), U32C(0xe46bbdb2), U32C(0x4023ebae), U32C(0xcbe066b8), \
  U32C(0x6bb35168), U32C(0xf76fcc72), U32C(0x5327fa6e), U32C(0xdee47578), \
  U32C(0x42c3de78), U32C(0xce805982), U32C(0x2a38877e), U32C(0xb5f50288), \
  U32C(0x55c7ed38), U32C(0xe1846842), U32C(0x3d3c963e), U32C(0xc8f91148), \
  U32C(0xaad3f3ab), U32C(0x36906eb5), U32C(0x92489cb1), U32C(0x1e0517bb), \
  U32C(0xbdd8026b), U32C(0x49947d75), U32C(0xa54cab71), U32C(0x3109267b), \
  U32C(0x94e88f7b), U32C(0x20a50a85), U32C(0x7c5d3881), U32C(0x0819b38b), \
  U32C(0xa7ec9e3b), U32C(0x33a91945), U32C(0x8f614741), U32C(0x1b1dc24b), \
  U32C(0xddb71bc8), U32C(0x697396d2), U32C(0xc52bc4ce), U32C(0x50e83fd8), \
  U32C(0xf0bb2a88), U32C(0x7c77a592), U32C(0xd82fd38e), U32C(0x63ec4e98), \
  U32C(0xc7cbb798), U32C(0x538832a2), U32C(0xaf40609e), U32C(0x3afcdba8), \
  U32C(0xdacfc658), U32C(0x668c4162), U32C(0xc2446f5e), U32C(0x4e00ea68), \
  U32C(0xe3954934), U32C(0x6f51c43e), U32C(0xcb09f23a), U32C(0x56c66d44), \
  U32C(0xf69957f4), U32C(0x8255d2fe), U32C(0xde0e00fa), U32C(0x69ca7c04), \
  U32C(0xcda9e504), U32C(0x5966600e), U32C(0xb51e8e0a), U32C(0x40db0914), \
  U32C(0xe0adf3c4), U32C(0x6c6a6ece), U32C(0xc8229cca), U32C(0x53df17d4), \
  U32C(0x16787151), U32C(0xa234ec5b), U32C(0xfded1a57), U32C(0x89a99561), \
  U32C(0x297c8011), U32C(0xb538fb1b), U32C(0x10f12917), U32C(0x9cada421), \
  U32C(0x008d0d21), U32C(0x8c49882b), U32C(0xe801b627), U32C(0x73be3131), \
  U32C(0x13911be1), U32C(0x9f4d96eb), U32C(0xfb05c4e7), U32C(0x86c23ff1), \
  U32C(0x586340a2), U32C(0xe41fbbac), U32C(0x3fd7e9a8), U32C(0xcb9464b2), \
  U32C(0x6b674f62), U32C(0xf723ca6c), U32C(0x52dbf868), U32C(0xde987372), \
  U32C(0x4277dc72), U32C(0xce34577c), U32C(0x29ec8578), U32C(0xb5a90082), \
  U32C(0x557beb32), U32C(0xe138663c), U32C(0x3cf09438), U32C(0xc8ad0f42), \
  U32C(0x8b4668bf), U32C(0x1702e3c9), U32C(0x72bb11c5), U32C(0xfe778ccf), \
  U32C(0x9e4a777f), U32C(0x2a06f289), U32C(0x85bf2085), U32C(0x117b9b8f), \
  U32C(0x755b048f), U32C(0x01177f99), U32C(0x5ccfad95), U32C(0xe88c289f), \
  U32C(0x885f134f), U32C(0x141b8e59), U32C(0x6fd3bc55), U32C(0xfb90375f), \
  U32C(0x9124962b), U32C(0x1ce11135), U32C(0x78993f31), U32C(0x0455ba3b), \
  U32C(0xa428a4eb), U32C(0x2fe51ff5), U32C(0x8b9d4df1), U32C(0x1759c8fb), \
  U32C(0x7b3931fb), U32C(0x06f5ad05), U32C(0x62addb01), U32C(0xee6a560b), \
  U32C(0x8e3d40bb), U32C(0x19f9bbc5), U32C(0x75b1e9c1), U32C(0x016e64cb), \
  U32C(0xc407be48), U32C(0x4fc43952), U32C(0xab7c674e), U32C(0x3738e258), \
  U32C(0xd70bcd08), U32C(0x62c84812), U32C(0xbe80760e), U32C(0x4a3cf118), \
  U32C(0xae1c5a18), U32C(0x39d8d522), U32C(0x9591031e), U32C(0x214d7e28), \
  U32C(0xc12068d8), U32C(0x4cdce3e2), U32C(0xa89511de), U32C(0x34518ce8), \
  U32C(0x162c6f4b), U32C(0xa1e8ea55), U32C(0xfda11851), U32C(0x895d935b), \
  U32C(0x29307e0b), U32C(0xb4ecf915), U32C(0x10a52711), U32C(0x9c61a21b), \
  U32C(0x00410b1b), U32C(0x8bfd8625), U32C(0xe7b5b421), U32C(0x73722f2b), \
  U32C(0x134519db), U32C(0x9f0194e5), U32C(0xfab9c2e1), U32C(0x86763deb), \
  U32C(0x490f9768), U32C(0xd4cc1272), U32C(0x3084406e), U32C(0xbc40bb78), \
  U32C(0x5c13a628), U32C(0xe7d02132), U32C(0x43884f2e), U32C(0xcf44ca38), \
  U32C(0x33243338), U32C(0xbee0ae42), U32C(0x1a98dc3e), U32C(0xa6555748), \
  U32C(0x462841f8), U32C(0xd1e4bd02), U32C(0x2d9ceafe), U32C(0xb9596608), \
  U32C(0x4eedc4d4), U32C(0xdaaa3fde), U32C(0x36626dda), U32C(0xc21ee8e4), \
  U32C(0x61f1d394), U32C(0xedae4e9e), U32C(0x49667c9a), U32C(0xd522f7a4), \
  U32C(0x390260a4), U32C(0xc4bedbae), U32C(0x207709aa), U32C(0xac3384b4), \
  U32C(0x4c066f64), U32C(0xd7c2ea6e), U32C(0x337b186a), U32C(0xbf379374), \
  U32C(0x81d0ecf1), U32C(0x0d8d67fb), U32C(0x694595f7), U32C(0xf5021101), \
  U32C(0x94d4fbb1), U32C(0x209176bb), U32C(0x7c49a4b7), U32C(0x08061fc1), \
  U32C(0x6be588c1), U32C(0xf7a203cb), U32C(0x535a31c7), U32C(0xdf16acd1), \
  U32C(0x7ee99781), U32C(0x0aa6128b), U32C(0x665e4087), U32C(0xf21abb91), \
  U32C(0xf6b2743d), U32C(0x826eef47), U32C(0xde271d43), U32C(0x69e3984d), \
  U32C(0x09b682fd), U32C(0x9572fe07), U32C(0xf12b2c03), U32C(0x7ce7a70d), \
  U32C(0xe0c7100d), U32C(0x6c838b17), U32C(0xc83bb913), U32C(0x53f8341d), \
  U32C(0xf3cb1ecd), U32C(0x7f8799d7), U32C(0xdb3fc7d3), U32C(0x66fc42dd), \
  U32C(0x29959c5a), U32C(0xb5521764), U32C(0x110a4560), U32C(0x9cc6c06a), \
  U32C(0x3c99ab1a), U32C(0xc8562624), U32C(0x240e5420), U32C(0xafcacf2a), \
  U32C(0x13aa382a), U32C(0x9f66b334), U32C(0xfb1ee130), U32C(0x86db5c3a), \
  U32C(0x26ae46ea), U32C(0xb26ac1f4), U32C(0x0e22eff0), U32C(0x99df6afa), \
  U32C(0x2f73c9c6), U32C(0xbb3044d0), U32C(0x16e872cc), U32C(0xa2a4edd6), \
  U32C(0x4277d886), U32C(0xce345390), U32C(0x29ec818c), U32C(0xb5a8fc96), \
  U32C(0x19886596), U32C(0xa544e0a0), U32C(0x00fd0e9c), U32C(0x8cb989a6), \
  U32C(0x2c8c7456), U32C(0xb848ef60), U32C(0x14011d5c), U32C(0x9fbd9866), \
  U32C(0x6256f1e3), U32C(0xee136ced), U32C(0x49cb9ae9), U32C(0xd58815f3), \
  U32C(0x755b00a3), U32C(0x01177bad), U32C(0x5ccfa9a9), U32C(0xe88c24b3), \
  U32C(0x4c6b8db3), U32C(0xd82808bd), U32C(0x33e036b9), U32C(0xbf9cb1c3), \
  U32C(0x5f6f9c73), U32C(0xeb2c177d), U32C(0x46e44579), U32C(0xd2a0c083), \
  U32C(0xb47ba2e6), U32C(0x40381df0), U32C(0x9bf04bec), U32C(0x27acc6f6), \
  U32C(0xc77fb1a6), U32C(0x533c2cb0), U32C(0xaef45aac), U32C(0x3ab0d5b6), \
  U32C(0x9e903eb6), U32C(0x2a4cb9c0), U32C(0x8604e7bc), U32C(0x11c162c6), \
  U32C(0xb1944d76), U32C(0x3d50c880), U32C(0x9908f67c), U32C(0x24c57186), \
  U32C(0xe75ecb03), U32C(0x731b460d), U32C(0xced37409), U32C(0x5a8fef13), \
  U32C(0xfa62d9c3), U32C(0x861f54cd), U32C(0xe1d782c9), U32C(0x6d93fdd3), \
  U32C(0xd17366d3), U32C(0x5d2fe1dd), U32C(0xb8e80fd9), U32C(0x44a48ae3), \
  U32C(0xe4777593), U32C(0x7033f09d), U32C(0xcbec1e99), U32C(0x57a899a3), \
  U32C(0xed3cf86f), U32C(0x78f97379), U32C(0xd4b1a175), U32C(0x606e1c7f), \
  U32C(0x0041072f), U32C(0x8bfd8239), U32C(0xe7b5b035), U32C(0x73722b3f), \
  U32C(0xd751943f), U32C(0x630e0f49), U32C(0xbec63d45), U32C(0x4a82b84f), \
  U32C(0xea55a2ff), U32C(0x76121e09), U32C(0xd1ca4c05), U32C(0x5d86c70f), \
  U32C(0x2020208c), U32C(0xabdc9b96), U32C(0x0794c992), U32C(0x9351449c), \
  U32C(0x33242f4c), U32C(0xbee0aa56), U32C(0x1a98d852), U32C(0xa655535c), \
  U32C(0x0a34bc5c), U32C(0x95f13766), U32C(0xf1a96562), U32C(0x7d65e06c), \
  U32C(0x1d38cb1c), U32C(0xa8f54626), U32C(0x04ad7422), U32C(0x9069ef2c), \
  U32C(0x620aefdd), U32C(0xedc76ae7), U32C(0x497f98e3), U32C(0xd53c13ed), \
  U32C(0x750efe9d), U32C(0x00cb79a7), U32C(0x5c83a7a3), U32C(0xe84022ad), \
  U32C(0x4c1f8bad), U32C(0xd7dc06b7), U32C(0x339434b3), U32C(0xbf50afbd), \
  U32C(0x5f239a6d), U32C(0xeae01577), U32C(0x46984373), U32C(0xd254be7d), \
  U32C(0x94ee17fa), U32C(0x20aa9304), U32C(0x7c62c100), U32C(0x081f3c0a), \
  U32C(0xa7f226ba), U32C(0x33aea1c4), U32C(0x8f66cfc0), U32C(0x1b234aca), \
  U32C(0x7f02b3ca), U32C(0x0abf2ed4), U32C(0x66775cd0), U32C(0xf233d7da), \
  U32C(0x9206c28a), U32C(0x1dc33d94), U32C(0x797b6b90), U32C(0x0537e69a), \
  U32C(0x9acc4566), U32C(0x2688c070), U32C(0x8240ee6c), U32C(0x0dfd6976), \
  U32C(0xadd05426), U32C(0x398ccf30), U32C(0x9544fd2c), U32C(0x21017836), \
  U32C(0x84e0e136), U32C(0x109d5c40), U32C(0x6c558a3c), U32C(0xf8120546), \
  U32C(0x97e4eff6), U32C(0x23a16b00), U32C(0x7f5998fc), U32C(0x0b161406), \
  U32C(0xcdaf6d83), U32C(0x596be88d), U32C(0xb5241689), U32C(0x40e09193), \
  U32C(0xe0b37c43), U32C(0x6c6ff74d), U32C(0xc8282549), U32C(0x53e4a053), \
  U32C(0xb7c40953), U32C(0x4380845d), U32C(0x9f38b259), U32C(0x2af52d63), \
  U32C(0xcac81813), U32C(0x5684931d), U32C(0xb23cc119), U32C(0x3df93c23), \
  U32C(0x1fd41e86), U32C(0xab909990), U32C(0x0748c78c), U32C(0x93054296), \
  U32C(0x32d82d46), U32C(0xbe94a850), U32C(0x1a4cd64c), U32C(0xa6095156), \
  U32C(0x09e8ba56), U32C(0x95a53560), U32C(0xf15d635c), U32C(0x7d19de66), \
  U32C(0x1cecc916), U32C(0xa8a94420), U32C(0x0461721c), U32C(0x901ded26), \
  U32C(0x52b746a3), U32C(0xde73c1ad), U32C(0x3a2befa9), U32C(0xc5e86ab3), \
  U32C(0x65bb5563), U32C(0xf177d06d), U32C(0x4d2ffe69), U32C(0xd8ec7973), \
  U32C(0x3ccbe273), U32C(0xc8885d7d), U32C(0x24408b79), U32C(0xaffd0683), \
  U32C(0x4fcff133), U32C(0xdb8c6c3d), U32C(0x37449a39), U32C(0xc3011543), \
  U32C(0x5895740f), U32C(0xe451ef19), U32C(0x400a1d15), U32C(0xcbc6981f), \
  U32C(0x6b9982cf), U32C(0xf755fdd9), U32C(0x530e2bd5), U32C(0xdecaa6df), \
  U32C(0x42aa0fdf), U32C(0xce668ae9), U32C(0x2a1eb8e5), U32C(0xb5db33ef), \
  U32C(0x55ae1e9f), U32C(0xe16a99a9), U32C(0x3d22c7a5), U32C(0xc8df42af), \
  U32C(0x8b789c2c), U32C(0x17351736), U32C(0x72ed4532), U32C(0xfea9c03c), \
  U32C(0x9e7caaec), U32C(0x2a3925f6), U32C(0x85f153f2), U32C(0x11adcefc), \
  U32C(0x758d37fc), U32C(0x0149b306), U32C(0x5d01e102), U32C(0xe8be5c0c), \
  U32C(0x889146bc), U32C(0x144dc1c6), U32C(0x7005efc2), U32C(0xfbc26acc), \
  U32C(0xd7b30c53), U32C(0x636f875d), U32C(0xbf27b559), U32C(0x4ae43063), \
  U32C(0xeab71b13), U32C(0x7673961d), U32C(0xd22bc419), U32C(0x5de83f23), \
  U32C(0xc1c7a823), U32C(0x4d84232d), U32C(0xa93c5129), U32C(0x34f8cc33), \
  U32C(0xd4cbb6e3), U32C(0x608831ed), U32C(0xbc405fe9), U32C(0x47fcdaf3), \
  U32C(0x0a963470), U32C(0x9652af7a), U32C(0xf20add76), U32C(0x7dc75880), \
  U32C(0x1d9a4330), U32C(0xa956be3a), U32C(0x050eec36), U32C(0x90cb6740), \
  U32C(0xf4aad040), U32C(0x80674b4a), U32C(0xdc1f7946), U32C(0x67dbf450), \
  U32C(0x07aedf00), U32C(0x936b5a0a), U32C(0xef238806), U32C(0x7ae00310), \
  U32C(0x107461dc), U32C(0x9c30dce6), U32C(0xf7e90ae2), U32C(0x83a585ec), \
  U32C(0x2378709c), U32C(0xaf34eba6), U32C(0x0aed19a2), U32C(0x96a994ac), \
  U32C(0xfa88fdac), U32C(0x864578b6), U32C(0xe1fda6b2), U32C(0x6dba21bc), \
  U32C(0x0d8d0c6c), U32C(0x99498776), U32C(0xf501b572), U32C(0x80be307c), \
  U32C(0x435789f9), U32C(0xcf140503), U32C(0x2acc32ff), U32C(0xb688ae09), \
  U32C(0x565b98b9), U32C(0xe21813c3), U32C(0x3dd041bf), U32C(0xc98cbcc9), \
  U32C(0x2d6c25c9), U32C(0xb928a0d3), U32C(0x14e0cecf), U32C(0xa09d49d9), \
  U32C(0x40703489), U32C(0xcc2caf93), U32C(0x27e4dd8f), U32C(0xb3a15899), \
  U32C(0x957c3afc), U32C(0x2138b606), U32C(0x7cf0e402), U32C(0x08ad5f0c), \
  U32C(0xa88049bc), U32C(0x343cc4c6), U32C(0x8ff4f2c2), U32C(0x1bb16dcc), \
  U32C(0x7f90d6cc), U32C(0x0b4d51d6), U32C(0x67057fd2), U32C(0xf2c1fadc), \
  U32C(0x9294e58c), U32C(0x1e516096), U32C(0x7a098e92), U32C(0x05c6099c), \
  U32C(0xc85f6319), U32C(0x541bde23), U32C(0xafd40c1f), U32C(0x3b908729), \
  U32C(0xdb6371d9), U32C(0x671fece3), U32C(0xc2d81adf), U32C(0x4e9495e9), \
  U32C(0xb273fee9), U32C(0x3e3079f3), U32C(0x99e8a7ef), U32C(0x25a522f9), \
  U32C(0xc5780da9), U32C(0x513488b3), U32C(0xacecb6af), U32C(0x38a931b9), \
  U32C(0xce3d9085), U32C(0x59fa0b8f), U32C(0xb5b2398b), U32C(0x416eb495), \
  U32C(0xe1419f45), U32C(0x6cfe1a4f), U32C(0xc8b6484b), U32C(0x5472c355), \
  U32C(0xb8522c55), U32C(0x440ea75f), U32C(0x9fc6d55b), U32C(0x2b835065), \
  U32C(0xcb563b15), U32C(0x5712b61f), U32C(0xb2cae41b), U32C(0x3e875f25), \
  U32C(0x0120b8a2), U32C(0x8cdd33ac), U32C(0xe89561a8), U32C(0x7451dcb2), \
  U32C(0x1424c762), U32C(0x9fe1426c), U32C(0xfb997068), U32C(0x8755eb72), \
  U32C(0xeb355472), U32C(0x76f1cf7c), U32C(0xd2a9fd78), U32C(0x5e667882), \
  U32C(0xfe396332), U32C(0x89f5de3c), U32C(0xe5ae0c38), U32C(0x716a8742), \
  U32C(0x430b87f3), U32C(0xcec802fd), U32C(0x2a8030f9), U32C(0xb63cac03), \
  U32C(0x560f96b3), U32C(0xe1cc11bd), U32C(0x3d843fb9), U32C(0xc940bac3), \
  U32C(0x2d2023c3), U32C(0xb8dc9ecd), U32C(0x1494ccc9), U32C(0xa05147d3), \
  U32C(0x40243283), U32C(0xcbe0ad8d), U32C(0x2798db89), U32C(0xb3555693), \
  U32C(0x75eeb010), U32C(0x01ab2b1a), U32C(0x5d635916), U32C(0xe91fd420), \
  U32C(0x88f2bed0), U32C(0x14af39da), U32C(0x706767d6), U32C(0xfc23e2e0), \
  U32C(0x60034be0), U32C(0xebbfc6ea), U32C(0x4777f4e6), U32C(0xd3346ff0), \
  U32C(0x73075aa0), U32C(0xfec3d5aa), U32C(0x5a7c03a6), U32C(0xe6387eb0), \
  U32C(0x7bccdd7c), U32C(0x07895886), U32C(0x63418682), U32C(0xeefe018c), \
  U32C(0x8ed0ec3c), U32C(0x1a8d6746), U32C(0x76459542), U32C(0x0202104c), \
  U32C(0x65e1794c), U32C(0xf19df456), U32C(0x4d562252), U32C(0xd9129d5c), \
  U32C(0x78e5880c), U32C(0x04a20316), U32C(0x605a3112), U32C(0xec16ac1c), \
  U32C(0xaeb00599), U32C(0x3a6c80a3), U32C(0x9624ae9f), U32C(0x21e129a9), \
  U32C(0xc1b41459), U32C(0x4d708f63), U32C(0xa928bd5f), U32C(0x34e53869), \
  U32C(0x98c4a169), U32C(0x24811c73), U32C(0x80394a6f), U32C(0x0bf5c579), \
  U32C(0xabc8b029), U32C(0x37852b33), U32C(0x933d592f), U32C(0x1ef9d439), \
  U32C(0x00d4b69c), U32C(0x8c9131a6), U32C(0xe8495fa2), U32C(0x7405daac), \
  U32C(0x13d8c55c), U32C(0x9f954066), U32C(0xfb4d6e62), U32C(0x8709e96c), \
  U32C(0xeae9526c), U32C(0x76a5cd76), U32C(0xd25dfb72), U32C(0x5e1a767c), \
  U32C(0xfded612c), U32C(0x89a9dc36), U32C(0xe5620a32), U32C(0x711e853c), \
  U32C(0x33b7deb9), U32C(0xbf7459c3), U32C(0x1b2c87bf), U32C(0xa6e902c9), \
  U32C(0x46bbed79), U32C(0xd2786883), U32C(0x2e30967f), U32C(0xb9ed1189), \
  U32C(0x1dcc7a89), U32C(0xa988f593), U32C(0x0541238f), U32C(0x90fd9e99), \
  U32C(0x30d08949), U32C(0xbc8d0453), U32C(0x1845324f), U32C(0xa401ad59), \
  U32C(0x39960c25), U32C(0xc552872f), U32C(0x210ab52b), U32C(0xacc73035), \
  U32C(0x4c9a1ae5), U32C(0xd85695ef), U32C(0x340ec3eb), U32C(0xbfcb3ef5), \
  U32C(0x23aaa7f5), U32C(0xaf6722ff), U32C(0x0b1f50fb), U32C(0x96dbcc05), \
  U32C(0x36aeb6b5), U32C(0xc26b31bf), U32C(0x1e235fbb), U32C(0xa9dfdac5), \
  U32C(0x6c793442), U32C(0xf835af4c), U32C(0x53eddd48), U32C(0xdfaa5852), \
  U32C(0x7f7d4302), U32C(0x0b39be0c), U32C(0x66f1ec08), U32C(0xf2ae6712), \
  U32C(0x568dd012), U32C(0xe24a4b1c), U32C(0x3e027918), U32C(0xc9bef422), \
  U32C(0x6991ded2), U32C(0xf54e59dc), U32C(0x510687d8), U32C(0xdcc302e2), \
  U32C(0x00000000), U32C(0xffd624d0), U32C(0x89581695), U32C(0x892e3b65), \
  U32C(0xf0bbfbd3), U32C(0xf09220a3), U32C(0x7a141268), U32C(0x79ea3738), \
  U32C(0x83404b20), U32C(0x83166ff0), U32C(0x0c9861b5), U32C(0x0c6e8685), \
  U32C(0x73fc46f3), U32C(0x73d26bc3), U32C(0xfd545d88), U32C(0xfd2a8258), \
  U32C(0x9e66abea), U32C(0x9e3cd0ba), U32C(0x27bec27f), U32C(0x2794e74f), \
  U32C(0x8f22a7bd), U32C(0x8ef8cc8d), U32C(0x187abe52), U32C(0x1850e322), \
  U32C(0x21a6f70a), U32C(0x217d1bda), U32C(0xaaff0d9f), U32C(0xaad5326f), \
  U32C(0x1262f2dd), U32C(0x123917ad), U32C(0x9bbb0972), U32C(0x9b912e42), \
  U32C(0x798ce417), U32C(0x796308e7), U32C(0x02e4faac), U32C(0x02bb1f7c), \
  U32C(0x6a48dfea), U32C(0x6a1f04ba), U32C(0xf3a0f67f), U32C(0xf3771b4f), \
  U32C(0xfccd2f37), U32C(0xfca35407), U32C(0x862545cc), U32C(0x85fb6a9c), \
  U32C(0xed892b0a), U32C(0xed5f4fda), U32C(0x76e1419f), U32C(0x76b7666f), \
  U32C(0x17f39001), U32C(0x17c9b4d1), U32C(0xa14ba696), U32C(0xa121cb66), \
  U32C(0x08af8bd4), U32C(0x0885b0a4), U32C(0x9207a269), U32C(0x91ddc739), \
  U32C(0x9b33db21), U32C(0x9b09fff1), U32C(0x248bf1b6), U32C(0x24621686), \
  U32C(0x8befd6f4), U32C(0x8bc5fbc4), U32C(0x1547ed89), U32C(0x151e1259), \
  U32C(0x8d1adfb3), U32C(0x8cf10483), U32C(0x1672f648), U32C(0x16491b18), \
  U32C(0x7dd6db86), U32C(0x7dad0056), U32C(0x072ef21b), U32C(0x070516eb), \
  U32C(0x105b2ad3), U32C(0x10314fa3), U32C(0x99b34168), U32C(0x99896638), \
  U32C(0x011726a6), U32C(0x00ed4b76), U32C(0x8a6f3d3b), U32C(0x8a45620b), \
  U32C(0x2b818b9d), U32C(0x2b57b06d), U32C(0xb4d9a232), U32C(0xb4afc702), \
  U32C(0x1c3d8770), U32C(0x1c13ac40), U32C(0xa5959e05), U32C(0xa56bc2d5), \
  U32C(0xaec1d6bd), U32C(0xae97fb8d), U32C(0x3819ed52), U32C(0x37f01222), \
  U32C(0x9f7dd290), U32C(0x9f53f760), U32C(0x28d5e925), U32C(0x28ac0df5), \
  U32C(0x06a7c3ca), U32C(0x067de89a), U32C(0x8fffda5f), U32C(0x8fd5ff2f), \
  U32C(0xf763bf9d), U32C(0xf739e46d), U32C(0x80bbd632), U32C(0x8091fb02), \
  U32C(0x89e80eea), U32C(0x89be33ba), U32C(0x1340257f), U32C(0x13164a4f), \
  U32C(0x7aa40abd), U32C(0x7a7a2f8d), U32C(0x03fc2152), U32C(0x03d24622), \
  U32C(0xa50e6fb4), U32C(0xa4e49484), U32C(0x2e668649), U32C(0x2e3cab19), \
  U32C(0x95ca6b87), U32C(0x95a09057), U32C(0x1f22821c), U32C(0x1ef8a6ec), \
  U32C(0x284ebad4), U32C(0x2824dfa4), U32C(0xb1a6d169), U32C(0xb17cf639), \
  U32C(0x190ab6a7), U32C(0x18e0db77), U32C(0xa262cd3c), U32C(0xa238f20c), \
  U32C(0xb8c6bf9f), U32C(0xb89ce46f), U32C(0x421ed634), U32C(0x41f4fb04), \
  U32C(0xa982bb72), U32C(0xa958e042), U32C(0x32dad207), U32C(0x32b0f6d7), \
  U32C(0x3c070abf), U32C(0x3bdd2f8f), U32C(0xc55f2154), U32C(0xc5354624), \
  U32C(0x2cc30692), U32C(0x2c992b62), U32C(0xb61b1d27), U32C(0xb5f141f7), \
  U32C(0x572d6b89), U32C(0x57039059), U32C(0xe085821e), U32C(0xe05ba6ee), \
  U32C(0x47e9675c), U32C(0x47bf8c2c), U32C(0xd1417df1), U32C(0xd117a2c1), \
  U32C(0xda6db6a9), U32C(0xda43db79), U32C(0x63c5cd3e), U32C(0x639bf20e), \
  U32C(0xcb29b27c), U32C(0xcaffd74c), U32C(0x5481c911), U32C(0x5457ede1), \
  U32C(0x3253a3b6), U32C(0x3229c886), U32C(0xbbabba4b), U32C(0xbb81df1b), \
  U32C(0x230f9f89), U32C(0x22e5c459), U32C(0xac67b61e), U32C(0xac3ddaee), \
  U32C(0xb593eed6), U32C(0xb56a13a6), U32C(0x3eec056b), U32C(0x3ec22a3b), \
  U32C(0xa64feaa9), U32C(0xa6260f79), U32C(0x2fa8013e), U32C(0x2f7e260e), \
  U32C(0xd0ba4fa0), U32C(0xd0907470), U32C(0x5a126635), U32C(0x59e88b05), \
  U32C(0xc1764b73), U32C(0xc14c7043), U32C(0x4ace6208), U32C(0x4aa486d8), \
  U32C(0x53fa9ac0), U32C(0x53d0bf90), U32C(0xdd52b155), U32C(0xdd28d625), \
  U32C(0x44b69693), U32C(0x448cbb63), U32C(0xce0ead28), U32C(0xcde4d1f8), \
  U32C(0x45e19f52), U32C(0x45b7c422), U32C(0xcf39b5e7), U32C(0xcf0fdab7), \
  U32C(0x369d9b25), U32C(0x3673bff5), U32C(0xbff5b1ba), U32C(0xbfcbd68a), \
  U32C(0xc921ea72), U32C(0xc8f80f42), U32C(0x527a0107), U32C(0x525025d7), \
  U32C(0xb9dde645), U32C(0xb9b40b15), U32C(0x4335fcda), U32C(0x430c21aa), \
  U32C(0xe4484b3c), U32C(0xe41e700c), U32C(0x6da061d1), U32C(0x6d7686a1), \
  U32C(0xd504470f), U32C(0xd4da6bdf), U32C(0x5e5c5da4), U32C(0x5e328274), \
  U32C(0x6788965c), U32C(0x675ebb2c), U32C(0xf0e0acf1), U32C(0xf0b6d1c1), \
  U32C(0x5844922f), U32C(0x581ab6ff), U32C(0xe19ca8c4), U32C(0xe172cd94), \
  U32C(0xbf6e8369), U32C(0xbf44a839), U32C(0x48c699fe), U32C(0x489cbece), \
  U32C(0xb02a7f3c), U32C(0xb000a40c), U32C(0x398295d1), U32C(0x3958baa1), \
  U32C(0x42aece89), U32C(0x4284f359), U32C(0xcc06e51e), U32C(0xcbdd09ee), \
  U32C(0x336aca5c), U32C(0x3340ef2c), U32C(0xbcc2e0f1), U32C(0xbc9905c1), \
  U32C(0x5dd52f53), U32C(0x5dab5423), U32C(0xe72d45e8), U32C(0xe7036ab8), \
  U32C(0x4e912b26), U32C(0x4e674ff6), U32C(0xd7e941bb), U32C(0xd7bf668b), \
  U32C(0xe1157a73), U32C(0xe0eb9f43), U32C(0x6a6d9108), U32C(0x6a43b5d8), \
  U32C(0xd1d17646), U32C(0xd1a79b16), U32C(0x5b298cdb), U32C(0x5affb1ab), \
  U32C(0x3bbad552), U32C(0x3b90fa22), U32C(0xc512ebe7), U32C(0xc4e910b7), \
  U32C(0x2c76d125), U32C(0x2c4cf5f5), U32C(0xb5cee7ba), U32C(0xb5a50c8a), \
  U32C(0xbefb2072), U32C(0xbed14542), U32C(0x48533707), U32C(0x48295bd7), \
  U32C(0xafb71c45), U32C(0xaf8d4115), U32C(0x390f32da), U32C(0x38e557aa), \
  U32C(0xda21813c), U32C(0xd9f7a60c), U32C(0x637997d1), U32C(0x634fbca1), \
  U32C(0xcadd7d0f), U32C(0xcab3a1df), U32C(0x543593a4), U32C(0x540bb874), \
  U32C(0x5d61cc5c), U32C(0x5d37f12c), U32C(0xe6b9e2f1), U32C(0xe69007c1), \
  U32C(0x4e1dc82f), U32C(0x4df3ecff), U32C(0xd775dec4), U32C(0xd74c0394), \
  U32C(0xb547b969), U32C(0xb51dde39), U32C(0x3e9fcffe), U32C(0x3e75f4ce), \
  U32C(0xa603b53c), U32C(0xa5d9da0c), U32C(0x2f5bcbd1), U32C(0x2f31f0a1), \
  U32C(0x38880489), U32C(0x385e2959), U32C(0xc1e01b1e), U32C(0xc1b63fee), \
  U32C(0x2944005c), U32C(0x291a252c), U32C(0xb29c16f1), U32C(0xb2723bc1), \
  U32C(0x53ae6553), U32C(0x53848a23), U32C(0xdd067be8), U32C(0xdcdca0b8), \
  U32C(0x446a6126), U32C(0x444085f6), U32C(0xcdc277bb), U32C(0xcd989c8b), \
  U32C(0xd6eeb073), U32C(0xd6c4d543), U32C(0x6046c708), U32C(0x601cebd8), \
  U32C(0xc7aaac46), U32C(0xc780d116), U32C(0x5102c2db), U32C(0x50d8e7ab), \
  U32C(0xc8d5b505), U32C(0xc8abd9d5), U32C(0x522dcb9a), U32C(0x5203f06a), \
  U32C(0xb991b0d8), U32C(0xb967d5a8), U32C(0x42e9c76d), U32C(0x42bfec3d), \
  U32C(0x4c160025), U32C(0x4bec24f5), U32C(0xd56e16ba), U32C(0xd5443b8a), \
  U32C(0x3cd1fbf8), U32C(0x3ca820c8), U32C(0xc62a128d), U32C(0xc600375d), \
  U32C(0x673c60ef), U32C(0x671285bf), U32C(0xf0947784), U32C(0xf06a9c54), \
  U32C(0x57f85cc2), U32C(0x57ce8192), U32C(0xe1507357), U32C(0xe1269827), \
  U32C(0xea7cac0f), U32C(0xea52d0df), U32C(0x73d4c2a4), U32C(0x73aae774), \
  U32C(0xdb38a7e2), U32C(0xdb0eccb2), U32C(0x6490be77), U32C(0x6466e347), \
  U32C(0x4262991c), U32C(0x4238bdec), U32C(0xcbbaafb1), U32C(0xcb90d481), \
  U32C(0x331e94ef), U32C(0x32f4b9bf), U32C(0xbc76ab84), U32C(0xbc4cd054), \
  U32C(0xc5a2e43c), U32C(0xc579090c), U32C(0x4efafad1), U32C(0x4ed11fa1), \
  U32C(0xb65ee00f), U32C(0xb63504df), U32C(0x3fb6f6a4), U32C(0x3f8d1b74), \
  U32C(0xe0c94506), U32C(0xe09f69d6), U32C(0x6a215b9b), U32C(0x69f7806b), \
  U32C(0xd18540d9), U32C(0xd15b65a9), U32C(0x5add576e), U32C(0x5ab37c3e), \
  U32C(0x64099026), U32C(0x63dfb4f6), U32C(0xed61a6bb), U32C(0xed37cb8b), \
  U32C(0x54c58bf9), U32C(0x549bb0c9), U32C(0xde1da28e), U32C(0xddf3c75e), \
  U32C(0xf48194f1), U32C(0xf457b9c1), U32C(0x7dd9ab86), U32C(0x7dafd056), \
  U32C(0xe53d90c4), U32C(0xe513b594), U32C(0x6e95a759), U32C(0x6e6bcc29), \
  U32C(0x77c1e011), U32C(0x779804e1), U32C(0x0119f6a6), U32C(0x00f01b76), \
  U32C(0x687ddbe4), U32C(0x685400b4), U32C(0xf1d5f279), U32C(0xf1ac1749), \
  U32C(0x92e840db), U32C(0x92be65ab), U32C(0x1c405770), U32C(0x1c167c40), \
  U32C(0x83a43cae), U32C(0x837a617e), U32C(0x0cfc5343), U32C(0x0cd27813), \
  U32C(0x16288bfb), U32C(0x15feb0cb), U32C(0x9f80a290), U32C(0x9f56c760), \
  U32C(0x06e487ce), U32C(0x06baac9e), U32C(0x903c9e63), U32C(0x9012c333), \
  U32C(0x6e0e7908), U32C(0x6de49dd8), U32C(0xf7668f9d), U32C(0xf73cb46d), \
  U32C(0x5eca74db), U32C(0x5ea099ab), U32C(0xe8228b70), U32C(0xe7f8b040), \
  U32C(0xf14ec428), U32C(0xf124e8f8), U32C(0x7aa6dabd), U32C(0x7a7cff8d), \
  U32C(0xe20abffb), U32C(0xe1e0e4cb), U32C(0x6b62d690), U32C(0x6b38fb60), \
  U32C(0x0c7524f2), U32C(0x0c4b49c2), U32C(0x95cd3b87), U32C(0x95a36057), \
  U32C(0xfd3120c5), U32C(0xfd074595), U32C(0x8689375a), U32C(0x865f5c2a), \
  U32C(0x8fb57012), U32C(0x8f8b94e2), U32C(0x190d86a7), U32C(0x18e3ab77), \
  U32C(0x80716be5), U32C(0x804790b5), U32C(0x09c9827a), U32C(0x099fa74a), \
  U32C(0x819c74a4), U32C(0x81729974), U32C(0x0af48b39), U32C(0x0acab009), \
  U32C(0x72587077), U32C(0x722e9547), U32C(0xfbb0870c), U32C(0xfb86abdc), \
  U32C(0x04dcbfc4), U32C(0x04b2e494), U32C(0x8e34d659), U32C(0x8e0afb29), \
  U32C(0xf598bb97), U32C(0xf56ee067), U32C(0x7ef0d22c), U32C(0x7ec6f6fc), \
  U32C(0x2003208e), U32C(0x1fd9455e), U32C(0xa95b3723), U32C(0xa9315bf3), \
  U32C(0x10bf1c61), U32C(0x10954131), U32C(0x9a1732f6), U32C(0x99ed57c6), \
  U32C(0xa3436bae), U32C(0xa319907e), U32C(0x2c9b8243), U32C(0x2c71a713), \
  U32C(0x93ff6781), U32C(0x93d58c51), U32C(0x1d577e16), U32C(0x1d2da2e6), \
  U32C(0xfb2958bb), U32C(0xfaff7d8b), U32C(0x84816f50), U32C(0x84579420), \
  U32C(0xebe5548e), U32C(0xebbb795e), U32C(0x753d6b23), U32C(0x75138ff3), \
  U32C(0x7e69a3db), U32C(0x7e3fc8ab), U32C(0x07c1ba70), U32C(0x0797df40), \
  U32C(0x6f259fae), U32C(0x6efbc47e), U32C(0xf87db643), U32C(0xf853db13), \
  U32C(0x999004a5), U32C(0x99662975), U32C(0x22e81b3a), U32C(0x22be400a), \
  U32C(0x8a4c0078), U32C(0x8a222548), U32C(0x13a4170d), U32C(0x137a3bdd), \
  U32C(0x1cd04fc5), U32C(0x1ca67495), U32C(0xa628665a), U32C(0xa5fe8b2a), \
  U32C(0x0d8c4b98), U32C(0x0d627068), U32C(0x96e4622d), U32C(0x96ba86fd), \
  U32C(0x923ddd55), U32C(0x92140225), U32C(0x1b95f3ea), U32C(0x1b6c18ba), \
  U32C(0x82f9d928), U32C(0x82cffdf8), U32C(0x0c51efbd), U32C(0x0c28148d), \
  U32C(0x157e2875), U32C(0x15544d45), U32C(0x9ed63f0a), U32C(0x9eac63da), \
  U32C(0x063a2448), U32C(0x06104918), U32C(0x8f923add), U32C(0x8f685fad), \
  U32C(0x30a4893f), U32C(0x307aae0f), U32C(0xb9fc9fd4), U32C(0xb9d2c4a4), \
  U32C(0x21608512), U32C(0x2136a9e2), U32C(0xaab89ba7), U32C(0xaa8ec077), \
  U32C(0xb3e4d45f), U32C(0xb3baf92f), U32C(0x3d3ceaf4), U32C(0x3d130fc4), \
  U32C(0xa4a0d032), U32C(0xa476f502), U32C(0x2df8e6c7), U32C(0x2dcf0b97), \
  U32C(0x0bcac16c), U32C(0x0ba0e63c), U32C(0x9522d801), U32C(0x94f8fcd1), \
  U32C(0xfc86bd3f), U32C(0xfc5ce20f), U32C(0x85ded3d4), U32C(0x85b4f8a4), \
  U32C(0x8f0b0c8c), U32C(0x8ee1315c), U32C(0x18632321), U32C(0x183947f1), \
  U32C(0x7fc7085f), U32C(0x7f9d2d2f), U32C(0x091f1ef4), U32C(0x08f543c4), \
  U32C(0xaa316d56), U32C(0xaa079226), U32C(0x338983eb), U32C(0x335fa8bb), \
  U32C(0x9aed6929), U32C(0x9ac38df9), U32C(0x24457fbe), U32C(0x241ba48e), \
  U32C(0x2d71b876), U32C(0x2d47dd46), U32C(0xb6c9cf0b), U32C(0xb69ff3db), \
  U32C(0x1e2db449), U32C(0x1e03d919), U32C(0xa785cade), U32C(0xa75befae), \
  U32C(0x1f58bd08), U32C(0x1f2ee1d8), U32C(0xa8b0d39d), U32C(0xa886f86d), \
  U32C(0x1014b8db), U32C(0x0feaddab), U32C(0x996ccf70), U32C(0x9942f440), \
  U32C(0xa2990828), U32C(0xa26f2cf8), U32C(0x2bf11ebd), U32C(0x2bc7438d), \
  U32C(0x935503fb), U32C(0x932b28cb), U32C(0x1cad1a90), U32C(0x1c833f60), \
  U32C(0xbdbf68f2), U32C(0xbd958dc2), U32C(0x47177f87), U32C(0x46eda457), \
  U32C(0xae7b64c5), U32C(0xae518995), U32C(0x37d37b5a), U32C(0x37a9a02a), \
  U32C(0x40ffb412), U32C(0x40d5d8e2), U32C(0xca57caa7), U32C(0xca2def77), \
  U32C(0x31bbafe5), U32C(0x3191d4b5), U32C(0xbb13c67a), U32C(0xbae9eb4a), \
  U32C(0x98e5a11f), U32C(0x98bbc5ef), U32C(0x223db7b4), U32C(0x2213dc84), \
  U32C(0x89a19cf2), U32C(0x8977c1c2), U32C(0x12f9b387), U32C(0x12cfd857), \
  U32C(0x1c25ec3f), U32C(0x1bfc110f), U32C(0xa57e02d4), U32C(0xa55427a4), \
  U32C(0x0ce1e812), U32C(0x0cb80ce2), U32C(0x9639fea7), U32C(0x96102377), \
  U32C(0x374c4d09), U32C(0x372271d9), U32C(0xc0a4639e), U32C(0xc07a886e), \
  U32C(0x280848dc), U32C(0x27de6dac), U32C(0xb1605f71), U32C(0xb1368441), \
  U32C(0xba8c9829), U32C(0xba62bcf9), U32C(0x43e4aebe), U32C(0x43bad38e), \
  U32C(0xab4893fc), U32C(0xab1eb8cc), U32C(0x34a0aa91), U32C(0x3476cf61), \
  U32C(0x4b049cf4), U32C(0x4adac1c4), U32C(0xd45cb389), U32C(0xd432d859), \
  U32C(0x3bc098c7), U32C(0x3b96bd97), U32C(0xc518af5c), U32C(0xc4eed42c), \
  U32C(0xce44e814), U32C(0xce1b0ce4), U32C(0x579cfea9), U32C(0x57732379), \
  U32C(0xbf00e3e7), U32C(0xbed708b7), U32C(0x4858fa7c), U32C(0x482f1f4c), \
  U32C(0xe96b48de), U32C(0xe9416dae), U32C(0x72c35f73), U32C(0x72998443), \
  U32C(0xda2744b1), U32C(0xd9fd6981), U32C(0x637f5b46), U32C(0x63558016), \
  U32C(0x6cab93fe), U32C(0x6c81b8ce), U32C(0xf603aa93), U32C(0xf5d9cf63), \
  U32C(0x5d678fd1), U32C(0x5d3db4a1), U32C(0xe6bfa666), U32C(0xe695cb36), \
  U32C(0xc491810b), U32C(0xc467a5db), U32C(0x4de997a0), U32C(0x4dbfbc70), \
  U32C(0xb54d7cde), U32C(0xb523a1ae), U32C(0x3ea59373), U32C(0x3e7bb843), \
  U32C(0x47d1cc2b), U32C(0x47a7f0fb), U32C(0xd129e2c0), U32C(0xd1000790), \
  U32C(0x388dc7fe), U32C(0x3863ecce), U32C(0xc1e5de93), U32C(0xc1bc0363), \
  U32C(0x62f82cf5), U32C(0x62ce51c5), U32C(0xec50438a), U32C(0xec26685a), \
  U32C(0x53b428c8), U32C(0x538a4d98), U32C(0xdd0c3f5d), U32C(0xdce2642d), \
  U32C(0xe6387815), U32C(0xe60e9ce5), U32C(0x6f908eaa), U32C(0x6f66b37a), \
  U32C(0xd6f473e8), U32C(0xd6ca98b8), U32C(0x604c8a7d), U32C(0x6022af4d), \
  U32C(0xd81f7ca7), U32C(0xd7f5a177), U32C(0x6177933c), U32C(0x614db80c), \
  U32C(0xc8db787a), U32C(0xc8b19d4a), U32C(0x52338f0f), U32C(0x5209b3df), \
  U32C(0x5b5fc7c7), U32C(0x5b35ec97), U32C(0xe4b7de5c), U32C(0xe48e032c), \
  U32C(0x4c1bc39a), U32C(0x4bf1e86a), U32C(0xd573da2f), U32C(0xd549feff), \
  U32C(0x76862891), U32C(0x765c4d61), U32C(0xffde3f26), U32C(0xffb463f6), \
  U32C(0x67422464), U32C(0x67184934), U32C(0xf09a3af9), U32C(0xf0705fc9), \
  U32C(0xf9c673b1), U32C(0xf99c9881), U32C(0x831e8a46), U32C(0x82f4af16), \
  U32C(0xea826f84), U32C(0xea589454), U32C(0x73da8619), U32C(0x73b0aae9), \
  U32C(0x51ac60be), U32C(0x5182858e), U32C(0xdb047753), U32C(0xdada9c23), \
  U32C(0x42685c91), U32C(0x423e8161), U32C(0xcbc07326), U32C(0xcb9697f6), \
  U32C(0xd4ecabde), U32C(0xd4c2d0ae), U32C(0x5e44c273), U32C(0x5e1ae743), \
  U32C(0xc5a8a7b1), U32C(0xc57ecc81), U32C(0x4f00be46), U32C(0x4ed6e316), \
  U32C(0xf0130ca8), U32C(0xefe93178), U32C(0x796b233d), U32C(0x7941480d), \
  U32C(0xe0cf087b), U32C(0xe0a52d4b), U32C(0x6a271f10), U32C(0x69fd43e0), \
  U32C(0x735357c8), U32C(0x73297c98), U32C(0xfcab6e5d), U32C(0xfc81932d), \
  U32C(0x640f539b), U32C(0x63e5786b), U32C(0xed676a30), U32C(0xed3d8f00), \
  U32C(0xcdf8b2a7), U32C(0xcdced777), U32C(0x5750c93c), U32C(0x5726ee0c), \
  U32C(0xbeb4ae7a), U32C(0xbe8ad34a), U32C(0x480cc50f), U32C(0x47e2e9df), \
  U32C(0x5138fdc7), U32C(0x510f2297), U32C(0xda91145c), U32C(0xda67392c), \
  U32C(0x41f4f99a), U32C(0x41cb1e6a), U32C(0xcb4d102f), U32C(0xcb2334ff), \
  U32C(0x6c5f5e91), U32C(0x6c358361), U32C(0xf5b77526), U32C(0xf58d99f6), \
  U32C(0x5d1b5a64), U32C(0x5cf17f34), U32C(0xe67370f9), U32C(0xe64995c9), \
  U32C(0xef9fa9b1), U32C(0xef75ce81), U32C(0x78f7c046), U32C(0x78cde516), \
  U32C(0xe05ba584), U32C(0xe031ca54), U32C(0x69b3bc19), U32C(0x6989e0e9), \
  U32C(0x478596be), U32C(0x475bbb8e), U32C(0xd0ddad53), U32C(0xd0b3d223), \
  U32C(0x38419291), U32C(0x3817b761), U32C(0xc199a926), U32C(0xc16fcdf6), \
  U32C(0xcac5e1de), U32C(0xca9c06ae), U32C(0x541df873), U32C(0x53f41d43), \
  U32C(0xbb81ddb1), U32C(0xbb580281), U32C(0x44d9f446), U32C(0x44b01916), \
  U32C(0xe5ec42a8), U32C(0xe5c26778), U32C(0x6f44593d), U32C(0x6f1a7e0d), \
  U32C(0xd6a83e7b), U32C(0xd67e634b), U32C(0x60005510), U32C(0x5fd679e0), \
  U32C(0x692c8dc8), U32C(0x6902b298), U32C(0xf284a45d), U32C(0xf25ac92d), \
  U32C(0x59e8899b), U32C(0x59beae6b), U32C(0xe340a030), U32C(0xe316c500), \
  U32C(0x5b13925a), U32C(0x5ae9b72a), U32C(0xe46ba8ef), U32C(0xe441cdbf), \
  U32C(0x4bcf8e2d), U32C(0x4ba5b2fd), U32C(0xd527a4c2), U32C(0xd4fdc992), \
  U32C(0xde53dd7a), U32C(0xde2a024a), U32C(0x67abf40f), U32C(0x678218df), \
  U32C(0xcf0fd94d), U32C(0xcee5fe1d), U32C(0x5867efe2), U32C(0x583e14b2), \
  U32C(0xf97a3e44), U32C(0xf9506314), U32C(0x82d254d9), U32C(0x82a879a9), \
  U32C(0xea363a17), U32C(0xea0c5ee7), U32C(0x738e50ac), U32C(0x7364757c), \
  U32C(0x7cba8964), U32C(0x7c90ae34), U32C(0x06129ff9), U32C(0x05e8c4c9), \
  U32C(0x6d768537), U32C(0x6d4caa07), U32C(0xf6ce9bcc), U32C(0xf6a4c09c), \
  U32C(0xd4a07671), U32C(0xd4769b41), U32C(0x5df88d06), U32C(0x5dceb1d6), \
  U32C(0xc55c7244), U32C(0xc5329714), U32C(0x4eb488d9), U32C(0x4e8aada9), \
  U32C(0x57e0c191), U32C(0x57b6e661), U32C(0xe138d826), U32C(0xe10efcf6), \
  U32C(0x489cbd64), U32C(0x4872e234), U32C(0xd1f4d3f9), U32C(0xd1caf8c9), \
  U32C(0x7307225b), U32C(0x72dd472b), U32C(0xfc5f38f0), U32C(0xfc355dc0), \
  U32C(0x63c31e2e), U32C(0x639942fe), U32C(0xed1b34c3), U32C(0xecf15993), \
  U32C(0xf6476d7b), U32C(0xf61d924b), U32C(0x7f9f8410), U32C(0x7f75a8e0), \
  U32C(0xe703694e), U32C(0xe6d98e1e), U32C(0x705b7fe3), U32C(0x7031a4b3), \
  U32C(0x86bf7246), U32C(0x86959716), U32C(0x101788db), U32C(0x0fedadab), \
  U32C(0x777b6e19), U32C(0x775192e9), U32C(0x00d384ae), U32C(0x00a9a97e), \
  U32C(0x09ffbd66), U32C(0x09d5e236), U32C(0x9357d3fb), U32C(0x932df8cb), \
  U32C(0xfabbb939), U32C(0xfa91de09), U32C(0x8413cfce), U32C(0x83e9f49e), \
  U32C(0x25261e30), U32C(0x24fc4300), U32C(0xae7e34c5), U32C(0xae545995), \
  U32C(0x15e21a03), U32C(0x15b83ed3), U32C(0x9f3a3098), U32C(0x9f105568), \
  U32C(0xa8666950), U32C(0xa83c8e20), U32C(0x31be7fe5), U32C(0x3194a4b5), \
  U32C(0x99226523), U32C(0x98f889f3), U32C(0x227a7bb8), U32C(0x2250a088), \
  U32C(0x004c565d), U32C(0x00227b2d), U32C(0x89a46cf2), U32C(0x897a91c2), \
  U32C(0xf1085230), U32C(0xf0de7700), U32C(0x7a6068c5), U32C(0x7a368d95), \
  U32C(0x838ca17d), U32C(0x8362c64d), U32C(0x0ce4b812), U32C(0x0cbadce2), \
  U32C(0x74489d50), U32C(0x741ec220), U32C(0xfda0b3e5), U32C(0xfd76d8b5), \
  U32C(0x9eb30247), U32C(0x9e892717), U32C(0x280b18dc), U32C(0x27e13dac), \
  U32C(0x8f6efe1a), U32C(0x8f4522ea), U32C(0x18c714af), U32C(0x189d397f), \
  U32C(0x21f34d67), U32C(0x21c97237), U32C(0xab4b63fc), U32C(0xab2188cc), \
  U32C(0x12af493a), U32C(0x12856e0a), U32C(0x9c075fcf), U32C(0x9bdd849f), \
  U32C(0x13da51f9), U32C(0x13b076c9), U32C(0x9d32688e), U32C(0x9d088d5e), \
  U32C(0x04964dcc), U32C(0x046c729c), U32C(0x8dee6461), U32C(0x8dc48931), \
  U32C(0x971a9d19), U32C(0x96f0c1e9), U32C(0x2072b3ae), U32C(0x2048d87e), \
  U32C(0x87d698ec), U32C(0x87acbdbc), U32C(0x112eaf81), U32C(0x1104d451), \
  U32C(0xb240fde3), U32C(0xb21722b3), U32C(0x3b991478), U32C(0x3b6f3948), \
  U32C(0xa2fcf9b6), U32C(0xa2d31e86), U32C(0x2c55104b), U32C(0x2c2b351b), \
  U32C(0x35814903), U32C(0x35576dd3), U32C(0xbed95f98), U32C(0xbeaf8468), \
  U32C(0x263d44d6), U32C(0x261369a6), U32C(0xaf955b6b), U32C(0xaf6b803b), \
  U32C(0x8d673610), U32C(0x8d3d5ae0), U32C(0x16bf4ca5), U32C(0x16957175), \
  U32C(0x7e2331e3), U32C(0x7df956b3), U32C(0x077b4878), U32C(0x07516d48), \
  U32C(0x10a78130), U32C(0x107da600), U32C(0x99ff97c5), U32C(0x99d5bc95), \
  U32C(0x01637d03), U32C(0x0139a1d3), U32C(0x8abb9398), U32C(0x8a91b868), \
  U32C(0x2bcde1fa), U32C(0x2ba406ca), U32C(0xb525f88f), U32C(0xb4fc1d5f), \
  U32C(0x1c89ddcd), U32C(0x1c60029d), U32C(0xa5e1f462), U32C(0xa5b81932), \
  U32C(0xaf0e2d1a), U32C(0xaee451ea), U32C(0x386643af), U32C(0x383c687f), \
  U32C(0x9fca28ed), U32C(0x9fa04dbd), U32C(0x29223f82), U32C(0x28f86452), \
  U32C(0xa6461e22), U32C(0xa61c42f2), U32C(0x2f9e34b7), U32C(0x2f745987), \
  U32C(0x970219f5), U32C(0x96d83ec5), U32C(0x205a308a), U32C(0x2030555a), \
  U32C(0x29866942), U32C(0x295c8e12), U32C(0xb2de7fd7), U32C(0xb2b4a4a7), \
  U32C(0x1a426515), U32C(0x1a1889e5), U32C(0xa39a7baa), U32C(0xa370a07a), \
  U32C(0x44acca0c), U32C(0x4482eedc), U32C(0xce04e0a1), U32C(0xcddb0571), \
  U32C(0x3568c5df), U32C(0x353eeaaf), U32C(0xbec0dc74), U32C(0xbe970144), \
  U32C(0xc7ed152c), U32C(0xc7c339fc), U32C(0x51452bc1), U32C(0x511b5091), \
  U32C(0xb8a910ff), U32C(0xb87f35cf), U32C(0x42012794), U32C(0x41d74c64), \
  U32C(0x1fd30239), U32C(0x1fa92709), U32C(0xa92b18ce), U32C(0xa9013d9e), \
  U32C(0x108efe0c), U32C(0x106522dc), U32C(0x99e714a1), U32C(0x99bd3971), \
  U32C(0xa3134d59), U32C(0xa2e97229), U32C(0x2c6b63ee), U32C(0x2c4188be), \
  U32C(0x93cf492c), U32C(0x93a56dfc), U32C(0x1d275fc1), U32C(0x1cfd8491), \
  U32C(0xbe39ae23), U32C(0xbe0fd2f3), U32C(0x4791c4b8), U32C(0x4767e988), \
  U32C(0xaef5a9f6), U32C(0xaecbcec6), U32C(0x384dc08b), U32C(0x3823e55b), \
  U32C(0x4179f943), U32C(0x41501e13), U32C(0xcad20fd8), U32C(0xcaa834a8), \
  U32C(0x3235f516), U32C(0x320c19e6), U32C(0xbb8e0bab), U32C(0xbb64307b), \
  U32C(0x3360fdd5), U32C(0x333722a5), U32C(0xbcb9146a), U32C(0xbc8f393a), \
  U32C(0x241cf9a8), U32C(0x23f31e78), U32C(0xad75103d), U32C(0xad4b350d), \
  U32C(0xb6a148f5), U32C(0xb6776dc5), U32C(0x3ff95f8a), U32C(0x3fcf845a), \
  U32C(0xa75d44c8), U32C(0xa7336998), U32C(0x30b55b5d), U32C(0x308b802d), \
  U32C(0xd1c7a9bf), U32C(0xd19dce8f), U32C(0x5b1fc054), U32C(0x5af5e524), \
  U32C(0xc283a592), U32C(0xc259ca62), U32C(0x4bdbbc27), U32C(0x4bb1e0f7), \
  U32C(0x5507f4df), U32C(0x54de19af), U32C(0xde600b74), U32C(0xde363044), \
  U32C(0x45c3f0b2), U32C(0x459a1582), U32C(0xcf1c0747), U32C(0xcef22c17), \
  U32C(0xacede1ec), U32C(0xacc406bc), U32C(0x3645f881), U32C(0x361c1d51), \
  U32C(0x9da9ddbf), U32C(0x9d80028f), U32C(0x2701f454), U32C(0x26d81924), \
  U32C(0x302e2d0c), U32C(0x300451dc), U32C(0xb98643a1), U32C(0xb95c6871), \
  U32C(0x20ea28df), U32C(0x20c04daf), U32C(0xaa423f74), U32C(0xaa186444), \
  U32C(0x4b548dd6), U32C(0x4b2ab2a6), U32C(0xd4aca46b), U32C(0xd482c93b), \
  U32C(0x3c1089a9), U32C(0x3be6ae79), U32C(0xc568a03e), U32C(0xc53ec50e), \
  U32C(0xce94d8f6), U32C(0xce6afdc6), U32C(0x57ecef8b), U32C(0x57c3145b), \
  U32C(0xbf50d4c9), U32C(0xbf26f999), U32C(0x48a8eb5e), U32C(0x487f102e), \
  U32C(0x5f0cddc1), U32C(0x5ee30291), U32C(0xe864f456), U32C(0xe83b1926), \
  U32C(0x4fc8d994), U32C(0x4f9efe64), U32C(0xd920f029), U32C(0xd8f714f9), \
  U32C(0xe24d28e1), U32C(0xe2234db1), U32C(0x6ba53f76), U32C(0x6b7b6446), \
  U32C(0xd30924b4), U32C(0xd2df4984), U32C(0x5c613b49), U32C(0x5c376019), \
  U32C(0xfd7389ab), U32C(0xfd49ae7b), U32C(0x86cba040), U32C(0x86a1c510), \
  U32C(0xee2f857e), U32C(0xee05aa4e), U32C(0x77879c13), U32C(0x775dc0e3), \
  U32C(0x80b3d4cb), U32C(0x8089f99b), U32C(0x0a0beb60), U32C(0x09e21030), \
  U32C(0x716fd09e), U32C(0x7145f56e), U32C(0xfac7e733), U32C(0xfa9e0c03), \
  U32C(0xd899c1d8), U32C(0xd86fe6a8), U32C(0x61f1d86d), U32C(0x61c7fd3d), \
  U32C(0xc955bdab), U32C(0xc92be27b), U32C(0x52add440), U32C(0x5283f910), \
  U32C(0x5bda0cf8), U32C(0x5bb031c8), U32C(0xe532238d), U32C(0xe508485d), \
  U32C(0x4c9608cb), U32C(0x4c6c2d9b), U32C(0xd5ee1f60), U32C(0xd5c44430), \
  U32C(0x77006dc2), U32C(0x76d69292), U32C(0x00588457), U32C(0x002ea927), \
  U32C(0x67bc6995), U32C(0x67928e65), U32C(0xf114802a), U32C(0xf0eaa4fa), \
  U32C(0xfa40b8e2), U32C(0xfa16ddb2), U32C(0x8398cf77), U32C(0x836ef447), \
  U32C(0xeafcb4b5), U32C(0xead2d985), U32C(0x7454cb4a), U32C(0x742af01a), \
  U32C(0xec27bd74), U32C(0xebfde244), U32C(0x757fd409), U32C(0x7555f8d9), \
  U32C(0xdce3b947), U32C(0xdcb9de17), U32C(0x663bcfdc), U32C(0x6611f4ac), \
  U32C(0x6f680894), U32C(0x6f3e2d64), U32C(0xf8c01f29), U32C(0xf89643f9), \
  U32C(0x60240467), U32C(0x5ffa2937), U32C(0xe97c1afc), U32C(0xe9523fcc), \
  U32C(0x8a8e695e), U32C(0x8a648e2e), U32C(0x13e67ff3), U32C(0x13bca4c3), \
  U32C(0x7b4a6531), U32C(0x7b208a01), U32C(0x04a27bc6), U32C(0x0478a096), \
  U32C(0x0dceb47e), U32C(0x0da4d94e), U32C(0x9726cb13), U32C(0x96fcefe3), \
  U32C(0xfe8ab051), U32C(0xfe60d521), U32C(0x87e2c6e6), U32C(0x87b8ebb6), \
  U32C(0x65b4a18b), U32C(0x658ac65b), U32C(0xef0cb820), U32C(0xeee2dcf0), \
  U32C(0x56709d5e), U32C(0x5646c22e), U32C(0xdfc8b3f3), U32C(0xdf9ed8c3), \
  U32C(0xe8f4ecab), U32C(0xe8cb117b), U32C(0x724d0340), U32C(0x72232810), \
  U32C(0xd9b0e87e), U32C(0xd9870d4e), U32C(0x6308ff13), U32C(0x62df23e3), \
  U32C(0x041b4d75), U32C(0x03f17245), U32C(0x8d73640a), U32C(0x8d4988da), \
  U32C(0xf4d74948), U32C(0xf4ad6e18), U32C(0x7e2f5fdd), U32C(0x7e0584ad), \
  U32C(0x875b9895), U32C(0x8731bd65), U32C(0x10b3af2a), U32C(0x1089d3fa), \
  U32C(0x78179468), U32C(0x77edb938), U32C(0x016faafd), U32C(0x0145cfcd), \
  U32C(0xe200f374), U32C(0xe1d71844), U32C(0x6b590a09), U32C(0x6b2f2ed9), \
  U32C(0xd2bcef47), U32C(0xd2931417), U32C(0x5c1505dc), U32C(0x5beb2aac), \
  U32C(0x65413e94), U32C(0x65176364), U32C(0xee995529), U32C(0xee6f79f9), \
  U32C(0x55fd3a67), U32C(0x55d35f37), U32C(0xdf5550fc), U32C(0xdf2b75cc), \
  U32C(0x80679f5e), U32C(0x803dc42e), U32C(0x09bfb5f3), U32C(0x0995dac3), \
  U32C(0x71239b31), U32C(0x70f9c001), U32C(0xfa7bb1c6), U32C(0xfa51d696), \
  U32C(0x03a7ea7e), U32C(0x037e0f4e), U32C(0x8d000113), U32C(0x8cd625e3), \
  U32C(0xf463e651), U32C(0xf43a0b21), U32C(0x7dbbfce6), U32C(0x7d9221b6), \
  U32C(0x5b8dd78b), U32C(0x5b63fc5b), U32C(0xe4e5ee20), U32C(0xe4bc12f0), \
  U32C(0x4c49d35e), U32C(0x4c1ff82e), U32C(0xd5a1e9f3), U32C(0xd5780ec3), \
  U32C(0xdece22ab), U32C(0xdea4477b), U32C(0x68263940), U32C(0x67fc5e10), \
  U32C(0xcf8a1e7e), U32C(0xcf60434e), U32C(0x58e23513), U32C(0x58b859e3), \
  U32C(0xf9f48375), U32C(0xf9caa845), U32C(0x834c9a0a), U32C(0x8322beda), \
  U32C(0xeab07f48), U32C(0xea86a418), U32C(0x740895dd), U32C(0x73debaad), \
  U32C(0x7d34ce95), U32C(0x7d0af365), U32C(0x068ce52a), U32C(0x066309fa), \
  U32C(0x6df0ca68), U32C(0x6dc6ef38), U32C(0xf748e0fd), U32C(0xf71f05cd), \
  U32C(0x6f1bd327), U32C(0x6ef1f7f7), U32C(0xf873e9bc), U32C(0xf84a0e8c), \
  U32C(0x5fd7cefa), U32C(0x5fadf3ca), U32C(0xe92fe58f), U32C(0xe9060a5f), \
  U32C(0xf25c1e47), U32C(0xf2324317), U32C(0x7bb434dc), U32C(0x7b8a59ac), \
  U32C(0xe3181a1a), U32C(0xe2ee3eea), U32C(0x6c7030af), U32C(0x6c46557f), \
  U32C(0x0d827f11), U32C(0x0d58a3e1), U32C(0x96da95a6), U32C(0x96b0ba76), \
  U32C(0xfe3e7ae4), U32C(0xfe149fb4), U32C(0x87969179), U32C(0x876cb649), \
  U32C(0x90c2ca31), U32C(0x9098ef01), U32C(0x1a1ae0c6), U32C(0x19f10596), \
  U32C(0x817ec604), U32C(0x8154ead4), U32C(0x0ad6dc99), U32C(0x0aad0169), \
  U32C(0xe8a8b73e), U32C(0xe87edc0e), U32C(0x7200cdd3), U32C(0x71d6f2a3), \
  U32C(0xd964b311), U32C(0xd93ad7e1), U32C(0x62bcc9a6), U32C(0x6292ee76), \
  U32C(0x6be9025e), U32C(0x6bbf272e), U32C(0xf54118f3), U32C(0xf5173dc3), \
  U32C(0x5ca4fe31), U32C(0x5c7b2301), U32C(0xe5fd14c6), U32C(0xe5d33996), \
  U32C(0x870f6328), U32C(0x86e587f8), U32C(0x106779bd), U32C(0x103d9e8d), \
  U32C(0x77cb5efb), U32C(0x77a183cb), U32C(0x01237590), U32C(0x00f99a60), \
  U32C(0x0a4fae48), U32C(0x0a25d318), U32C(0x93a7c4dd), U32C(0x937de9ad), \
  U32C(0xfb0baa1b), U32C(0xfae1ceeb), U32C(0x8463c0b0), U32C(0x8439e580), \
  U32C(0x9ac7b313), U32C(0x9a9dd7e3), U32C(0x241fc9a8), U32C(0x23f5ee78), \
  U32C(0x8b83aee6), U32C(0x8b59d3b6), U32C(0x14dbc57b), U32C(0x14b1ea4b), \
  U32C(0x1e07fe33), U32C(0x1dde2303), U32C(0xa76014c8), U32C(0xa7363998), \
  U32C(0x0ec3fa06), U32C(0x0e9a1ed6), U32C(0x981c109b), U32C(0x97f2356b), \
  U32C(0x392e5efd), U32C(0x390483cd), U32C(0xc2867592), U32C(0xc25c9a62), \
  U32C(0x29ea5ad0), U32C(0x29c07fa0), U32C(0xb3427165), U32C(0xb3189635), \
  U32C(0xbc6eaa1d), U32C(0xbc44ceed), U32C(0x45c6c0b2), U32C(0x459ce582), \
  U32C(0xad2aa5f0), U32C(0xad00cac0), U32C(0x3682bc85), U32C(0x3658e155), \
  U32C(0x1454972a), U32C(0x142abbfa), U32C(0x9dacadbf), U32C(0x9d82d28f), \
  U32C(0x051092fd), U32C(0x04e6b7cd), U32C(0x8e68a992), U32C(0x8e3ece62), \
  U32C(0x9794e24a), U32C(0x976b071a), U32C(0x20ecf8df), U32C(0x20c31daf), \
  U32C(0x8850de1d), U32C(0x882702ed), U32C(0x11a8f4b2), U32C(0x117f1982), \
  U32C(0xb2bb4314), U32C(0xb29167e4), U32C(0x3c1359a9), U32C(0x3be97e79), \
  U32C(0xa3773ee7), U32C(0xa34d63b7), U32C(0x2ccf557c), U32C(0x2ca57a4c), \
  U32C(0x35fb8e34), U32C(0x35d1b304), U32C(0xbf53a4c9), U32C(0xbf29c999), \
  U32C(0x26b78a07), U32C(0x268daed7), U32C(0xb00fa09c), U32C(0xafe5c56c), \
  U32C(0x27e292c6), U32C(0x27b8b796), U32C(0xb13aa95b), U32C(0xb110ce2b), \
  U32C(0x189e8e99), U32C(0x1874b369), U32C(0xa1f6a52e), U32C(0xa1ccc9fe), \
  U32C(0xab22dde6), U32C(0xaaf902b6), U32C(0x347af47b), U32C(0x3451194b), \
  U32C(0x9bded9b9), U32C(0x9bb4fe89), U32C(0x2536f04e), U32C(0x250d151e), \
  U32C(0xc6493eb0), U32C(0xc61f6380), U32C(0x4fa15545), U32C(0x4f777a15), \
  U32C(0xb7053a83), U32C(0xb6db5f53), U32C(0x405d5118), U32C(0x403375e8), \
  U32C(0x498989d0), U32C(0x495faea0), U32C(0xd2e1a065), U32C(0xd2b7c535), \
  U32C(0x3a4585a3), U32C(0x3a1baa73), U32C(0xc39d9c38), U32C(0xc373c108), \
  U32C(0xa16f76dd), U32C(0xa1459bad), U32C(0x2ac78d72), U32C(0x2a9db242), \
  U32C(0x922b72b0), U32C(0x92019780), U32C(0x1b838945), U32C(0x1b59ae15), \
  U32C(0x24afc1fd), U32C(0x2485e6cd), U32C(0xae07d892), U32C(0xadddfd62), \
  U32C(0x156bbdd0), U32C(0x1541e2a0), U32C(0x9ec3d465), U32C(0x9e99f935), \
  U32C(0x3fd622c7), U32C(0x3fac4797), U32C(0xc92e395c), U32C(0xc9045e2c), \
  U32C(0x30921e9a), U32C(0x3068436a), U32C(0xb9ea352f), U32C(0xb9c059ff), \
  U32C(0xc3166de7), U32C(0xc2ec92b7), U32C(0x4c6e847c), U32C(0x4c44a94c), \
  U32C(0xb3d269ba), U32C(0xb3a88e8a), U32C(0x3d2a804f), U32C(0x3d00a51f), \
  U32C(0x3883fb77), U32C(0x385a2047), U32C(0xc1dc120c), U32C(0xc1b236dc), \
  U32C(0x293ff74a), U32C(0x29161c1a), U32C(0xb2980ddf), U32C(0xb26e32af), \
  U32C(0xbbc44697), U32C(0xbb9a6b67), U32C(0x451c5d2c), U32C(0x44f281fc), \
  U32C(0xac80426a), U32C(0xac56673a), U32C(0x35d858ff), U32C(0x35ae7dcf), \
  U32C(0xd6eaa761), U32C(0xd6c0cc31), U32C(0x6042bdf6), U32C(0x6018e2c6), \
  U32C(0xc7a6a334), U32C(0xc77cc804), U32C(0x50feb9c9), U32C(0x50d4de99), \
  U32C(0x5a2af281), U32C(0x5a011751), U32C(0xe3830916), U32C(0xe3592de6), \
  U32C(0x4ae6ee54), U32C(0x4abd1324), U32C(0xd43f04e9), U32C(0xd41529b9), \
  U32C(0xb210df8e), U32C(0xb1e7045e), U32C(0x3b68f623), U32C(0x3b3f1af3), \
  U32C(0xa2ccdb61), U32C(0xa2a30031), U32C(0x2c24f1f6), U32C(0x2bfb16c6), \
  U32C(0x35512aae), U32C(0x35274f7e), U32C(0xbea94143), U32C(0xbe7f6613), \
  U32C(0x260d2681), U32C(0x25e34b51), U32C(0xaf653d16), U32C(0xaf3b61e6), \
  U32C(0x50778b78), U32C(0x504db048), U32C(0xd9cfa20d), U32C(0xd9a5c6dd), \
  U32C(0x4133874b), U32C(0x4109ac1b), U32C(0xca8b9de0), U32C(0xca61c2b0), \
  U32C(0xd3b7d698), U32C(0xd38dfb68), U32C(0x5d0fed2d), U32C(0x5ce611fd), \
  U32C(0xc473d26b), U32C(0xc449f73b), U32C(0x4dcbe900), U32C(0x4da20dd0), \
  U32C(0xc59edb2a), U32C(0xc574fffa), U32C(0x4ef6f1bf), U32C(0x4ecd168f), \
  U32C(0xb65ad6fd), U32C(0xb630fbcd), U32C(0x3fb2ed92), U32C(0x3f891262), \
  U32C(0x48df264a), U32C(0x48b54b1a), U32C(0xd2373cdf), U32C(0xd20d61af), \
  U32C(0x399b221d), U32C(0x397146ed), U32C(0xc2f338b2), U32C(0xc2c95d82), \
  U32C(0x64058714), U32C(0x63dbabe4), U32C(0xed5d9da9), U32C(0xed33c279), \
  U32C(0x54c182e7), U32C(0x5497a7b7), U32C(0xde19997c), U32C(0xddefbe4c), \
  U32C(0xe745d234), U32C(0xe71bf704), U32C(0x709de8c9), U32C(0x70740d99), \
  U32C(0xd801ce07), U32C(0xd7d7f2d7), U32C(0x6159e49c), U32C(0x6130096c), \
  U32C(0x3f2bbf41), U32C(0x3f01e411), U32C(0xc883d5d6), U32C(0xc859faa6), \
  U32C(0x2fe7bb14), U32C(0x2fbddfe4), U32C(0xb93fd1a9), U32C(0xb915f679), \
  U32C(0xc26c0a61), U32C(0xc2422f31), U32C(0x4bc420f6), U32C(0x4b9a45c6), \
  U32C(0xb3280634), U32C(0xb2fe2b04), U32C(0x3c801cc9), U32C(0x3c564199), \
  U32C(0xdd926b2b), U32C(0xdd688ffb), U32C(0x66ea81c0), U32C(0x66c0a690), \
  U32C(0xce4e66fe), U32C(0xce248bce), U32C(0x57a67d93), U32C(0x577ca263), \
  U32C(0x60d2b64b), U32C(0x60a8db1b), U32C(0xea2acce0), U32C(0xea00f1b0), \
  U32C(0x518eb21e), U32C(0x5164d6ee), U32C(0xdae6c8b3), U32C(0xdabced83), \
  U32C(0xf14abb16), U32C(0xf120dfe6), U32C(0x7aa2d1ab), U32C(0x7a78f67b), \
  U32C(0xe206b6e9), U32C(0xe1dcdbb9), U32C(0x6b5ecd7e), U32C(0x6b34f24e), \
  U32C(0x748b0636), U32C(0x74612b06), U32C(0xfde31ccb), U32C(0xfdb9419b), \
  U32C(0x65470209), U32C(0x651d26d9), U32C(0xee9f189e), U32C(0xee753d6e), \
  U32C(0x8fb16700), U32C(0x8f878bd0), U32C(0x19097d95), U32C(0x18dfa265), \
  U32C(0x806d62d3), U32C(0x804387a3), U32C(0x09c57968), U32C(0x099b9e38), \
  U32C(0x12f1b220), U32C(0x12c7d6f0), U32C(0x9c49c8b5), U32C(0x9c1fed85), \
  U32C(0x03adadf3), U32C(0x0383d2c3), U32C(0x8d05c488), U32C(0x8cdbe958), \
  U32C(0x6ad79f2d), U32C(0x6aadc3fd), U32C(0xf42fb5c2), U32C(0xf405da92), \
  U32C(0x5b939b00), U32C(0x5b69bfd0), U32C(0xe4ebb195), U32C(0xe4c1d665), \
  U32C(0xee17ea4d), U32C(0xedee0f1d), U32C(0x777000e2), U32C(0x774625b2), \
  U32C(0xded3e620), U32C(0xdeaa0af0), U32C(0x682bfcb5), U32C(0x68022185), \
  U32C(0x093e4b17), U32C(0x09146fe7), U32C(0x929661ac), U32C(0x926c867c), \
  U32C(0xf9fa46ea), U32C(0xf9d06bba), U32C(0x83525d7f), U32C(0x8328824f), \
  U32C(0x8c7e9637), U32C(0x8c54bb07), U32C(0x15d6accc), U32C(0x15acd19c), \
  U32C(0x7d3a920a), U32C(0x7d10b6da), U32C(0x0692a89f), U32C(0x0668cd6f), \
  U32C(0x7e659ac9), U32C(0x7e3bbf99), U32C(0x07bdb15e), U32C(0x0793d62e), \
  U32C(0x6f21969c), U32C(0x6ef7bb6c), U32C(0xf879ad31), U32C(0xf84fd201), \
  U32C(0x01a5e5e9), U32C(0x017c0ab9), U32C(0x8afdfc7e), U32C(0x8ad4214e), \
  U32C(0xf261e1bc), U32C(0xf238068c), U32C(0x7bb9f851), U32C(0x7b901d21), \
  U32C(0x1ccc46b3), U32C(0x1ca26b83), U32C(0xa6245d48), U32C(0xa5fa8218), \
  U32C(0x0d884286), U32C(0x0d5e6756), U32C(0x96e0591b), U32C(0x96b67deb), \
  U32C(0xa00c91d3), U32C(0x9fe2b6a3), U32C(0x2964a868), U32C(0x293acd38), \
  U32C(0x90c88da6), U32C(0x909eb276), U32C(0x1a20a43b), U32C(0x19f6c90b), \
  U32C(0xf7f27ee0), U32C(0xf7c8a3b0), U32C(0x814a9575), U32C(0x8120ba45), \
  U32C(0xe8ae7ab3), U32C(0xe8849f83), U32C(0x72069148), U32C(0x71dcb618), \
  U32C(0x7b32ca00), U32C(0x7b08eed0), U32C(0x048ae095), U32C(0x04610565), \
  U32C(0x6beec5d3), U32C(0x6bc4eaa3), U32C(0xf546dc68), U32C(0xf51d0138), \
  U32C(0x96592aca), U32C(0x962f4f9a), U32C(0x1fb1415f), U32C(0x1f87662f), \
  U32C(0x8715269d), U32C(0x86eb4b6d), U32C(0x106d3d32), U32C(0x10436202), \
  U32C(0x199975ea), U32C(0x196f9aba), U32C(0xa2f18c7f), U32C(0xa2c7b14f), \
  U32C(0x0a5571bd), U32C(0x0a2b968d), U32C(0x93ad8852), U32C(0x9383ad22), \
  U32C(0x743ed0c9), U32C(0x7414f599), U32C(0xfd96e75e), U32C(0xfd6d0c2e), \
  U32C(0x64facc9c), U32C(0x64d0f16c), U32C(0xee52e331), U32C(0xee290801), \
  U32C(0xf77f1be9), U32C(0xf75540b9), U32C(0x80d7327e), U32C(0x80ad574e), \
  U32C(0xe83b17bc), U32C(0xe8113c8c), U32C(0x71932e51), U32C(0x71695321), \
  U32C(0x12a57cb3), U32C(0x127ba183), U32C(0x9bfd9348), U32C(0x9bd3b818), \
  U32C(0x03617886), U32C(0x03379d56), U32C(0x8cb98f1b), U32C(0x8c8fb3eb), \
  U32C(0x95e5c7d3), U32C(0x95bbeca3), U32C(0x1f3dde68), U32C(0x1f140338), \
  U32C(0x86a1c3a6), U32C(0x8677e876), U32C(0x0ff9da3b), U32C(0x0fcfff0b), \
  U32C(0xedcbb4e0), U32C(0xeda1d9b0), U32C(0x7723cb75), U32C(0x76f9f045), \
  U32C(0xde87b0b3), U32C(0xde5dd583), U32C(0x67dfc748), U32C(0x67b5ec18), \
  U32C(0x710c0000), U32C(0x70e224d0), U32C(0xfa641695), U32C(0xfa3a3b65), \
  U32C(0x61c7fbd3), U32C(0x619e20a3), U32C(0xeb201268), U32C(0xeaf63738), \
  U32C(0x8c3260ca), U32C(0x8c08859a), U32C(0x158a775f), U32C(0x15609c2f), \
  U32C(0x7cee5c9d), U32C(0x7cc4816d), U32C(0x06467332), U32C(0x061c9802), \
  U32C(0x0f72abea), U32C(0x0f48d0ba), U32C(0x98cac27f), U32C(0x98a0e74f), \
  U32C(0x002ea7bd), U32C(0x0004cc8d), U32C(0x8986be52), U32C(0x895ce322), \
  U32C(0x0159b07c), U32C(0x012fd54c), U32C(0x8ab1c711), U32C(0x8a87ebe1), \
  U32C(0xf215ac4f), U32C(0xf1ebd11f), U32C(0x7b6dc2e4), U32C(0x7b43e7b4), \
  U32C(0x8499fb9c), U32C(0x8470206c), U32C(0x0df21231), U32C(0x0dc83701), \
  U32C(0x7555f76f), U32C(0x752c1c3f), U32C(0xfeae0e04), U32C(0xfe8432d4), \
  U32C(0x9fc05c66), U32C(0x9f968136), U32C(0x291872fb), U32C(0x28ee97cb), \
  U32C(0x907c5839), U32C(0x90527d09), U32C(0x19d46ece), U32C(0x19aa939e), \
  U32C(0x2300a786), U32C(0x22d6cc56), U32C(0xac58be1b), U32C(0xac2ee2eb), \
  U32C(0x13bca359), U32C(0x1392c829), U32C(0x9d14b9ee), U32C(0x9ceadebe), \
  U32C(0x7ae69493), U32C(0x7abcb963), U32C(0x043eab28), U32C(0x0414cff8), \
  U32C(0x6ba29066), U32C(0x6b78b536), U32C(0xf4faa6fb), U32C(0xf4d0cbcb), \
  U32C(0xfe26dfb3), U32C(0xfdfd0483), U32C(0x877ef648), U32C(0x87551b18), \
  U32C(0xeee2db86), U32C(0xeeb90056), U32C(0x783af21b), U32C(0x781116eb), \
  U32C(0x194d407d), U32C(0x1923654d), U32C(0xa2a55712), U32C(0xa27b7be2), \
  U32C(0x0a093c50), U32C(0x09df6120), U32C(0x936152e5), U32C(0x933777b5), \
  U32C(0x9c8d8b9d), U32C(0x9c63b06d), U32C(0x25e5a232), U32C(0x25bbc702), \
  U32C(0x8d498770), U32C(0x8d1fac40), U32C(0x16a19e05), U32C(0x1677c2d5), \
  U32C(0x2d059068), U32C(0x2cdbb538), U32C(0xb65da6fd), U32C(0xb633cbcd), \
  U32C(0x1dc18c3b), U32C(0x1d97b10b), U32C(0xa719a2d0), U32C(0xa6efc7a0), \
  U32C(0xb045db88), U32C(0xb01c0058), U32C(0x399df21d), U32C(0x397416ed), \
  U32C(0xa101d75b), U32C(0xa0d7fc2b), U32C(0x2a59edf0), U32C(0x2a3012c0), \
  U32C(0xcb6c3c52), U32C(0xcb426122), U32C(0x54c452e7), U32C(0x549a77b7), \
  U32C(0xbc283825), U32C(0xbbfe5cf5), U32C(0x45804eba), U32C(0x4556738a), \
  U32C(0x4eac8772), U32C(0x4e82ac42), U32C(0xd8049e07), U32C(0xd7dac2d7), \
  U32C(0x3f688345), U32C(0x3f3ea815), U32C(0xc8c099da), U32C(0xc896beaa), \
  U32C(0xa692747f), U32C(0xa668994f), U32C(0x2fea8b14), U32C(0x2fc0afe4), \
  U32C(0x974e7052), U32C(0x97249522), U32C(0x20a686e7), U32C(0x207cabb7), \
  U32C(0x29d2bf9f), U32C(0x29a8e46f), U32C(0xb32ad634), U32C(0xb300fb04), \
  U32C(0x1a8ebb72), U32C(0x1a64e042), U32C(0xa3e6d207), U32C(0xa3bcf6d7), \
  U32C(0x44f92069), U32C(0x44cf4539), U32C(0xce5136fe), U32C(0xce275bce), \
  U32C(0x35b51c3c), U32C(0x358b410c), U32C(0xbf0d32d1), U32C(0xbee357a1), \
  U32C(0xc8396b89), U32C(0xc80f9059), U32C(0x5191821e), U32C(0x5167a6ee), \
  U32C(0xb8f5675c), U32C(0xb8cb8c2c), U32C(0x424d7df1), U32C(0x4223a2c1), \
  U32C(0xba20701b), U32C(0xb9f694eb), U32C(0x437886b0), U32C(0x434eab80), \
  U32C(0xaadc6bee), U32C(0xaab290be), U32C(0x34348283), U32C(0x340aa753), \
  U32C(0x3d60bb3b), U32C(0x3d36e00b), U32C(0xc6b8d1d0), U32C(0xc68ef6a0), \
  U32C(0x2e1cb70e), U32C(0x2df2dbde), U32C(0xb774cda3), U32C(0xb74af273), \
  U32C(0x58871c05), U32C(0x585d40d5), U32C(0xe1df329a), U32C(0xe1b5576a), \
  U32C(0x494317d8), U32C(0x49193ca8), U32C(0xd29b2e6d), U32C(0xd271533d), \
  U32C(0xdbc76725), U32C(0xdb9d8bf5), U32C(0x651f7dba), U32C(0x64f5a28a), \
  U32C(0xcc8362f8), U32C(0xcc5987c8), U32C(0x55db798d), U32C(0x55b19e5d), \
  U32C(0x33ad5432), U32C(0x33837902), U32C(0xbd056ac7), U32C(0xbcdb8f97), \
  U32C(0x24695005), U32C(0x243f74d5), U32C(0xadc1669a), U32C(0xad978b6a), \
  U32C(0xb6ed9f52), U32C(0xb6c3c422), U32C(0x4045b5e7), U32C(0x401bdab7), \
  U32C(0xa7a99b25), U32C(0xa77fbff5), U32C(0x3101b1ba), U32C(0x30d7d68a), \
  U32C(0xd214001c), U32C(0xd1ea24ec), U32C(0x5b6c16b1), U32C(0x5b423b81), \
  U32C(0xc2cffbef), U32C(0xc2a620bf), U32C(0x4c281284), U32C(0x4bfe3754), \
  U32C(0x55544b3c), U32C(0x552a700c), U32C(0xdeac61d1), U32C(0xde8286a1), \
  U32C(0x4610470f), U32C(0x45e66bdf), U32C(0xcf685da4), U32C(0xcf3e8274), \
  U32C(0xcbf825b8), U32C(0xcbce4a88), U32C(0x55503c4d), U32C(0x5526611d), \
  U32C(0xbcb4218b), U32C(0xbc8a465b), U32C(0x460c3820), U32C(0x45e25cf0), \
  U32C(0x4f3870d8), U32C(0x4f0e95a8), U32C(0xd890876d), U32C(0xd866ac3d), \
  U32C(0x3ff46cab), U32C(0x3fca917b), U32C(0xc94c8340), U32C(0xc922a810), \
  U32C(0x6a5ed1a2), U32C(0x6a34f672), U32C(0xf3b6e837), U32C(0xf38d0d07), \
  U32C(0x5b1acd75), U32C(0x5af0f245), U32C(0xe472e40a), U32C(0xe44908da), \
  U32C(0xed9f1cc2), U32C(0xed754192), U32C(0x76f73357), U32C(0x76cd5827), \
  U32C(0xde5b1895), U32C(0xde313d65), U32C(0x67b32f2a), U32C(0x678953fa), \
  U32C(0x458509cf), U32C(0x455b2e9f), U32C(0xcedd2064), U32C(0xceb34534), \
  U32C(0x364105a2), U32C(0x36172a72), U32C(0xbf991c37), U32C(0xbf6f4107), \
  U32C(0xc8c554ef), U32C(0xc89b79bf), U32C(0x521d6b84), U32C(0x51f39054), \
  U32C(0xb98150c2), U32C(0xb9577592), U32C(0x42d96757), U32C(0x42af8c27), \
  U32C(0xe3ebb5b9), U32C(0xe3c1da89), U32C(0x6d43cc4e), U32C(0x6d19f11e), \
  U32C(0xd4a7b18c), U32C(0xd47dd65c), U32C(0x5dffc821), U32C(0x5dd5ecf1), \
  U32C(0x672c00d9), U32C(0x670225a9), U32C(0xf084176e), U32C(0xf05a3c3e), \
  U32C(0x57e7fcac), U32C(0x57be217c), U32C(0xe1401341), U32C(0xe1163811), \
  U32C(0x5913056b), U32C(0x58e92a3b), U32C(0xe26b1c00), U32C(0xe24140d0), \
  U32C(0x49cf013e), U32C(0x49a5260e), U32C(0xd32717d3), U32C(0xd2fd3ca3), \
  U32C(0xdc53508b), U32C(0xdc29755b), U32C(0x65ab6720), U32C(0x65818bf0), \
  U32C(0xcd0f4c5e), U32C(0xcce5712e), U32C(0x566762f3), U32C(0x563d87c3), \
  U32C(0xf779b155), U32C(0xf74fd625), U32C(0x80d1c7ea), U32C(0x80a7ecba), \
  U32C(0xe835ad28), U32C(0xe80bd1f8), U32C(0x718dc3bd), U32C(0x7163e88d), \
  U32C(0x7ab9fc75), U32C(0x7a902145), U32C(0x0412130a), U32C(0x03e837da), \
  U32C(0x6b75f848), U32C(0x6b4c1d18), U32C(0xf4ce0edd), U32C(0xf4a433ad), \
  U32C(0xd29fe982), U32C(0xd2760e52), U32C(0x5bf80017), U32C(0x5bce24e7), \
  U32C(0xc35be555), U32C(0xc3320a25), U32C(0x4cb3fbea), U32C(0x4c8a20ba), \
  U32C(0x55e034a2), U32C(0x55b65972), U32C(0xdf384b37), U32C(0xdf0e7007), \
  U32C(0x469c3075), U32C(0x46725545), U32C(0xcff4470a), U32C(0xcfca6bda), \
  U32C(0x7106956c), U32C(0x70dcba3c), U32C(0xfa5eac01), U32C(0xfa34d0d1), \
  U32C(0x61c2913f), U32C(0x6198b60f), U32C(0xeb1aa7d4), U32C(0xeaf0cca4), \
  U32C(0xf446e08c), U32C(0xf41d055c), U32C(0x7d9ef721), U32C(0x7d751bf1), \
  U32C(0xe502dc5f), U32C(0xe4d9012f), U32C(0x6e5af2f4), U32C(0x6e3117c4), \
  U32C(0x84bee557), U32C(0x84950a27), U32C(0x0e16fbec), U32C(0x0ded20bc), \
  U32C(0x757ae12a), U32C(0x755105fa), U32C(0xfed2f7bf), U32C(0xfea91c8f), \
  U32C(0x07ff3077), U32C(0x07d55547), U32C(0x9157470c), U32C(0x912d6bdc), \
  U32C(0xf8bb2c4a), U32C(0xf891511a), U32C(0x821342df), U32C(0x81e967af), \
  U32C(0x23259141), U32C(0x22fbb611), U32C(0xac7da7d6), U32C(0xac53cca6), \
  U32C(0x13e18d14), U32C(0x13b7b1e4), U32C(0x9d39a3a9), U32C(0x9d0fc879), \
  U32C(0xa665dc61), U32C(0xa63c0131), U32C(0x2fbdf2f6), U32C(0x2f9417c6), \
  U32C(0x9721d834), U32C(0x96f7fd04), U32C(0x2079eec9), U32C(0x20501399), \
  U32C(0xfe4bc96e), U32C(0xfe21ee3e), U32C(0x87a3e003), U32C(0x877a04d3), \
  U32C(0xef07c541), U32C(0xeeddea11), U32C(0x785fdbd6), U32C(0x783600a6), \
  U32C(0x818c148e), U32C(0x8162395e), U32C(0x0ae42b23), U32C(0x0aba4ff3), \
  U32C(0x72481061), U32C(0x721e3531), U32C(0xfba026f6), U32C(0xfb764bc6), \
  U32C(0x9cb27558), U32C(0x9c889a28), U32C(0x260a8bed), U32C(0x25e0b0bd), \
  U32C(0x8d6e712b), U32C(0x8d4495fb), U32C(0x16c687c0), U32C(0x169cac90), \
  U32C(0x1ff2c078), U32C(0x1fc8e548), U32C(0xa94ad70d), U32C(0xa920fbdd), \
  U32C(0x10aebc4b), U32C(0x1084e11b), U32C(0x9a06d2e0), U32C(0x99dcf7b0), \
  U32C(0x11d9c50a), U32C(0x11afe9da), U32C(0x9b31db9f), U32C(0x9b08006f), \
  U32C(0x0295c0dd), U32C(0x026be5ad), U32C(0x8bedd772), U32C(0x8bc3fc42), \
  U32C(0x951a102a), U32C(0x94f034fa), U32C(0x1e7226bf), U32C(0x1e484b8f), \
  U32C(0x85d60bfd), U32C(0x85ac30cd), U32C(0x0f2e2292), U32C(0x0f044762), \
  U32C(0xb04070f4), U32C(0xb01695c4), U32C(0x39988789), U32C(0x396eac59), \
  U32C(0xa0fc6cc7), U32C(0xa0d29197), U32C(0x2a54835c), U32C(0x2a2aa82c), \
  U32C(0x3380bc14), U32C(0x3356e0e4), U32C(0xbcd8d2a9), U32C(0xbcaef779), \
  U32C(0x243cb7e7), U32C(0x2412dcb7), U32C(0xad94ce7c), U32C(0xad6af34c), \
  U32C(0x8b66a921), U32C(0x8b3ccdf1), U32C(0x14bebfb6), U32C(0x1494e486), \
  U32C(0x7c22a4f4), U32C(0x7bf8c9c4), U32C(0x057abb89), U32C(0x0550e059), \
  U32C(0x0ea6f441), U32C(0x0e7d1911), U32C(0x97ff0ad6), U32C(0x97d52fa6), \
  U32C(0xff62f014), U32C(0xff3914e4), U32C(0x88bb06a9), U32C(0x88912b79), \
  U32C(0x29cd550b), U32C(0x29a379db), U32C(0xb3256ba0), U32C(0xb2fb9070), \
  U32C(0x1a8950de), U32C(0x1a5f75ae), U32C(0xa3e16773), U32C(0xa3b78c43), \
  U32C(0xad0da02b), U32C(0xace3c4fb), U32C(0x3665b6c0), U32C(0x363bdb90), \
  U32C(0x9dc99bfe), U32C(0x9d9fc0ce), U32C(0x2721b293), U32C(0x26f7d763), \
  U32C(0x07b2fb0a), U32C(0x07891fda), U32C(0x910b119f), U32C(0x90e1366f), \
  U32C(0xf86ef6dd), U32C(0xf8451bad), U32C(0x81c70d72), U32C(0x819d3242), \
  U32C(0x8af3462a), U32C(0x8ac96afa), U32C(0x144b5cbf), U32C(0x1421818f), \
  U32C(0x7baf41fd), U32C(0x7b8566cd), U32C(0x05075892), U32C(0x04dd7d62), \
  U32C(0xa619a6f4), U32C(0xa5efcbc4), U32C(0x2f71bd89), U32C(0x2f47e259), \
  U32C(0x96d5a2c7), U32C(0x96abc797), U32C(0x202db95c), U32C(0x2003de2c), \
  U32C(0x2959f214), U32C(0x293016e4), U32C(0xb2b208a9), U32C(0xb2882d79), \
  U32C(0x1a15ede7), U32C(0x19ec12b7), U32C(0xa36e047c), U32C(0xa344294c), \
  U32C(0x813fdf21), U32C(0x811603f1), U32C(0x0a97f5b6), U32C(0x0a6e1a86), \
  U32C(0x71fbdaf4), U32C(0x71d1ffc4), U32C(0xfb53f189), U32C(0xfb2a1659), \
  U32C(0x04802a41), U32C(0x04564f11), U32C(0x8dd840d6), U32C(0x8dae65a6), \
  U32C(0xf53c2614), U32C(0xf5124ae4), U32C(0x7e943ca9), U32C(0x7e6a6179), \
  U32C(0x1fa68b0b), U32C(0x1f7cafdb), U32C(0xa8fea1a0), U32C(0xa8d4c670), \
  U32C(0x106286de), U32C(0x1038abae), U32C(0x99ba9d73), U32C(0x9990c243), \
  U32C(0xa2e6d62b), U32C(0xa2bcfafb), U32C(0x2c3eecc0), U32C(0x2c151190), \
  U32C(0x93a2d1fe), U32C(0x9378f6ce), U32C(0x1cfae893), U32C(0x1cd10d63), \
  U32C(0x94cddabd), U32C(0x94a3ff8d), U32C(0x1e25f152), U32C(0x1dfc1622), \
  U32C(0x8589d690), U32C(0x855ffb60), U32C(0x0ee1ed25), U32C(0x0eb811f5), \
  U32C(0x180e25dd), U32C(0x17e44aad), U32C(0xa1663c72), U32C(0xa13c6142), \
  U32C(0x08ca21b0), U32C(0x08a04680), U32C(0x92223845), U32C(0x91f85d15), \
  U32C(0x333486a7), U32C(0x330aab77), U32C(0xbc8c9d3c), U32C(0xbc62c20c), \
  U32C(0x23f0827a), U32C(0x23c6a74a), U32C(0xad48990f), U32C(0xad1ebddf), \
  U32C(0xb674d1c7), U32C(0xb64af697), U32C(0x3fcce85c), U32C(0x3fa30d2c), \
  U32C(0xa730cd9a), U32C(0xa706f26a), U32C(0x3088e42f), U32C(0x305f08ff), \
  U32C(0x0e5abed4), U32C(0x0e30e3a4), U32C(0x97b2d569), U32C(0x9788fa39), \
  U32C(0xff16baa7), U32C(0xfeecdf77), U32C(0x886ed13c), U32C(0x8844f60c), \
  U32C(0x919b09f4), U32C(0x91712ec4), U32C(0x1af32089), U32C(0x1ac94559), \
  U32C(0x825705c7), U32C(0x822d2a97), U32C(0x0baf1c5c), U32C(0x0b85412c), \
  U32C(0xacc16abe), U32C(0xac978f8e), U32C(0x36198153), U32C(0x35efa623), \
  U32C(0x9d7d6691), U32C(0x9d538b61), U32C(0x26d57d26), U32C(0x26aba1f6), \
  U32C(0x3001b5de), U32C(0x2fd7daae), U32C(0xb959cc73), U32C(0xb92ff143), \
  U32C(0x20bdb1b1), U32C(0x2093d681), U32C(0xaa15c846), U32C(0xa9ebed16), \
  U32C(0xc079baa9), U32C(0xc04fdf79), U32C(0x49d1d13e), U32C(0x49a7f60e), \
  U32C(0xb135b67c), U32C(0xb10bdb4c), U32C(0x3a8dcd11), U32C(0x3a63f1e1), \
  U32C(0x43ba05c9), U32C(0x43902a99), U32C(0xcd121c5e), U32C(0xcce8412e), \
  U32C(0x3476019c), U32C(0x344c266c), U32C(0xbdce1831), U32C(0xbda43d01), \
  U32C(0x5ee06693), U32C(0x5eb68b63), U32C(0xe8387d28), U32C(0xe80ea1f8), \
  U32C(0x4f9c6266), U32C(0x4f728736), U32C(0xd8f478fb), U32C(0xd8ca9dcb), \
  U32C(0xe220b1b3), U32C(0xe1f6d683), U32C(0x6b78c848), U32C(0x6b4eed18), \
  U32C(0xd2dcad86), U32C(0xd2b2d256), U32C(0x5c34c41b), U32C(0x5c0ae8eb), \
  U32C(0x3a069ec0), U32C(0x39dcc390), U32C(0xc35eb555), U32C(0xc334da25), \
  U32C(0x2ac29a93), U32C(0x2a98bf63), U32C(0xb41ab128), U32C(0xb3f0d5f8), \
  U32C(0xbd46e9e0), U32C(0xbd1d0eb0), U32C(0x469f0075), U32C(0x46752545), \
  U32C(0xae02e5b3), U32C(0xadd90a83), U32C(0x375afc48), U32C(0x37312118), \
  U32C(0xd86d4aaa), U32C(0xd8436f7a), U32C(0x61c5613f), U32C(0x619b860f), \
  U32C(0xc929467d), U32C(0xc8ff6b4d), U32C(0x52815d12), U32C(0x525781e2), \
  U32C(0x5bad95ca), U32C(0x5b83ba9a), U32C(0xe505ac5f), U32C(0xe4dbd12f), \
  U32C(0x4c69919d), U32C(0x4c3fb66d), U32C(0xd5c1a832), U32C(0xd597cd02), \
  U32C(0x4d949a5c), U32C(0x4d6abf2c), U32C(0xd6ecb0f1), U32C(0xd6c2d5c1), \
  U32C(0x3e50962f), U32C(0x3e26baff), U32C(0xc7a8acc4), U32C(0xc77ed194), \
  U32C(0xd0d4e57c), U32C(0xd0ab0a4c), U32C(0x5a2cfc11), U32C(0x5a0320e1), \
  U32C(0xc190e14f), U32C(0xc167061f), U32C(0x4ae8f7e4), U32C(0x4abf1cb4), \
  U32C(0xebfb4646), U32C(0xebd16b16), U32C(0x75535cdb), U32C(0x752981ab), \
  U32C(0xdcb74219), U32C(0xdc8d66e9), U32C(0x660f58ae), U32C(0x65e57d7e), \
  U32C(0x6f3b9166), U32C(0x6f11b636), U32C(0xf893a7fb), U32C(0xf869cccb), \
  U32C(0x5ff78d39), U32C(0x5fcdb209), U32C(0xe94fa3ce), U32C(0xe925c89e), \
  U32C(0xc7217e73), U32C(0xc6f7a343), U32C(0x50799508), U32C(0x504fb9d8), \
  U32C(0xb7dd7a46), U32C(0xb7b39f16), U32C(0x413590db), U32C(0x410bb5ab), \
  U32C(0x4a61c993), U32C(0x4a37ee63), U32C(0xd3b9e028), U32C(0xd39004f8), \
  U32C(0x3b1dc566), U32C(0x3af3ea36), U32C(0xc475dbfb), U32C(0xc44c00cb), \
  U32C(0x65882a5d), U32C(0x655e4f2d), U32C(0xeee040f2), U32C(0xeeb665c2), \
  U32C(0x56442630), U32C(0x561a4b00), U32C(0xdf9c3cc5), U32C(0xdf726195), \
  U32C(0xe8c8757d), U32C(0xe89e9a4d), U32C(0x72208c12), U32C(0x71f6b0e2), \
  U32C(0xd9847150), U32C(0xd95a9620), U32C(0x62dc87e5), U32C(0x62b2acb5), \
  U32C(0x5e36030d), U32C(0x5e0c27dd), U32C(0xe78e19a2), U32C(0xe7643e72), \
  U32C(0x4ef1fee0), U32C(0x4ec823b0), U32C(0xd84a1575), U32C(0xd8203a45), \
  U32C(0xe1764e2d), U32C(0xe14c72fd), U32C(0x6ace64c2), U32C(0x6aa48992), \
  U32C(0xd2324a00), U32C(0xd2086ed0), U32C(0x5b8a6095), U32C(0x5b608565), \
  U32C(0xfc9caef7), U32C(0xfc72d3c7), U32C(0x85f4c58c), U32C(0x85caea5c), \
  U32C(0xed58aaca), U32C(0xed2ecf9a), U32C(0x76b0c15f), U32C(0x7686e62f), \
  U32C(0x7fdcfa17), U32C(0x7fb31ee7), U32C(0x093510ac), U32C(0x090b357c), \
  U32C(0x7098f5ea), U32C(0x706f1aba), U32C(0xf9f10c7f), U32C(0xf9c7314f), \
  U32C(0xd7c2e724), U32C(0xd7990bf4), U32C(0x611afdb9), U32C(0x60f12289), \
  U32C(0xc87ee2f7), U32C(0xc85507c7), U32C(0x51d6f98c), U32C(0x51ad1e5c), \
  U32C(0x5b033244), U32C(0x5ad95714), U32C(0xe45b48d9), U32C(0xe4316da9), \
  U32C(0x4bbf2e17), U32C(0x4b9552e7), U32C(0xd51744ac), U32C(0xd4ed697c), \
  U32C(0x7629930e), U32C(0x75ffb7de), U32C(0xff81a9a3), U32C(0xff57ce73), \
  U32C(0x66e58ee1), U32C(0x66bbb3b1), U32C(0xf03da576), U32C(0xf013ca46), \
  U32C(0xf969de2e), U32C(0xf94002fe), U32C(0x82c1f4c3), U32C(0x82981993), \
  U32C(0xea25da01), U32C(0xe9fbfed1), U32C(0x737df096), U32C(0x73541566), \
  U32C(0xeb50e2c0), U32C(0xeb270790), U32C(0x74a8f955), U32C(0x747f1e25), \
  U32C(0xdc0cde93), U32C(0xdbe30363), U32C(0x6564f528), U32C(0x653b19f8), \
  U32C(0x6e912de0), U32C(0x6e6752b0), U32C(0xf7e94475), U32C(0xf7bf6945), \
  U32C(0x5f4d29b3), U32C(0x5f234e83), U32C(0xe8a54048), U32C(0xe87b6518), \
  U32C(0x89b78eaa), U32C(0x898db37a), U32C(0x130fa53f), U32C(0x12e5ca0f), \
  U32C(0x7a738a7d), U32C(0x7a49af4d), U32C(0x03cba112), U32C(0x03a1c5e2), \
  U32C(0x0cf7d9ca), U32C(0x0ccdfe9a), U32C(0x964ff05f), U32C(0x9626152f), \
  U32C(0xfdb3d59d), U32C(0xfd89fa6d), U32C(0x870bec32), U32C(0x86e21102), \
  U32C(0x64ddc6d7), U32C(0x64b3eba7), U32C(0xee35dd6c), U32C(0xee0c023c), \
  U32C(0x5599c2aa), U32C(0x556fe77a), U32C(0xdef1d93f), U32C(0xdec7fe0f), \
  U32C(0xe81e11f7), U32C(0xe7f436c7), U32C(0x7176288c), U32C(0x714c4d5c), \
  U32C(0xd8da0dca), U32C(0xd8b0329a), U32C(0x6232245f), U32C(0x6208492f), \
  U32C(0x034472c1), U32C(0x031a9791), U32C(0x8c9c8956), U32C(0x8c72ae26), \
  U32C(0xf4006e94), U32C(0xf3d69364), U32C(0x7d588529), U32C(0x7d2ea9f9), \
  U32C(0x8684bde1), U32C(0x865ae2b1), U32C(0x0fdcd476), U32C(0x0fb2f946), \
  U32C(0x7740b9b4), U32C(0x7716de84), U32C(0x0098d049), U32C(0x006ef519), \
  U32C(0x16fcc2ac), U32C(0x16d2e77c), U32C(0xa054d941), U32C(0xa02afe11), \
  U32C(0x07b8be7f), U32C(0x078ee34f), U32C(0x9110d514), U32C(0x90e6f9e4), \
  U32C(0x9a3d0dcc), U32C(0x9a13329c), U32C(0x23952461), U32C(0x236b4931), \
  U32C(0x8af9099f), U32C(0x8acf2e6f), U32C(0x14512034), U32C(0x14274504), \
  U32C(0xb5636e96), U32C(0xb5399366), U32C(0x3ebb852b), U32C(0x3e91a9fb), \
  U32C(0xa61f6a69), U32C(0xa5f58f39), U32C(0x2f7780fe), U32C(0x2f4da5ce), \
  U32C(0x38a3b9b6), U32C(0x3879de86), U32C(0xc1fbd04b), U32C(0xc1d1f51b), \
  U32C(0x295fb589), U32C(0x2935da59), U32C(0xb2b7cc1e), U32C(0xb28df0ee), \
  U32C(0x9089a6c3), U32C(0x905fcb93), U32C(0x19e1bd58), U32C(0x19b7e228), \
  U32C(0x8145a296), U32C(0x811bc766), U32C(0x0a9db92b), U32C(0x0a73ddfb), \
  U32C(0x13c9f1e3), U32C(0x13a016b3), U32C(0x9d220878), U32C(0x9cf82d48), \
  U32C(0x0485edb6), U32C(0x045c1286), U32C(0x8dde044b), U32C(0x8db4291b), \
  U32C(0x2ef052ad), U32C(0x2ec6777d), U32C(0xb8486942), U32C(0xb81e8e12), \
  U32C(0x1fac4e80), U32C(0x1f827350), U32C(0xa9046515), U32C(0xa8da89e5), \
  U32C(0xb2309dcd), U32C(0xb206c29d), U32C(0x3b88b462), U32C(0x3b5ed932), \
  U32C(0xa2ec99a0), U32C(0xa2c2be70), U32C(0x2c44b035), U32C(0x2c1ad505), \
  U32C(0xa417a25f), U32C(0xa3edc72f), U32C(0x2d6fb8f4), U32C(0x2d45ddc4), \
  U32C(0x94d39e32), U32C(0x94a9c302), U32C(0x1e2bb4c7), U32C(0x1e01d997), \
  U32C(0x2757ed7f), U32C(0x272e124f), U32C(0xb0b00414), U32C(0xb08628e4), \
  U32C(0x1813e952), U32C(0x17ea0e22), U32C(0xa16bffe7), U32C(0xa14224b7), \
  U32C(0x427e4e49), U32C(0x42547319), U32C(0xcbd664de), U32C(0xcbac89ae), \
  U32C(0x333a4a1c), U32C(0x33106eec), U32C(0xbc9260b1), U32C(0xbc688581), \
  U32C(0xc5be9969), U32C(0xc594be39), U32C(0x4f16affe), U32C(0x4eecd4ce), \
  U32C(0xb67a953c), U32C(0xb650ba0c), U32C(0x3fd2abd1), U32C(0x3fa8d0a1), \
  U32C(0x1da48676), U32C(0x1d7aab46), U32C(0xa6fc9d0b), U32C(0xa6d2c1db), \
  U32C(0x0e608249), U32C(0x0e36a719), U32C(0x97b898de), U32C(0x978ebdae), \
  U32C(0xa0e4d196), U32C(0xa0baf666), U32C(0x2a3ce82b), U32C(0x2a130cfb), \
  U32C(0x91a0cd69), U32C(0x9176f239), U32C(0x1af8e3fe), U32C(0x1acf08ce), \
  U32C(0xbc0b3260), U32C(0xbbe15730), U32C(0x456348f5), U32C(0x45396dc5), \
  U32C(0xacc72e33), U32C(0xac9d5303), U32C(0x361f44c8), U32C(0x35f56998), \
  U32C(0x3f4b7d80), U32C(0x3f21a250), U32C(0xc8a39415), U32C(0xc879b8e5), \
  U32C(0x30077953), U32C(0x2fdd9e23), U32C(0xb95f8fe8), U32C(0xb935b4b8), \
  U32C(0x99f0d85f), U32C(0x99c6fd2f), U32C(0x2348eef4), U32C(0x231f13c4), \
  U32C(0x8aacd432), U32C(0x8a82f902), U32C(0x1404eac7), U32C(0x13db0f97), \
  U32C(0x1d31237f), U32C(0x1d07484f), U32C(0xa6893a14), U32C(0xa65f5ee4), \
  U32C(0x0ded1f52), U32C(0x0dc34422), U32C(0x974535e7), U32C(0x971b5ab7), \
  U32C(0x38578449), U32C(0x382da919), U32C(0xc1af9ade), U32C(0xc185bfae), \
  U32C(0x2913801c), U32C(0x28e9a4ec), U32C(0xb26b96b1), U32C(0xb241bb81), \
  U32C(0xbb97cf69), U32C(0xbb6df439), U32C(0x44efe5fe), U32C(0x44c60ace), \
  U32C(0xac53cb3c), U32C(0xac29f00c), U32C(0x35abe1d1), U32C(0x358206a1), \
  U32C(0x137dbc76), U32C(0x1353e146), U32C(0x9cd5d30b), U32C(0x9cabf7db), \
  U32C(0x0439b849), U32C(0x040fdd19), U32C(0x8d91cede), U32C(0x8d67f3ae), \
  U32C(0x96be0796), U32C(0x96942c66), U32C(0x20161e2b), U32C(0x1fec42fb), \
  U32C(0x877a0369), U32C(0x87502839), U32C(0x10d219fe), U32C(0x10a83ece), \
  U32C(0xb1e46860), U32C(0xb1ba8d30), U32C(0x3b3c7ef5), U32C(0x3b12a3c5), \
  U32C(0xa2a06433), U32C(0xa2768903), U32C(0x2bf87ac8), U32C(0x2bce9f98), \
  U32C(0x3524b380), U32C(0x34fad850), U32C(0xbe7cca15), U32C(0xbe52eee5), \
  U32C(0x25e0af53), U32C(0x25b6d423), U32C(0xaf38c5e8), U32C(0xaf0eeab8), \
  U32C(0x270bb812), U32C(0x26e1dce2), U32C(0xb063cea7), U32C(0xb039f377), \
  U32C(0x17c7b3e5), U32C(0x179dd8b5), U32C(0xa11fca7a), U32C(0xa0f5ef4a), \
  U32C(0xaa4c0332), U32C(0xaa222802), U32C(0x33a419c7), U32C(0x337a3e97), \
  U32C(0x9b07ff05), U32C(0x9ade23d5), U32C(0x2460159a), U32C(0x24363a6a), \
  U32C(0xc57263fc), U32C(0xc54888cc), U32C(0x4eca7a91), U32C(0x4ea09f61), \
  U32C(0xb62e5fcf), U32C(0xb604849f), U32C(0x3f867664), U32C(0x3f5c9b34), \
  U32C(0x48b2af1c), U32C(0x4888d3ec), U32C(0xd20ac5b1), U32C(0xd1e0ea81), \
  U32C(0x396eaaef), U32C(0x3944cfbf), U32C(0xc2c6c184), U32C(0xc29ce654), \
  U32C(0xa0989c29), U32C(0xa06ec0f9), U32C(0x29f0b2be), U32C(0x29c6d78e), \
  U32C(0x915497fc), U32C(0x912abccc), U32C(0x1aacae91), U32C(0x1a82d361), \
  U32C(0x23d8e749), U32C(0x23af0c19), U32C(0xad30fdde), U32C(0xad0722ae), \
  U32C(0x1494e31c), U32C(0x146b07ec), U32C(0x9decf9b1), U32C(0x9dc31e81), \
  U32C(0x3eff4813), U32C(0x3ed56ce3), U32C(0xc8575ea8), U32C(0xc82d8378), \
  U32C(0x2fbb43e6), U32C(0x2f9168b6), U32C(0xb9135a7b), U32C(0xb8e97f4b), \
  U32C(0xc23f9333), U32C(0xc215b803), U32C(0x4b97a9c8), U32C(0x4b6dce98), \
  U32C(0xb2fb8f06), U32C(0xb2d1b3d6), U32C(0x3c53a59b), U32C(0x3c29ca6b), \
  U32C(0x52b797fe), U32C(0x528dbcce), U32C(0xdc0fae93), U32C(0xdbe5d363), \
  U32C(0x437393d1), U32C(0x4349b8a1), U32C(0xcccbaa66), U32C(0xcca1cf36), \
  U32C(0xd5f7e31e), U32C(0xd5ce07ee), U32C(0x5f4ff9b3), U32C(0x5f261e83), \
  U32C(0xc6b3def1), U32C(0xc68a03c1), U32C(0x500bf586), U32C(0x4fe21a56), \
  U32C(0xf11e43e8), U32C(0xf0f468b8), U32C(0x7a765a7d), U32C(0x7a4c7f4d), \
  U32C(0xe1da3fbb), U32C(0xe1b0648b), U32C(0x6b325650), U32C(0x6b087b20), \
  U32C(0x745e8f08), U32C(0x7434b3d8), U32C(0xfdb6a59d), U32C(0xfd8cca6d), \
  U32C(0x651a8adb), U32C(0x64f0afab), U32C(0xee72a170), U32C(0xee48c640), \
  U32C(0xcc447c15), U32C(0xcc1aa0e5), U32C(0x559c92aa), U32C(0x5572b77a), \
  U32C(0xbd0077e8), U32C(0xbcd69cb8), U32C(0x46588e7d), U32C(0x462eb34d), \
  U32C(0x4f84c735), U32C(0x4f5aec05), U32C(0xd8dcddca), U32C(0xd8b3029a), \
  U32C(0x4040c308), U32C(0x4016e7d8), U32C(0xc998d99d), U32C(0xc96efe6d), \
  U32C(0x6aab27ff), U32C(0x6a814ccf), U32C(0xf4033e94), U32C(0xf3d96364), \
  U32C(0x5b6723d2), U32C(0x5b3d48a2), U32C(0xe4bf3a67), U32C(0xe4955f37), \
  U32C(0xedeb731f), U32C(0xedc197ef), U32C(0x774389b4), U32C(0x7719ae84), \
  U32C(0xdea76ef2), U32C(0xde7d93c2), U32C(0x67ff8587), U32C(0x67d5aa57), \
  U32C(0xdfd277b1), U32C(0xdfa89c81), U32C(0x692a8e46), U32C(0x6900b316), \
  U32C(0xd08e7384), U32C(0xd0649854), U32C(0x59e68a19), U32C(0x59bcaee9), \
  U32C(0x6312c2d1), U32C(0x62e8e7a1), U32C(0xec6ad966), U32C(0xec40fe36), \
  U32C(0x53cebea4), U32C(0x53a4e374), U32C(0xdd26d539), U32C(0xdcfcfa09), \
  U32C(0x7e39239b), U32C(0x7e0f486b), U32C(0x07913a30), U32C(0x07675f00), \
  U32C(0x6ef51f6e), U32C(0x6ecb443e), U32C(0xf84d3603), U32C(0xf8235ad3), \
  U32C(0x01796ebb), U32C(0x014f938b), U32C(0x8ad18550), U32C(0x8aa7aa20), \
  U32C(0xf2356a8e), U32C(0xf20b8f5e), U32C(0x7b8d8123), U32C(0x7b63a5f3), \
  U32C(0x595f5bc8), U32C(0x59358098), U32C(0xe2b7725d), U32C(0xe28d972d), \
  U32C(0x4a1b579b), U32C(0x49f17c6b), U32C(0xd3736e30), U32C(0xd3499300), \
  U32C(0xdc9fa6e8), U32C(0xdc75cbb8), U32C(0x65f7bd7d), U32C(0x65cde24d), \
  U32C(0xcd5ba2bb), U32C(0xcd31c78b), U32C(0x56b3b950), U32C(0x5689de20), \
  U32C(0xf7c607b2), U32C(0xf79c2c82), U32C(0x811e1e47), U32C(0x80f44317), \
  U32C(0xe8820385), U32C(0xe8582855), U32C(0x71da1a1a), U32C(0x71b03eea), \
  U32C(0x7b0652d2), U32C(0x7adc77a2), U32C(0x045e6967), U32C(0x04348e37), \
  U32C(0x6bc24ea5), U32C(0x6b987375), U32C(0xf51a653a), U32C(0xf4f08a0a), \
  U32C(0x723e43da), U32C(0x721468aa), U32C(0xfb965a6f), U32C(0xfb6c7f3f), \
  U32C(0x62fa3fad), U32C(0x62d0647d), U32C(0xec525642), U32C(0xec287b12), \
  U32C(0xf57e8efa), U32C(0xf554b3ca), U32C(0x7ed6a58f), U32C(0x7eacca5f), \
  U32C(0xe63a8acd), U32C(0xe610af9d), U32C(0x6f92a162), U32C(0x6f68c632), \
  U32C(0x10a4efc4), U32C(0x107b1494), U32C(0x99fd0659), U32C(0x99d32b29), \
  U32C(0x0160eb97), U32C(0x01371067), U32C(0x8ab9022c), U32C(0x8a8f26fc), \
  U32C(0x93e53ae4), U32C(0x93bb5fb4), U32C(0x1d3d5179), U32C(0x1d137649), \
  U32C(0x84a136b7), U32C(0x84775b87), U32C(0x0df94d4c), U32C(0x0dcf721c), \
  U32C(0xebcb27f1), U32C(0xeba14cc1), U32C(0x75233e86), U32C(0x74f96356), \
  U32C(0xdc8723c4), U32C(0xdc5d4894), U32C(0x65df3a59), U32C(0x65b55f29), \
  U32C(0x6f0b7311), U32C(0x6ee197e1), U32C(0xf86389a6), U32C(0xf839ae76), \
  U32C(0x5fc76ee4), U32C(0x5f9d93b4), U32C(0xe91f8579), U32C(0xe8f5aa49), \
  U32C(0x8a31d3db), U32C(0x8a07f8ab), U32C(0x1389ea70), U32C(0x13600f40), \
  U32C(0x7aedcfae), U32C(0x7ac3f47e), U32C(0x0445e643), U32C(0x041c0b13), \
  U32C(0x0d721efb), U32C(0x0d4843cb), U32C(0x96ca3590), U32C(0x96a05a60), \
  U32C(0xfe2e1ace), U32C(0xfe043f9e), U32C(0x87863163), U32C(0x875c5633), \
  U32C(0xff59238d), U32C(0xff2f485d), U32C(0x88b13a22), U32C(0x88875ef2), \
  U32C(0xf0151f60), U32C(0xefeb4430), U32C(0x796d35f5), U32C(0x79435ac5), \
  U32C(0x82996ead), U32C(0x826f937d), U32C(0x0bf18542), U32C(0x0bc7aa12), \
  U32C(0x73556a80), U32C(0x732b8f50), U32C(0xfcad8115), U32C(0xfc83a5e5), \
  U32C(0x9dbfcf77), U32C(0x9d95f447), U32C(0x2717e60c), U32C(0x26ee0adc), \
  U32C(0x8e7bcb4a), U32C(0x8e51f01a), U32C(0x17d3e1df), U32C(0x17aa06af), \
  U32C(0x21001a97), U32C(0x20d63f67), U32C(0xaa58312c), U32C(0xaa2e55fc), \
  U32C(0x11bc166a), U32C(0x11923b3a), U32C(0x9b142cff), U32C(0x9aea51cf), \
  U32C(0x78e607a4), U32C(0x78bc2c74), U32C(0x023e1e39), U32C(0x02144309), \
  U32C(0x69a20377), U32C(0x69782847), U32C(0xf2fa1a0c), U32C(0xf2d03edc), \
  U32C(0xfc2652c4), U32C(0xfbfc7794), U32C(0x857e6959), U32C(0x85548e29), \
  U32C(0xece24e97), U32C(0xecb87367), U32C(0x763a652c), U32C(0x761089fc), \
  U32C(0x174cb38e), U32C(0x1722d85e), U32C(0xa0a4ca23), U32C(0xa07aeef3), \
  U32C(0x0808af61), U32C(0x07ded431), U32C(0x9160c5f6), U32C(0x9136eac6), \
  U32C(0x9a8cfeae), U32C(0x9a63237e), U32C(0x23e51543), U32C(0x23bb3a13), \
  U32C(0x8b48fa81), U32C(0x8b1f1f51), U32C(0x14a11116), U32C(0x147735e6), \
  U32C(0x2b050379), U32C(0x2adb2849), U32C(0xb45d1a0e), U32C(0xb4333ede), \
  U32C(0x1bc0ff4c), U32C(0x1b97241c), U32C(0xa51915e1), U32C(0xa4ef3ab1), \
  U32C(0xae454e99), U32C(0xae1b7369), U32C(0x379d652e), U32C(0x377389fe), \
  U32C(0x9f014a6c), U32C(0x9ed76f3c), U32C(0x28596101), U32C(0x282f85d1), \
  U32C(0xc96baf63), U32C(0xc941d433), U32C(0x52c3c5f8), U32C(0x5299eac8), \
  U32C(0xba27ab36), U32C(0xb9fdd006), U32C(0x437fc1cb), U32C(0x4355e69b), \
  U32C(0x4cabfa83), U32C(0x4c821f53), U32C(0xd6041118), U32C(0xd5da35e8), \
  U32C(0x3d67f656), U32C(0x3d3e1b26), U32C(0xc6c00ceb), U32C(0xc69631bb), \
  U32C(0xa491e790), U32C(0xa4680c60), U32C(0x2de9fe25), U32C(0x2dc022f5), \
  U32C(0x954de363), U32C(0x95240833), U32C(0x1ea5f9f8), U32C(0x1e7c1ec8), \
  U32C(0x27d232b0), U32C(0x27a85780), U32C(0xb12a4945), U32C(0xb1006e15), \
  U32C(0x188e2e83), U32C(0x18645353), U32C(0xa1e64518), U32C(0xa1bc69e8), \
  U32C(0x42f8937a), U32C(0x42ceb84a), U32C(0xcc50aa0f), U32C(0xcc26cedf), \
  U32C(0x33b48f4d), U32C(0x338ab41d), U32C(0xbd0ca5e2), U32C(0xbce2cab2), \
  U32C(0xc638de9a), U32C(0xc60f036a), U32C(0x4f90f52f), U32C(0x4f6719ff), \
  U32C(0xb6f4da6d), U32C(0xb6caff3d), U32C(0x404cf102), U32C(0x402315d2), \
  U32C(0xb81fe32c), U32C(0xb7f607fc), U32C(0x4177f9c1), U32C(0x414e1e91), \
  U32C(0xa8dbdeff), U32C(0xa8b203cf), U32C(0x3233f594), U32C(0x320a1a64), \
  U32C(0x3b602e4c), U32C(0x3b36531c), U32C(0xc4b844e1), U32C(0xc48e69b1), \
  U32C(0x2c1c2a1f), U32C(0x2bf24eef), U32C(0xb57440b4), U32C(0xb54a6584), \
  U32C(0x56868f16), U32C(0x565cb3e6), U32C(0xdfdea5ab), U32C(0xdfb4ca7b), \
  U32C(0x47428ae9), U32C(0x4718afb9), U32C(0xd09aa17e), U32C(0xd070c64e), \
  U32C(0xd9c6da36), U32C(0xd99cff06), U32C(0x631ef0cb), U32C(0x62f5159b), \
  U32C(0xca82d609), U32C(0xca58fad9), U32C(0x53daec9e), U32C(0x53b1116e), \
  U32C(0x31acc743), U32C(0x3182ec13), U32C(0xbb04ddd8), U32C(0xbadb02a8), \
  U32C(0x2268c316), U32C(0x223ee7e6), U32C(0xabc0d9ab), U32C(0xab96fe7b), \
  U32C(0xb4ed1263), U32C(0xb4c33733), U32C(0x3e4528f8), U32C(0x3e1b4dc8), \
  U32C(0xa5a90e36), U32C(0xa57f3306), U32C(0x2f0124cb), U32C(0x2ed7499b), \
  U32C(0xd013732d), U32C(0xcfe997fd), U32C(0x596b89c2), U32C(0x5941ae92), \
  U32C(0xc0cf6f00), U32C(0xc0a593d0), U32C(0x4a278595), U32C(0x49fdaa65), \
  U32C(0x5353be4d), U32C(0x5329e31d), U32C(0xdcabd4e2), U32C(0xdc81f9b2), \
  U32C(0x440fba20), U32C(0x43e5def0), U32C(0xcd67d0b5), U32C(0xcd3df585), \
  U32C(0xadf9192c), U32C(0xadcf3dfc), U32C(0x37512fc1), U32C(0x37275491), \
  U32C(0x9eb514ff), U32C(0x9e8b39cf), U32C(0x280d2b94), U32C(0x27e35064), \
  U32C(0x3139644c), U32C(0x310f891c), U32C(0xba917ae1), U32C(0xba679fb1), \
  U32C(0x21f5601f), U32C(0x21cb84ef), U32C(0xab4d76b4), U32C(0xab239b84), \
  U32C(0x4c5fc516), U32C(0x4c35e9e6), U32C(0xd5b7dbab), U32C(0xd58e007b), \
  U32C(0x3d1bc0e9), U32C(0x3cf1e5b9), U32C(0xc673d77e), U32C(0xc649fc4e), \
  U32C(0xcfa01036), U32C(0xcf763506), U32C(0x58f826cb), U32C(0x58ce4b9b), \
  U32C(0xc05c0c09), U32C(0xc03230d9), U32C(0x49b4229e), U32C(0x498a476e), \
  U32C(0x2785fd43), U32C(0x275c2213), U32C(0xb0de13d8), U32C(0xb0b438a8), \
  U32C(0x1841f916), U32C(0x18181de6), U32C(0xa19a0fab), U32C(0xa170347b), \
  U32C(0xaac64863), U32C(0xaa9c6d33), U32C(0x341e5ef8), U32C(0x33f483c8), \
  U32C(0x9b824436), U32C(0x9b586906), U32C(0x24da5acb), U32C(0x24b07f9b), \
  U32C(0xc5eca92d), U32C(0xc5c2cdfd), U32C(0x4f44bfc2), U32C(0x4f1ae492), \
  U32C(0xb6a8a500), U32C(0xb67ec9d0), U32C(0x4000bb95), U32C(0x3fd6e065), \
  U32C(0x492cf44d), U32C(0x4903191d), U32C(0xd2850ae2), U32C(0xd25b2fb2), \
  U32C(0x39e8f020), U32C(0x39bf14f0), U32C(0xc34106b5), U32C(0xc3172b85), \
  U32C(0x3b13f8df), U32C(0x3aea1daf), U32C(0xc46c0f74), U32C(0xc4423444), \
  U32C(0x2bcff4b2), U32C(0x2ba61982), U32C(0xb5280b47), U32C(0xb4fe3017), \
  U32C(0xbe5443ff), U32C(0xbe2a68cf), U32C(0x47ac5a94), U32C(0x47827f64), \
  U32C(0xaf103fd2), U32C(0xaee664a2), U32C(0x38685667), U32C(0x383e7b37), \
  U32C(0xd97aa4c9), U32C(0xd950c999), U32C(0x62d2bb5e), U32C(0x62a8e02e), \
  U32C(0xca36a09c), U32C(0xca0cc56c), U32C(0x538eb731), U32C(0x5364dc01), \
  U32C(0x5cbaefe9), U32C(0x5c9114b9), U32C(0xe613067e), U32C(0xe5e92b4e), \
  U32C(0x4d76ebbc), U32C(0x4d4d108c), U32C(0xd6cf0251), U32C(0xd6a52721), \
  U32C(0xb4a0dcf6), U32C(0xb47701c6), U32C(0x3df8f38b), U32C(0x3dcf185b), \
  U32C(0xa55cd8c9), U32C(0xa532fd99), U32C(0x2eb4ef5e), U32C(0x2e8b142e), \
  U32C(0x37e12816), U32C(0x37b74ce6), U32C(0xc1393eab), U32C(0xc10f637b), \
  U32C(0x289d23e9), U32C(0x287348b9), U32C(0xb1f53a7e), U32C(0xb1cb5f4e), \
  U32C(0x530788e0), U32C(0x52ddadb0), U32C(0xdc5f9f75), U32C(0xdc35c445), \
  U32C(0x43c384b3), U32C(0x4399a983), U32C(0xcd1b9b48), U32C(0xccf1c018), \
  U32C(0xd647d400), U32C(0xd61df8d0), U32C(0x5f9fea95), U32C(0x5f760f65), \
  U32C(0xc703cfd3), U32C(0xc6d9f4a3), U32C(0x505be668), U32C(0x50320b38), \
  U32C(0x66bfd8cb), U32C(0x6695fd9b), U32C(0xf017ef60), U32C(0xefee1430), \
  U32C(0x577bd49e), U32C(0x5751f96e), U32C(0xe0d3eb33), U32C(0xe0aa1003), \
  U32C(0xea0023eb), U32C(0xe9d648bb), U32C(0x73583a80), U32C(0x732e5f50), \
  U32C(0xdabc1fbe), U32C(0xda92448e), U32C(0x64143653), U32C(0x63ea5b23), \
  U32C(0x052684b5), U32C(0x04fca985), U32C(0x8e7e9b4a), U32C(0x8e54c01a), \
  U32C(0xf5e28088), U32C(0xf5b8a558), U32C(0x7f3a971d), U32C(0x7f10bbed), \
  U32C(0x8866cfd5), U32C(0x883cf4a5), U32C(0x11bee66a), U32C(0x11950b3a), \
  U32C(0x7922cba8), U32C(0x78f8f078), U32C(0x027ae23d), U32C(0x0251070d), \
  U32C(0xe04cbce2), U32C(0xe022e1b2), U32C(0x69a4d377), U32C(0x697af847), \
  U32C(0xd108b8b5), U32C(0xd0dedd85), U32C(0x5a60cf4a), U32C(0x5a36f41a), \
  U32C(0x638d0802), U32C(0x63632cd2), U32C(0xece51e97), U32C(0xecbb4367), \
  U32C(0x544903d5), U32C(0x541f28a5), U32C(0xdda11a6a), U32C(0xdd773f3a), \
  U32C(0x7eb368cc), U32C(0x7e898d9c), U32C(0x080b7f61), U32C(0x07e1a431), \
  U32C(0x6f6f649f), U32C(0x6f45896f), U32C(0xf8c77b34), U32C(0xf89da004), \
  U32C(0x01f3b3ec), U32C(0x01c9d8bc), U32C(0x8b4bca81), U32C(0x8b21ef51), \
  U32C(0xf2afafbf), U32C(0xf285d48f), U32C(0x7c07c654), U32C(0x7bddeb24), \
  U32C(0xf3dab87e), U32C(0xf3b0dd4e), U32C(0x7d32cf13), U32C(0x7d08f3e3), \
  U32C(0xe496b451), U32C(0xe46cd921), U32C(0x6deecae6), U32C(0x6dc4efb6), \
  U32C(0x771b039e), U32C(0x76f1286e), U32C(0x00731a33), U32C(0x00493f03), \
  U32C(0x67d6ff71), U32C(0x67ad2441), U32C(0xf12f1606), U32C(0xf1053ad6), \
  U32C(0x92416468), U32C(0x92178938), U32C(0x1b997afd), U32C(0x1b6f9fcd), \
  U32C(0x82fd603b), U32C(0x82d3850b), U32C(0x0c5576d0), U32C(0x0c2b9ba0), \
  U32C(0x1581af88), U32C(0x1557d458), U32C(0x9ed9c61d), U32C(0x9eafeaed), \
  U32C(0x063dab5b), U32C(0x0613d02b), U32C(0x8f95c1f0), U32C(0x8f6be6c0), \
  U32C(0x6d679c95), U32C(0x6d3dc165), U32C(0xf6bfb32a), U32C(0xf695d7fa), \
  U32C(0x5e239868), U32C(0x5df9bd38), U32C(0xe77baefd), U32C(0xe751d3cd), \
  U32C(0xf0a7e7b5), U32C(0xf07e0c85), U32C(0x79fffe4a), U32C(0x79d6231a), \
  U32C(0xe163e388), U32C(0xe13a0858), U32C(0x6abbfa1d), U32C(0x6a921eed), \
  U32C(0x0bce487f), U32C(0x0ba46d4f), U32C(0x95265f14), U32C(0x94fc83e4), \
  U32C(0xfc8a4452), U32C(0xfc606922), U32C(0x85e25ae7), U32C(0x85b87fb7), \
  U32C(0x8f0e939f), U32C(0x8ee4b86f), U32C(0x1866aa34), U32C(0x183ccf04), \
  U32C(0x7fca8f72), U32C(0x7fa0b442), U32C(0x0922a607), U32C(0x08f8cad7), \
  U32C(0x047c212f), U32C(0x045245ff), U32C(0x8dd437c4), U32C(0x8daa5c94), \
  U32C(0xf5381d02), U32C(0xf50e41d2), U32C(0x7e903397), U32C(0x7e665867), \
  U32C(0x87bc6c4f), U32C(0x8792911f), U32C(0x111482e4), U32C(0x10eaa7b4), \
  U32C(0x78786822), U32C(0x784e8cf2), U32C(0x01d07eb7), U32C(0x01a6a387), \
  U32C(0xa2e2cd19), U32C(0xa2b8f1e9), U32C(0x2c3ae3ae), U32C(0x2c11087e), \
  U32C(0x939ec8ec), U32C(0x9374edbc), U32C(0x1cf6df81), U32C(0x1ccd0451), \
  U32C(0x26231839), U32C(0x25f93d09), U32C(0xaf7b2ece), U32C(0xaf51539e), \
  U32C(0x16df140c), U32C(0x16b538dc), U32C(0xa0372aa1), U32C(0xa00d4f71), \
  U32C(0x7e090546), U32C(0x7ddf2a16), U32C(0x07611bdb), U32C(0x073740ab), \
  U32C(0x6ec50119), U32C(0x6e9b25e9), U32C(0xf81d17ae), U32C(0xf7f33c7e), \
  U32C(0x01495066), U32C(0x011f7536), U32C(0x8aa166fb), U32C(0x8a778bcb), \
  U32C(0xf2054c39), U32C(0xf1db7109), U32C(0x7b5d62ce), U32C(0x7b33879e), \
  U32C(0x1c6fb130), U32C(0x1c45d600), U32C(0xa5c7c7c5), U32C(0xa59dec95), \
  U32C(0x0d2bad03), U32C(0x0d01d1d3), U32C(0x9683c398), U32C(0x9659e868), \
  U32C(0x9faffc50), U32C(0x9f862120), U32C(0x290812e5), U32C(0x28de37b5), \
  U32C(0x906bf823), U32C(0x90421cf3), U32C(0x19c40eb8), U32C(0x199a3388), \
  U32C(0x919700e2), U32C(0x916d25b2), U32C(0x1aef1777), U32C(0x1ac53c47), \
  U32C(0x8252fcb5), U32C(0x82292185), U32C(0x0bab134a), U32C(0x0b81381a), \
  U32C(0x14d74c02), U32C(0x14ad70d2), U32C(0x9e2f6297), U32C(0x9e058767), \
  U32C(0x059347d5), U32C(0x05696ca5), U32C(0x8eeb5e6a), U32C(0x8ec1833a), \
  U32C(0x2ffdaccc), U32C(0x2fd3d19c), U32C(0xb955c361), U32C(0xb92be831), \
  U32C(0x20b9a89f), U32C(0x208fcd6f), U32C(0xaa11bf34), U32C(0xa9e7e404), \
  U32C(0xb33df7ec), U32C(0xb3141cbc), U32C(0x3c960e81), U32C(0x3c6c3351), \
  U32C(0xa3f9f3bf), U32C(0xa3d0188f), U32C(0x2d520a54), U32C(0x2d282f24), \
  U32C(0x0b23e4f9), U32C(0x0afa09c9), U32C(0x947bfb8e), U32C(0x9452205e), \
  U32C(0xfbdfe0cc), U32C(0xfbb6059c), U32C(0x8537f761), U32C(0x850e1c31), \
  U32C(0x8e643019), U32C(0x8e3a54e9), U32C(0x17bc46ae), U32C(0x17926b7e), \
  U32C(0x7f202bec), U32C(0x7ef650bc), U32C(0x08784281), U32C(0x084e6751), \
  U32C(0xa98a90e3), U32C(0xa960b5b3), U32C(0x32e2a778), U32C(0x32b8cc48), \
  U32C(0x9a468cb6), U32C(0x9a1cb186), U32C(0x239ea34b), U32C(0x2374c81b), \
  U32C(0x2ccadc03), U32C(0x2ca100d3), U32C(0xb622f298), U32C(0xb5f91768), \
  U32C(0x1d86d7d6), U32C(0x1d5cfca6), U32C(0xa6deee6b), U32C(0xa6b5133b), \
  U32C(0xbd42e0ce), U32C(0xbd19059e), U32C(0x469af763), U32C(0x46711c33), \
  U32C(0xadfedca1), U32C(0xadd50171), U32C(0x3756f336), U32C(0x372d1806), \
  U32C(0x40832bee), U32C(0x405950be), U32C(0xc9db4283), U32C(0xc9b16753), \
  U32C(0x313f27c1), U32C(0x31154c91), U32C(0xba973e56), U32C(0xba6d6326), \
  U32C(0x5ba98cb8), U32C(0x5b7fb188), U32C(0xe501a34d), U32C(0xe4d7c81d), \
  U32C(0x4c65888b), U32C(0x4c3bad5b), U32C(0xd5bd9f20), U32C(0xd593c3f0), \
  U32C(0xdee9d7d8), U32C(0xdebffca8), U32C(0x6841ee6d), U32C(0x6818133d), \
  U32C(0xcfa5d3ab), U32C(0xcf7bf87b), U32C(0x58fdea40), U32C(0x58d40f10), \
  U32C(0x36cfc4e5), U32C(0x36a5e9b5), U32C(0xc027db7a), U32C(0xbffe004a), \
  U32C(0x278bc0b8), U32C(0x2761e588), U32C(0xb0e3d74d), U32C(0xb0b9fc1d), \
  U32C(0xba101005), U32C(0xb9e634d5), U32C(0x4368269a), U32C(0x433e4b6a), \
  U32C(0xaacc0bd8), U32C(0xaaa230a8), U32C(0x3424226d), U32C(0x33fa473d), \
  U32C(0xd53670cf), U32C(0xd50c959f), U32C(0x5e8e8764), U32C(0x5e64ac34), \
  U32C(0xc5f26ca2), U32C(0xc5c89172), U32C(0x4f4a8337), U32C(0x4f20a807), \
  U32C(0x5876bbef), U32C(0x584ce0bf), U32C(0xe1ced284), U32C(0xe1a4f754), \
  U32C(0x4932b7c2), U32C(0x4908dc92), U32C(0xd28ace57), U32C(0xd260f327), \
  U32C(0x4a5dc081), U32C(0x4a33e551), U32C(0xd3b5d716), U32C(0xd38bfbe6), \
  U32C(0x3b19bc54), U32C(0x3aefe124), U32C(0xc471d2e9), U32C(0xc447f7b9), \
  U32C(0xcd9e0ba1), U32C(0xcd743071), U32C(0x56f62236), U32C(0x56cc4706), \
  U32C(0xbe5a0774), U32C(0xbe302c44), U32C(0x47b21e09), U32C(0x478842d9), \
  U32C(0xe8c46c6b), U32C(0xe89a913b), U32C(0x721c8300), U32C(0x71f2a7d0), \
  U32C(0xd980683e), U32C(0xd9568d0e), U32C(0x62d87ed3), U32C(0x62aea3a3), \
  U32C(0x6c04b78b), U32C(0x6bdadc5b), U32C(0xf55cce20), U32C(0xf532f2f0), \
  U32C(0x5cc0b35e), U32C(0x5c96d82e), U32C(0xe618c9f3), U32C(0xe5eeeec3), \
  U32C(0xc3eaa498), U32C(0xc3c0c968), U32C(0x4d42bb2d), U32C(0x4d18dffd), \
  U32C(0xb4a6a06b), U32C(0xb47cc53b), U32C(0x3dfeb700), U32C(0x3dd4dbd0), \
  U32C(0x472aefb8), U32C(0x47011488), U32C(0xd083064d), U32C(0xd0592b1d), \
  U32C(0x37e6eb8b), U32C(0x37bd105b), U32C(0xc13f0220), U32C(0xc11526f0), \
  U32C(0x62515082), U32C(0x62277552), U32C(0xeba96717), U32C(0xeb7f8be7), \
  U32C(0x530d4c55), U32C(0x52e37125), U32C(0xdc6562ea), U32C(0xdc3b87ba), \
  U32C(0xe5919ba2), U32C(0xe567c072), U32C(0x6ee9b237), U32C(0x6ebfd707), \
  U32C(0xd64d9775), U32C(0xd623bc45), U32C(0x5fa5ae0a), U32C(0x5f7bd2da), \
  U32C(0x4036f681), U32C(0x400d1b51), U32C(0xc98f0d16), U32C(0xc96531e6), \
  U32C(0x30f2f254), U32C(0x30c91724), U32C(0xba4b08e9), U32C(0xba212db9), \
  U32C(0xc37741a1), U32C(0xc34d6671), U32C(0x4ccf5836), U32C(0x4ca57d06), \
  U32C(0xb4333d74), U32C(0xb4096244), U32C(0x3d8b5409), U32C(0x3d6178d9), \
  U32C(0xde9da26b), U32C(0xde73c73b), U32C(0x67f5b900), U32C(0x67cbddd0), \
  U32C(0xcf599e3e), U32C(0xcf2fc30e), U32C(0x58b1b4d3), U32C(0x5887d9a3), \
  U32C(0x61dded8b), U32C(0x61b4125b), U32C(0xeb360420), U32C(0xeb0c28f0), \
  U32C(0x5299e95e), U32C(0x52700e2e), U32C(0xdbf1fff3), U32C(0xdbc824c3), \
  U32C(0xb9c3da98), U32C(0xb999ff68), U32C(0x431bf12d), U32C(0x42f215fd), \
  U32C(0xaa7fd66b), U32C(0xaa55fb3b), U32C(0x33d7ed00), U32C(0x33ae11d0), \
  U32C(0x3d0425b8), U32C(0x3cda4a88), U32C(0xc65c3c4d), U32C(0xc632611d), \
  U32C(0x2dc0218b), U32C(0x2d96465b), U32C(0xb7183820), U32C(0xb6ee5cf0), \
  U32C(0x582a8682), U32C(0x5800ab52), U32C(0xe1829d17), U32C(0xe158c1e7), \
  U32C(0x48e68255), U32C(0x48bca725), U32C(0xd23e98ea), U32C(0xd214bdba), \
  U32C(0xdb6ad1a2), U32C(0xdb40f672), U32C(0x64c2e837), U32C(0x64990d07), \
  U32C(0xcc26cd75), U32C(0xcbfcf245), U32C(0x557ee40a), U32C(0x555508da), \
  U32C(0xcd51d634), U32C(0xcd27fb04), U32C(0x56a9ecc9), U32C(0x56801199), \
  U32C(0xbe0dd207), U32C(0xbde3f6d7), U32C(0x4765e89c), U32C(0x473c0d6c), \
  U32C(0x50922154), U32C(0x50684624), U32C(0xd9ea37e9), U32C(0xd9c05cb9), \
  U32C(0x414e1d27), U32C(0x412441f7), U32C(0xcaa633bc), U32C(0xca7c588c), \
  U32C(0x6bb8821e), U32C(0x6b8ea6ee), U32C(0xf51098b3), U32C(0xf4e6bd83), \
  U32C(0x5c747df1), U32C(0x5c4aa2c1), U32C(0xe5cc9486), U32C(0xe5a2b956), \
  U32C(0xeef8cd3e), U32C(0xeecef20e), U32C(0x7850e3d3), U32C(0x782708a3), \
  U32C(0xdfb4c911), U32C(0xdf8aede1), U32C(0x690cdfa6), U32C(0x68e30476), \
  U32C(0x46deba4b), U32C(0x46b4df1b), U32C(0xd036d0e0), U32C(0xd00cf5b0), \
  U32C(0x379ab61e), U32C(0x3770daee), U32C(0xc0f2ccb3), U32C(0xc0c8f183), \
  U32C(0xca1f056b), U32C(0xc9f52a3b), U32C(0x53771c00), U32C(0x534d40d0), \
  U32C(0xbadb013e), U32C(0xbab1260e), U32C(0x443317d3), U32C(0x44093ca3), \
  U32C(0xe5456635), U32C(0xe51b8b05), U32C(0x6e9d7cca), U32C(0x6e73a19a), \
  U32C(0xd6016208), U32C(0xd5d786d8), U32C(0x5f59789d), U32C(0x5f2f9d6d), \
  U32C(0x6885b155), U32C(0x685bd625), U32C(0xf1ddc7ea), U32C(0xf1b3ecba), \
  U32C(0x5941ad28), U32C(0x5917d1f8), U32C(0xe299c3bd), U32C(0xe26fe88d), \
  U32C(0xf8fdb620), U32C(0xf8d3daf0), U32C(0x8255ccb5), U32C(0x822bf185), \
  U32C(0xe9b9b1f3), U32C(0xe98fd6c3), U32C(0x7311c888), U32C(0x72e7ed58), \
  U32C(0x7c3e0140), U32C(0x7c142610), U32C(0x059617d5), U32C(0x056c3ca5), \
  U32C(0x6cf9fd13), U32C(0x6cd021e3), U32C(0xf65213a8), U32C(0xf6283878), \
  U32C(0x9764620a), U32C(0x973a86da), U32C(0x20bc789f), U32C(0x20929d6f), \
  U32C(0x88205ddd), U32C(0x87f682ad), U32C(0x11787472), U32C(0x114e9942), \
  U32C(0x1aa4ad2a), U32C(0x1a7ad1fa), U32C(0xa3fcc3bf), U32C(0xa3d2e88f), \
  U32C(0x0b60a8fd), U32C(0x0b36cdcd), U32C(0x94b8bf92), U32C(0x948ee462), \
  U32C(0x728a9a37), U32C(0x7260bf07), U32C(0xfbe2b0cc), U32C(0xfbb8d59c), \
  U32C(0x6346960a), U32C(0x631cbada), U32C(0xec9eac9f), U32C(0xec74d16f), \
  U32C(0xf5cae557), U32C(0xf5a10a27), U32C(0x7f22fbec), U32C(0x7ef920bc), \
  U32C(0xe686e12a), U32C(0xe65d05fa), U32C(0x6fdef7bf), U32C(0x6fb51c8f), \
  U32C(0x10f14621), U32C(0x10c76af1), U32C(0x9a495cb6), U32C(0x9a1f8186), \
  U32C(0x01ad41f4), U32C(0x018366c4), U32C(0x8b055889), U32C(0x8adb7d59), \
  U32C(0x94319141), U32C(0x9407b611), U32C(0x1d89a7d6), U32C(0x1d5fcca6), \
  U32C(0x84ed8d14), U32C(0x84c3b1e4), U32C(0x0e45a3a9), U32C(0x0e1bc879), \
  U32C(0x861895d3), U32C(0x85eebaa3), U32C(0x0f70ac68), U32C(0x0f46d138), \
  U32C(0x76d491a6), U32C(0x76aab676), U32C(0x002ca83b), U32C(0x0002cd0b), \
  U32C(0x0958e0f3), U32C(0x092f05c3), U32C(0x92b0f788), U32C(0x92871c58), \
  U32C(0xfa14dcc6), U32C(0xf9eb0196), U32C(0x836cf35b), U32C(0x8343182b), \
  U32C(0x247f41bd), U32C(0x2455668d), U32C(0xadd75852), U32C(0xadad7d22), \
  U32C(0x153b3d90), U32C(0x15116260), U32C(0x9e935425), U32C(0x9e6978f5), \
  U32C(0xa7bf8cdd), U32C(0xa795b1ad), U32C(0x3117a372), U32C(0x30edc842), \
  U32C(0x987b88b0), U32C(0x9851ad80), U32C(0x21d39f45), U32C(0x21a9c415), \
  U32C(0xffa579ea), U32C(0xff7b9eba), U32C(0x88fd907f), U32C(0x88d3b54f), \
  U32C(0xf06175bd), U32C(0xf0379a8d), U32C(0x79b98c52), U32C(0x798fb122), \
  U32C(0x82e5c50a), U32C(0x82bbe9da), U32C(0x0c3ddb9f), U32C(0x0c14006f), \
  U32C(0x73a1c0dd), U32C(0x7377e5ad), U32C(0xfcf9d772), U32C(0xfccffc42), \
  U32C(0x9e0c25d4), U32C(0x9de24aa4), U32C(0x27643c69), U32C(0x273a6139), \
  U32C(0x8ec821a7), U32C(0x8e9e4677), U32C(0x1820383c), U32C(0x17f65d0c), \
  U32C(0x214c70f4), U32C(0x212295c4), U32C(0xaaa48789), U32C(0xaa7aac59), \
  U32C(0x12086cc7), U32C(0x11de9197), U32C(0x9b60835c), U32C(0x9b36a82c), \
  U32C(0x00000000), U32C(0x1139265e), U32C(0xb9cf4535), U32C(0xcb086b93), \
  U32C(0xe7c87f14), U32C(0xf901a572), U32C(0xa197c449), U32C(0xb2d0eaa7), \
  U32C(0xf4f855d3), U32C(0x06317c31), U32C(0xaec79b08), U32C(0xc000c166), \
  U32C(0xdcc0d4e7), U32C(0xedf9fb45), U32C(0x96901a1c), U32C(0xa7c9407a), \
  U32C(0x7c77f154), U32C(0x8db117b2), U32C(0x36473689), U32C(0x47805ce7), \
  U32C(0x64407068), U32C(0x757996c6), U32C(0x1e0fb59d), U32C(0x2f48dbfb), \
  U32C(0x71704727), U32C(0x82a96d85), U32C(0x2b3f8c5c), U32C(0x3c78b2ba), \
  U32C(0x5938c63b), U32C(0x6a71ec99), U32C(0x13080b70), U32C(0x244131ce), \
  U32C(0x46c0f13c), U32C(0x57fa179a), U32C(0x00903671), U32C(0x11c95ccf), \
  U32C(0x2e897050), U32C(0x3fc296ae), U32C(0xe858b585), U32C(0xf991dbe3), \
  U32C(0x3bb9470f), U32C(0x4cf26d6d), U32C(0xf5888c44), U32C(0x06c1b2a2), \
  U32C(0x2381c623), U32C(0x34baec81), U32C(0xdd510b58), U32C(0xee8a31b6), \
  U32C(0xc338e290), U32C(0xd47208ee), U32C(0x7d0827c5), U32C(0x8e414e23), \
  U32C(0xab0161a4), U32C(0xbc3a8802), U32C(0x64d0a6d9), U32C(0x7609cd37), \
  U32C(0xb8313863), U32C(0xc96a5ec1), U32C(0x72007d98), U32C(0x8339a3f6), \
  U32C(0x9ff9b777), U32C(0xb132ddd5), U32C(0x59c8fcac), U32C(0x6b02230a), \
  U32C(0x2d1229e6), U32C(0x3e4b5044), U32C(0xe6e16f1b), U32C(0xf81a9579), \
  U32C(0x14daa8fa), U32C(0x2613cf58), U32C(0xcea9ee2f), U32C(0xdfe3148d), \
  U32C(0x220a7fb9), U32C(0x3343a617), U32C(0xdbd9c4ee), U32C(0xed12eb4c), \
  U32C(0x09d2fecd), U32C(0x1b0c252b), U32C(0xc3a24402), U32C(0xd4db6a60), \
  U32C(0xa98a1b3a), U32C(0xbac34198), U32C(0x6359606f), U32C(0x749286cd), \
  U32C(0x91529a4e), U32C(0xa28bc0ac), U32C(0x4b21df83), U32C(0x5c5b05e1), \
  U32C(0x9e82710d), U32C(0xafbb976b), U32C(0x5851b642), U32C(0x698adca0), \
  U32C(0x864af021), U32C(0x9784167f), U32C(0x401a3556), U32C(0x51535bb4), \
  U32C(0x73d31b22), U32C(0x850c4180), U32C(0x2da26057), U32C(0x3edb86b5), \
  U32C(0x5b9b9a36), U32C(0x6cd4c094), U32C(0x156adf6b), U32C(0x26a405c9), \
  U32C(0x68cb70f5), U32C(0x7a049753), U32C(0x229ab62a), U32C(0x33d3dc88), \
  U32C(0x5093f009), U32C(0x61cd1667), U32C(0x0a63353e), U32C(0x1b9c5b9c), \
  U32C(0xf04b0c76), U32C(0x018432d4), U32C(0xaa1a51ab), U32C(0xbb537809), \
  U32C(0xd8138b8a), U32C(0xe94cb1e8), U32C(0x91e2d0bf), U32C(0xa31bf71d), \
  U32C(0xe5436249), U32C(0xf67c88a7), U32C(0x9f12a77e), U32C(0xb04bcddc), \
  U32C(0xcd0be15d), U32C(0xde4507bb), U32C(0x86db2692), U32C(0x98144cf0), \
  U32C(0xcf390000), U32C(0xe072265e), U32C(0x89084535), U32C(0x9a416b93), \
  U32C(0xb7017f14), U32C(0xc83aa572), U32C(0x70d0c449), U32C(0x8209eaa7), \
  U32C(0xc43155d3), U32C(0xd56a7c31), U32C(0x7e009b08), U32C(0x8f39c166), \
  U32C(0xabf9d4e7), U32C(0xbd32fb45), U32C(0x65c91a1c), U32C(0x7702407a), \
  U32C(0x4bb0f154), U32C(0x5cea17b2), U32C(0x05803689), U32C(0x16b95ce7), \
  U32C(0x33797068), U32C(0x44b296c6), U32C(0xed48b59d), U32C(0xfe81dbfb), \
  U32C(0x40a94727), U32C(0x51e26d85), U32C(0xfa788c5c), U32C(0x0bb1b2ba), \
  U32C(0x2871c63b), U32C(0x39aaec99), U32C(0xe2410b70), U32C(0xf37a31ce), \
  U32C(0x15f9f13c), U32C(0x2733179a), U32C(0xcfc93671), U32C(0xe1025ccf), \
  U32C(0xfdc27050), U32C(0x0efb96ae), U32C(0xb791b585), U32C(0xc8cadbe3), \
  U32C(0x0af2470f), U32C(0x1c2b6d6d), U32C(0xc4c18c44), U32C(0xd5fab2a2), \
  U32C(0xf2bac623), U32C(0x03f3ec81), U32C(0xac8a0b58), U32C(0xbdc331b6), \
  U32C(0x9271e290), U32C(0xa3ab08ee), U32C(0x4c4127c5), U32C(0x5d7a4e23), \
  U32C(0x7a3a61a4), U32C(0x8b738802), U32C(0x3409a6d9), U32C(0x4542cd37), \
  U32C(0x876a3863), U32C(0x98a35ec1), U32C(0x41397d98), U32C(0x5272a3f6), \
  U32C(0x6f32b777), U32C(0x806bddd5), U32C(0x2901fcac), U32C(0x3a3b230a), \
  U32C(0xfc4b29e6), U32C(0x0d845044), U32C(0xb61a6f1b), U32C(0xc7539579), \
  U32C(0xe413a8fa), U32C(0xf54ccf58), U32C(0x9de2ee2f), U32C(0xaf1c148d), \
  U32C(0xf1437fb9), U32C(0x027ca617), U32C(0xab12c4ee), U32C(0xbc4beb4c), \
  U32C(0xd90bfecd), U32C(0xea45252b), U32C(0x92db4402), U32C(0xa4146a60), \
  U32C(0x78c31b3a), U32C(0x89fc4198), U32C(0x3292606f), U32C(0x43cb86cd), \
  U32C(0x608b9a4e), U32C(0x71c4c0ac), U32C(0x1a5adf83), U32C(0x2b9405e1), \
  U32C(0x6dbb710d), U32C(0x7ef4976b), U32C(0x278ab642), U32C(0x38c3dca0), \
  U32C(0x5583f021), U32C(0x66bd167f), U32C(0x0f533556), U32C(0x208c5bb4), \
  U32C(0x430c1b22), U32C(0x54454180), U32C(0xfcdb6057), U32C(0x0e1486b5), \
  U32C(0x2ad49a36), U32C(0x3c0dc094), U32C(0xe4a3df6b), U32C(0xf5dd05c9), \
  U32C(0x380470f5), U32C(0x493d9753), U32C(0xf1d3b62a), U32C(0x030cdc88), \
  U32C(0x1fccf009), U32C(0x31061667), U32C(0xd99c353e), U32C(0xead55b9c), \
  U32C(0xbf840c76), U32C(0xd0bd32d4), U32C(0x795351ab), U32C(0x8a8c7809), \
  U32C(0xa74c8b8a), U32C(0xb885b1e8), U32C(0x611bd0bf), U32C(0x7254f71d), \
  U32C(0xb47c6249), U32C(0xc5b588a7), U32C(0x6e4ba77e), U32C(0x7f84cddc), \
  U32C(0x9c44e15d), U32C(0xad7e07bb), U32C(0x56142692), U32C(0x674d4cf0)
};
#endif /* ABC_WINDOW_SIZE */
