/* ecrypt-sync-ae.c */

/* *** Please do not edit this file. *** */

#include "ecrypt-sync-ae.h"

#ifdef ECRYPT_USES_DEFAULT_ALL_IN_ONE

/*
 * Default implementation of all-in-one authenticated
 * encryption/decryption of (short) packets.
 */

#ifdef ECRYPT_HAS_SINGLE_PACKET_FUNCTION

void ECRYPT_AE_process_packet(
  int action,
  ECRYPT_AE_ctx* ctx,
  const u8* iv,
  const u8* aad,
  u32 aadlen,
  const u8* input,
  u8* output,
  u32 msglen,
  u8* mac)
{
  ECRYPT_AE_ivsetup(ctx, iv);

#ifdef ECRYPT_SUPPORTS_AAD
  ECRYPT_AE_authenticate_bytes(ctx, aad, aadlen);
#endif

#ifdef ECRYPT_HAS_SINGLE_BYTE_FUNCTION
  ECRYPT_AE_process_bytes(action, ctx, input, output, msglen);
#else
  if (action == 0)
    ECRYPT_AE_encrypt_bytes(ctx, input, output, msglen);
  else
    ECRYPT_AE_decrypt_bytes(ctx, input, output, msglen);
#endif

  ECRYPT_AE_finalize(ctx, mac);
}

#else

void ECRYPT_AE_encrypt_packet(
  ECRYPT_AE_ctx* ctx,
  const u8* iv,
  const u8* aad,
  u32 aadlen,
  const u8* plaintext,
  u8* ciphertext,
  u32 msglen,
  u8* mac)
{
  ECRYPT_AE_ivsetup(ctx, iv);

#ifdef ECRYPT_SUPPORTS_AAD
  ECRYPT_AE_authenticate_bytes(ctx, aad, aadlen);
#endif

  ECRYPT_AE_encrypt_bytes(ctx, plaintext, ciphertext, msglen);
  ECRYPT_AE_finalize(ctx, mac);
}

void ECRYPT_AE_decrypt_packet(
  ECRYPT_AE_ctx* ctx,
  const u8* iv,
  const u8* aad,
  u32 aadlen,
  const u8* ciphertext,
  u8* plaintext,
  u32 msglen,
  u8* mac)
{
  ECRYPT_AE_ivsetup(ctx, iv);

#ifdef ECRYPT_SUPPORTS_AAD
  ECRYPT_AE_authenticate_bytes(ctx, aad, aadlen);
#endif

  ECRYPT_AE_decrypt_bytes(ctx, ciphertext, plaintext, msglen);
  ECRYPT_AE_finalize(ctx, mac);
}

#endif

#endif
