#include <stdio.h>
#include "heap.h"
#include "sortedpp.h"
#include "printint.h"

void nomem()
{
  fprintf(stderr,"two4: fatal: out of memory\n");
  exit(111);
}

int H = 50;
int32 *ai;
int64 *pa;

#define WRAP (0xfffffffffffffa3LL)

int64 timesmodwrap(int64 y,int64 z)
{
  int64 result = 0;

  while (y) {
    /* return (result + y * z) % WRAP */
    if (y & 1) {
      result += z; if (result >= WRAP) result -= WRAP;
    }
    y >>= 1;
    z += z; if (z >= WRAP) z -= WRAP;
  }

  return result;
}

void init()
{
  int j;
  int32 x;
  int64 y;
  struct heap_entry *h;

  ai = (int32 *) malloc(H * sizeof(int32));
  if (!ai) nomem();
  pa = (int64 *) malloc(H * sizeof(int64));
  if (!pa) nomem();
  h = (struct heap_entry *) malloc((H + 1) * sizeof(struct heap_entry));
  if (!h) nomem();

  for (j = 1;j <= H;++j) {
    x = j;
    y = timesmodwrap(x,x);
    y = timesmodwrap(y,y);
    h[j].b = x;
    h[j].sum = y;
  }

  j = H / 2 + 1;
  while (j > 1) {
    --j;
    h[0] = h[j];
    heap_permute(h,j,H);
  }

  j = H;
  while (j > 0) {
    ai[H - j] = h[1].b;
    pa[H - j] = h[1].sum;
    h[0] = h[j];
    --j;
    heap_permute(h,1,j);
  }

  free(h);
}

static int32 gcdpos(int32 a,int32 b)
{ return b ? gcdpos(b,a % b) : a; }
static int32 gcd(int32 a,int32 b)
{ if (a < 0) a = -a; if (b < 0) b = -b; return gcdpos(a,b); }

int32 mod[10] = {
  30011, 30013, 30029, 30047, 30059, 30071, 30089, 30091, 30097, 30103
} ;

void soln(int32 a,int32 b,int32 c,int32 d)
{
  int64 am;
  int64 bm;
  int64 cm;
  int64 dm;
  int i;

  if (a < b) return;
  if (c < d) return;
  if (a <= c) return;

  if (a * a * a * a + b * b * b * b != c * c * c * c + d * d * d * d) return;

  if (gcd(a,gcd(b,gcd(c,d))) != 1) return;

  for (i = 0;i < 10;++i) {
    am = a % mod[i]; am = am * am * am * am;
    bm = b % mod[i]; bm = bm * bm * bm * bm;
    cm = c % mod[i]; cm = cm * cm * cm * cm;
    dm = d % mod[i]; dm = dm * dm * dm * dm;
    if ((am + bm) % mod[i] != (cm + dm) % mod[i]) return;
  }

  printint(a); putchar(' ');
  printint(b); putchar(' ');
  printint(c); putchar(' ');
  printint(d); putchar('\n');
  fflush(stdout);
}

#define RECORD 100
static int32 record1[RECORD];
static int32 record2[RECORD];
int recordlen;

void record(int32 a,int32 b)
{
  int j;

  for (j = 0;j < recordlen;++j) {
    soln(a,b,record1[j],record2[j]);
    soln(record1[j],record2[j],a,b);
    if (a != b) {
      soln(b,a,record1[j],record2[j]);
      soln(record1[j],record2[j],b,a);
    }
    if (record1[j] != record2[j]) {
      soln(a,b,record2[j],record1[j]);
      soln(record2[j],record1[j],a,b);
      if (a != b) {
        soln(b,a,record2[j],record1[j]);
        soln(record2[j],record1[j],b,a);
      }
    }
  }

  if (recordlen == RECORD) nomem();
  record1[recordlen] = a;
  record2[recordlen] = b;
  ++recordlen;
}

static struct sortedpp ab;
static struct sortedpp ab2;

main(argc,argv)
int argc;
char **argv;
{
  int32 a;
  int32 b;
  int64 abval;
  int32 a2;
  int32 b2;
  int64 ab2val;
  int64 recordval;

  if (argc > 1) H = atoi(argv[1]);
  if (H <= 0) exit(0);

  init();

  if (!sortedpp_init(&ab,H,ai,pa,(int64) 0)) nomem();
  if (!sortedpp_init(&ab2,H,ai,pa,WRAP)) nomem();

  if (!sortedpp_next(&ab,&a,&b,&abval)) abval = -1;
  if (!sortedpp_next(&ab2,&a2,&b2,&ab2val)) ab2val = -1; else ab2val -= WRAP;

  while ((abval >= 0) && (ab2val >= 0)) {
    recordlen = 0;
    if (abval > ab2val) recordval = ab2val; else recordval = abval;

    while (abval == recordval) {
      record(a,b);
      if (!sortedpp_next(&ab,&a,&b,&abval)) { abval = -1; break; }
    }

    while (ab2val == recordval) {
      record(a2,b2);
      if (!sortedpp_next(&ab2,&a2,&b2,&ab2val)) { ab2val = -1; break; }
      ab2val -= WRAP;
    }
  }
  while (abval >= 0) {
    recordlen = 0;
    recordval = abval;

    while (abval == recordval) {
      record(a,b);
      if (!sortedpp_next(&ab,&a,&b,&abval)) exit(0);
    }
  }
  while (ab2val >= 0) {
    recordlen = 0;
    recordval = ab2val;

    while (ab2val == recordval) {
      record(a2,b2);
      if (!sortedpp_next(&ab2,&a2,&b2,&ab2val)) exit(0);
      ab2val -= WRAP;
    }
  }

  exit(0);
}
