#include <stdio.h>
#include "sortedpp.h"
#include "printint.h"
#include "printint64.h"

void nomem()
{
  fprintf(stderr,"two3p: fatal: out of memory\n");
  exit(111);
}

static int32 gcdpos(int32 a,int32 b)
{ return b ? gcdpos(b,a % b) : a; }
static int32 gcd(int32 a,int32 b)
{ if (a < 0) a = -a; if (b < 0) b = -b; return gcdpos(a,b); }

int32 *ai;
int64 *pa;

static struct sortedpp ab;

#define RECORD 100
static int32 record1[RECORD];
static int32 record2[RECORD];

int H = 50;
int len;

int best = 2;
int bestcoprime = 2;

main(argc,argv)
int argc;
char **argv;
{
  int numcoprime;
  int j;
  int32 x;
  int64 y;
  int32 a;
  int32 b;
  int64 abval;
  int64 recordval;
  int recordlen;
  int64 max;

  if (argc > 1) H = atoi(argv[1]);

  if (H <= 0) exit(0);
  len = H;

  ai = (int32 *) malloc(len * sizeof(int32));
  if (!ai) nomem();
  pa = (int64 *) malloc(len * sizeof(int64));
  if (!pa) nomem();

  for (j = 0;j < len;++j) {
    x = 1 + j;
    ai[j] = x;
    y = x; y *= x; y *= x;
    pa[j] = y;
  }

  if (!sortedpp_init(&ab,len,ai,pa,(int64) 1)) nomem();

  if (!sortedpp_next(&ab,&a,&b,&abval)) exit(0);

  max = H; max *= H; max *= H;

  for (;;) {
    if (abval > max) exit(0);

    recordval = abval;
    recordlen = 1;
    record1[0] = a;
    record2[0] = b;

    for (;;) {
      if (!sortedpp_next(&ab,&a,&b,&abval)) exit(0);
      if (abval != recordval) break;
      if (recordlen == RECORD) nomem();
      record1[recordlen] = a;
      record2[recordlen] = b;
      ++recordlen;
    }

    if (recordlen >= best) {
      best = recordlen;
      printint64(recordval);
      printf(" %d ways, positive: ",recordlen);
      for (j = 0;j < recordlen;++j) {
        a = record1[j]; b = record2[j];
        printint(a); printf(" "); printint(b); printf("  ");
      }
      printf("\n"); fflush(stdout);
    }

    if (recordlen >= bestcoprime) {
      numcoprime = 0;
      for (j = 0;j < recordlen;++j)
        if (gcd(record1[j],record2[j]) == 1)
          ++numcoprime;
      if (numcoprime >= bestcoprime) {
        bestcoprime = numcoprime;
        printint64(recordval);
        printf(" %d ways, coprime, positive: ",numcoprime);
        for (j = 0;j < recordlen;++j) {
          a = record1[j]; b = record2[j];
          if (gcd(a,b) == 1) {
            printint(a); printf(" "); printint(b); printf("  ");
          }
        }
        printf("\n"); fflush(stdout);
      }
    }
  }
}
