#include <stdio.h>
#include "printint.h"
#include "printint64.h"
#include "heap.h"

void nomem()
{
  fprintf(stderr,"two3: fatal: out of memory\n");
  exit(111);
}

static int32 gcdpos(int32 a,int32 b)
{ return b ? gcdpos(b,a % b) : a; }
static int32 gcd(int32 a,int32 b)
{ if (a < 0) a = -a; if (b < 0) b = -b; return gcdpos(a,b); }

struct heap_entry *h;
int hlen;

#define RECORD 100
static int32 record1[RECORD];
static int32 record2[RECORD];

int H = 50;

int best = 2;
int bestcoprime = 2;

void init()
{
  int j;
  int64 a;
  int64 b;

  h = (struct heap_entry *) malloc((H + 1) * sizeof(*h));
  if (!h) nomem();

  hlen = 0;
  for (j = 1;j <= H;++j) {
    ++hlen;
    b = j;
    a = (b + 1) / 2;
    h[hlen].b = b;
    h[hlen].apos = a;
    h[hlen].sum = b * (b * b + 3 * (a - b) * a);
  }

  j = hlen / 2 + 1;
  while (j > 1) {
    --j;
    h[0] = h[j];
    heap_permute(h,j,hlen);
  }
}

void next(int32 *a,int32 *b,int64 *sum)
{
  int apos;

  if (!hlen) exit(0);

  apos = h[1].apos;

  *a = apos;
  *b = h[1].b;
  *sum = h[1].sum;

  h[0].sum = h[1].sum + h[1].b * (int64) (6 * apos + 3 - 3 * h[1].b);
  h[0].apos = apos + 1;
  h[0].b = h[1].b;
  heap_permute(h,1,hlen);
}

main(argc,argv)
int argc;
char **argv;
{
  int numcoprime;
  int j;
  int32 x;
  int64 y;
  int32 a;
  int32 b;
  int64 abval;
  int64 recordval;
  int recordlen;
  int64 max;

  if (argc > 1) H = atoi(argv[1]);

  if (H <= 0) exit(0);

  init();

  next(&a,&b,&abval);

  max = H; max *= H; max *= H;
  max /= 4;

  for (;;) {
    if (abval > max) exit(0);

    recordval = abval;
    recordlen = 1;
    record1[0] = a;
    record2[0] = b;

    for (;;) {
      next(&a,&b,&abval);
      if (abval != recordval) break;
      if (recordlen == RECORD) nomem();
      record1[recordlen] = a;
      record2[recordlen] = b;
      ++recordlen;
    }

    if (recordlen >= best) {
      best = recordlen;
      printint64(recordval);
      printf(" %d ways: ",recordlen);
      for (j = 0;j < recordlen;++j) {
        a = record1[j]; b = record2[j];
        printint(a); printf(" "); printint(b - a); printf("  ");
      }
      printf("\n"); fflush(stdout);
    }
    if (recordlen >= bestcoprime) {
      numcoprime = 0;
      for (j = 0;j < recordlen;++j)
        if (gcd(record1[j],record2[j]) == 1)
          ++numcoprime;
      if (numcoprime >= bestcoprime) {
        bestcoprime = numcoprime;
        printint64(recordval);
        printf(" %d ways, coprime: ",numcoprime);
        for (j = 0;j < recordlen;++j) {
          a = record1[j]; b = record2[j];
          if (gcd(a,b) == 1) {
            printint(a); printf(" "); printint(b - a); printf("  ");
          }
        }
        printf("\n"); fflush(stdout);
      }
    }
  }
}
