#include "sortedpq.h"
#include "heap.h"

int sortedpq_init(struct sortedpq *x
  ,int alen,int32 *a,int64 *pa
  ,int blen,int32 *b,int64 *qb
  ,int64 min
)
{
  int j;
  int p;
  int q;
  int c;
  int n;
  int64 minqb;
  struct heap_entry *h;

  h = (struct heap_entry *) malloc((blen + 1) * sizeof(*h));
  if (!h) return 0;
  n = 0;

  for (j = 0;j < blen;++j) {
    minqb = min - qb[j];

    p = 0;
    q = alen;
    while (p < q) {
      c = (p + q) / 2;
      if (minqb <= pa[c]) q = c; else p = c + 1;
    }

    if (q < alen) {
      ++n;
      h[n].b = b[j];
      h[n].apos = q;
      h[n].sum = qb[j] + pa[q];
    }
  }

  x->heap = h;
  x->heaplen = n;
  x->alen = alen;
  x->a = a;
  x->pa = pa;

  j = n / 2 + 1;
  while (j > 1) {
    --j;
    h[0] = h[j];
    heap_permute(h,j,n);
  }

  return 1;
}

int sortedpq_next(struct sortedpq *x,int32 *a,int32 *b,int64 *sum)
{
  struct heap_entry *h;
  int n;
  int apos;

  n = x->heaplen;
  if (!n) return 0;
  h = x->heap;

  apos = h[1].apos;

  *a = x->a[apos];
  *b = h[1].b;
  *sum = h[1].sum;

  ++apos;
  if (apos < x->alen) {
    h[0].apos = apos;
    h[0].b = h[1].b;
    h[0].sum = (h[1].sum - x->pa[apos - 1]) + x->pa[apos];
    heap_permute(h,1,n);
    return 1;
  }

  h[0] = h[n];
  --n;
  x->heaplen = n;
  heap_permute(h,1,n);
  return 1;
}
