#include "sortedpq.h"
#include "solvepqrs.h"

#define RECORD 100
static int32 record1[RECORD];
static int32 record2[RECORD];

static struct sortedpq ab;
static struct sortedpq cd;

int solvepqrs(
  int alen,int32 *ai,int64 *pa,
  int blen,int32 *bi,int64 *qb,
  int clen,int32 *ci,int64 *rc,
  int dlen,int32 *di,int64 *sd,
  int64 min,
  void (*soln)(int32,int32,int32,int32))
{
  int32 a;
  int32 b;
  int32 c;
  int32 d;
  int64 abval;
  int64 cdval;
  int64 recordval;
  int recordlen;
  int j;

  if (!sortedpq_init(&ab,alen,ai,pa,blen,bi,qb,min)) return -1;
  if (!sortedpq_init(&cd,clen,ci,rc,dlen,di,sd,min)) return -1;

  if (!sortedpq_next(&ab,&a,&b,&abval)) return 0;
  if (!sortedpq_next(&cd,&c,&d,&cdval)) return 0;

  for (;;) {
    while (cdval < abval)
      if (!sortedpq_next(&cd,&c,&d,&cdval)) return 0;
    if (cdval > abval) {
      if (!sortedpq_next(&ab,&a,&b,&abval)) return 0;
      continue;
    }

    recordlen = 0;
    recordval = abval;
    do {
      if (recordlen == RECORD) return -1;
      record1[recordlen] = c;
      record2[recordlen] = d;
      ++recordlen;

      if (!sortedpq_next(&cd,&c,&d,&cdval)) {
        do {
          for (j = 0;j < recordlen;++j)
	    soln(a,b,record1[j],record2[j]);
          if (!sortedpq_next(&ab,&a,&b,&abval)) return 0;
        } while (abval == recordval);
	return 0;
      }
    } while (cdval == recordval);

    do {
      for (j = 0;j < recordlen;++j)
	soln(a,b,record1[j],record2[j]);
      if (!sortedpq_next(&ab,&a,&b,&abval)) return 0;
    } while (abval == recordval);
  }
}
