#include "sortedpq.h"
#include "solvepqpq.h"

#define RECORD 100
static int32 record1[RECORD];
static int32 record2[RECORD];

static struct sortedpq ab;

int solvepqpq(
  int alen,int32 *ai,int64 *pa,
  int blen,int32 *bi,int64 *qb,
  int64 min,
  void (*soln)(int32,int32,int32,int32))
{
  int32 a;
  int32 b;
  int64 abval;
  int64 recordval;
  int recordlen;
  int j;

  if (!sortedpq_init(&ab,alen,ai,pa,blen,bi,qb,min)) return -1;

  if (!sortedpq_next(&ab,&a,&b,&abval)) return 0;

  for (;;) {
    recordval = abval;
    recordlen = 1;
    record1[0] = a;
    record2[0] = b;

    for (;;) {
      if (!sortedpq_next(&ab,&a,&b,&abval)) return 0;
      if (abval != recordval) break;

      for (j = 0;j < recordlen;++j) {
	soln(a,b,record1[j],record2[j]);
	soln(record1[j],record2[j],a,b);
      }

      if (recordlen == RECORD) return -1;
      record1[recordlen] = a;
      record2[recordlen] = b;
      ++recordlen;
    }
  }
}
