#include "sortedpp.h"
#include "solvepprr.h"

#define RECORD 100
static int32 record1[RECORD];
static int32 record2[RECORD];

static struct sortedpp ab;
static struct sortedpp cd;

int solvepprr(
  int alen,int32 *ai,int64 *pa,
  int clen,int32 *ci,int64 *rc,
  int64 min,
  void (*soln)(int32,int32,int32,int32))
{
  int32 a;
  int32 b;
  int32 c;
  int32 d;
  int64 abval;
  int64 cdval;
  int64 recordval;
  int recordlen;
  int j;

  if (!sortedpp_init(&ab,alen,ai,pa,min)) return -1;
  if (!sortedpp_init(&cd,clen,ci,rc,min)) return -1;

  if (!sortedpp_next(&ab,&a,&b,&abval)) return 0;
  if (!sortedpp_next(&cd,&c,&d,&cdval)) return 0;

  for (;;) {
    while (cdval < abval)
      if (!sortedpp_next(&cd,&c,&d,&cdval)) return 0;
    if (cdval > abval) {
      if (!sortedpp_next(&ab,&a,&b,&abval)) return 0;
      continue;
    }

    recordlen = 0;
    recordval = abval;
    do {
      if (recordlen == RECORD) return -1;
      record1[recordlen] = c;
      record2[recordlen] = d;
      ++recordlen;

      if (!sortedpp_next(&cd,&c,&d,&cdval)) {
        do {
          for (j = 0;j < recordlen;++j) {
	    soln(a,b,record1[j],record2[j]);
            if (record1[j] != record2[j])
	      soln(a,b,record2[j],record1[j]);
	    if (a != b) {
	      soln(b,a,record1[j],record2[j]);
	      if (record1[j] != record2[j])
	        soln(b,a,record2[j],record1[j]);
	    }
	  }
          if (!sortedpp_next(&ab,&a,&b,&abval)) return 0;
        } while (abval == recordval);
	return 0;
      }
    } while (cdval == recordval);

    do {
      for (j = 0;j < recordlen;++j) {
        soln(a,b,record1[j],record2[j]);
        if (record1[j] != record2[j])
          soln(a,b,record2[j],record1[j]);
        if (a != b) {
          soln(b,a,record1[j],record2[j]);
          if (record1[j] != record2[j])
            soln(b,a,record2[j],record1[j]);
	}
      }
      if (!sortedpp_next(&ab,&a,&b,&abval)) return 0;
    } while (abval == recordval);
  }
}
