#include "sortedpp.h"
#include "solvepppp.h"

#define RECORD 100
static int32 record1[RECORD];
static int32 record2[RECORD];

static struct sortedpp ab;

int solvepppp(
  int alen,int32 *ai,int64 *pa,
  int64 min,
  void (*soln)(int32,int32,int32,int32))
{
  int32 a;
  int32 b;
  int64 abval;
  int64 recordval;
  int recordlen;
  int j;

  if (!sortedpp_init(&ab,alen,ai,pa,min)) return -1;

  if (!sortedpp_next(&ab,&a,&b,&abval)) return 0;

  for (;;) {
    recordval = abval;
    recordlen = 1;
    record1[0] = a;
    record2[0] = b;

    for (;;) {
      if (!sortedpp_next(&ab,&a,&b,&abval)) return 0;
      if (abval != recordval) break;

      for (j = 0;j < recordlen;++j) {
	soln(a,b,record1[j],record2[j]);
	soln(record1[j],record2[j],a,b);
	if (a != b) {
	  soln(b,a,record1[j],record2[j]);
	  soln(record1[j],record2[j],b,a);
	}
	if (record1[j] != record2[j]) {
	  soln(a,b,record2[j],record1[j]);
	  soln(record2[j],record1[j],a,b);
	  if (a != b) {
	    soln(b,a,record2[j],record1[j]);
	    soln(record2[j],record1[j],b,a);
	  }
	}
      }

      if (recordlen == RECORD) return -1;
      record1[recordlen] = a;
      record2[recordlen] = b;
      ++recordlen;
    }
  }
}
