#ifndef HEAP_H
#define HEAP_H

#include "int32.h"
#include "int64.h"

struct heap_entry {
  int apos;
  int32 b;
  int64 sum;
} ;

/* insert h[0], delete h[j] */
static inline void heap_permute(struct heap_entry *h,int j,int n)
{
  int p;
  int q;

  q = j;

  while ((p = q << 1) < n) {
    if (h[p + 1].sum < h[p].sum) ++p;
    h[q] = h[p]; q = p;
  }
  if (p == n) {
    h[q] = h[p]; q = p;
  }
  while ((q > j) && (h[0].sum < h[p = q >> 1].sum)) {
    h[q] = h[p]; q = p;
  }
  h[q] = h[0];
}

#endif
