#include <stdio.h>
#include "heap.h"
#include "sortedpp.h"
#include "printint.h"

void nomem()
{
  fprintf(stderr,"four7p: fatal: out of memory\n");
  exit(111);
}

void soln(int32 xy1,int32 xy2,int32 xy3,int32 xy4)
{
  printint(xy1 >> 16); putchar(' ');
  printint(xy1 & 65535); putchar(' ');
  printint(xy2 >> 16); putchar(' ');
  printint(xy2 & 65535); putchar(' ');
  printint(xy3 >> 16); putchar(' ');
  printint(xy3 & 65535); putchar(' ');
  printint(xy4 >> 16); putchar(' ');
  printint(xy4 & 65535); putchar('\n');
  fflush(stdout);
}

#define M 155
#define MM2 (M * (M+1) / 2)
#define MAX (M * (M * (M * (M * (M * (M * (unsigned long long) M))))))

int32 *x;
int64 *x7;

int32 *xy;
int64 *x7y7;

struct sortedpp xyqueue;

struct heap_entry *ab; int ablen = 0;

#define RECORD 100
static int32 record1[RECORD];
static int32 record2[RECORD];

main()
{
  int i;
  int64 z;
  int32 t1;
  int32 t2;
  int32 b;
  int64 abval;
  int64 recordval;
  int recordlen;
  int j;

  x = (int32 *) malloc(M * sizeof(int32));
  if (!x) nomem();
  x7 = (int64 *) malloc(M * sizeof(int64));
  if (!x7) nomem();
  xy = (int32 *) malloc(MM2 * sizeof(int32));
  if (!xy) nomem();
  x7y7 = (int64 *) malloc(MM2 * sizeof(int64));
  if (!x7y7) nomem();
  ab = (struct heap_entry *) malloc((MM2 + 1) * sizeof(struct heap_entry));
  if (!ab) nomem();

  for (i = 0;i < M;++i) {
    z = i + 1;
    x[i] = z;
    x7[i] = z * z * z * z * z * z * z;
  }


  if (!sortedpp_init(&xyqueue,M,x,x7,(int64) 0)) nomem();

  for (i = 0;i < MM2;++i) {
    if (!sortedpp_next(&xyqueue,&t1,&t2,&x7y7[i])) nomem();
    xy[i] = (t1 << 16) + t2;
  }

  if (sortedpp_next(&xyqueue,&t1,&t2,&z)) nomem();
  free(xyqueue.heap);

  for (i = 0;i < MM2;++i)
    for (j = i;j < MM2;++j)
      if ((xy[j] & 65535) >= (xy[i] >> 16)) {
        ++ablen;
        ab[ablen].apos = j;
        ab[ablen].b = xy[i];
        ab[ablen].sum = x7y7[j] + x7y7[i];
	break;
      }

  j = ablen / 2 + 1;
  while (j > 1) {
    --j;
    ab[0] = ab[j];
    heap_permute(ab,j,ablen);
  }

  recordval = 0;
  recordlen = 0;

  while (ablen) {
    abval = ab[1].sum;
    if (abval > MAX) break;
    b = ab[1].b;
    j = ab[1].apos;

    if (abval == recordval) {
      for (j = 0;j < recordlen;++j)
	soln(xy[ab[1].apos],b,record1[j],record2[j]);
      if (recordlen == RECORD) nomem();
      record1[recordlen] = xy[j];
      record2[recordlen] = b;
      ++recordlen;
    }
    else {
      recordval = abval;
      record1[0] = xy[j];
      record2[0] = b;
      recordlen = 1;
    }

    t1 = b >> 16;
    abval -= x7y7[j];

    for (;;) {
      if (++j >= MM2) {
        ab[0] = ab[ablen];
        --ablen;
	break;
      }
      if ((xy[j] & 65535) >= t1) {
	ab[0].apos = j;
	ab[0].b = b;
	ab[0].sum = abval + x7y7[j];
	break;
      }
    }

    heap_permute(ab,1,ablen);
  }

  exit(0);
}
