#include <stdio.h>
#include "heap.h"

void nomem()
{
  fprintf(stderr,"euler4: fatal: out of memory\n");
  exit(111);
}

#define WRAP (0xfffffffffffffa3LL)

int64 timesmodwrap(int64 y,int64 z)
{
  int64 result = 0;

  while (y) {
    /* return (result + y * z) % WRAP */
    if (y & 1) {
      result += z; if (result >= WRAP) result -= WRAP;
    }
    y >>= 1;
    z += z; if (z >= WRAP) z -= WRAP;
  }

  return result;
}

static int32 gcdpos(int32 a,int32 b)
{ return b ? gcdpos(b,a % b) : a; }
static int32 gcd(int32 a,int32 b)
{ if (a < 0) a = -a; if (b < 0) b = -b; return gcdpos(a,b); }

int32 mod[10] = {
  30011, 30013, 30029, 30047, 30059, 30071, 30089, 30091, 30097, 30103
} ;

void soln(int32 a,int32 b,int32 c,int32 d)
{
  int64 am;
  int64 bm;
  int64 cm;
  int64 dm;
  int i;

  if (a * a * a * a + b * b * b * b + c * c * c * c != d * d * d * d) return;

  if (gcd(a,gcd(b,gcd(c,d))) != 1) return;

  for (i = 0;i < 10;++i) {
    am = a % mod[i]; am = am * am * am * am;
    bm = b % mod[i]; bm = bm * bm * bm * bm;
    cm = c % mod[i]; cm = cm * cm * cm * cm;
    dm = d % mod[i]; dm = dm * dm * dm * dm;
    if ((am + bm + cm) % mod[i] != (dm) % mod[i]) return;
  }

  printint(a); putchar(' ');
  printint(b); putchar(' ');
  printint(c); putchar(' ');
  printint(d); putchar('\n');
  fflush(stdout);
}

void reversesort(struct heap_entry *h,int n)
{
  int j;

  j = n / 2 + 1;
  while (j > 1) {
    --j;
    h[0] = h[j];
    heap_permute(h,j,n);
  }

  while (n > 1) {
    h[0] = h[n];
    h[n] = h[1];
    --n;
    heap_permute(h,1,n);
  }
}

int H = 100;

struct heap_entry *ab;
struct heap_entry *cd;
int32 *eight; int eightlen;
int64 *eightfourth;
int32 *odd; int oddlen;
int *oddlink;
int64 *oddfourth;

void init()
{
  int j;
  int i;
  int32 x;
  int64 y;

  j = 0;
  for (x = 1;x <= H;x += 2) {
    y = timesmodwrap(x,x);
    y = timesmodwrap(y,y);
    ++j;
    cd[j].b = x;
    cd[j].sum = y;
  }

  reversesort(cd,j);

  while (j > 0) {
    odd[oddlen] = cd[j].b;
    oddfourth[oddlen] = cd[j].sum;
    ++oddlen;
    --j;
  }

  j = 0;
  for (x = 8;x <= H;x += 8) {
    y = timesmodwrap(x,x);
    y = timesmodwrap(y,y);
    ++j;
    cd[j].b = x;
    cd[j].sum = y;
  }

  reversesort(cd,j);

  while (j > 0) {
    eight[eightlen] = cd[j].b;
    eightfourth[eightlen] = cd[j].sum;
    ++eightlen;
    --j;
  }
   
  for (j = 0;j < oddlen;++j) {
    oddlink[j] = -1;
    for (i = j - 1;i >= 0;--i) {
      if (!((odd[j] + odd[i]) & 1023)) {
        oddlink[j] = i;
        break;
      }
      if (!((odd[j] - odd[i]) & 1023)) {
        oddlink[j] = i;
        break;
      }
    }
  }
}

int ablen;
int cdlen;

void setupab(int64 carry)
{
  int i;
  int j;
  int64 z;
  int32 d;
  int n;

  n = 0;
  for (j = 0;j < eightlen;++j)
    if (!(eight[j] % 5))
      for (i = 0;i < eightlen;++i) {
	z = eightfourth[i] + eightfourth[j] - carry;
	if (z > -WRAP) {
          ++n;
          ab[n].b = eight[j];
          ab[n].apos = i;
          ab[n].sum = z;
	  break;
        }
      }
  j = n / 2 + 1;
  while (j > 1) {
    --j;
    ab[0] = ab[j];
    heap_permute(ab,j,n);
  }
  ablen = n;
}

void setupcd(int64 carry)
{
  int i;
  int j;
  int32 d;
  int n;

  n = 0;
  for (j = 0;j < oddlen;++j) {
    d = odd[j];
    if ((d % 5) && ((d % 8) == 1)) {
      for (i = oddlen - 1;i >= 0;--i)
	if (!((d + odd[i]) & 1023) || !((d - odd[i]) & 1023))
	  break;
      while (i >= 0) {
	if (odd[i] < d) {
          ++n;
          cd[n].b = d;
          cd[n].apos = i;
          cd[n].sum = oddfourth[j] - oddfourth[i];
          break;
	}
	i = oddlink[i];
      }
    }
  }
  j = n / 2 + 1;
  while (j > 1) {
    --j;
    cd[0] = cd[j];
    heap_permute(cd,j,n);
  }
  cdlen = n;
}

void doit(int64 carry)
{
  int j;
  int64 cdval;
  int64 z;

  setupab(carry);
  setupcd(carry);

  while (cdlen) {
    cdval = cd[1].sum;


    for (;;) {
      if (!ablen) return;
      z = ab[1].sum;
      if (z > cdval) break;

      if (z == cdval)
	soln(eight[ab[1].apos],ab[1].b,odd[cd[1].apos],cd[1].b);
	/* assuming user can handle transitivity */

      j = ab[1].apos;
      if (++j >= eightlen) {
        ab[0] = ab[ablen];
        --ablen;
      }
      else {
        ab[0].apos = j;
        ab[0].b = ab[1].b;
        ab[0].sum = (z - eightfourth[j - 1]) + eightfourth[j];
      }
      heap_permute(ab,1,ablen);
    }


    j = cd[1].apos;
    z = cdval + oddfourth[j];
    for (;;) {
      j = oddlink[j];
      if (j < 0) {
        cd[0] = cd[cdlen];
        --cdlen;
	break;
      }
      if (odd[j] < cd[1].b) {
        z -= oddfourth[j];
        cd[0].apos = j;
        cd[0].b = cd[1].b;
        cd[0].sum = z;
	break;
      }
    }
    heap_permute(cd,1,cdlen);
  }
}

main(int argc,char **argv)
{
  char *x;
  int len;

  if (argv[1]) H = atoi(argv[1]);
  if (H <= 0) exit(0);

  len = (H/40 + 8) * sizeof(struct heap_entry)
      + (H/2 + 8) * sizeof(struct heap_entry)
      + (H/8 + 8) * sizeof(int64)
      + (H/2 + 8) * sizeof(int64)
      + (H/8 + 8) * sizeof(int32)
      + (H/2 + 8) * sizeof(int32)
      + (H/2 + 8) * sizeof(int)
      ;
  x = (char *) malloc(len);
  if (!x) nomem();

  ab = (struct heap_entry *) x;
  x += (H/40 + 8) * sizeof(struct heap_entry);
  cd = (struct heap_entry *) x;
  x += (H/2 + 8) * sizeof(struct heap_entry);
  eightfourth = (int64 *) x;
  x += (H/8 + 8) * sizeof(int64);
  oddfourth = (int64 *) x;
  x += (H/2 + 8) * sizeof(int64);
  eight = (int32 *) x;
  x += (H/8 + 8) * sizeof(int32);
  odd = (int32 *) x;
  x += (H/2 + 8) * sizeof(int32);
  oddlink = (int *) x;

  init();

  doit(2 * WRAP);
  doit(WRAP);
  doit(0);

  exit(0);
}
