#include <stdio.h>
#include "cube.h"
#include "printint.h"

void nomem()
{
  fprintf(stderr,"cube: fatal: out of memory\n");
  exit(111);
}
void die_positive()
{
  fprintf(stderr,"cube: fatal: coefficients must be positive\n");
  exit(100);
}

int p = 1;
int q = 1;
int r = 1;
int s = 1;
int H = 50;
int len;

void cubeargs(char **argv,int argc,int argp,int argq,int argr,int args,int argH)
{
  if (argp < argc) p = atoi(argv[argp]);
  if (argq < argc) q = atoi(argv[argq]);
  if (argr < argc) r = atoi(argv[argr]);
  if (args < argc) s = atoi(argv[args]);
  if (argH < argc) H = atoi(argv[argH]);

  if (p <= 0) die_positive();
  if (q <= 0) die_positive();
  if (r <= 0) die_positive();
  if (s <= 0) die_positive();

  if (H <= 0) H = 0;
  len = H + H + 1;

  /* XXX: check for overflow in possible outputs */
}

void cube(a,pa,n)
int32 **a;
int64 **pa;
int n;
{
  int j;
  int32 x;
  int64 y;

  *a = (int32 *) malloc(len * sizeof(int32));
  if (!*a) nomem();
  *pa = (int64 *) malloc(len * sizeof(int64));
  if (!*pa) nomem();

  for (j = 0;j < len;++j) {
    x = -H + j;
    (*a)[j] = x;
    y = n; y *= x; y *= x; y *= x;
    (*pa)[j] = y;
  }
}

static int32 gcdpos(int32 a,int32 b)
{ return b ? gcdpos(b,a % b) : a; }
static int32 gcd(int32 a,int32 b)
{ if (a < 0) a = -a; if (b < 0) b = -b; return gcdpos(a,b); }

void cubesoln(int32 a,int32 b,int32 c,int32 d)
{
  int32 h;
  int64 u;
  int64 v;

  if ((p != r) || (p != s)) { /* XXX: skip if possible */
    u = p; u *= a; u *= a; u *= a;
  }

  if (p == r) if (a == c) return;
  if (p != r) { /* XXX: skip unless p/r and q/s are cubes */
    v = r; v *= c; v *= c; v *= c;
    if (u == v) return;
  }

  if (p == s) if (a == d) return;
  if (p != s) { /* XXX: skip unless p/s and q/r are cubes */
    v = s; v *= d; v *= d; v *= d;
    if (u == v) return;
  }

  if (gcd(a,gcd(b,gcd(c,d))) != 1) return;

  if (a > 0) h = a; else h = -a;
  if (b > h) h = b; else if (-b > h) h = -b;
  if (c > h) h = c; else if (-c > h) h = -c;
  if (d > h) h = d; else if (-d > h) h = -d;

  printint(h); putchar(' ');
  printint(a); putchar(' ');
  printint(b); putchar(' ');
  printint(c); putchar(' ');
  printint(d); putchar('\n');
}
