#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <gmp.h>
#include "alloc.h"
#include "byte.h"
#include "error.h"
#include "uint32.h"
#include "mpz_words.h"
#include "reduce.h"

void usage()
{
  fprintf(stderr,"verify: usage: verify judgefile publicfile sigfile\n");
  exit(100);
}
void nomem()
{
  fprintf(stderr,"verify: fatal: out of memory\n");
  exit(111);
}
void die_read(fn)
char *fn;
{
  fprintf(stderr,"verify: fatal: unable to read %s: %s\n",fn,error_str(errno));
  exit(111);
}

unsigned char pi[32] = {
  3,1,4,1,5,9,2,6,5,3,5,8,9,7,9,3,2,3,8,4,6,2,6,4,3,3,8,3,2,7,9,5
} ;

unsigned char *nbytes;
unsigned char *hbytes;
unsigned char *sbytes;
unsigned char *tbytes;
int flagminus;
int flagdouble;

unsigned char pbytes[12];
uint32 pwords[3];

uint32 x[4];

void main(argc,argv)
int argc;
char **argv;
{
  char *fnpublic;
  char *fnsig;
  char *fnjudge;
  FILE *fi;
  int c;
  mpz_t nmodp;
  mpz_t hmodp;
  mpz_t smodp;
  mpz_t tmodp;
  mpz_t p;
  struct timeval tv0;
  struct timeval tv1;
  int loop;
  int nlen;

  mpz_init(p);
  mpz_init(nmodp);
  mpz_init(hmodp);
  mpz_init(smodp);
  mpz_init(tmodp);

  fnjudge = argv[1];
  if (!fnjudge) usage();
  fnpublic = argv[2];
  if (!fnpublic) usage();
  fnsig = argv[3];
  if (!fnsig) usage();

  fi = fopen(fnjudge,"r");
  if (!fi) die_read(fnjudge);
  if (fread(pbytes,1,12,fi) != 12) die_read(fnjudge);
  fclose(fi);

  pwords[2] = pbytes[11];
  pwords[2] <<= 8;
  pwords[2] += pbytes[10];
  pwords[2] <<= 8;
  pwords[2] += pbytes[9];
  pwords[2] <<= 8;
  pwords[2] += pbytes[8];
  pwords[1] = pbytes[7];
  pwords[1] <<= 8;
  pwords[1] += pbytes[6];
  pwords[1] <<= 8;
  pwords[1] += pbytes[5];
  pwords[1] <<= 8;
  pwords[1] += pbytes[4];
  pwords[0] = pbytes[3];
  pwords[0] <<= 8;
  pwords[0] += pbytes[2];
  pwords[0] <<= 8;
  pwords[0] += pbytes[1];
  pwords[0] <<= 8;
  pwords[0] += pbytes[0];

  mpz_set_ui(p,0);
  mpz_add_ui(p,p,pwords[2]);
  mpz_mul_2exp(p,p,32);
  mpz_add_ui(p,p,pwords[1]);
  mpz_mul_2exp(p,p,32);
  mpz_add_ui(p,p,pwords[0]);
  mpz_mul_2exp(p,p,32);
  mpz_sub_ui(p,p,1);

  fi = fopen(fnpublic,"r");
  if (!fi) die_read(fnpublic);

  c = getc(fi);
  if (c == EOF) die_read(fnpublic);
  nlen = (unsigned long) (unsigned char) c;

  nbytes = alloc(nlen * 8);
  if (!nbytes) nomem();
  hbytes = alloc(nlen * 8);
  if (!hbytes) nomem();
  sbytes = alloc(nlen * 8);
  if (!sbytes) nomem();
  tbytes = alloc(nlen * 8);
  if (!tbytes) nomem();

  if (fread(nbytes,1,nlen * 8,fi) != nlen * 8) die_read(fnpublic);
  fclose(fi);

  byte_zero(hbytes,nlen * 8);
  hbytes[0] = 1;
  byte_copy(hbytes + 48,32,pi);

  fi = fopen(fnsig,"r");
  if (!fi) die_read(fnsig);
  getc(fi);
  if (fread(hbytes + 16,1,32,fi) != 32) die_read(fnsig);
  flagminus = (getc(fi) == '-');
  flagdouble = (getc(fi) == '2');
  if (fread(sbytes,1,nlen * 8,fi) != nlen * 8) die_read(fnsig);
  if (fread(tbytes,1,nlen * 8,fi) != nlen * 8) die_read(fnsig);
  fclose(fi);


  gettimeofday(&tv0,(struct timezone *) 0);

  for (loop = 0;loop < 100;++loop) {
    reduce(nbytes,nlen * 2,x,pwords[0],pwords[1],pwords[2]);
    mpz_words(nmodp,x,4);
    reduce(sbytes,nlen * 2,x,pwords[0],pwords[1],pwords[2]);
    mpz_words(smodp,x,4);
    reduce(tbytes,nlen * 2,x,pwords[0],pwords[1],pwords[2]);
    mpz_words(tmodp,x,4);
    reduce(hbytes,nlen * 2,x,pwords[0],pwords[1],pwords[2]);
    mpz_words(hmodp,x,4);

    if (flagminus)
      mpz_neg(hmodp,hmodp);
    if (flagdouble)
      mpz_add(hmodp,hmodp,hmodp);

    mpz_mul(smodp,smodp,smodp);
    mpz_mul(tmodp,tmodp,nmodp);
    mpz_sub(smodp,smodp,tmodp);
    mpz_sub(smodp,smodp,hmodp);
    mpz_mod(smodp,smodp,p);
  }

  gettimeofday(&tv1,(struct timezone *) 0);


  if (mpz_sgn(smodp) != 0) {
    fprintf(stderr,"verify: fatal: signature is invalid\n");
    exit(100);
  }
  fprintf(stderr,"verify: info: 100x verification took %d microseconds\n"
    ,(tv1.tv_sec - tv0.tv_sec) * 1000000 + tv1.tv_usec - tv0.tv_usec);
  exit(0);
}
