#include <stdio.h>
#include <gmp.h>
#include "uint64.h"
#include "prime.h"
#include "alloc.h"

void nomem()
{
  fprintf(stderr,"secretkey: fatal: out of memory\n");
  exit(111);
}
void eof()
{
  fprintf(stderr,"secretkey: fatal: not enough input\n");
  exit(100);
}
void usage()
{
  fprintf(stderr,"secretkey: usage: secretkey bits\nbits must be at least 800\n");
  exit(100);
}

static unsigned char x;
static int pos = 0;

int randombit()
{
  int c;
  if (!pos) {
    c = getchar();
    if (c == EOF) eof();
    x = c;
    pos = 8;
  }
  c = x & 1;
  x >>= 1;
  --pos;
  return c;
}

char *qbits;
int qlen;
char *rbits;
int rlen;

void main(argc,argv)
int argc;
char **argv;
{
  mpz_t q;
  mpz_t r;
  mpz_t x;
  mpz_t y;
  mpz_t g;
  int i;
  int keylen;
  uint64 u;
  uint64 v;

  mpz_init(q);
  mpz_init(r);
  mpz_init(x);
  mpz_init(y);
  mpz_init(g);

  if (!argv[1]) usage();
  keylen = atoi(argv[1]);
  if (keylen < 800) usage();

  qlen = keylen / 2;
  rlen = keylen + 1 - qlen;
  qbits = alloc(qlen + 1);
  rbits = alloc(rlen + 1);

  if (!qbits || !rbits) nomem();

  qbits[0] = '1';
  qbits[1] = '0';
  qbits[2] = '0';
  qbits[qlen - 3] = '0';
  qbits[qlen - 2] = '1';
  qbits[qlen - 1] = '1';
  qbits[qlen] = 0;

  for (;;) {
    for (i = 3;i < qlen - 3;++i)
      qbits[i] = '0' + randombit();
    mpz_set_str(q,qbits,2);
    i = mpz_prime(q);
    if (i == -1) nomem();
    if (i == 1) {
      mpz_out_raw(stdout,q);
      break;
    }
  }

  u = 0;
  for (i = qlen - 64;i < qlen;++i)
    u = u * 2 + (qbits[i] - '0');

  v = u;
  for (i = 0;i < 64;++i) { v *= v; v *= u; } /* actually 61 should be enough */
  v *= 0x55555555;

  i = rlen;
  do {
    rbits[--i] = '0' + (v & 1);
    v >>= 1;
  }
  while (i != rlen - 64);


  rbits[0] = '1';
  rbits[1] = '0';
  rbits[2] = '0';
  rbits[rlen] = 0;

  for (;;) {
    for (i = 3;i < rlen - 64;++i)
      rbits[i] = '0' + randombit();
    mpz_set_str(r,rbits,2);
    i = mpz_prime(r);
    if (i == -1) nomem();
    if (i == 1) {
      mpz_out_raw(stdout,r);
      break;
    }
  }

  mpz_gcdext(g,x,y,q,r);
  mpz_out_raw(stdout,x);
  mpz_out_raw(stdout,y);

  exit(0);
}
