#include <stdio.h>
#include <gmp.h>
#include "prime.h"
#include "alloc.h"

void nomem()
{
  fprintf(stderr,"secretjudge: fatal: out of memory\n");
  exit(111);
}
void eof()
{
  fprintf(stderr,"secretjudge: fatal: not enough input\n");
  exit(100);
}

static unsigned char x;
static int pos = 0;

int randombit()
{
  int c;
  if (!pos) {
    c = getchar();
    if (c == EOF) eof();
    x = c;
    pos = 8;
  }
  c = x & 1;
  x >>= 1;
  --pos;
  return c;
}

char qbits[129];

void main(argc,argv)
int argc;
char **argv;
{
  mpz_t q;
  mpz_t r;
  int i;

  mpz_init(q);
  mpz_init(r);

  qbits[0] = '1';
  for (i = 0;i < 32;++i)
    qbits[128 - 32 + i] = '1';
  qbits[128] = 0;

  for (;;) {
    for (i = 1;i < 128 - 32;++i)
      qbits[i] = '0' + randombit();
    mpz_set_str(q,qbits,2);
    i = mpz_prime(q);
    if (i == -1) nomem();
    if (i == 1) {
      mpz_add_ui(q,q,1);
      mpz_tdiv_q_2exp(q,q,32);
      for (i = 0;i < 12;++i) {
	putchar(mpz_get_ui(q));
	mpz_tdiv_q_2exp(q,q,8);
      }
      exit(0);
    }
  }
}
