#include <stdio.h>
#include <gmp.h>

void main()
{
  mpz_t q;
  mpz_t r;
  mpz_t n;
  int nlen;
  int i;

  mpz_init(q);
  mpz_init(r);
  mpz_init(n);
  if (mpz_inp_raw(q,stdin) == 0) exit(1);
  if (mpz_inp_raw(r,stdin) == 0) exit(1);

  mpz_mul(n,q,r);
  nlen = (mpz_sizeinbase(n,2) + 63) / 64;

  putchar(nlen);

  for (i = 0;i < nlen * 8;++i) {
    putchar(mpz_get_ui(n));
    mpz_tdiv_q_2exp(n,n,8);
  }

  exit(0);
}
