#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <gmp.h>
#include "mpz_bytes.h"
#include "alloc.h"
#include "error.h"

void usage()
{
  fprintf(stderr,"prove: usage: prove publicfile sigfile\n");
  exit(100);
}
void nomem()
{
  fprintf(stderr,"prove: fatal: out of memory\n");
  exit(111);
}
void die_read(fn)
char *fn;
{
  fprintf(stderr,"prove: fatal: unable to read %s: %s\n",fn,error_str(errno));
  exit(111);
}

unsigned char data[80] = {
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,1,4,1,5,9,2,6,5,3,5,8,9,7,9,3,2,3,8,4,6,2,6,4,3,3,8,3,2,7,9,5
} ;

char *bytes;

void main(argc,argv)
int argc;
char **argv;
{
  struct timeval tv0;
  struct timeval tv1;
  char *fnpublic;
  char *fnsig;
  FILE *fi;
  mpz_t n;
  mpz_t h;
  mpz_t s;
  mpz_t t;
  mpz_t a;
  mpz_t b;
  int c;
  int i;
  int nlen;
  int loop;
  int flagminus;
  int flagdouble;

  mpz_init(n);
  mpz_init(s);
  mpz_init(t);
  mpz_init(h);
  mpz_init(a);
  mpz_init(b);

  fnpublic = argv[1];
  if (!fnpublic) usage();
  fnsig = argv[2];
  if (!fnsig) usage();

  fi = fopen(fnpublic,"r");
  if (!fi) die_read(fnpublic);
  c = getc(fi);
  if (c == EOF) die_read(fnpublic);
  nlen = (unsigned long) (unsigned char) c;
  bytes = alloc(nlen * 8);
  if (!bytes) nomem();
  if (fread(bytes,1,nlen * 8,fi) != nlen * 8) die_read(fnpublic);
  mpz_bytes(n,bytes,nlen * 2);
  fclose(fi);

  fi = fopen(fnsig,"r");
  if (!fi) die_read(fnsig);
  getc(fi);
  if (fread(data + 16,1,32,fi) != 32) die_read(fnsig);
  mpz_bytes(h,data,20);

  flagminus = (getc(fi) == '-');
  flagdouble = (getc(fi) == '2');

  if (fread(bytes,1,nlen * 8,fi) != nlen * 8) die_read(fnsig);
  mpz_bytes(s,bytes,nlen * 2);
  if (fread(bytes,1,nlen * 8,fi) != nlen * 8) die_read(fnsig);
  mpz_bytes(t,bytes,nlen * 2);


  gettimeofday(&tv0,(struct timezone *) 0);

  mpz_mul_2exp(h,h,64 * nlen);
  if (flagminus) mpz_neg(h,h);
  if (flagdouble) mpz_add(h,h,h);
  for (loop = 0;loop < 100;++loop) {
    mpz_mul(b,s,s);
    mpz_mul(a,t,n);
    mpz_add(a,a,h);
    mpz_sub(a,a,b);
  }

  gettimeofday(&tv1,(struct timezone *) 0);


  if (mpz_sgn(a) != 0) {
    fprintf(stderr,"prove: fatal: signature is invalid\n");
    exit(100);
  }
  fprintf(stderr,"prove: info: 100x proof took %d microseconds\n"
    ,(tv1.tv_sec - tv0.tv_sec) * 1000000 + tv1.tv_usec - tv0.tv_usec);
  exit(0);
}
