#include <gmp.h>
#include "stralloc.h"

static unsigned long smallprime[] = {
  2, 3, 5, 7, 11, 13, 17, 19, 23, 29,
  31, 37, 41, 43, 47, 53, 59, 61, 67, 71,
  73, 79, 83, 89, 97,
  0
} ;

static stralloc bits = {0};

static int init = 0;
static mpz_t p12;
static mpz_t u;
static mpz_t v;
static mpz_t a;
static mpz_t b;

int mpz_prime(p)
mpz_t p;
{
  int i;
  unsigned long q;
  int r;

  if (!init) {
    mpz_init(p12);
    mpz_init(u);
    mpz_init(v);
    mpz_init(a);
    mpz_init(b);
    init = 1;
  }

  if (mpz_cmp_si(p,100) < 0) {
    if (mpz_cmp_si(p,1) <= 0) return 0;
    for (i = 0;q = smallprime[i];++i)
      if (mpz_cmp_si(p,q) == 0) return 1;
    return 0;
  }

  for (i = 0;q = smallprime[i];++i)
    if (!mpz_mod_ui(u,p,q)) return 0;
  if (mpz_cmp_si(p,10000) < 0) return 1;

  mpz_tdiv_q_2exp(p12,p,1);
  mpz_set_ui(u,2);
  mpz_powm(v,u,p12,p);
  if (mpz_cmp_si(v,1) != 0) {
    mpz_sub(v,p,v);
    if (mpz_cmp_si(v,1) != 0) return 0;
  }

  for (r = 3;r < 1000;++r) {
    mpz_set_ui(u,r * r - 4);
    if (mpz_jacobi(u,p) == -1) break;
  }

  if (r == 1000) return 1; /* XXX: not necessarily true */

  /* if p is prime then x^((p+1)/2) mod x^2-rx+1 is +-1 */
  mpz_add_ui(v,p12,1);

  if (!stralloc_ready(&bits,mpz_sizeinbase(v,2) + 2)) return -1;
  mpz_get_str(bits.s,2,v);

  mpz_set_ui(a,0);
  mpz_set_ui(b,1);

  for (i = 0;bits.s[i];++i) {
    /* square ax+b */
    mpz_mul_ui(u,b,2);
    mpz_sub(v,b,a);
    mpz_add(b,b,a);
    mpz_mul(b,b,v);
    mpz_mul_ui(v,a,r);
    mpz_add(u,u,v);
    mpz_mul(a,a,u);
    if (bits.s[i] == '1') { /* multiply ax+b by x */
      mpz_mul_ui(v,a,r);
      mpz_add(v,v,b);
      mpz_set_ui(b,0);
      mpz_sub(b,b,a);
      mpz_set(a,v);
    }
    mpz_mod(a,a,p);
    mpz_mod(b,b,p);
  }

  if (mpz_sgn(a) != 0) return 0;
  if (mpz_cmp_si(b,1) != 0) {
    mpz_sub(b,p,b);
    if (mpz_cmp_si(b,1) != 0) return 0;
  }

  return 1; /* XXX: not proven to be true */
}
