#include <gmp.h>
#include "mpz_bytes.h"
#include "uint32.h"
#include "endian.h"
#include "byte.h"

/* XXX: this assumes 32-bit words in gmp */

void mpz_bytes(z,bytes,words)
mpz_t z;
unsigned char *bytes;
unsigned int words;
{
  uint32 u;
  uint32 *zx;

  if (z->_mp_alloc < words)
    _mpz_realloc(z,words);
  z->_mp_size = words;

#if ENDIAN_LITTLE != 0
  zx = z->_mp_d + words;

  bytes += words * 4;

  while (words > 0) {
    --words;
    u = *--bytes;
    u <<= 8; u += *--bytes;
    u <<= 8; u += *--bytes;
    u <<= 8; u += *--bytes;
    *--zx = u;
  }
#else
  byte_copy(z->_mp_d,words * 4,bytes);
#endif
}
