#include <stdio.h>
#include "error.h"
#include "snefrufile.h"
#include "byte.h"

void die_read(fn)
char *fn;
{
  fprintf(stderr,"match: fatal: unable to read %s: %s\n",fn,error_str(errno));
  exit(111);
}
void usage()
{
  fprintf(stderr,"match: usage: match sigfile\n");
  exit(100);
}

snefrufile sf;
char h[32];
char check[32];

void main(argc,argv)
int argc;
char **argv;
{
  int c;
  int i;
  char *fnsig;
  FILE *fisig;

  fnsig = argv[1];
  if (!fnsig) usage();

  fisig = fopen(fnsig,"r");
  if (!fisig) die_read(fnsig);
  getc(fisig);
  for (i = 0;i < 32;++i) {
    c = getc(fisig);
    if (c == EOF) die_read(fnsig);
    check[i] = c;
  }
  fclose(fisig);

  snefrufile_clear(&sf);
  snefrufile_addn(&sf,"djb-sigs-",9);
  while ((c = getchar()) != EOF)
    snefrufile_add(&sf,c);
  snefrufile_hash(&sf,h);

  if (!byte_equal(h,32,check)) {
    fprintf(stderr,"match: fatal: fingerprint does not match\n");
    exit(100);
  }
  exit(0);
}
