#include "zpseriesexp.h"

static void fft(const zpfft_p *p,double f[],int d)
{
  switch(d) {
    case 1: zpfft_2(p,f); return;
    case 2: zpfft_4(p,f); return;
    case 4: zpfft_8(p,f); return;
    case 8: zpfft_16(p,f); return;
    case 16: zpfft_32(p,f); return;
    case 32: zpfft_64(p,f); return;
    case 64: zpfft_128(p,f); return;
    case 128: zpfft_256(p,f); return;
    case 256: zpfft_512(p,f); return;
    case 512: zpfft_1024(p,f); return;
    case 1024: zpfft_2048(p,f); return;
    case 2048: zpfft_4096(p,f); return;
    case 4096: zpfft_8192(p,f); return;
    case 8192: zpfft_16384(p,f); return;
    case 16384: zpfft_32768(p,f); return;
    case 32768: zpfft_65536(p,f); return;
    case 65536: zpfft_131072(p,f); return;
    case 131072: zpfft_262144(p,f); return;
    case 262144: zpfft_524288(p,f); return;
    case 524288: zpfft_1048576(p,f); return;
  }
}

static void scale(const zpfft_p *p,double f[],int d)
{
  unsigned long r;
  int i;

  r = 1;

  for (i = 1;i < d + d;i += i) {
    if (r & 1) r += p->p;
    r >>= 1;
  }

  for (i = 0;i < d + d;++i)
    f[i] = zpfft_product(p,f[i],r);
}

static void fft_un(const zpfft_p *p,double f[],int d)
{
  switch(d) {
    case 1: zpfft_un2(p,f); return;
    case 2: zpfft_un4(p,f); return;
    case 4: zpfft_un8(p,f); return;
    case 8: zpfft_un16(p,f); return;
    case 16: zpfft_un32(p,f); return;
    case 32: zpfft_un64(p,f); return;
    case 64: zpfft_un128(p,f); return;
    case 128: zpfft_un256(p,f); return;
    case 256: zpfft_un512(p,f); return;
    case 512: zpfft_un1024(p,f); return;
    case 1024: zpfft_un2048(p,f); return;
    case 2048: zpfft_un4096(p,f); return;
    case 4096: zpfft_un8192(p,f); return;
    case 8192: zpfft_un16384(p,f); return;
    case 16384: zpfft_un32768(p,f); return;
    case 32768: zpfft_un65536(p,f); return;
    case 65536: zpfft_un131072(p,f); return;
    case 131072: zpfft_un262144(p,f); return;
    case 262144: zpfft_un524288(p,f); return;
    case 524288: zpfft_un1048576(p,f); return;
  }
}

/* given precision, power of 2, at most 1048576 */
/* given h, leading coefficient 0 */
/* compute f = exp h, g = 1/exp h */

void zpseriesexp(const zpfft_p *p,int precision,double f[],double g[],double h[],double recip[],double t0[],double t1[],double t2[],double t3[],double t4[])
{
  int d;
  int i;

  f[0] = 1;
  g[0] = 1;
  d = 1;

  while (d < precision) {
    for (i = 0;i < d;++i) t0[i] = g[i];
    for (i = d;i < d + d;++i) t0[i] = 0;
    fft(p,t0,d);
    scale(p,t0,d);

    for (i = 0;i < d;++i) t1[i] = f[i];
    for (i = d;i < d + d;++i) t1[i] = 0;
    fft(p,t1,d);

    for (i = 0;i < d + d;++i) t2[i] = zpfft_product(p,t0[i],t1[i]);
    fft_un(p,t2,d);

    for (i = 0;i < d;++i) t3[i] = t2[i + d];
    for (i = d;i < d + d;++i) t3[i] = 0;
    fft(p,t3,d);

    for (i = 0;i < d;++i) t4[i] = zpfft_product(p,h[i],i);

    for (i = d;i < d + d;++i) t4[i] = 0;
    fft(p,t4,d);
    scale(p,t4,d);

    for (i = 0;i < d + d;++i) t3[i] = zpfft_product(p,t3[i],t4[i]);
    fft_un(p,t3,d);

    for (i = 0;i < d;++i) t4[i] = zpfft_product(p,f[i],i);
    for (i = d;i < d + d;++i) t4[i] = 0;
    fft(p,t4,d);

    for (i = 0;i < d + d;++i) t4[i] = zpfft_product(p,t0[i],t4[i]);
    fft_un(p,t4,d);

    for (i = 0;i < d;++i)
      t3[i] = zpfft_product(p,recip[i + d],zpfft_product(p,h[i + d],i + d) + t3[i] - t4[i + d]);
    for (i = d;i < d + d;++i) t3[i] = 0;
    fft(p,t3,d);
    scale(p,t3,d);

    for (i = 0;i < d + d;++i) t1[i] = zpfft_product(p,t1[i],t3[i]);
    fft_un(p,t1,d);

    for (i = 0;i < d;++i) f[i + d] = t1[i];

    for (i = 0;i < d;++i) t3[i] = f[i + d];
    for (i = d;i < d + d;++i) t3[i] = 0;
    fft(p,t3,d);

    for (i = 0;i < d + d;++i) t3[i] = zpfft_product(p,t3[i],t0[i]);
    fft_un(p,t3,d);

    for (i = 0;i < d;++i) t3[i] = zpfft_product(p,-1.0,t3[i] + t2[i + d]);
    for (i = d;i < d + d;++i) t3[i] = 0;
    fft(p,t3,d);

    for (i = 0;i < d + d;++i) t3[i] = zpfft_product(p,t3[i],t0[i]);
    fft_un(p,t3,d);

    for (i = 0;i < d;++i) g[i + d] = t3[i];

    d += d;
  }
}
