#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define D 25
#define C 200

double half[D];
double integ[D];
double c[C][D];

void rho_init()
{
  int i;
  int j;
  double minus1overu;
  double r;

  half[0] = 0.5;
  for (j = 1;j < D;++j) half[j] = half[j - 1] * 0.5;

  for (j = 0;j < D;++j) integ[j] = (1.0 / (j + 1)) * half[j];

  c[0][0] = 1;
  for (j = 1;j < D;++j) c[0][j] = 0;
  for (j = 0;j < D;++j) c[1][j] = c[0][j];

  for (i = 2;i < C;++i) {
    minus1overu = -2.0 / i;

    r = 0;
    for (j = 0;j < D;++j)
      r += (c[i - 2][j] + c[i - 1][j]) * integ[j];
    r *= minus1overu;
    r = -r;

    c[i][0] = r;
    c[i][1] = minus1overu * c[i - 2][0];
    for (j = 2;j < D;++j)
      c[i][j] = minus1overu * (c[i - 2][j - 1] + (j - 1) * c[i][j - 1]) / j;
  }
}

double rho(double u)
{
  int i;
  int j;
  double eps;
  double result;

  if (u > 10000.0) return 0;
  if (u < 0) return 0;

  i = (int) floor(2.0 * u);
  if (i >= C) return 0;
  if (i < 0) return 0;

  eps = u - 0.5 * i;

  result = 0;
  for (j = D - 1;j >= 0;--j)
    result = result * eps + c[i][j];

  return result;
}

main(int argc,char **argv)
{
  int num;
  int den;
  double psi;
  double x;
  double y;
  double u;
  double psix;
  double rhou;

  y = 1000.0;
  if (argv[1])
    y = atof(argv[1]);

  if (y < 2) y = 2;

  rho_init();

  while (scanf("%d%d%lf",&num,&den,&psi) == 3) {
    x = num;
    x /= den;
    x *= log(2.0);
    x = exp(x);
    u = log(x) / log(y);
    psix = psi / floor(x);
    rhou = rho(u);
    printf("%e %e %e %e %e %f\n",x,y,u,rhou,psix,psix / rhou);
  }

  exit(0);
}
