#include <stdio.h>
#include <math.h>
#include "../primegen-0.97/primegen.h"
#include "zpseriesexp.h"
#include "crt.h"

double reciprocal(const zpfft_p *p,double u)
{
  int e;
  double v;

  e = (int) p->p - 2;
  v = 1;

  /* want u^e * v */
  while (e) {
    if (e & 1) v = zpfft_product(p,u,v);
    e >>= 1;
    u = zpfft_product(p,u,u);
  }

  return v;
}

#define PRECISION 262144 /* power of 2, at most 1048576 */

zpfft_p p;
double recip[PRECISION];
double h[PRECISION];
double t[6][PRECISION];
double exph[CRT_PRIMES][PRECISION];

double u[CRT_PRIMES];
int v[CRT_DIGITS];
int sum[CRT_DIGITS];

void add(int k,uint32 numq)
{
  int i;
  int ik;

  if (numq == 0) return;

  i = 1;
  ik = k;
  while (ik < PRECISION) {
    h[ik] = zpfft_product(&p,1.0,h[ik] + zpfft_product(&p,numq,recip[i]));
    ++i;
    ik += k;
  }
}

int flagupper = 0;
uint32 y = 1000;
uint32 alpha;

primegen pg;

main(int argc,char **argv)
{
  int i;
  int j;
  int k;
  double two1alpha; /* approximately 2^(1/alpha) */
  double twokalpha;
  uint32 qcutoff;
  uint32 q;
  uint32 numq;
  int carry;

  asm volatile("fldcw %0"::"m"(0x137f));

  if (argv[1]) {
    y = atoi(argv[1]);
    if (y > 1073741824) {
      fprintf(stderr,"psibound: fatal: bound must be at most 1073741824\n");
      exit(111);
    }
    if (argv[2])
      flagupper = atoi(argv[2]);
  }

  if (flagupper)
    alpha = 771;
  else
    alpha = 776;

  two1alpha = exp(log(2.0) / alpha);

  for (j = 0;j < CRT_PRIMES;++j) {
    zpfft_init(&p,crt_p[j],crt_zeta1048576[j]);

    recip[0] = 0;
    for (i = 1;i < PRECISION;++i) recip[i] = reciprocal(&p,i);
    for (i = 0;i < PRECISION;++i) h[i] = 0;

    k = alpha;
    twokalpha = 2.0;
    if (flagupper)
      twokalpha *= two1alpha;
    qcutoff = 2;
    numq = 0;
    primegen_init(&pg);
    for (;;) {
      q = primegen_next(&pg);
      if (q > y) break;
      while (q > qcutoff) {
        add(k,numq);
        ++k;
        twokalpha *= two1alpha;
	if (flagupper)
          qcutoff = -1 + (uint32) ceil(twokalpha * 1.0000001);
	else
	  qcutoff = (uint32) floor(twokalpha * 0.9999999);
        numq = 0;
      }
      /* alpha lg q is >= k if flagupper, <= k otherwise */
      ++numq;
    }
    add(k,numq);
  
    zpseriesexp(&p,PRECISION,exph[j],t[5],h,recip,t[0],t[1],t[2],t[3],t[4]);
  }

  for (k = 0;k < CRT_DIGITS;++k)
    sum[k] = 0;

  for (i = 0;i < PRECISION;++i) {
    printf("%d %d ",i,alpha);

    for (j = 0;j < CRT_PRIMES;++j)
      u[j] = exph[j][i];
    crt(v,u);

    carry = 0;
    for (k = 0;k < CRT_DIGITS;++k) {
      sum[k] = sum[k] + v[k] + carry;
      carry = 0;
      if (sum[k] >= 1000000000) { carry = 1; sum[k] -= 1000000000; }
    }
      
    for (k = CRT_DIGITS - 1;k > 0;--k)
      if (sum[k]) break;
    printf("%d",sum[k]);
    for (--k;k >= 0;--k)
      printf("%09d",sum[k]);
    printf("\n");
  }

  exit(0);
}
