#include "crt.h"

const double crt_p[CRT_PRIMES] = {
  2113929217.0
, 2088763393.0
, 2025848833.0
, 2013265921.0
, 1811939329.0
, 1711276033.0
, 1572864001.0
, 1484783617.0
, 1321205761.0
, 1107296257.0
} ;

static const double pinv[CRT_PRIMES] = {
  1/2113929217.0
, 1/2088763393.0
, 1/2025848833.0
, 1/2013265921.0
, 1/1811939329.0
, 1/1711276033.0
, 1/1572864001.0
, 1/1484783617.0
, 1/1321205761.0
, 1/1107296257.0
} ;

const double crt_zeta1048576[CRT_PRIMES] = {
  406741685.0
, 725841926.0
, 410676751.0
, 352904935.0
, 82138356.0
, 389950522.0
, 116308534.0
, 251381178.0
, 567160981.0
, 440920819.0
} ;

static const double xinv[CRT_PRIMES] = {
  -134969222.0
, 529895435.0
, -177745543.0
, 168119292.0
, 742294624.0
, 465551824.0
, 1034333009.0
, 226816810.0
, 1072380324.0
, 565423035.0
} ;

static const double x[CRT_PRIMES][CRT_DIGITS] = {
  { 757966337, 456372265, 644788650, 413959351, 610168779, 715989072, 910382298, 325953188, 250532929, 90, 0 }
, {  98033153, 916430653, 441257412, 782012571,  13921803,  10036160, 771276554, 230993128, 337888747, 91, 0 }
, { 327450113, 346172717, 949574137, 841591772,  82172700, 905719708,  28256984, 707538532, 174469141, 94, 0 }
, { 246978049, 796849681, 670119729, 298883639, 607035765, 669617015, 784978408, 550854617, 763059573, 94, 0 }
, { 706547201, 166855301, 727323377, 271122638,  88016991, 687180434, 887218239, 245477866, 292288409, 105, 0 }
, { 299750913,   4949489, 664464478, 446507806, 377750991, 679969152, 632792484, 699416331, 485952429, 111, 0 }
, { 819312129, 427219137,   3272114, 359597143, 688559410, 285159925, 740977104, 275449323, 296716237, 121, 0 }
, { 717607937, 962404446, 503512033,   1452195, 783541095, 317351109, 174231621, 809989887, 492284144, 128, 0 }
, {  28991489,  42963088, 471312717, 601941537, 640502744, 383251438, 623308557, 935994039, 400852645, 144, 0 }
, { 632861697, 712608686, 247471505, 585870566, 518136718, 545433305, 117172804, 890167504, 296471881, 172, 0 }
} ;

static const double pprod[CRT_DIGITS] = {
  286768129, 414253690, 989725716,  92295733, 104396811, 643370234, 895350885, 411977535, 122728562, 783238409, 190
} ;

static const double alpha0 = 13835058055282163712.0;
static const double ten9 = 1000000000.0;
static const double tenm9 = 0.000000001;
static const double beta0 = -0.499999999883584678173065185546875;

void crt(register int out[CRT_DIGITS],register double u[CRT_PRIMES])
{
  register int i;
  register int j;
  register double r;
  register double t0;
  register double t1;
  register double t2;

  r = 0;
  for (i = 0;i < CRT_PRIMES;++i) {
    t0 = u[i];
    t0 *= xinv[i];
    t1 = pinv[i];
    t1 *= t0;
    t1 += alpha0;
    t1 -= alpha0;
    t1 *= crt_p[i];
    t0 -= t1;
    u[i] = t0;
    t0 *= pinv[i];
    r += t0;
  }
  r += alpha0;
  r -= alpha0;

  t0 = 0;
  for (j = 0;j < CRT_DIGITS;++j) {
    for (i = 0;i < CRT_PRIMES;++i) {
      t1 = u[i];
      t1 *= x[i][j];
      t0 += t1;
    }
    t1 = r;
    t1 *= pprod[j];
    t0 -= t1;

    t1 = tenm9;
    t1 *= t0;
    t1 += alpha0;
    t1 -= alpha0;
    t2 = ten9;
    t2 *= t1;
    t0 -= t2;

    t2 = tenm9;
    t2 *= t0;
    t2 += beta0;
    t2 += alpha0;
    t2 -= alpha0;
    t1 += t2;
    t2 *= ten9;
    t0 -= t2;

    out[j] = t0;
    t0 = t1;
  }
}
