#include <stdlib.h>
#include <stdio.h>
#include "nistp224.h"
#include "myrandom.h"
#include "timing.h"

void flushcache(void)
{
  system("sleep 0");
}

timing start;
timing_basic startb;
timing finish;
timing_basic finishb;

#define TIMINGS 32

timing tnothing[TIMINGS + 1];
timing t28low[TIMINGS + 1];
timing t28[TIMINGS + 1];
timing t28high[TIMINGS + 1];
timing t56low[TIMINGS + 1];
timing t56[TIMINGS + 1];
timing t56high[TIMINGS + 1];

unsigned char y[TIMINGS][56];
unsigned char e[TIMINGS][28];
unsigned char elow[28];
unsigned char ehigh[28];
unsigned char out[56];

int main(void)
{
  int i;
  int j;

  timing_basic_now(&startb);
  timing_now(&start);

  for (j = 0;j < 28;++j) elow[j] = 0x88;
  for (j = 0;j < 28;++j) ehigh[j] = 0x77;

  for (i = 0;i < TIMINGS;++i) {
    for (j = 0;j < 28;++j) e[i][j] = myrandom();
    do {
      for (j = 0;j < 28;++j) y[i][j] = myrandom();
      nistp224_uncompress(y[i]);
    } while (!nistp224_valid(y[i]));
  }

  flushcache();
  timing_now(&tnothing[i = 0]);
  while (i < TIMINGS) {
    ++i;
    timing_now(&tnothing[i]);
  }

  flushcache();
  timing_now(&t56low[i = 0]);
  while (i < TIMINGS) {
    nistp224_56(out,y[i],elow);
    ++i;
    timing_now(&t56low[i]);
  }

  flushcache();
  timing_now(&t56[i = 0]);
  while (i < TIMINGS) {
    nistp224_56(out,y[i],e[i]);
    ++i;
    timing_now(&t56[i]);
  }

  flushcache();
  timing_now(&t56high[i = 0]);
  while (i < TIMINGS) {
    nistp224_56(out,y[i],ehigh);
    ++i;
    timing_now(&t56high[i]);
  }

  flushcache();
  timing_now(&t28low[i = 0]);
  while (i < TIMINGS) {
    nistp224(out,y[i],elow);
    ++i;
    timing_now(&t28low[i]);
  }

  flushcache();
  timing_now(&t28[i = 0]);
  while (i < TIMINGS) {
    nistp224(out,y[i],e[i]);
    ++i;
    timing_now(&t28[i]);
  }

  flushcache();
  timing_now(&t28high[i = 0]);
  while (i < TIMINGS) {
    nistp224(out,y[i],ehigh);
    ++i;
    timing_now(&t28high[i]);
  }

  timing_basic_now(&finishb);
  timing_now(&finish);

  printf("Using %s, opt-%s.c.\n",TIMING_H,NISTP224_H);

  printf(" nothing");
  for (i = 0;i < TIMINGS;++i)
    printf(" %7.0f",timing_diff(&tnothing[i + 1],&tnothing[i]));
  printf("\n");

  printf(" 28low  ");
  for (i = 0;i < TIMINGS;++i)
    printf(" %7.0f",timing_diff(&t28low[i + 1],&t28low[i]));
  printf("\n");

  printf(" 28     ");
  for (i = 0;i < TIMINGS;++i)
    printf(" %7.0f",timing_diff(&t28[i + 1],&t28[i]));
  printf("\n");

  printf(" 28high ");
  for (i = 0;i < TIMINGS;++i)
    printf(" %7.0f",timing_diff(&t28high[i + 1],&t28high[i]));
  printf("\n");

  printf(" 56low  ");
  for (i = 0;i < TIMINGS;++i)
    printf(" %7.0f",timing_diff(&t56low[i + 1],&t56low[i]));
  printf("\n");

  printf(" 56     ");
  for (i = 0;i < TIMINGS;++i)
    printf(" %7.0f",timing_diff(&t56[i + 1],&t56[i]));
  printf("\n");

  printf(" 56high ");
  for (i = 0;i < TIMINGS;++i)
    printf(" %7.0f",timing_diff(&t56high[i + 1],&t56high[i]));
  printf("\n");

  printf("Timings are in ticks. Nanoseconds per tick: approximately %f.\n"
    ,timing_basic_diff(&finishb,&startb) / timing_diff(&finish,&start));
  printf("Timings may be underestimates on systems without hardware tick support.\n");

  exit(0);
}
