#include <stdio.h>
#include "opt-idea53.c"

static double antiradix[12] = {
  1 / T0
, 1 / T1
, 1 / T2
, 1 / T3
, 1 / T4
, 1 / T5
, 1 / T6
, 1 / T7
, 1 / T8
, 1 / T9
, 1 / T10
, 1 / T11
} ;

static int x[12][16][64];

static small t1[1] = { 11 };
static small t2[1];
static small t3[1];

int main()
{
  int i;
  int j;
  int k;

  p_f2(t2,t1); /* 2 */
  p_fg(t3,t1,t2); /* 3 */
  p_f2(t1,t2); /* 4 */
  p_fg(t2,t1,t3); /* 7 */
  p_f2(t3,t1); /* 8 */
  p_fg(t1,t2,t3); /* 15 */
  p_f2(t2,t3); /* 16 */
  p_fg(t3,t1,t2); /* 31 */

  for (i = 0;i < 41;++i) {
    p_f2(t1,t2);
    p_fg(t2,t1,t3);
    p_f2(t3,t1);
    p_fg(t1,t2,t3);
    p_f2(t2,t3);
    p_fg(t3,t1,t2);
  }

  t1[0] = t3[0];

  for (i = 0;i < 16;++i) {
    x[0][i][0] = 1;

    x[0][i][1] = t1->t0;
    x[1][i][1] = t1->t1 * antiradix[1];
    x[2][i][1] = t1->t2 * antiradix[2];
    x[3][i][1] = t1->t3 * antiradix[3];
    x[4][i][1] = t1->t4 * antiradix[4];
    x[5][i][1] = t1->t5 * antiradix[5];
    x[6][i][1] = t1->t6 * antiradix[6];
    x[7][i][1] = t1->t7 * antiradix[7];
    x[8][i][1] = t1->t8 * antiradix[8];
    x[9][i][1] = t1->t9 * antiradix[9];
    x[10][i][1] = t1->t10 * antiradix[10];
    x[11][i][1] = t1->t11 * antiradix[11];

    p_f2(t2,t1);

    for (j = 0;j < 31;++j) {
      x[0][i][2 * j + 2] = t2->t0;
      x[1][i][2 * j + 2] = t2->t1 * antiradix[1];
      x[2][i][2 * j + 2] = t2->t2 * antiradix[2];
      x[3][i][2 * j + 2] = t2->t3 * antiradix[3];
      x[4][i][2 * j + 2] = t2->t4 * antiradix[4];
      x[5][i][2 * j + 2] = t2->t5 * antiradix[5];
      x[6][i][2 * j + 2] = t2->t6 * antiradix[6];
      x[7][i][2 * j + 2] = t2->t7 * antiradix[7];
      x[8][i][2 * j + 2] = t2->t8 * antiradix[8];
      x[9][i][2 * j + 2] = t2->t9 * antiradix[9];
      x[10][i][2 * j + 2] = t2->t10 * antiradix[10];
      x[11][i][2 * j + 2] = t2->t11 * antiradix[11];

      p_fg(t3,t1,t2);

      x[0][i][2 * j + 3] = t3->t0;
      x[1][i][2 * j + 3] = t3->t1 * antiradix[1];
      x[2][i][2 * j + 3] = t3->t2 * antiradix[2];
      x[3][i][2 * j + 3] = t3->t3 * antiradix[3];
      x[4][i][2 * j + 3] = t3->t4 * antiradix[4];
      x[5][i][2 * j + 3] = t3->t5 * antiradix[5];
      x[6][i][2 * j + 3] = t3->t6 * antiradix[6];
      x[7][i][2 * j + 3] = t3->t7 * antiradix[7];
      x[8][i][2 * j + 3] = t3->t8 * antiradix[8];
      x[9][i][2 * j + 3] = t3->t9 * antiradix[9];
      x[10][i][2 * j + 3] = t3->t10 * antiradix[10];
      x[11][i][2 * j + 3] = t3->t11 * antiradix[11];

      p_fg(t2,t1,t3);
    }

    t1[0] = t2[0];
  }

  for (j = 0;j < 64;++j) {
    printf("{");
    for (i = 0;i < 16;++i) {
      printf("{");
      for (k = 0;k < 12;++k) {
	printf("%d,",x[k][i][j]);
      }
      printf("},\n");
    }
    printf("},\n");
  }
}

