#include "myrandom.h"

static unsigned long in[4] = {0,0,0,0};
static unsigned long t[16];

#define ROTATE(x,b) x = (((x) << (b)) | ((x) >> (32 - (b))))

unsigned char myrandom(void)
{
  static int pos = 0;
  register unsigned long y;
  register unsigned long x;
  register unsigned long sum;
  int rounds;

  if (!pos) {
    x = 0;
    sum = 0;
    rounds = 3;
    t[1] =t[2] =t[3] =0; t[0] =in[0];
    t[5] =t[6] =t[7] =0; t[4] =in[1];
    t[9] =t[10]=t[11]=0; t[8] =in[2];
    t[13]=t[14]=t[15]=0; t[12]=in[3];
    do {
      sum += 0x9e3779b9; y=x; y+=sum;
      ROTATE(x,5);  x^=y; y=t[0];  x+=y; y=sum; t[0] =x; y+=x;
      ROTATE(x,7);  x^=y; y=t[1];  x+=y; y=sum; t[1] =x; y+=x;
      ROTATE(x,9);  x^=y; y=t[2];  x+=y; y=sum; t[2] =x; y+=x;
      ROTATE(x,13); x^=y; y=t[3];  x+=y; y=sum; t[3] =x; y+=x;
      ROTATE(x,5);  x^=y; y=t[4];  x+=y; y=sum; t[4] =x; y+=x;
      ROTATE(x,7);  x^=y; y=t[5];  x+=y; y=sum; t[5] =x; y+=x;
      ROTATE(x,9);  x^=y; y=t[6];  x+=y; y=sum; t[6] =x; y+=x;
      ROTATE(x,13); x^=y; y=t[7];  x+=y; y=sum; t[7] =x; y+=x;
      ROTATE(x,5);  x^=y; y=t[8];  x+=y; y=sum; t[8] =x; y+=x;
      ROTATE(x,7);  x^=y; y=t[9];  x+=y; y=sum; t[9] =x; y+=x;
      ROTATE(x,9);  x^=y; y=t[10]; x+=y; y=sum; t[10]=x; y+=x;
      ROTATE(x,13); x^=y; y=t[11]; x+=y; y=sum; t[11]=x; y+=x;
      ROTATE(x,5);  x^=y; y=t[12]; x+=y; y=sum; t[12]=x; y+=x;
      ROTATE(x,7);  x^=y; y=t[13]; x+=y; y=sum; t[13]=x; y+=x;
      ROTATE(x,9);  x^=y; y=t[14]; x+=y; y=sum; t[14]=x; y+=x;
      ROTATE(x,13); x^=y; y=t[15]; x+=y;
      t[15] = x;
    } while (--rounds);
    if (!++in[0]) if (!++in[1]) if (!++in[2]) ++in[3];
    pos = 16;
  }

  return t[--pos];
}
