#include <stdio.h>
#include "nistp224.h"
#include "myrandom.h"

void print28(const char *s,const unsigned char x[28])
{
  int j;

  printf("%slittleendian(%d",s,(unsigned int) x[0]);
  for (j = 1;j < 14;++j)
    printf(",%d",(unsigned int) x[j]);
  printf(")+2^112*littleendian(%d",(unsigned int) x[14]);
  for (j = 15;j < 28;++j)
    printf(",%d",(unsigned int) x[j]);
  printf(")\n");
}

unsigned char badpoints28[][28] = {
  {
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  } ,
  {
    0x11,0x1d,0x5c,0x11,0xd6,0x80,0x32,0x34,0x22,0x11,0xc2,0x56,0xd3,0xc1,
    0x03,0x4a,0xb9,0x90,0x13,0x32,0x7f,0xbf,0xb4,0x6b,0xbd,0x0c,0x0e,0xb7
  }
} ;

unsigned char badpoints56[][56] = {
  {
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  } ,
  {
    0x21,0x1d,0x5c,0x11,0xd6,0x80,0x32,0x34,0x22,0x11,0xc2,0x56,0xd3,0xc1,
    0x03,0x4a,0xb9,0x90,0x13,0x32,0x7f,0xbf,0xb4,0x6b,0xbd,0x0c,0x0e,0xb7,
    0x34,0x7e,0x00,0x85,0x99,0x81,0xd5,0x44,0x64,0x47,0x07,0x4a,0xa0,0x75,
    0x43,0xcd,0xe6,0xdf,0x22,0x4c,0xfb,0x23,0xf7,0xb5,0x88,0x63,0x37,0xbd
  }
} ;

unsigned char points[100][56] = {
  {
    0x21,0x1d,0x5c,0x11,0xd6,0x80,0x32,0x34,0x22,0x11,0xc2,0x56,0xd3,0xc1,
    0x03,0x4a,0xb9,0x90,0x13,0x32,0x7f,0xbf,0xb4,0x6b,0xbd,0x0c,0x0e,0xb7,
    0x34,0x7e,0x00,0x85,0x99,0x81,0xd5,0x44,0x64,0x47,0x07,0x5a,0xa0,0x75,
    0x43,0xcd,0xe6,0xdf,0x22,0x4c,0xfb,0x23,0xf7,0xb5,0x88,0x63,0x37,0xbd
  }
} ;

unsigned char e[28];
unsigned char out[56];

int main(void)
{
  int i;
  int j;

  printf("\
p=2^224-2^96+1\n\
b=18958286285566608000408668544493926415504680968679321075787234672564\n\
define modp(x) {\n\
  x = x %% p\n\
  if (x < 0) x += p\n\
  return (x)\n\
}\n\
define invert(x) {\n\
  auto q,y,a,b\n\
  x = modp(x)\n\
  y = p\n\
  a = 1\n\
  b = 0\n\
  while(1) {\n\
    if (!x) return (modp(b))\n\
    q = y / x\n\
    y -= q * x\n\
    b -= q * a\n\
    if (!y) return (modp(a))\n\
    q = x / y\n\
    x -= q * y\n\
    a -= q * b\n\
  }\n\
}\n\
define ecdouble(p1[]) {\n\
  auto s\n\
  s = modp(3 * (p1[1] * p1[1] - 1) * invert(2 * p1[2]));\n\
  out1 = modp(s * s - p1[1] - p1[1]);\n\
  out2 = modp(s * (p1[1] - out1) - p1[2]);\n\
}\n\
define ecadd(p1[],p2[]) {\n\
  auto s\n\
  s = modp((p2[2] - p1[2]) * invert(p2[1] - p1[1]));\n\
  out1 = modp(s * s - p1[1] - p2[1]);\n\
  out2 = modp(s * (p1[1] - out1) - p1[2]);\n\
}\n\
define ecmul(in[],n) {\n\
  auto x[],t[]\n\
\n\
  x[1] = in[1];\n\
  x[2] = in[2];\n\
  if (n == 0) { out1 = 0; out2 = 0; return; }\n\
  while (!(n %% 2)) {\n\
    trash = ecdouble(x[]);\n\
    x[1] = out1;\n\
    x[2] = out2;\n\
    n = n / 2;\n\
  }\n\
  t[1] = x[1];\n\
  t[2] = x[2];\n\
  n = n - 1;\n\
  while (n > 0) {\n\
    if (n %% 2) {\n\
      trash = ecadd(x[],t[]);\n\
      t[1] = out1;\n\
      t[2] = out2;\n\
      n = n - 1;\n\
    }\n\
    trash = ecdouble(x[]);\n\
    x[1] = out1;\n\
    x[2] = out2;\n\
    n = n / 2;\n\
  }\n\
  out1 = t[1];\n\
  out2 = t[2];\n\
}\n\
define littleendian(e0,e1,e2,e3,e4,e5,e6,e7,e8,e9,e10,e11,e12,e13) {\n\
  return (e0 + 256 * (e1 + 256 * (e2 + 256 * (e3 + 256 * (e4 + 256 * (e5 + 256 * (e6 + 256 * (e7 + 256 * (e8 + 256 * (e9 + 256 * (e10 + 256 * (e11 + 256 * (e12 + 256 * e13)))))))))))))\n\
}\n\
define bigendian(e13,e12,e11,e10,e9,e8,e7,e6,e5,e4,e3,e2,e1,e0) {\n\
  return (littleendian(e0,e1,e2,e3,e4,e5,e6,e7,e8,e9,e10,e11,e12,e13))\n\
}\n\
\n\
");

  for (i = 1;i < (sizeof points)/sizeof (points[0]);++i) {
    for (j = 0;j < 28;++j)
      e[j] = myrandom();
    printf("e=2^224+2^112*bigendian(%d",((unsigned int) e[0]) - 136);
    for (j = 1;j < 14;++j)
      printf(",%d",((unsigned int) e[j]) - 136);
    printf(")+bigendian(%d",((unsigned int) e[14]) - 136);
    for (j = 15;j < 28;++j)
      printf(",%d",((unsigned int) e[j]) - 136);
    printf(")\n");

    print28("a[1]=",points[i - 1]);
    print28("a[2]=",points[i - 1] + 28);
    printf("(a[2]*a[2]-a[1]*a[1]*a[1]+3*a[1]-b)%%p\n");
    printf("trash=ecmul(a[],e)\n");

    nistp224_56(points[i],points[i - 1],e);

    print28("c[1]=",points[i]);
    print28("c[2]=",points[i] + 28);

    printf("out1-c[1]\n");
    printf("out2-c[2]\n");

    nistp224(points[i],points[i - 1],e);

    print28("-a[1]+",points[i - 1]);
    print28("-a[2]+",points[i - 1] + 28);
    print28("-c[1]+",points[i]);
    print28("-c[2]+",points[i] + 28);
  }

  for (i = 0;i < (sizeof badpoints28)/sizeof (badpoints28[0]);++i)
    printf("%d\n",nistp224(out,badpoints28[i],e));
  for (i = 0;i < (sizeof badpoints56)/sizeof (badpoints56[0]);++i)
    printf("%d\n",nistp224_56(out,badpoints56[i],e));

  return 0;
}
