/* output has MD5 checksum 17f757166e87a3854bb2bdf8ebcdd6a6 */
/* feeding output through gp prints all zeros */

#include <math.h>
#include <stdio.h>
#include "gaudry.h"

/* generated by jot -w 0x%02x, -r 16 0 255 */
/* and surely not secure */
/* but fine for speed testing */
static unsigned char a[16] = {
  0x31, 0xdf, 0xae, 0x2f, 0xca, 0xce, 0x85, 0x84, 0xe3, 0x18, 0xaf, 0xca, 0x6f, 0x7f, 0xdb, 0x66,
};
static unsigned char b[16] = {
  0xe3, 0xb2, 0xb4, 0x0b, 0x9e, 0x67, 0x58, 0xab, 0x8c, 0xa5, 0x22, 0x8f, 0x30, 0x79, 0x73, 0xf4, 
};
static unsigned char c[16] = {
  0xb0, 0xa7, 0x55, 0xe1, 0x54, 0x0c, 0x2d, 0x36, 0x35, 0xa9, 0xbe, 0x7f, 0x00, 0x98, 0x58, 0xf6, 
};
static unsigned char d[16] = {
  0xa1, 0xb2, 0xaa, 0xe7, 0x9a, 0xfa, 0xa5, 0x75, 0x92, 0x19, 0x59, 0x48, 0x6b, 0xaa, 0xc1, 0x07,
};

/* randomly chosen projective point on the above curve */
static unsigned char x1str[16] = { /* x1 = 123586693484390917848746833708539737431 */
  0x57, 0x75, 0x2c, 0x24, 0x0b, 0x74, 0xdc, 0xfb, 0xec, 0xc0, 0x6d, 0x53, 0x6e, 0xee, 0xf9, 0x5c
};
static unsigned char y1str[16] = { /* y1 = 64445485763761902310874199993242972207 */
  0x2F, 0x70, 0xBD, 0x87, 0x16, 0x72, 0x90, 0x51, 0xB3, 0xFE, 0xC9, 0xCA, 0xC3, 0xBF, 0x7B, 0x30,
};
static unsigned char z1str[16] = { /* z1 = 151176062376677679166631122011713950862 */
  0x8E, 0xD4, 0x5B, 0x40, 0x5B, 0xE4, 0x5F, 0xCD, 0xA4, 0xF6, 0x9E, 0xA0, 0x56, 0x73, 0xBB, 0x71,
};
static unsigned char t1str[16] = { /* t1 = 14362865463495528323137549673108943467 */
  0x6B, 0x32, 0xCD, 0x70, 0xA2, 0x1A, 0x01, 0x64, 0xF5, 0xF4, 0x4E, 0xD1, 0xF0, 0x2F, 0xCE, 0x0A,
};

/* same point as above in x1/y1, x1/z1, x1/t1 coordinates */
/* 14157603935820307318641562892455895978 */
/* 102577795541696887093579261934387366831 */
/* 71749792585390832338083154897500435431 */
static unsigned char basepoint[48] = {
  0xAA, 0xE3, 0xFF, 0xE5, 0xE2, 0x57, 0xF6, 0x1D, 0x50, 0xFF, 0xEA, 0x1A, 0xC4, 0xA7, 0xA6, 0x0A,
  0xAF, 0x8B, 0xC4, 0xF2, 0xA5, 0xFA, 0x5F, 0xEF, 0xF5, 0x0F, 0x78, 0x58, 0xCA, 0xC3, 0x2B, 0x4D,
  0xE7, 0xF3, 0xE0, 0x46, 0xD0, 0x2C, 0x3F, 0x75, 0x9C, 0x45, 0xD8, 0x40, 0xE5, 0x81, 0xFA, 0x35,
};

void print16(const unsigned char *k)
{
  int i;
  printf("0");
  for (i = 0;i < 16;++i) printf("+%u*256^%d",255 & (int) k[i],i);
}

void print32(const unsigned char *k)
{
  int i;
  printf("0");
  for (i = 0;i < 32;++i) printf("+%u*256^%d",(i == 31 ? 127 : 255) & (int) k[i],i);
}

void printkey(const unsigned char *k)
{
  printf("[Mod(");
  print16(k + 0);
  printf(",2^127-1),Mod(");
  print16(k + 16);
  printf(",2^127-1),Mod(");
  print16(k + 32);
  printf(",2^127-1)]");
}

void printdouble(double *d)
{
  int i;
  for (i = 0;i < 5;++i) if (d[i] != round(d[i])) printf("non-integer!!! yikes!\n");
  printf("0");
  for (i = 0;i < 5;++i) printf("+%.0f",d[i]);
}

void printpoint(double *d)
{
  printf("[Mod(");
  printdouble(d);
  printf(",2^127-1),Mod(");
  printdouble(d + 5);
  printf(",2^127-1),Mod(");
  printdouble(d + 10);
  printf(",2^127-1),Mod(");
  printdouble(d + 15);
  printf(",2^127-1)]");
}

void randomdouble(double *d)
{
  d[0] = ((random() % 67108864) - 33554432);
  d[1] = ((random() % 33554432) - 16777216) * 67108864.0;
  d[2] = ((random() % 67108864) - 33554432) * 2251799813685248.0;
  d[3] = ((random() % 33554432) - 16777216) * 151115727451828646838272.0;
  d[4] = ((random() % 33554432) - 16777216) * 5070602400912917605986812821504.0;
}

void random16(unsigned char *k)
{
  int i;
  for (i = 0;i < 16;++i) k[i] = random();
}

double x[20];
double y[20];
double z[20];

unsigned char k[48];
unsigned char sharedsecret[48];

double q1[20];
double x1overy1z1t1[20];

unsigned char e[32];

unsigned char alicesecret[32];
unsigned char alicepublic[48];
unsigned char aliceshared[48];
unsigned char bobsecret[32];
unsigned char bobpublic[48];
unsigned char bobshared[48];

main()
{
  int loop;
  int i;

  gaudry_init();

  for (loop = 0;loop < 100;++loop) {
    random16(k);
    printf("tk="); print16(k); printf(";\n");
    gaudry_todouble(x,k);
    printf("tx="); printdouble(x); printf(";\n");
    printf("(tx-tk)%(2^127-1)\n");

    randomdouble(x);
    randomdouble(y);
    printf("tx="); printdouble(x); printf(";\n");
    printf("ty="); printdouble(y); printf(";\n");
    gaudry_mult(z,x,y);
    printf("tz="); printdouble(z); printf(";\n");
    printf("(tx*ty-tz)%(2^127-1)\n");

    randomdouble(x);
    printf("tx="); printdouble(x); printf(";\n");
    gaudry_recip(z,x);
    printf("tz="); printdouble(z); printf(";\n");
    printf("(tx*tz-1)%(2^127-1)\n");
    gaudry_fromdouble(k,z);
    printf("tk="); print16(k); printf(";\n");
    printf("(tz-tk)%(2^127-1)\n");

    randomdouble(x); printf("x0="); printdouble(x); printf(";\n");
    randomdouble(x + 5); printf("x1="); printdouble(x + 5); printf(";\n");
    randomdouble(x + 10); printf("x2="); printdouble(x + 10); printf(";\n");
    randomdouble(x + 15); printf("x3="); printdouble(x + 15); printf(";\n");
    gaudry_hadamard(z,x);
    printf("z0="); printdouble(z); printf(";\n");
    printf("z1="); printdouble(z + 5); printf(";\n");
    printf("z2="); printdouble(z + 10); printf(";\n");
    printf("z3="); printdouble(z + 15); printf(";\n");
    printf("(x0+x1+x2+x3)-z0\n");
    printf("(x0+x1-x2-x3)-z1\n");
    printf("(x0-x1+x2-x3)-z2\n");
    printf("(x0-x1-x2+x3)-z3\n");
  }

  gaudry_surface_specify(a,b,c,d);
  printf("p=2^127-1;\n");
  printf("a=Mod("); print16(a); printf(",p);\n");
  printf("b=Mod("); print16(b); printf(",p);\n");
  printf("c=Mod("); print16(c); printf(",p);\n");
  printf("d=Mod("); print16(d); printf(",p);\n");
  printf("qx1=Mod("); print16(x1str); printf(",p);\n");
  printf("qy1=Mod("); print16(y1str); printf(",p);\n");
  printf("qz1=Mod("); print16(z1str); printf(",p);\n");
  printf("qt1=Mod("); print16(t1str); printf(",p);\n");
  printf("R1=[qx1,qy1,qz1,qt1];\n");
  printf("H(Q)=Q*[1,1,1,1;1,1,-1,-1;1,-1,1,-1;1,-1,-1,1]\n");
  printf("AA = H([a*a,b*b,c*c,d*d])[1]/4;\n");
  printf("BB = H([a*a,b*b,c*c,d*d])[2]/4;\n");
  printf("CC = H([a*a,b*b,c*c,d*d])[3]/4;\n");
  printf("DD = H([a*a,b*b,c*c,d*d])[4]/4;\n");
  printf("e = 256 * a*b*c*d *AA*BB*CC*DD / ((a*a*d*d-b*b*c*c)*(a*a*c*c-b*b*d*d)*(a*a*b*b-c*c*d*d));\n");
  printf("f = (a*a*a*a - b*b*b*b - c*c*c*c + d*d*d*d) / (a*a*d*d - b*b*c*c);\n");
  printf("g = (a*a*a*a - b*b*b*b + c*c*c*c - d*d*d*d) / (a*a*c*c - b*b*d*d);\n");
  printf("h = (a*a*a*a + b*b*b*b - c*c*c*c - d*d*d*d) / (a*a*b*b - c*c*d*d);\n");
  printf("C = x^4+y^4+z^4+t^4 + 2*e*x*y*z*t - f*(x^2*t^2+y^2*z^2) - g*(x^2*z^2+y^2*t^2) - h*(x^2*y^2+z^2*t^2);\n");
  printf("square(Q)=[Q[1]^2,Q[2]^2,Q[3]^2,Q[4]^2]\n");
  printf("ABC(Q)=[Q[1],Q[2]*AA/BB,Q[3]*AA/CC,Q[4]*AA/DD]\n");
  printf("mult(P,Q)=[P[1]*Q[1],P[2]*Q[2],P[3]*Q[3],P[4]*Q[4]]\n");
  printf("abc(Q)=[Q[1],Q[2]*a/b,Q[3]*a/c,Q[4]*a/d]\n");
  printf("double(Q)=abc(H(ABC(square(H(square(Q))))))\n");
  printf("divide(P,Q)=[P[1]/Q[1],P[2]/Q[2],P[3]/Q[3],P[4]/Q[4]]\n");
  printf("dividescaled(Q,Q1)=[Q[1],Q[2]*Q1[1]/Q1[2],Q[3]*Q1[1]/Q1[3],Q[4]*Q1[1]/Q1[4]]\n");
  printf("add(Q2,Q3,Q1)=dividescaled(H(ABC(mult(H(square(Q2)),H(square(Q3))))),Q1)\n");
  printf("onsurface(Q)=subst(subst(subst(subst(C,x,Q[1]),y,Q[2]),z,Q[3]),t,Q[4])\n");
  printf("doubleadd(Z,Q1)=[double(Z[1]),add(Z[1],Z[2],Q1)]\n");
  printf("flip(Z,bit)=[Z[2]*bit+Z[1]*(1-bit),Z[1]*bit+Z[2]*(1-bit)]\n");
  printf("doubleaddflip(Z,Q1,bit)=flip(doubleadd(flip(Z,bit),Q1),bit)\n");
  printf("ladder(Q1,n)=if(n==0,[[a,b,c,d],Q1],doubleaddflip(ladder(Q1,floor(n/2)),Q1,n%2))\n");
  printf("scalarmult(Q1,n)=ladder(Q1,n)[1]\n");

  gaudry_todouble(q1 + 0,x1str);
  gaudry_todouble(q1 + 5,y1str);
  gaudry_todouble(q1 + 10,z1str);
  gaudry_todouble(q1 + 15,t1str);

  printf("Q1="); printpoint(q1); printf(";\n");
  printf("lift(onsurface(Q1))\n");
  printf("lift((Q1-R1)[1])\n");
  printf("lift((Q1-R1)[2])\n");
  printf("lift((Q1-R1)[3])\n");
  printf("lift((Q1-R1)[4])\n");

  for (loop = 0;loop < 1000;++loop) {
    for (i = 0;i < 32;++i) alicesecret[i] = random();
    printf("AK="); print32(alicesecret); printf(";\n");
    gaudry(alicepublic,alicesecret,basepoint);
    printf("AP="); printkey(alicepublic); printf(";\n");
    printf("T=scalarmult(Q1,AK);\n");
    printf("lift(T[1]/T[2]-AP[1])\n");
    printf("lift(T[1]/T[3]-AP[2])\n");
    printf("lift(T[1]/T[4]-AP[3])\n");

    for (i = 0;i < 32;++i) bobsecret[i] = random();
    printf("BK="); print32(bobsecret); printf(";\n");
    gaudry(bobpublic,bobsecret,basepoint);
    printf("BP="); printkey(bobpublic); printf(";\n");
    printf("T=scalarmult(Q1,BK);\n");
    printf("lift(T[1]/T[2]-BP[1])\n");
    printf("lift(T[1]/T[3]-BP[2])\n");
    printf("lift(T[1]/T[4]-BP[3])\n");
  
    gaudry(aliceshared,alicesecret,bobpublic);
    gaudry(bobshared,bobsecret,alicepublic);
    printf("AS="); printkey(aliceshared); printf(";\n");
    printf("BS="); printkey(bobshared); printf(";\n");
    printf("lift(AS[1]-BS[1])\n");
    printf("lift(AS[2]-BS[2])\n");
    printf("lift(AS[3]-BS[3])\n");
    printf("T=scalarmult(Q1,AK*BK);\n");
    printf("lift(T[1]/T[2]-AS[1])\n");
    printf("lift(T[1]/T[3]-AS[2])\n");
    printf("lift(T[1]/T[4]-AS[3])\n");
  }

  return 0;
}
