#include "complex8.h"
#include "multiplyc8.h"

#define rc register complex8
#define rr register real8

/* n even, n > 0 */
static void doit(rc *a,rc *b,register int n)
{
  rr t1, t2, t3, t4, t5, t6, t7, t8;

  do {
    t1 = a[0].re; t1 *= b[0].re;
    t3 = a[0].im; t3 *= b[0].im;
    t2 = a[0].im; t2 *= b[0].re;
    t4 = a[0].re; t4 *= b[0].im;
    t5 = a[1].re; t5 *= b[1].re;
    t7 = a[1].im; t7 *= b[1].im;
    t6 = a[1].im; t6 *= b[1].re;
    t8 = a[1].re; t8 *= b[1].im;
    t1 -= t3;
    t2 += t4;
    t5 -= t7;
    t6 += t8;
    a[0].re = t1;
    a[0].im = t2;
    a[1].re = t5;
    a[1].im = t6;

    a += 2; b += 2; n -= 2;
  } while (n > 0);
}

void multiplyc8_2(rc *a,rc *b) { doit(a,b,2); }
void multiplyc8_4(rc *a,rc *b) { doit(a,b,4); }
void multiplyc8_8(rc *a,rc *b) { doit(a,b,8); }
void multiplyc8_16(rc *a,rc *b) { doit(a,b,16); }
void multiplyc8_32(rc *a,rc *b) { doit(a,b,32); }
void multiplyc8_64(rc *a,rc *b) { doit(a,b,64); }
void multiplyc8_128(rc *a,rc *b) { doit(a,b,128); }
void multiplyc8_256(rc *a,rc *b) { doit(a,b,256); }
void multiplyc8_512(rc *a,rc *b) { doit(a,b,512); }
void multiplyc8_1024(rc *a,rc *b) { doit(a,b,1024); }
void multiplyc8_2048(rc *a,rc *b) { doit(a,b,2048); }
void multiplyc8_4096(rc *a,rc *b) { doit(a,b,4096); }
void multiplyc8_8192(rc *a,rc *b) { doit(a,b,8192); }
void multiplyc8_16384(rc *a,rc *b) { doit(a,b,16384); }
void multiplyc8_32768(rc *a,rc *b) { doit(a,b,32768); }
void multiplyc8_65536(rc *a,rc *b) { doit(a,b,65536); }
