#include "complex4.h"
#include "multiplyc4.h"

#define rc register complex4
#define rr register real4

/* n even, n > 0 */
static void doit(rc *a,rc *b,register int n)
{
  rr t1, t2, t3, t4, t5, t6, t7, t8;

  do {
    t1 = a[0].re; t1 *= b[0].re;
    t3 = a[0].im; t3 *= b[0].im;
    t2 = a[0].im; t2 *= b[0].re;
    t4 = a[0].re; t4 *= b[0].im;
    t5 = a[1].re; t5 *= b[1].re;
    t7 = a[1].im; t7 *= b[1].im;
    t6 = a[1].im; t6 *= b[1].re;
    t8 = a[1].re; t8 *= b[1].im;
    t1 -= t3;
    t2 += t4;
    t5 -= t7;
    t6 += t8;
    a[0].re = t1;
    a[0].im = t2;
    a[1].re = t5;
    a[1].im = t6;

    a += 2; b += 2; n -= 2;
  } while (n > 0);
}

void multiplyc4_2(rc *a,rc *b) { doit(a,b,2); }
void multiplyc4_4(rc *a,rc *b) { doit(a,b,4); }
void multiplyc4_8(rc *a,rc *b) { doit(a,b,8); }
void multiplyc4_16(rc *a,rc *b) { doit(a,b,16); }
void multiplyc4_32(rc *a,rc *b) { doit(a,b,32); }
void multiplyc4_64(rc *a,rc *b) { doit(a,b,64); }
void multiplyc4_128(rc *a,rc *b) { doit(a,b,128); }
void multiplyc4_256(rc *a,rc *b) { doit(a,b,256); }
void multiplyc4_512(rc *a,rc *b) { doit(a,b,512); }
void multiplyc4_1024(rc *a,rc *b) { doit(a,b,1024); }
void multiplyc4_2048(rc *a,rc *b) { doit(a,b,2048); }
void multiplyc4_4096(rc *a,rc *b) { doit(a,b,4096); }
void multiplyc4_8192(rc *a,rc *b) { doit(a,b,8192); }
void multiplyc4_16384(rc *a,rc *b) { doit(a,b,16384); }
void multiplyc4_32768(rc *a,rc *b) { doit(a,b,32768); }
void multiplyc4_65536(rc *a,rc *b) { doit(a,b,65536); }
