#include "fftc8.h"

extern void fftc8_twopass();
extern void fftc8_untwopass();

#define FFTC8(first,second,third,r,n) \
void first(register complex8 *a) { \
fftc8_pass(a,r,n); third(a + 4 * n); third(a + 6 * n); second(a); }

#define FFTC8_TWO(first,third,fourth,r,n) \
void first(register complex8 *a) { \
fftc8_twopass(a,r,n); \
third(a); \
third(a + 8 * n); third(a + 12 * n); \
fourth(a + 4 * n); fourth(a + 6 * n); \
}

#define FFTC8_UN(first,second,third,r,n) \
void first(register complex8 *a) { \
second(a); third(a + 4 * n); third(a + 6 * n); fftc8_unpass(a,r,n); }

#define FFTC8_UNTWO(first,third,fourth,r,n) \
void first(register complex8 *a) { \
fourth(a + 4 * n); fourth(a + 6 * n); \
third(a + 8 * n); third(a + 12 * n); \
third(a); \
fftc8_untwopass(a,r,n); }
