#include "fftc4.h"

extern void fftc4_twopass();
extern void fftc4_untwopass();

#define FFTC4(first,second,third,r,n) \
void first(register complex4 *a) { \
fftc4_pass(a,r,n); third(a + 4 * n); third(a + 6 * n); second(a); }

#define FFTC4_TWO(first,third,fourth,r,n) \
void first(register complex4 *a) { \
fftc4_twopass(a,r,n); \
third(a); \
third(a + 8 * n); third(a + 12 * n); \
fourth(a + 4 * n); fourth(a + 6 * n); \
}

#define FFTC4_UN(first,second,third,r,n) \
void first(register complex4 *a) { \
second(a); third(a + 4 * n); third(a + 6 * n); fftc4_unpass(a,r,n); }

#define FFTC4_UNTWO(first,third,fourth,r,n) \
void first(register complex4 *a) { \
fourth(a + 4 * n); fourth(a + 6 * n); \
third(a + 8 * n); third(a + 12 * n); \
third(a); \
fftc4_untwopass(a,r,n); }
