/*

``Of course, you would be crazy to write code like this by hand.''
(Steven Johnson, 6 November 1997, taken slightly out of context)

*/

void inline fft_2(register complex *a)
{
  register real r0;
  register real i0;
  register real t;
  register real u;
  r0 = *(volatile real *)&a[0].re;
  r0 += a[1].re;
  i0 = *(volatile real *)&a[0].im;
  i0 += a[1].im;
  t = *(volatile real *)&a[0].re;
  t -= a[1].re;
  u = *(volatile real *)&a[0].im;
  u -= a[1].im;
  a[0].re = r0;
  a[0].im = i0;
  a[1].re = t;
  a[1].im = u;
}

void inline fft_4(register complex *a)
{
  register real s1, s2, s3, s4, s5, s6, s7, s8;

  s5 = *(volatile real *)&a[0].re;
  s5 += a[2].re;
  s7 = *(volatile real *)&a[1].re;
  s7 += a[3].re;
  s1 = *(volatile real *)&a[0].re;
  s2 = *(volatile real *)&a[0].im;
  s8 = s5;
  s8 += s7;
  s5 -= s7;
  s6 = *(volatile real *)&a[0].im;
  s6 += a[2].im;
  s3 = *(volatile real *)&a[1].re;
  s3 -= a[3].re;
  s4 = *(volatile real *)&a[1].im;
  s4 -= a[3].im;
  a[0].re = s8;
  s8 = *(volatile real *)&a[1].im;
  s8 += a[3].im;
  s2 -= a[2].im;
  s7 = s6;
  s7 += s8;
  s6 -= s8;
  a[1].re = s5;
  a[0].im = s7;
  a[1].im = s6;
  s1 -= a[2].re;
  s5 = s2;
  s5 += s3;
  s6 = s1;
  s2 -= s3;
  s6 += s4;
  s1 -= s4;
  a[2].im = s5;
  a[3].im = s2;
  a[2].re = s1;
  a[3].re = s6;
}

inline void fft_8(register complex *a)
{
  register real t1, t2, t3, t4, t5, t6, t7;

  t1 = *(volatile real *)&a[0].re;
  t2 = *(volatile real *)&a[0].im;
  t3 = *(volatile real *)&a[0].re;
  t4 = *(volatile real *)&a[0].im;
  t1 += a[4].re;
  t2 += a[4].im;
  t3 -= a[4].re;
  t4 -= a[4].im;
  a[0].re = t1;
  a[0].im = t2;
  t1 = *(volatile real *)&a[2].re;
  t2 = *(volatile real *)&a[2].im;
  t5 = *(volatile real *)&a[2].re;
  t6 = *(volatile real *)&a[2].im;
  t1 += a[6].re;
  t2 += a[6].im;
  t5 -= a[6].re;
  t6 -= a[6].im;
  a[2].re = t1;
  t1 = t3;
  a[2].im = t2;
  t2 = t4;
  t1 -= t6;
  t4 += t5;
  t3 += t6;
  t2 -= t5;
  a[4].re = t1;
  a[4].im = t4;
  a[6].re = t3;
  a[6].im = t2;

  t1 = *(volatile real *)&a[1].re;
  t2 = *(volatile real *)&a[1].im;
  t3 = *(volatile real *)&a[1].re;
  t4 = *(volatile real *)&a[1].im;
  t1 += a[5].re;
  t2 += a[5].im;
  t3 -= a[5].re;
  t4 -= a[5].im;
  a[1].re = t1;
  a[1].im = t2;
  t1 = *(volatile real *)&a[3].re;
  t2 = *(volatile real *)&a[3].im;
  t5 = *(volatile real *)&a[3].re;
  t6 = *(volatile real *)&a[3].im;
  t1 += a[7].re;
  t2 += a[7].im;
  t5 -= a[7].re;
  t6 -= a[7].im;
  a[3].re = t1;
  t1 = t3;
  a[3].im = t2;
  t2 = t4;
  t3 += t6;
  t1 -= t6;
  t4 += t5;
  t2 -= t5;
  t6 = t1;
  t1 += t4;
  t5 = t2;
  t2 += t3;
  t1 *= sqrthalf;
  t6 -= t4;
  t5 -= t3;
  t2 *= sqrthalf;
  t3 = *(volatile real *)&a[4].re;
  t6 *= sqrthalf;
  t7 = *(volatile real *)&a[4].re;
  t5 *= sqrthalf;
  t4 = *(volatile real *)&a[4].im;
  t3 += t6;
  t7 -= t6;
  t6 = *(volatile real *)&a[4].im;
  t4 += t1;
  a[4].re = t3;
  t6 -= t1;
  a[4].im = t4;
  a[5].re = t7;
  a[5].im = t6;

  t3 = *(volatile real *)&a[6].re;
  t4 = *(volatile real *)&a[6].im;
  t7 = *(volatile real *)&a[6].re;
  t6 = *(volatile real *)&a[6].im;
  t3 += t2;
  t4 += t5;
  t7 -= t2;
  t6 -= t5;
  a[6].re = t3;
  a[6].im = t4;
  a[7].re = t7;
  a[7].im = t6;

  fft_4(a);
}

void fft_16(register complex *a)
{
  register real t1, t2, t3, t4, t5, t6, t7, t8;

  t1 = *(volatile real *)&a[0].re;
  t2 = *(volatile real *)&a[0].im;
  t3 = *(volatile real *)&a[0].re;
  t4 = *(volatile real *)&a[0].im;
  t1 += a[8].re;
  t2 += a[8].im;
  t3 -= a[8].re;
  t4 -= a[8].im;
  a[0].re = t1;
  a[0].im = t2;
  t1 = *(volatile real *)&a[4].re;
  t2 = *(volatile real *)&a[4].im;
  t5 = *(volatile real *)&a[4].re;
  t6 = *(volatile real *)&a[4].im;
  t1 += a[12].re;
  t2 += a[12].im;
  t5 -= a[12].re;
  t6 -= a[12].im;
  a[4].re = t1;
  t1 = t3;
  a[4].im = t2;
  t2 = t4;
  t1 -= t6;
  t4 += t5;
  t3 += t6;
  t2 -= t5;
  a[8].re = t1;
  a[8].im = t4;
  a[12].re = t3;
  a[12].im = t2;

  t1 = *(volatile real *)&a[1].re;
  t2 = *(volatile real *)&a[1].im;
  t3 = *(volatile real *)&a[1].re;
  t4 = *(volatile real *)&a[1].im;
  t1 += a[9].re;
  t2 += a[9].im;
  t3 -= a[9].re;
  t4 -= a[9].im;
  a[1].re = t1;
  a[1].im = t2;
  t7 = t3;
  t1 = *(volatile real *)&a[5].re;
  t2 = *(volatile real *)&a[5].im;
  t5 = *(volatile real *)&a[5].re;
  t6 = *(volatile real *)&a[5].im;
  t1 += a[13].re;
  t2 += a[13].im;
  t5 -= a[13].re;
  t6 -= a[13].im;
  a[5].re = t1;
  t3 += t6;
  t7 -= t6;
  a[5].im = t2;
  t6 = t7;
  t7 *= fft_roots16[0].re;
  t1 = t3;
  t3 *= fft_roots16[0].re;
  t2 = t4;
  t1 *= fft_roots16[0].im;
  t4 += t5;
  t6 *= fft_roots16[0].im;
  t2 -= t5;
  t8 = t4;
  t4 *= fft_roots16[0].im;
  t5 = t2;
  t8 *= fft_roots16[0].re;
  t7 -= t4;
  t2 *= fft_roots16[0].im;
  t8 += t6;
  t5 *= fft_roots16[0].re;
  a[9].re = t7;
  t3 += t2;
  t5 -= t1;
  a[9].im = t8;
  a[13].re = t3;
  a[13].im = t5;

  t1 = *(volatile real *)&a[2].re;
  t2 = *(volatile real *)&a[2].im;
  t3 = *(volatile real *)&a[2].re;
  t4 = *(volatile real *)&a[2].im;
  t1 += a[10].re;
  t2 += a[10].im;
  t3 -= a[10].re;
  t4 -= a[10].im;
  a[2].re = t1;
  a[2].im = t2;
  t1 = *(volatile real *)&a[6].re;
  t2 = *(volatile real *)&a[6].im;
  t5 = *(volatile real *)&a[6].re;
  t6 = *(volatile real *)&a[6].im;
  t1 += a[14].re;
  t2 += a[14].im;
  t5 -= a[14].re;
  t6 -= a[14].im;
  a[6].re = t1;
  t1 = t3;
  a[6].im = t2;
  t2 = t4;
  t3 += t6;
  t1 -= t6;
  t4 += t5;
  t2 -= t5;
  t6 = t1;
  t1 += t4;
  t5 = t2;
  t2 += t3;
  t1 *= sqrthalf;
  t6 -= t4;
  t2 *= sqrthalf;
  t5 -= t3;
  t6 *= sqrthalf;
  a[10].im = t1;
  t5 *= sqrthalf;
  a[14].re = t2;
  a[10].re = t6;
  a[14].im = t5;

  t1 = *(volatile real *)&a[3].re;
  t2 = *(volatile real *)&a[3].im;
  t3 = *(volatile real *)&a[3].re;
  t4 = *(volatile real *)&a[3].im;
  t1 += a[11].re;
  t2 += a[11].im;
  t3 -= a[11].re;
  t4 -= a[11].im;
  a[3].re = t1;
  a[3].im = t2;
  t7 = t3;
  t1 = *(volatile real *)&a[7].re;
  t2 = *(volatile real *)&a[7].im;
  t5 = *(volatile real *)&a[7].re;
  t6 = *(volatile real *)&a[7].im;
  t1 += a[15].re;
  t2 += a[15].im;
  t5 -= a[15].re;
  t6 -= a[15].im;
  a[7].re = t1;
  t3 += t6;
  t7 -= t6;
  a[7].im = t2;
  t6 = t7;
  t7 *= fft_roots16[0].im;
  t1 = t3;
  t3 *= fft_roots16[0].im;
  t2 = t4;
  t1 *= fft_roots16[0].re;
  t4 += t5;
  t6 *= fft_roots16[0].re;
  t2 -= t5;
  t8 = t4;
  t4 *= fft_roots16[0].re;
  t5 = t2;
  t8 *= fft_roots16[0].im;
  t7 -= t4;
  t2 *= fft_roots16[0].re;
  t8 += t6;
  t5 *= fft_roots16[0].im;
  a[11].re = t7;
  t3 += t2;
  t5 -= t1;
  a[11].im = t8;
  a[15].re = t3;
  a[15].im = t5;

  fft_4(a + 8);
  fft_4(a + 12);
  fft_8(a);
}

inline void fft_un4(register complex *a)
{
  register real s1, s2, s3, s4, s5, s6, s7, s8;

  s1 = *(volatile real *)&a[0].re;
  s1 += a[1].re;
  s2 = *(volatile real *)&a[0].im;
  s2 += a[1].im;
  s6 = *(volatile real *)&a[3].re;
  s6 += a[2].re;
  s4 = s1;
  s5 = s2;
  s4 += s6;
  s1 -= s6;
  s3 = *(volatile real *)&a[0].re;
  s6 = *(volatile real *)&a[2].im;
  s6 += a[3].im;
  a[0].re = s4;
  s4 = *(volatile real *)&a[0].im;
  s5 += s6;
  s3 -= a[1].re;
  s2 -= s6;
  s4 -= a[1].im;
  a[0].im = s5;
  s7 = *(volatile real *)&a[2].im;
  s7 -= a[3].im;
  s8 = *(volatile real *)&a[3].re;
  s8 -= a[2].re;
  s5 = s3;
  s6 = s4;
  s3 -= s7;
  s4 -= s8;
  s5 += s7;
  s6 += s8;
  a[2].re = s1;
  a[2].im = s2;
  a[3].re = s3;
  a[3].im = s4;
  a[1].re = s5;
  a[1].im = s6;
}

inline void fft_un8(register complex *a) {
  register real t1, t2, t3, t4, t5, t6, t7, t8;

  fft_un4(a);

  t7 = *(volatile real *)&a[4].re;
  t7 -= a[5].re;
  t8 = *(volatile real *)&a[4].im;
  t8 -= a[5].im;
  t1 = *(volatile real *)&a[4].re;
  t1 += a[5].re;
  t2 = *(volatile real *)&a[4].im;
  t2 += a[5].im;
  a[5].re = t7;
  a[5].im = t8;

  t7 = *(volatile real *)&a[6].re;
  t7 -= a[7].re;
  t8 = *(volatile real *)&a[6].im;
  t8 -= a[7].im;
  t3 = *(volatile real *)&a[6].re;
  t3 += a[7].re;
  t4 = *(volatile real *)&a[6].im;
  t4 += a[7].im;
  a[7].re = t7;
  a[7].im = t8;

  t8 = t3;
  t7 = t2;
  t7 -= t4;
  t8 -= t1;
  t1 += t3;
  t2 += t4;
  t5 = *(volatile real *)&a[0].re;
  t6 = *(volatile real *)&a[0].im;
  t3 = *(volatile real *)&a[2].re;
  t4 = *(volatile real *)&a[2].im;
  t5 -= t1;
  t6 -= t2;
  t3 -= t7;
  t4 -= t8;
  a[4].re = t5;
  a[4].im = t6;
  a[6].re = t3;
  a[6].im = t4;
  t1 += a[0].re;
  t2 += a[0].im;
  t7 += a[2].re;
  t8 += a[2].im;
  a[0].re = t1;
  a[0].im = t2;
  a[2].re = t7;
  a[2].im = t8;

  t1 = *(volatile real *)&a[5].re;
  t1 += a[5].im;
  t2 = *(volatile real *)&a[5].im;
  t2 -= a[5].re;
  t1 *= sqrthalf;
  t3 = *(volatile real *)&a[7].re;
  t2 *= sqrthalf;
  t3 -= a[7].im;
  t4 = *(volatile real *)&a[7].im;
  t4 += a[7].re;
  t3 *= sqrthalf;
  t7 = t2;
  t4 *= sqrthalf;
  t8 = t3;
  t8 -= t1;
  t7 -= t4;
  t1 += t3;
  t2 += t4;
  t5 = *(volatile real *)&a[1].re;
  t6 = *(volatile real *)&a[1].im;
  t3 = *(volatile real *)&a[3].re;
  t4 = *(volatile real *)&a[3].im;
  t5 -= t1;
  t6 -= t2;
  t3 -= t7;
  t4 -= t8;
  a[5].re = t5;
  a[5].im = t6;
  a[7].re = t3;
  a[7].im = t4;
  t1 += a[1].re;
  t2 += a[1].im;
  t7 += a[3].re;
  t8 += a[3].im;
  a[1].re = t1;
  a[1].im = t2;
  a[3].re = t7;
  a[3].im = t8;
}

void fft_un16(register complex *a) {
  register real t1, t2, t3, t4, t5, t6, t7, t8;

  fft_un4(a + 8);
  fft_un4(a + 12);
  fft_un8(a);

  t1 = *(volatile real *)&a[8].re;
  t2 = *(volatile real *)&a[12].im;
  t7 = *(volatile real *)&a[8].im;
  t8 = *(volatile real *)&a[12].re;
  t7 -= a[12].im;
  t8 -= a[8].re;
  t1 += a[12].re;
  t2 += a[8].im;
  t5 = *(volatile real *)&a[0].re;
  t6 = *(volatile real *)&a[0].im;
  t3 = *(volatile real *)&a[4].re;
  t4 = *(volatile real *)&a[4].im;
  t5 -= t1;
  t6 -= t2;
  t3 -= t7;
  t4 -= t8;
  a[8].re = t5;
  a[8].im = t6;
  a[12].re = t3;
  a[12].im = t4;
  t1 += a[0].re;
  t2 += a[0].im;
  t7 += a[4].re;
  t8 += a[4].im;
  a[0].re = t1;
  a[0].im = t2;
  a[4].re = t7;
  a[4].im = t8;

  t1 = *(volatile real *)&a[10].re;
  t1 += a[10].im;
  t2 = *(volatile real *)&a[10].im;
  t2 -= a[10].re;
  t1 *= sqrthalf;
  t3 = *(volatile real *)&a[14].re;
  t2 *= sqrthalf;
  t3 -= a[14].im;
  t4 = *(volatile real *)&a[14].im;
  t4 += a[14].re;
  t3 *= sqrthalf;
  t7 = t2;
  t4 *= sqrthalf;
  t8 = t3;
  t8 -= t1;
  t7 -= t4;
  t1 += t3;
  t2 += t4;
  t5 = *(volatile real *)&a[2].re;
  t6 = *(volatile real *)&a[2].im;
  t3 = *(volatile real *)&a[6].re;
  t4 = *(volatile real *)&a[6].im;
  t5 -= t1;
  t6 -= t2;
  t3 -= t7;
  t4 -= t8;
  a[10].re = t5;
  a[10].im = t6;
  a[14].re = t3;
  a[14].im = t4;
  t1 += a[2].re;
  t2 += a[2].im;
  t7 += a[6].re;
  t8 += a[6].im;
  a[2].re = t1;
  a[2].im = t2;
  a[6].re = t7;
  a[6].im = t8;

  UNTRANSFORM(a[1],a[5],a[9],a[13],fft_roots16[0].re,fft_roots16[0].im)
  UNTRANSFORM(a[3],a[7],a[11],a[15],fft_roots16[0].im,fft_roots16[0].re)
}
