#include <math.h>
#include "fftc4.h"
#include "fftc8.h"
#include "fftorder.h"

complex8 testroots[8192];
complex4 x4[8192];
complex8 x8[8192];

#define DOIT(format,m,x,fft,unfft,order) \
  for (j = 0;j < m;++j) { \
    testroots[j].re = cos(2 * M_PI * j / m); \
    testroots[j].im = sin(2 * M_PI * j / m); \
  } \
  err = 0; \
  for (t = 0;t < m;++t) { \
    for (j = 0;j < m;++j) x[j].re = x[j].im = 0; \
    x[t].re = 1; \
    fft(x); \
    for (j = 0;j < m;++j) { \
      dr = x[j].re - testroots[(order[j] * t) % m].re; \
      di = x[j].im - testroots[(order[j] * t) % m].im; \
      err += (dr * dr + di * di); \
    } \
    for (j = 0;j < m;++j) x[j].re = x[j].im = 0; \
    x[t].im = 1; \
    fft(x); \
    for (j = 0;j < m;++j) { \
      dr = x[j].re + testroots[(order[j] * t) % m].im; \
      di = x[j].im - testroots[(order[j] * t) % m].re; \
      err += (dr * dr + di * di); \
    } \
  } \
  printf(format,m,err); \
  err = 0; \
  for (t = 0;t < m;++t) { \
    for (j = 0;j < m;++j) x[j].re = x[j].im = 0; \
    x[t].re = 1; \
    unfft(x); \
    for (j = 0;j < m;++j) { \
      dr = x[j].re - testroots[(j * order[t]) % m].re; \
      di = x[j].im + testroots[(j * order[t]) % m].im; \
      err += (dr * dr + di * di); \
    } \
    for (j = 0;j < m;++j) x[j].re = x[j].im = 0; \
    x[t].im = 1; \
    unfft(x); \
    for (j = 0;j < m;++j) { \
      dr = x[j].re - testroots[(j * order[t]) % m].im; \
      di = x[j].im - testroots[(j * order[t]) % m].re; \
      err += (dr * dr + di * di); \
    } \
  } \
  printf(format,m,err);

void main()
{
  int j;
  int t;
  double dr;
  double di;
  double err;

  DOIT("%d c4 %g\n",2,x4,fftc4_2,fftc4_un2,fftorder_2)
  DOIT("%d c8 %g\n",2,x8,fftc8_2,fftc8_un2,fftorder_2)
  DOIT("%d c4 %g\n",4,x4,fftc4_4,fftc4_un4,fftorder_4)
  DOIT("%d c8 %g\n",4,x8,fftc8_4,fftc8_un4,fftorder_4)
  DOIT("%d c4 %g\n",8,x4,fftc4_8,fftc4_un8,fftorder_8)
  DOIT("%d c8 %g\n",8,x8,fftc8_8,fftc8_un8,fftorder_8)
  DOIT("%d c4 %g\n",16,x4,fftc4_16,fftc4_un16,fftorder_16)
  DOIT("%d c8 %g\n",16,x8,fftc8_16,fftc8_un16,fftorder_16)
  DOIT("%d c4 %g\n",32,x4,fftc4_32,fftc4_un32,fftorder_32)
  DOIT("%d c8 %g\n",32,x8,fftc8_32,fftc8_un32,fftorder_32)
  DOIT("%d c4 %g\n",64,x4,fftc4_64,fftc4_un64,fftorder_64)
  DOIT("%d c8 %g\n",64,x8,fftc8_64,fftc8_un64,fftorder_64)
  DOIT("%d c4 %g\n",128,x4,fftc4_128,fftc4_un128,fftorder_128)
  DOIT("%d c8 %g\n",128,x8,fftc8_128,fftc8_un128,fftorder_128)
  DOIT("%d c4 %g\n",256,x4,fftc4_256,fftc4_un256,fftorder_256)
  DOIT("%d c8 %g\n",256,x8,fftc8_256,fftc8_un256,fftorder_256)
  DOIT("%d c4 %g\n",512,x4,fftc4_512,fftc4_un512,fftorder_512)
  DOIT("%d c8 %g\n",512,x8,fftc8_512,fftc8_un512,fftorder_512)
  DOIT("%d c4 %g\n",1024,x4,fftc4_1024,fftc4_un1024,fftorder_1024)
  DOIT("%d c8 %g\n",1024,x8,fftc8_1024,fftc8_un1024,fftorder_1024)

#ifdef BIG
  DOIT("%d c4 %g\n",2048,x4,fftc4_2048,fftc4_un2048,fftorder_2048)
  DOIT("%d c8 %g\n",2048,x8,fftc8_2048,fftc8_un2048,fftorder_2048)
  DOIT("%d c4 %g\n",4096,x4,fftc4_4096,fftc4_un4096,fftorder_4096)
  DOIT("%d c8 %g\n",4096,x8,fftc8_4096,fftc8_un4096,fftorder_4096)
  DOIT("%d c4 %g\n",8192,x4,fftc4_8192,fftc4_un8192,fftorder_8192)
  DOIT("%d c8 %g\n",8192,x8,fftc8_8192,fftc8_un8192,fftorder_8192)
#endif

  exit(0);
}
