#ifndef FFTC8_H
#define FFTC8_H

typedef struct {
  double re;
  double im;
} fftc8;

extern void fftc8_pass();
extern void fftc8_unpass();

extern void fftc8_2();
extern void fftc8_4();
extern void fftc8_8();
extern void fftc8_16();
extern void fftc8_32();
extern void fftc8_64();
extern void fftc8_128();
extern void fftc8_256();
extern void fftc8_512();
extern void fftc8_1024();

#define fftc8_un2 fftc8_2
extern void fftc8_un4();
extern void fftc8_un8();
extern void fftc8_un16();
extern void fftc8_un32();
extern void fftc8_un64();
extern void fftc8_un128();
extern void fftc8_un256();
extern void fftc8_un512();
extern void fftc8_un1024();

extern double fftc8_roots32[];
extern double fftc8_roots64[];
extern double fftc8_roots128[];
extern double fftc8_roots256[];
extern double fftc8_roots512[];
extern double fftc8_roots1024[];

#define FFTC8(first,second,third,r,n) \
void first(register fftc8 *a) { \
fftc8_pass(a,r,n); third(a + 2 * n); third(a + 3 * n); second(a); }

#define FFTC8_UN(first,second,third,r,n) \
void first(register fftc8 *a) { \
second(a); third(a + 2 * n); third(a + 3 * n); fftc8_unpass(a,r,n); }

#endif
