#ifndef FFTC4_H
#define FFTC4_H

typedef struct {
  float re;
  float im;
} fftc4;

extern void fftc4_pass();
extern void fftc4_unpass();

extern void fftc4_2();
extern void fftc4_4();
extern void fftc4_8();
extern void fftc4_16();
extern void fftc4_32();
extern void fftc4_64();
extern void fftc4_128();
extern void fftc4_256();
extern void fftc4_512();
extern void fftc4_1024();

#define fftc4_un2 fftc4_2
extern void fftc4_un4();
extern void fftc4_un8();
extern void fftc4_un16();
extern void fftc4_un32();
extern void fftc4_un64();
extern void fftc4_un128();
extern void fftc4_un256();
extern void fftc4_un512();
extern void fftc4_un1024();

extern float fftc4_roots32[];
extern float fftc4_roots64[];
extern float fftc4_roots128[];
extern float fftc4_roots256[];
extern float fftc4_roots512[];
extern float fftc4_roots1024[];

#define FFTC4(first,second,third,r,n) \
void first(register fftc4 *a) { \
fftc4_pass(a,r,n); third(a + 2 * n); third(a + 3 * n); second(a); }

#define FFTC4_UN(first,second,third,r,n) \
void first(register fftc4 *a) { \
second(a); third(a + 2 * n); third(a + 3 * n); fftc4_unpass(a,r,n); }

#endif
