#ifndef FFTC8_H
#define FFTC8_H

typedef struct {
  double re;
  double im;
} fftc8;

extern void fftc8_pass();

#define FFTC8(first,second,third,r,n) \
void first(register fftc8 *a) { \
fftc8_pass(a,r,n); second(a); third(a + 2 * n); third(a + 3 * n); }

extern void fftc8_2();
extern void fftc8_4();
extern void fftc8_8();
extern void fftc8_16();
extern void fftc8_32();
extern void fftc8_64();
extern void fftc8_128();
extern void fftc8_256();
extern void fftc8_512();
extern void fftc8_1024();
extern void fftc8_2048();
extern void fftc8_4096();
extern void fftc8_8192();
extern void fftc8_16384();
extern void fftc8_32768();
extern void fftc8_65536();

#endif
