#include <math.h>
#include "fftc8.h"
#include "fftorder.h"

fftc8 testroots[1024];
fftc8 x[1024];

#define DOIT(m,fft,order) \
  for (j = 0;j < m;++j) { \
    testroots[j].re = cos(2 * M_PI * j / m); \
    testroots[j].im = sin(2 * M_PI * j / m); \
  } \
  err = 0; \
  for (t = 0;t < m;++t) { \
    for (j = 0;j < m;++j) x[j].re = x[j].im = 0; \
    x[t].re = 1; \
    fft(x); \
    for (j = 0;j < m;++j) { \
      dr = x[j].re - testroots[(order[j] * t) % m].re; \
      di = x[j].im - testroots[(order[j] * t) % m].im; \
      err += (dr * dr + di * di); \
    } \
    for (j = 0;j < m;++j) x[j].re = x[j].im = 0; \
    x[t].im = 1; \
    fft(x); \
    for (j = 0;j < m;++j) { \
      dr = x[j].re + testroots[(order[j] * t) % m].im; \
      di = x[j].im - testroots[(order[j] * t) % m].re; \
      err += (dr * dr + di * di); \
    } \
  } \
  printf("%d %g\n",m,err);

void main()
{
  int j;
  int t;
  double dr;
  double di;
  double err;

  DOIT(2,fftc8_2,fftorder_2)
  DOIT(4,fftc8_4,fftorder_4)
  DOIT(8,fftc8_8,fftorder_8)
  DOIT(16,fftc8_16,fftorder_16)
  DOIT(32,fftc8_32,fftorder_32)
  DOIT(64,fftc8_64,fftorder_64)
  DOIT(128,fftc8_128,fftorder_128)
  DOIT(256,fftc8_256,fftorder_256)
  DOIT(512,fftc8_512,fftorder_512)
  DOIT(1024,fftc8_1024,fftorder_1024)
}
